/* This is -*- C -*- */
/* $Id: guppi-axis-item.c,v 1.3 2000/04/14 14:55:59 trow Exp $ */

/*
 * guppi-axis-item.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-axis-item.h"
#include "guppi-axis-calc.h"
#include <guppi-rgb.h>
#include <guppi-alpha-template.h>

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0,
  ARG_STATE
};

static void
guppi_axis_item_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_axis_item_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {
  case ARG_STATE:
    guppi_canvas_item_set_state(GUPPI_CANVAS_ITEM(obj),
				GUPPI_ITEM_STATE(GTK_VALUE_POINTER(*arg)));
    break;

  default:
    break;
  };
}

static void
guppi_axis_item_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_axis_item_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_axis_item_class_init(GuppiAxisItemClass* klass)
{
  static void guppi_axis_item_update(GnomeCanvasItem*, double affine[6],
				     ArtSVP*, gint);
  static void guppi_axis_item_render(GnomeCanvasItem*, GnomeCanvasBuf*);
  static void guppi_axis_item_state_set_hook(GuppiCanvasItem*,
					     GuppiItemState*);


  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GnomeCanvasItemClass* item_class = GNOME_CANVAS_ITEM_CLASS(klass);
  GuppiCanvasItemClass* gci_class = GUPPI_CANVAS_ITEM_CLASS(klass);

  parent_class = gtk_type_class(GUPPI_TYPE_CANVAS_ITEM);

  gtk_object_add_arg_type("GuppiAxisItem::state",
			  GTK_TYPE_POINTER,
			  GTK_ARG_WRITABLE,
			  ARG_STATE);

  object_class->get_arg = guppi_axis_item_get_arg;
  object_class->set_arg = guppi_axis_item_set_arg;
  object_class->destroy = guppi_axis_item_destroy;
  object_class->finalize = guppi_axis_item_finalize;

  item_class->update = guppi_axis_item_update;
  item_class->render = guppi_axis_item_render;

  gci_class->state_set_hook = guppi_axis_item_state_set_hook;
}

static void
guppi_axis_item_init(GuppiAxisItem* obj)
{

}

GtkType
guppi_axis_item_get_type(void)
{
  static GtkType guppi_axis_item_type = 0;
  if (!guppi_axis_item_type) {
    static const GtkTypeInfo guppi_axis_item_info = {
      "GuppiAxisItem",
      sizeof(GuppiAxisItem),
      sizeof(GuppiAxisItemClass),
      (GtkClassInitFunc)guppi_axis_item_class_init,
      (GtkObjectInitFunc)guppi_axis_item_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_axis_item_type = gtk_type_unique(GUPPI_TYPE_CANVAS_ITEM, &guppi_axis_item_info);
  }
  return guppi_axis_item_type;
}

static void
guppi_axis_item_update(GnomeCanvasItem* item, double affine[6],
		       ArtSVP* clip_path, gint flags)
{
  GuppiCanvasItem* gci = GUPPI_CANVAS_ITEM(item);
  GuppiAxisItem* gai = GUPPI_AXIS_ITEM(item);
  GList* old_x_list;
  GList* old_y_list;
  GList* iter;

  /* Chain our calls to update */
  if (parent_class && GNOME_CANVAS_ITEM_CLASS(parent_class)->update)
    GNOME_CANVAS_ITEM_CLASS(parent_class)->update(item,affine,clip_path,flags);

  old_x_list = gai->x_list;
  old_y_list = gai->y_list;

  gai->x_list = optimal_guppi_axis_numerical_labels(gci->x0, gci->x1, 6, 10); 
  gai->y_list = optimal_guppi_axis_numerical_labels(gci->y0, gci->y1, 6, 10); 

  
  iter = gai->x_list;
  while (iter) {
    ((GuppiAxisLabel*)iter->data)->rot = -90;
    iter = g_list_next(iter);
  }

  /* Render the text labels, "stealing" any text renderings from
     the old list that we can re-use. */
  guppi_axis_label_render_labels(gai->x_list, old_x_list);
  guppi_axis_label_render_labels(gai->y_list, old_y_list);

  guppi_axis_label_list_free(old_x_list);
  guppi_axis_label_list_free(old_y_list);


  guppi_canvas_item_request_total_redraw(GUPPI_CANVAS_ITEM(item));
}

static void
guppi_axis_item_render(GnomeCanvasItem* item,
		       GnomeCanvasBuf* buf)
{
  GuppiCanvasItem* gci = GUPPI_CANVAS_ITEM(item);
  GuppiAxisItem* gai = GUPPI_AXIS_ITEM(item);
  double t;
  gint i, xc, yc, xw, yw;
  guchar alph;
  GList* iter;
  guchar* ptr;
  GuppiAxisLabel* lab;

  /* Chain our calls to render */
  if (parent_class && GNOME_CANVAS_ITEM_CLASS(parent_class)->render)
    GNOME_CANVAS_ITEM_CLASS(parent_class)->render(item, buf);

  xw = buf->rect.x1 - buf->rect.x0;
  yw = buf->rect.y1 - buf->rect.y0;
  

  iter = gai->x_list;
  while (iter) {
    lab = (GuppiAxisLabel*)iter->data;

    t = lab->pos;
    alph = t==0 ? 0x80 : 0x20;
    guppi_canvas_item_plot2pixel(gci, t, 0, &xc, NULL);
    if (buf->rect.x0 <= xc && xc < buf->rect.x1) {
      ptr = buf->buf + 3*(xc-buf->rect.x0);
      for (i=0; i<yw; ++i) {
	PIXEL_RGBA(ptr, 0, 0, 0, alph);
	ptr += buf->buf_rowstride;
      }
    }

    if (lab->atemp) {
      xc -= lab->atemp->width/2;
      guppi_alpha_template_print(lab->atemp,
				 xc, gci->cy1-4-lab->atemp->height,
				 0xdf, 0, 0, 0xff,
				 buf->buf, buf->buf_rowstride,
				 buf->rect.x1 - buf->rect.x0,
				 buf->rect.y1 - buf->rect.y0,
				 buf->rect.x0, buf->rect.y0);

      
    }
    iter = g_list_next(iter);
  }

  iter = gai->y_list;
  while (iter) {
    lab = (GuppiAxisLabel*)iter->data;

    t = lab->pos;
    alph = t==0 ? 0x80 : 0x20;
    guppi_canvas_item_plot2pixel(gci, 0, t, NULL, &yc);
    if (buf->rect.y0 <= yc && yc < buf->rect.y1) {
      ptr = buf->buf + buf->buf_rowstride*(yc-buf->rect.y0);
      for (i=0; i<xw; ++i) {
	PIXEL_RGBA(ptr, 0, 0, 0, alph);
	ptr += 3;
      }
    }

    if (lab->atemp) {
      yc -= lab->atemp->height/2;
      guppi_alpha_template_print(lab->atemp,
				 gci->cx0+4, yc,
				 0xdf, 0, 0, 0xff,
				 buf->buf, buf->buf_rowstride,
				 buf->rect.x1 - buf->rect.x0,
				 buf->rect.y1 - buf->rect.y0,
				 buf->rect.x0, buf->rect.y0);

    }

    iter = g_list_next(iter);
  }
}

static void
guppi_axis_item_state_set_hook(GuppiCanvasItem* item, GuppiItemState* state)
{

}



/* $Id: guppi-axis-item.c,v 1.3 2000/04/14 14:55:59 trow Exp $ */
