/* This is -*- C -*- */
/* $Id: guppi-struct-core-impl.c,v 1.2 2000/02/21 18:32:13 trow Exp $ */

/*
 * guppi-struct-core-impl.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-struct-core-impl.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

typedef struct _GuppiStructField GuppiStructField;
struct _GuppiStructField {
  GtkType type;
  GuppiData* data;
};

static void
guppi_struct_core_impl_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_struct_core_impl_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
hash_free(gpointer key, gpointer val, gpointer user_data)
{
  GuppiStructField* f = (GuppiStructField*)val;

  if (f->data)
    gtk_object_unref(GTK_OBJECT(f->data));

  g_free(key);
  g_free(val);
}

static void
guppi_struct_core_impl_destroy(GtkObject* obj)
{
  GuppiStructCoreImpl* core = GUPPI_STRUCT_CORE_IMPL(obj);

  if (parent_class->destroy)
    parent_class->destroy(obj);

  
  g_hash_table_foreach(core->fields, hash_free, NULL);
  g_hash_table_destroy(core->fields);
  g_list_free(core->field_names);
  core->fields = NULL;
}

static void
guppi_struct_core_impl_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

/*****************************************************************************/

static gboolean
v_struct_add_field(GuppiStructImpl* impl, const gchar* field, GtkType t)
{
  GuppiStructCoreImpl* core = GUPPI_STRUCT_CORE_IMPL(impl);
  GuppiStructField* p;
  gchar* dup_field;

  p = (GuppiStructField*)g_hash_table_lookup(core->fields, field);
  if (p != NULL)
    return FALSE;

  ++core->field_count;
  dup_field = g_strdup(field);
  core->field_names = g_list_append(core->field_names, dup_field);

  p = g_new(GuppiStructField, 1);
  p->type = t;
  p->data = NULL;
  g_hash_table_insert(core->fields, dup_field, p);

  return TRUE;
}

static gchar**
v_struct_get_names(const GuppiStructImpl* impl)
{
  const GuppiStructCoreImpl* core = GUPPI_STRUCT_CORE_IMPL(impl);
  gchar** v = g_new(gchar*, 1+core->field_count);
  gint i=0;
  GList* walk = core->field_names;

  while (walk) {
    v[i] = g_strdup((gchar*)walk->data);
    ++i;
    walk = g_list_next(walk);
  }
  v[i] = NULL;

  return v;
}

static gsize
v_struct_size(const GuppiStructImpl* impl)
{
  const GuppiStructCoreImpl* core = GUPPI_STRUCT_CORE_IMPL(impl);
  g_assert(core->field_count >= 0);
  return (gsize)core->field_count;
}

static GtkType
v_struct_field_type(const GuppiStructImpl* impl, const gchar* field)
{
  const GuppiStructCoreImpl* core = GUPPI_STRUCT_CORE_IMPL(impl);
  GuppiStructField* p;

  p = (GuppiStructField*)g_hash_table_lookup(core->fields, field);
  if (p == NULL)
    return (GtkType)0;
  return p->type;
}

static GuppiData*
v_struct_get(const GuppiStructImpl* impl, const gchar* field)
{
  const GuppiStructCoreImpl* core = GUPPI_STRUCT_CORE_IMPL(impl);
  GuppiStructField* p;

  p = (GuppiStructField*)g_hash_table_lookup(core->fields, field);
  return p ? p->data : NULL;
}

static gboolean
v_struct_set(GuppiStructImpl* impl, const gchar* field, GuppiData* data)
{
  GuppiStructCoreImpl* core = GUPPI_STRUCT_CORE_IMPL(impl);
  GuppiStructField* p;

  p = (GuppiStructField*)g_hash_table_lookup(core->fields, field);
  if (p == NULL)
    return FALSE;

  if (p->type && !gtk_type_is_a(GTK_OBJECT_TYPE(data), p->type))
    return FALSE;

  if (p->data)
    gtk_object_unref(GTK_OBJECT(data));
  p->data = data;
  gtk_object_ref(GTK_OBJECT(data));

  return TRUE;
}



/*****************************************************************************/

static void
guppi_struct_core_impl_class_init(GuppiStructCoreImplClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GuppiStructImplClass* struct_class = GUPPI_STRUCT_IMPL_CLASS(klass);

  parent_class = gtk_type_class(GUPPI_TYPE_STRUCT_IMPL);

  object_class->get_arg = guppi_struct_core_impl_get_arg;
  object_class->set_arg = guppi_struct_core_impl_set_arg;
  object_class->destroy = guppi_struct_core_impl_destroy;
  object_class->finalize = guppi_struct_core_impl_finalize;

  struct_class->add_field = v_struct_add_field;
  struct_class->get_size = v_struct_size;
  struct_class->get_names = v_struct_get_names;
  struct_class->field_type = v_struct_field_type;
  struct_class->get = v_struct_get;
  struct_class->set = v_struct_set;

}

static void
guppi_struct_core_impl_init(GuppiStructCoreImpl* obj)
{
  obj->fields = g_hash_table_new(g_str_hash, g_str_equal);
}

GtkType
guppi_struct_core_impl_get_type(void)
{
  static GtkType guppi_struct_core_impl_type = 0;
  if (!guppi_struct_core_impl_type) {
    static const GtkTypeInfo guppi_struct_core_impl_info = {
      "GuppiStructCoreImpl",
      sizeof(GuppiStructCoreImpl),
      sizeof(GuppiStructCoreImplClass),
      (GtkClassInitFunc)guppi_struct_core_impl_class_init,
      (GtkObjectInitFunc)guppi_struct_core_impl_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_struct_core_impl_type = gtk_type_unique(GUPPI_TYPE_STRUCT_IMPL, &guppi_struct_core_impl_info);
  }
  return guppi_struct_core_impl_type;
}

GtkObject*
guppi_struct_core_impl_new(void)
{
  return GTK_OBJECT(gtk_type_new(guppi_struct_core_impl_get_type()));
}






/* $Id: guppi-struct-core-impl.c,v 1.2 2000/02/21 18:32:13 trow Exp $ */
