/* This is -*- C -*- */
/* $Id: guppi-seq-date.h,v 1.1 2000/02/21 18:32:54 trow Exp $ */

/*
 * guppi-seq-date.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SEQ_DATE_H
#define _INC_GUPPI_SEQ_DATE_H

#include <config.h>
#include <gnome.h>

#include "guppi-seq.h"

typedef struct _GuppiSeqDate GuppiSeqDate;
typedef struct _GuppiSeqDateClass GuppiSeqDateClass;

struct _GuppiSeqDate {
  GuppiSeq parent;
};

struct _GuppiSeqDateClass {
  GuppiSeqClass parent_class;
};

#define GUPPI_TYPE_SEQ_DATE (guppi_seq_date_get_type())
#define GUPPI_SEQ_DATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SEQ_DATE,GuppiSeqDate))
#define GUPPI_SEQ_DATE0(obj) ((obj) ? (GUPPI_SEQ_DATE(obj)) : NULL)
#define GUPPI_SEQ_DATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SEQ_DATE,GuppiSeqDateClass))
#define GUPPI_IS_SEQ_DATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SEQ_DATE))
#define GUPPI_IS_SEQ_DATE0(obj) (((obj) == NULL) || (GUPPI_IS_SEQ_DATE(obj)))
#define GUPPI_IS_SEQ_DATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SEQ_DATE))

GtkType guppi_seq_date_get_type(void);

GuppiData* guppi_seq_date_new(void);

const GDate* guppi_seq_date_get(const GuppiSeqDate*, gint);
void guppi_seq_date_set(GuppiSeqDate*, gint, const GDate*);
void guppi_seq_date_prepend(GuppiSeqDate*, const GDate*);
void guppi_seq_date_append(GuppiSeqDate*, const GDate*);
void guppi_seq_date_insert(GuppiSeqDate*, gint, const GDate*);

const GDate* guppi_seq_date_min(const GuppiSeqDate*);
const GDate* guppi_seq_date_max(const GuppiSeqDate*);



#endif /* _INC_GUPPI_SEQ_DATE_H */

/* $Id: guppi-seq-date.h,v 1.1 2000/02/21 18:32:54 trow Exp $ */
