/* This is -*- C -*- */
/* $Id: guppi-scatter-state-control.c,v 1.8 2000/03/10 16:28:41 trow Exp $ */

/*
 * guppi-scatter-state-control.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <guppi-paths.h>
#include <guppi-seq-scalar.h>
#include <guppi-data-picker.h>
#include "guppi-scatter-state-control.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_scatter_state_control_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_scatter_state_control_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_scatter_state_control_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_scatter_state_control_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_scatter_state_control_class_init(GuppiScatterStateControlClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GTK_TYPE_VBOX);

  object_class->get_arg = guppi_scatter_state_control_get_arg;
  object_class->set_arg = guppi_scatter_state_control_set_arg;
  object_class->destroy = guppi_scatter_state_control_destroy;
  object_class->finalize = guppi_scatter_state_control_finalize;

}

static void
guppi_scatter_state_control_init(GuppiScatterStateControl* obj)
{
  obj->state = NULL;
}

GtkType
guppi_scatter_state_control_get_type(void)
{
  static GtkType guppi_scatter_state_control_type = 0;
  if (!guppi_scatter_state_control_type) {
    static const GtkTypeInfo guppi_scatter_state_control_info = {
      "GuppiScatterStateControl",
      sizeof(GuppiScatterStateControl),
      sizeof(GuppiScatterStateControlClass),
      (GtkClassInitFunc)guppi_scatter_state_control_class_init,
      (GtkObjectInitFunc)guppi_scatter_state_control_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_scatter_state_control_type = gtk_type_unique(GTK_TYPE_VBOX, &guppi_scatter_state_control_info);
  }
  return guppi_scatter_state_control_type;
}

/*****************************************************************************/

static void
guppi_scatter_state_control_apply_state(GuppiScatterStateControl* gssc)
{
  /* shortened notation */
  GladeXML* xml = gssc->glade_xml;
  GuppiScatterState* state = gssc->state;

  GtkWidget* x_picker = glade_xml_get_widget(xml, "x_data_picker");
  GtkWidget* y_picker = glade_xml_get_widget(xml, "y_data_picker");

  gboolean can_plot;

  can_plot = state->x_data && state->y_data;

  /* Set data pickers */
  guppi_data_picker_set_selected_data(GUPPI_DATA_PICKER(x_picker),
				      (GuppiData*)state->x_data);
  guppi_data_picker_set_selected_data(GUPPI_DATA_PICKER(y_picker),
				      (GuppiData*)state->y_data);

  gtk_widget_set_sensitive(gssc->notebook, can_plot);
}

static void
state_change_cb(GuppiScatterState* state, gpointer data)
{
  g_return_if_fail(data != NULL);
  guppi_scatter_state_control_apply_state(GUPPI_SCATTER_STATE_CONTROL(data));
}

/*****************************************************************************/

static void
on_x_data_changed(GuppiDataPicker* gdp, GuppiData* data, gpointer state_ptr)
{
  GuppiScatterState* gss = GUPPI_SCATTER_STATE(state_ptr);
  guppi_scatter_state_set_x_data(gss,
				 data ? GUPPI_SEQ_SCALAR(data) : NULL);
}

static void
on_y_data_changed(GuppiDataPicker* gdp, GuppiData* data, gpointer state_ptr)
{
  GuppiScatterState* gss = GUPPI_SCATTER_STATE(state_ptr);
  guppi_scatter_state_set_y_data(gss,
				 data ? GUPPI_SEQ_SCALAR(data) : NULL);
}

static void
guppi_scatter_state_control_connect_signals(GuppiScatterStateControl* gssc)
{
  GtkWidget* w;
  
  /* shortened notation */
  GladeXML* xml = gssc->glade_xml;
  GuppiScatterState* state = gssc->state;

  gtk_signal_connect(GTK_OBJECT(state),
		     "changed",
		     GTK_SIGNAL_FUNC(state_change_cb),
		     gssc);

  gtk_signal_connect(GTK_OBJECT(state),
		     "reset_x_data",
		     GTK_SIGNAL_FUNC(state_change_cb),
		     gssc);

  gtk_signal_connect(GTK_OBJECT(state),
		     "reset_y_data",
		     GTK_SIGNAL_FUNC(state_change_cb),
		     gssc);

  w = glade_xml_get_widget(xml, "x_data_picker");
  gtk_signal_connect(GTK_OBJECT(w),
		     "selected_data",
		     GTK_SIGNAL_FUNC(on_x_data_changed),
		     state);

  w = glade_xml_get_widget(xml, "y_data_picker");
  gtk_signal_connect(GTK_OBJECT(w),
		     "selected_data",
		     GTK_SIGNAL_FUNC(on_y_data_changed),
		     state);
}

/*****************************************************************************/

void
guppi_scatter_state_control_construct(GuppiScatterStateControl* gssc,
				      GuppiScatterState* state)
{
  gchar* path;
  GtkWidget* w;
  GtkWidget* stycont;
  GtkNotebook* nb;
  GtkWidget* label;
  gchar buffer[256];
  gint i;

  GladeXML* info_window;

  g_return_if_fail(gssc != NULL);
  g_return_if_fail(state != NULL);
  g_return_if_fail(gssc->state == NULL);

  gssc->state = state;
  gtk_object_ref(GTK_OBJECT(state));

  path = guppi_glade_path("guppi-scatter-state-control.glade");
  gssc->glade_xml = path ? glade_xml_new(path, "root_table") : NULL;
  g_free(path);

  if (gssc->glade_xml == NULL)
    g_error("glade_xml_new() failed to load \"guppi-scatter-state-control.glade\"");
  gssc->widget = glade_xml_get_widget(gssc->glade_xml, "root_table");

  /* A crude hack */
  nb = GTK_NOTEBOOK(gtk_notebook_new());
  gssc->notebook = GTK_WIDGET(nb);
  gtk_notebook_set_tab_pos(nb, GTK_POS_BOTTOM);

  /* Manually add our style control */
  w = glade_xml_get_widget(gssc->glade_xml, "style_frame");
  gtk_container_add(GTK_CONTAINER(w), gssc->notebook);
  for (i=0; i<8; ++i) {
    stycont = guppi_scatter_style_control_new(guppi_scatter_state_get_style(gssc->state, i));
    g_snprintf(buffer, 256, "Style %d", i+1);
    label = gtk_label_new(buffer);
    gtk_notebook_append_page(nb, stycont, label);
  }
	
  guppi_scatter_state_control_apply_state(gssc);
  guppi_scatter_state_control_connect_signals(gssc);

  gtk_widget_show_all(gssc->widget);
  gtk_container_add(GTK_CONTAINER(gssc), gssc->widget);

  /* Show info window! */
  path = guppi_glade_path("guppi-scatter-notice.glade");
  info_window = path ? glade_xml_new(path, "info_window") : NULL;
  g_free(path);
  if (info_window) {
    w = glade_xml_get_widget(info_window, "info_window");
    gtk_widget_show_all(w);
  }
}

GtkWidget*
guppi_scatter_state_control_new(GuppiScatterState* state)
{
  GuppiScatterStateControl* gssc;
  
  g_return_val_if_fail(state != NULL, NULL);

  gssc = GUPPI_SCATTER_STATE_CONTROL(gtk_type_new(guppi_scatter_state_control_get_type()));

  guppi_scatter_state_control_construct(gssc, state);

  return GTK_WIDGET(gssc);
}



/* $Id: guppi-scatter-state-control.c,v 1.8 2000/03/10 16:28:41 trow Exp $ */
