/* This is -*- C -*- */
/* $Id: transform.h,v 1.2 2000/02/06 03:17:13 trow Exp $ */

/*
 * transform.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_TRANSFORM_H
#define _INC_TRANSFORM_H

#include <config.h>
#include <glib.h>
#include <math.h>

typedef struct _Transform Transform;

struct _Transform {
  double t0, t1;  // Plot bounds
  gint p0, p1;    // Pixel bounds
  double ppu, C;  // pre-calculated scaling factors
};

Transform* transform_new(void);

void transform_set_plot_bounds(Transform*, double, double);
void transform_set_pixel_bounds(Transform*, gint, gint);

gint transform_plot2pixel(const Transform*, double);
double transform_pixel2plot(const Transform*, gint);

double transform_plot_units_per_pixel(const Transform*);
double transform_pixels_per_plot_units(const Transform*);

/*
 * Fast plot-to-pixel and pixel-to-plot coordinate transforms.
 * (They are macros to avoid function-call overhead, but they are thus
 * also have no error checking. 
 */

#define transform_plot2pixel_unsafe(Tr,t) ((gint)rint((Tr)->ppu*(t)+(Tr)->C))
#define transform_pixel2plot_unsafe(Tr,p) (((p)-(Tr)->C)/(Tr)->ppu)


#endif /* _INC_TRANSFORM_H */

/* $Id: transform.h,v 1.2 2000/02/06 03:17:13 trow Exp $ */
