/* This is -*- C -*- */
/* $Id: guppi-item-state.h,v 1.1 2000/01/21 06:13:48 trow Exp $ */

/*
 * guppi-item-state.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_ITEM_STATE_H
#define _INC_GUPPI_ITEM_STATE_H

#include <config.h>
#include <gnome.h>

typedef struct _GuppiItemState GuppiItemState;
typedef struct _GuppiItemStateClass GuppiItemStateClass;

struct _GuppiItemState {
  GtkObject parent;

  gint freeze_count;
  gboolean pending_update;
};

struct _GuppiItemStateClass {
  GtkObjectClass parent_class;

  void (*update)(void);
};

#define GUPPI_TYPE_ITEM_STATE (guppi_item_state_get_type())
#define GUPPI_ITEM_STATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_ITEM_STATE,GuppiItemState))
#define GUPPI_ITEM_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_ITEM_STATE,GuppiItemStateClass))
#define GUPPI_IS_ITEM_STATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_ITEM_STATE))
#define GUPPI_IS_ITEM_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_ITEM_STATE))

GtkType guppi_item_state_get_type(void);

GuppiItemState* guppi_item_state_new(void);

void guppi_item_state_freeze(GuppiItemState*);
void guppi_item_state_thaw(GuppiItemState*);

void guppi_item_state_request_update(GuppiItemState*);



#endif /* _INC_GUPPI_ITEM_STATE_H */

/* $Id: guppi-item-state.h,v 1.1 2000/01/21 06:13:48 trow Exp $ */
