/* This is -*- C -*- */
/* $Id: guppi-data-impl.c,v 1.1 2000/02/09 21:04:56 trow Exp $ */

/*
 * guppi-data-impl.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-data-impl.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_data_impl_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_data_impl_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_data_impl_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_data_impl_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_data_impl_class_init(GuppiDataImplClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GTK_TYPE_OBJECT);

  klass->impl_name = "-* GuppiDataImpl *-";
  klass->hooks = g_hash_table_new(g_str_hash, g_str_equal);

  object_class->get_arg = guppi_data_impl_get_arg;
  object_class->set_arg = guppi_data_impl_set_arg;
  object_class->destroy = guppi_data_impl_destroy;
  object_class->finalize = guppi_data_impl_finalize;

}

static void
guppi_data_impl_init(GuppiDataImpl* obj)
{

}

GtkType
guppi_data_impl_get_type(void)
{
  static GtkType guppi_data_impl_type = 0;
  if (!guppi_data_impl_type) {
    static const GtkTypeInfo guppi_data_impl_info = {
      "GuppiDataImpl",
      sizeof(GuppiDataImpl),
      sizeof(GuppiDataImplClass),
      (GtkClassInitFunc)guppi_data_impl_class_init,
      (GtkObjectInitFunc)guppi_data_impl_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_data_impl_type = gtk_type_unique(GTK_TYPE_OBJECT, &guppi_data_impl_info);
  }
  return guppi_data_impl_type;
}

const gchar*
guppi_data_impl_get_impl_name(const GuppiDataImpl* impl)
{
  g_return_val_if_fail(impl != NULL, NULL);
  return GUPPI_DATA_IMPL_CLASS(GTK_OBJECT(impl)->klass)->impl_name;
}

/****************************************************************************/

static GuppiDataImplHook
guppi_data_impl_class_get_hook(const GuppiDataImplClass* klass,
			       const gchar* key)
{
  gpointer value;
  gboolean have_hook;
  GtkType type;
  gpointer parent;

  g_return_val_if_fail(klass != NULL, NULL);
  g_return_val_if_fail(key != NULL, NULL);

  have_hook = g_hash_table_lookup_extended(klass->hooks, key, NULL, &value);

  /* If we have the proper hook in our table, fine... */
  if (have_hook)
    return (GuppiDataImplHook)value;

  /* If we are at the deepest level, give up... */
  type = GTK_OBJECT_CLASS(klass)->type;
  if (type == GUPPI_TYPE_DATA_IMPL)
    return NULL;

  /* ...otherwise we check the parent class for the same key. */
  parent = gtk_type_parent_class(type);
  g_assert(parent != NULL);
  g_assert(GUPPI_IS_DATA_IMPL_CLASS(parent));
  return guppi_data_impl_class_get_hook(GUPPI_DATA_IMPL_CLASS(parent), key);
}

gboolean
guppi_data_impl_has_hook(const GuppiDataImpl* impl, const gchar* key)
{
  GuppiDataImplClass* klass;
  g_return_val_if_fail(impl != NULL, FALSE);
  g_return_val_if_fail(key != NULL, FALSE);

  klass = GUPPI_DATA_IMPL_CLASS(GTK_OBJECT(impl)->klass);
  return guppi_data_impl_class_get_hook(klass, key) != NULL;
}

gpointer
guppi_data_impl_call_hook(GuppiDataImpl* impl, const gchar* key,
			  gpointer user_data)
{
  GuppiDataImplClass* klass;
  GuppiDataImplHook hook;
  g_return_val_if_fail(impl != NULL, NULL);
  g_return_val_if_fail(key != NULL, NULL);

  klass = GUPPI_DATA_IMPL_CLASS(GTK_OBJECT(impl)->klass);
  hook = guppi_data_impl_class_get_hook(klass, key);
  g_return_val_if_fail(hook != NULL, NULL);

  return (hook)(impl, user_data);
}

void
guppi_data_impl_class_add_hook(GuppiDataImplClass* klass, const gchar* key,
			       GuppiDataImplHook hook_func)
{
  g_return_if_fail(klass != NULL);
  g_return_if_fail(key != NULL);
  g_hash_table_insert(klass->hooks, (gpointer)key, hook_func);
}




/* $Id: guppi-data-impl.c,v 1.1 2000/02/09 21:04:56 trow Exp $ */
