// Copyright (C) 2020-2025 Free Software Foundation, Inc.

// This file is part of GCC.

// GCC is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 3, or (at your option) any later
// version.

// GCC is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.

// You should have received a copy of the GNU General Public License
// along with GCC; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

// This is an FFI interface to gccrs (c++).
// It is a counterpart to `rust-polonius-ffi.h`.

// Generated by rust-bindgen, remove unsafe phantoms and add Into impls.
// ```shell
// bindgen \
//  --generate types \
//  --allowlist-file rust-polonius-facts-ffi.h
//  --no-layout-tests
//  rust-polonius-ffi.h
//  -- -x c++
// ```
include!("gccrs_ffi_generated.rs");

use crate::GccrsAtom;

impl<T1, T2> Into<(GccrsAtom, GccrsAtom)> for Pair<T1, T2>
where
    GccrsAtom: From<T1> + From<T2>,
{
    fn into(self) -> (GccrsAtom, GccrsAtom) {
        (self.first.into(), self.second.into())
    }
}

impl<T1, T2, T3> Into<(GccrsAtom, GccrsAtom, GccrsAtom)> for Triple<T1, T2, T3>
where
    GccrsAtom: From<T1> + From<T2> + From<T3>,
{
    fn into(self) -> (GccrsAtom, GccrsAtom, GccrsAtom) {
        (self.first.into(), self.second.into(), self.third.into())
    }
}

impl<OUT, IN> Into<Vec<OUT>> for Slice<IN>
where
    IN: Into<OUT> + Copy,
{
    fn into(self) -> Vec<OUT> {
        let slice = unsafe { std::slice::from_raw_parts(self.data, self.len as usize) };
        slice.iter().map(|&e| e.into()).collect()
    }
}
