#!/bin/sh
# Ensure that cp merely warns when a non-directory source file is
# listed on the command line more than once.  fileutils-4.1.1
# made this fail:  cp a a d/
# Ensure that mv fails with a similar command.

# Copyright (C) 2001-2013 Free Software Foundation, Inc.

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

. "${srcdir=.}/tests/init.sh"; path_prepend_ ./src
print_ver_ cp mv

skip_if_root_

for i in cp; do

  # cp may not fail in this case.

  rm -fr a d; touch a; mkdir d
  $i a a d/ 2> out || fail=1
  rm -fr a d; touch a; mkdir d
  $i ./a a d/ 2>> out || fail=1

  # cp succeeds with --backup=numbered.
  rm -fr a d; touch a; mkdir d
  $i --backup=numbered a a d/ 2>> out || fail=1

  # But not with plain '--backup'
  rm -fr a d; touch a; mkdir d
  $i --backup a a d/ 2>> out && fail=1
  cat <<EOF > exp
$i: warning: source file 'a' specified more than once
$i: warning: source file 'a' specified more than once
$i: will not overwrite just-created 'd/a' with 'a'
EOF
  compare exp out || fail=1
done

for i in mv; do
  # But mv *does* fail in this case (it has to).

  rm -fr a d; touch a; mkdir d
  $i a a d/ 2> out && fail=1
  rm -fr a d; touch a; mkdir d
  $i ./a a d/ 2>> out && fail=1
  cat <<EOF > exp
$i: cannot stat 'a': No such file or directory
$i: cannot stat 'a': No such file or directory
EOF
  compare exp out || fail=1
done

Exit $fail
