#    Copyright (C) 1990, 1991 Aladdin Enterprises.  All rights reserved.
#    Distributed by Free Software Foundation, Inc.
#
# This file is part of Ghostscript.
#
# Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
# to anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer
# to the Ghostscript General Public License for full details.
#
# Everyone is granted permission to copy, modify and redistribute
# Ghostscript, but only under the conditions described in the Ghostscript
# General Public License.  A copy of this license is supposed to have been
# given to you along with Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# Partial makefile for Ghostscript, common to all Unix configurations.

# This is the last part of the makefile for Unix configurations.
# Since Unix make doesn't have an 'include' facility, we concatenate
# the various parts of the makefile together by brute force (in tar_gs).

# -------------------------------- Library -------------------------------- #

## The Unix platform

PLATUNIX=gp_unix.$(OBJ)

gp_unix.$(OBJ): gp_unix.c gp.h

# -------------------------- Auxiliary programs --------------------------- #

ansi2knr$(XE):
	$(CC) -o ansi2knr$(XE) $(CFLAGS) ansi2knr.c $(EXTRALIBS)

genarch$(XE): genarch.c
	$(CC) -o genarch$(XE) $(CFLAGS) genarch.c $(EXTRALIBS)

# ----------------------------- Main program ------------------------------ #

# (Dummy) tracing package

utrace.$(OBJ): utrace.c cframe_.h

# Main program

ALLUNIX=gsmain.$(OBJ) utrace.$(OBJ) $(LIB) $(PLATUNIX) $(DEVICE_OBJS)

# Interpreter main program

GSUNIX=gs.$(OBJ) $(INT) $(ALLUNIX)

gs: $(GSUNIX)
	$(CC) $(LDFLAGS) -o gs $(GSUNIX) $(EXTRALIBS) -lm

# Installation

sysps = gs_init.ps gs_fonts.ps gs_statd.ps symbol_e.ps gconfig.ps quit.ps
sysfiles = $(sysps) Fontmap uglyr.gsf
artps = chess.ps cheq.ps golfer.ps escher.ps
utilps = decrypt.ps bdftops.ps pfbtops.ps pstoppm.ps fcutils.ps prfont.ps

install:
	$(proginstall) gs $(bindir)
	$(proginstall) gsnd $(bindir)
	$(proginstall) bdftops $(bindir)
	$(proginstall) pfbtops $(bindir)
	$(fileinstall) gs_init.ps $(libdir)
	$(fileinstall) gs_fonts.ps $(libdir)
	$(fileinstall) gs_statd.ps $(libdir)
	$(fileinstall) symbol_e.ps $(libdir)
	$(fileinstall) gconfig.ps $(libdir)
	$(fileinstall) quit.ps $(libdir)
	$(fileinstall) Fontmap $(libdir)
	$(fileinstall) uglyr.gsf $(libdir)
	$(fileinstall) chess.ps $(libdir)
	$(fileinstall) cheq.ps $(libdir)
	$(fileinstall) golfer.ps $(libdir)
	$(fileinstall) escher.ps $(libdir)
	$(fileinstall) decrypt.ps $(libdir)
	$(fileinstall) bdftops.ps $(libdir)
	$(fileinstall) pfbtops.ps $(libdir)
	$(fileinstall) pstoppm.ps $(libdir)
	$(fileinstall) fcutils.ps $(libdir)
	$(fileinstall) prfont.ps $(libdir)
