#    Copyright (C) 1989, 1990, 1991 Aladdin Enterprises.  All rights reserved.
#    Distributed by Free Software Foundation, Inc.
#
# This file is part of Ghostscript.
#
# Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
# to anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer
# to the Ghostscript General Public License for full details.
#
# Everyone is granted permission to copy, modify and redistribute
# Ghostscript, but only under the conditions described in the Ghostscript
# General Public License.  A copy of this license is supposed to have been
# given to you along with Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# makefile for Ghostscript, MS-DOS/Turbo C platform.

# ------------------------------- Options ------------------------------- #

###### This section is the only part of the file you should need to edit.

# ------ Generic options ------ #

# Define the default directory/ies for the runtime
# initialization and font files.  Separate multiple directories with \;.
# Use \\ or / to indicate directories, not a single \.

GS_LIB_DEFAULT=c:/gs\;c:/gs/fonts

# Define the name of the Ghostscript initialization file.
# (There is no reason to change this.)

GS_INIT=gs_init.ps

# Choose generic configuration options.

# -DDEBUG
#	includes debugging features (-Z switch) in the code.
#	  Code runs substantially slower even if no debugging switches
#	  are set.
# -DNOPRIVATE
#	makes private (static) procedures and variables public,
#	  so they are visible to the debugger and profiler.
#	  No execution time or space penalty, just larger .OBJ and .EXE files.

GENOPT= -DNOPRIVATE

# ------ Platform-specific options ------ #

# Define which assembler you are using.  This can be a full path name
# if you want.  Normally it will be masm or tasm.

ASM=masm

# Define the drive and directory for the Turbo C files.
# COMPDIR contains the compiler and linker (normally \tc).
# BGIDIR contains the BGI files (normally \tc).
# INCDIR contains the include files (normally \tc\include).
# INC2DIR is an optional second include file directory,
#   so that INCDIR can be a RAMdisk directory containing the most heavily
#   used files and INC2DIR can be \tc\include (or whatever).
# LIBDIR contains the library files (normally \tc\lib).
# Note that these prefixes are always followed by a \,
#   so if you want to use the current directory, use an explicit '.'.

COMPDIR=c:\tc
BGIDIR=c:\tc
INCDIR=c:\tc\include
LIBDIR=c:\tc\lib

# Choose platform-specific options.

# Define the processor (CPU) type.  Options are 86, 186, 286, 386, or 486.
# (The 8086 and 8088 both correspond to processor type 86.)
# 286 and up do not use protected mode.  Higher numbers produce
# code that may be significantly smaller and faster, but the executable
# will bail out with an error message on lower-numbered processor types.

CPU_TYPE=86

# Define the math coprocessor (FPU) type.  Options are 0, 87, 287, or 387.
# If the CPU type is 486, the FPU type is irrelevant, since the 80486
# CPU includes the equivalent of an 80387 on-chip.
# A non-zero option means that the executable will only run if a FPU
# of that type (or higher) is available: this is NOT currently checked
# at runtime.
#   Code is significantly faster.

FPU_TYPE=0

# ---------------------------- End of options ---------------------------- #

# Define the name of the makefile -- used in dependencies.

MAKEFILE=turboc.mak

# Define the extensions for the object and executable files.

OBJ=obj
XE=.exe

# Define the ANSI-to-K&R dependency.  (Turbo C accepts ANSI syntax.)

AK=

# Define the need for uniq.

UNIQ=uniq$(XE)

# Define the directory separator and shell quote string.
# The blank line in between is necessary, because MAKE interprets
# the second \ as a line continuation character.

DS=\\

Q="

# Define the memory model for Turbo C.  Don't change it!

MM=l

# Define the compilation rules and flags

!if $(CPU_TYPE) >= 386
ASMFLAGS=/DFOR80386
PLATOPT=-1 -DFOR80386
!elif $(CPU_TYPE) >= 186
ASMFLAGS=
PLATOPT=-1
!else
ASMFLAGS=
PLATOPT=
!endif

!if $(CPU_TYPE) == 486 || $(FPU_TYPE) >= 287
FPFLAGS=-f287
FPLIB=fp87
!elif $(FPU_TYPE) != 0
FPFLAGS=-f87
FPLIB=fp87
!else
FPFLAGS=
FPLIB=emu
!endif

CCFLAGS=$(GENOPT) $(PLATOPT) $(FPFLAGS) -m$(MM)
CC=$(COMPDIR)\tcc -d -r -y -G -K -N -I$(INCDIR) -I$(INC2DIR)
CCC=$(CC) -a $(CCFLAGS) -O -c
CC0=$(COMPDIR)\tcc -m$(MM) -c
CCINT=$(CC) -a $(CCFLAGS) -c

.c.obj:
	$(CCC) $<

.c.i:
	$(COMPDIR)\cpp -I$(INCDIR) -I$(INC2DIR) -a $(CCFLAGS) -P- $<

.c.asm:
	$(CC) $(CCFLAGS) -O -S $<

.asm.obj:
	$(ASM) $(ASMFLAGS) $<;

# ------ Devices and features ------ #

# Choose the language feature(s) to include.  See ghost.mak for details.

FEATURES=

# Choose the device(s) to include.  See gdevs.mak for details.

DEVICES=vga ega bgi epson
DEVICE_DEVS=vga.dev ega.dev bgi.dev epson.dev
!include "ghost.mak"
!include "gdevs.mak"
DEVICE_OBJS=$(vga_) $(ega_) $(bgi_) $(epson_)

# -------------------------------- Library -------------------------------- #

# We have to compile gp_dos without -1, because it includes a run-time
# check to make sure we are running on the right kind of processor.
gp_dos.$(OBJ): gp_dos.c gp.h overlay.h $(MAKEFILE) makefile
	$(CC) -a -m$(MM) $(GENOPT) -DCPU_TYPE=$(CPU_TYPE) -c gp_dos.c

# ------------------------------ Interpreter ------------------------------ #

iutilasm.$(OBJ): iutilasm.asm

# -------------------------- Auxiliary programs --------------------------- #

ansi2knr$(XE): ansi2knr.c
	$(CC) $(CCFLAGS) -L$(LIBDIR) ansi2knr.c

genarch$(XE): genarch.c
	$(CC) $(CCFLAGS) -L$(LIBDIR) genarch.c

# We need a substitute for the Unix uniq utility.
# It only has to handle stdin and stdout, no options.
uniq$(XE): uniq.c
	$(CC) $(CCFLAGS) -L$(LIBDIR) uniq.c

# ----------------------------- Main program ------------------------------ #

# A rule to do a quick and dirty compilation attempt when first installing
# Ghostscript.  Many of the compilations will fail: follow this with 'make'.

begin:
	erase arch.h
	erase genarch.exe
	make arch.h
	- $(CCC) *.c
	erase gp_dos.obj
	erase gdevepsn.obj

# Get around the fact that the DOS shell has a rather small limit on
# the length of a command line.  (sigh)

LIBCTR=libc$(MM).tr

$(LIBCTR): $(MAKEFILE) makefile
	gssetmm $(LIBCTR) $(LIBDIR) $(FPLIB) math$(MM) c$(MM)

# Tracing package

# trace.c must be compiled without the -a switch!
trace.obj: trace.c
	$(CC) $(CCFLAGS) -O -c trace.c

LIBDOS=$(LIB) gp_dos.$(OBJ) gconfig.tr $(DEVICE_OBJS)

# Interpreter main program

GS_ALL=gs.$(OBJ) $(INT) iutilasm.$(OBJ) gsmain.$(OBJ) trace.$(OBJ)\
  $(LIBDOS) $(LIBCTR) gconfig.tr

gs.exe: $(GS_ALL) $(INT)
	tlink /m /l $(LIBDIR)\c0$(MM) @gconfig.tr @gs.tr ,gs,gs,$(LIBDIR)\graphics @$(LIBCTR)
