/* Copyright (C) 1991 Aladdin Enterprises.  All rights reserved.
   Distributed by Free Software Foundation, Inc.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* gxop1.h */
/* Type 1 state shared between interpreter and compiled fonts. */

#define ostack_size 24

/* Define the fixed-point coefficient structure */
/* for avoiding floating point. */
#define max_coeff_bits 11		/* max coefficient in char space */
typedef struct {
	long xx, xy, yx, yy;
	int skewed;
	int shift;			/* see c_fixed */
	fixed round;			/* ditto */
} fixed_coeff;
typedef struct gs_op1_state_s {
	struct gx_path_s *ppath;
	struct gs_type1_state_s *pis;
	fixed_coeff fc;
	fixed px, py;
	fixed ostack[ostack_size];
	fixed _ss *osp;			/* not used when interpreting */
#define cstack s.ostack
#define cs0 cstack[0]
#define ics0 fixed2int_var(cs0)
#define cs1 cstack[1]
#define ics1 fixed2int_var(cs1)
#define cs2 cstack[2]
#define ics2 fixed2int_var(cs2)
#define cs3 cstack[3]
#define ics3 fixed2int_var(cs3)
#define cs4 cstack[4]
#define ics4 fixed2int_var(cs4)
#define cs5 cstack[5]
#define ics5 fixed2int_var(cs5)
} gs_op1_state;
typedef gs_op1_state _ss *is_ptr;
