/* Copyright (C) 1989, 1990, 1991 Aladdin Enterprises.  All rights reserved.
   Distributed by Free Software Foundation, Inc.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* gxfont.h */
/* Internal font definition for Ghostscript library */
/* Requires gsmatrix.h, gxdevice.h */
#include "gsfont.h"

/* A font object as seen by clients. */
/* See the PostScript Language Reference Manual for details. */

struct gs_show_enum_s;

typedef int (*gs_proc_build_char)
     (P5(struct gs_show_enum_s *, struct gs_state_s *, struct gs_font_s *,
	 int /* char code */, char * /* build_char_data */));

int gs_no_build_char_proc
     (P5(struct gs_show_enum_s *, struct gs_state_s *, struct gs_font_s *,
	 int, char *));

/* Define the known font types. */
/* These numbers must be the same as the values of FontType */
/* in font dictionaries. */
typedef enum {
	ft_composite = 0,
	ft_encrypted = 1,
	ft_user_defined = 3
} font_type;

/* This is the type-specific information for a type 0 (composite) gs_font. */
typedef struct gs_type0_data_s gs_type0_data;
struct gs_type0_data_s {
	int FMapType;
	byte EscChar, ShiftIn, ShiftOut;
	byte *SubsVector;
	  uint subs_size;		/* bytes per entry */
	  int subs_width;		/* # of entries */
	int *Encoding;
	  uint encoding_size;
	gs_font **FDepVector;
	  uint fdep_size;
};

/* This is the type-specific information for a type 1 (encrypted) gs_font. */
typedef struct gs_type1_data_s gs_type1_data;
struct gs_type1_data_s {
	int PaintType;			/* PaintType */
	int (*subr_proc)(P3(gs_type1_data *pdata,
			    int index, byte **pcharstring));
	int (*pop_proc)(P2(gs_type1_data *, fixed *));
	char *proc_data;		/* data for subr_proc */
	int lenIV;			/* # of leading garbage bytes */
};

/* Even though it costs a little extra space, it's more convenient to */
/* include all the necessary information for >>all<< known font types */
/* (user-defined, encrypted, and composite) in the font structure. */
struct gs_font_s {
	gs_font *next, *prev;		/* chain for scaled font cache */
	gs_font *base;			/* original (unscaled) base font */
	gs_font_dir *dir;		/* directory where registered */
	char *client_data;		/* additional client data */
	gs_matrix FontMatrix;
	font_type FontType;
	gs_proc_build_char build_char_proc;	/* BuildChar */
	char *build_char_data;		/* private data for BuildChar */
	union _d {
		/* Composite (type 0) fonts */
		gs_type0_data type0_data;
		/* Base (non-type 0) fonts */
		struct _b {
			gs_rect FontBBox;
			long UniqueID;
			/* Type 1 data */
			gs_type1_data type1_data;
		} base;
	} data;
};
