#    Copyright (C) 1989, 1990, 1991 Aladdin Enterprises.  All rights reserved.
#    Distributed by Free Software Foundation, Inc.
#
# This file is part of Ghostscript.
#
# Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
# to anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer
# to the Ghostscript General Public License for full details.
#
# Everyone is granted permission to copy, modify and redistribute
# Ghostscript, but only under the conditions described in the Ghostscript
# General Public License.  A copy of this license is supposed to have been
# given to you along with Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# Generic makefile for Ghostscript.
# The platform-specific makefiles `include' this file.
# They define the following symbols:
#	GS_INIT - the name of the initialization file for Ghostscript,
#		normally gs_init.ps.
#	GS_LIB_DEFAULT - the default directory/ies for searching for the
#		initialization and font files at run time.
#	DEVICES, DEVICE_DEVS, DEVICE_OBJS - the devices to include in the
#		executable.  See gdevs.mak for details.
#	FEATURES - the optional features to include in the executable.
#		(Currently no such features are defined; this is just a
#		place-holder.)
# It is very unlikely that anyone would want to edit the remaining
#   symbols, but we describe them here for completeness:
#	Q - the string that causes the shell to pass a " to a program
#		(" on MS-DOS, \" on Unix).
#	XE - the extension for executable files (e.g., null or .exe).
#	OBJ - the extension for relocatable object files (e.g., o or obj).
#	CCC - the C invocation for normal compilation.
#	CC0 - a C invocation with the fewer possible flags.  Needed because
#		MS-DOS limits the length of command lines to 128 characters.
#	CCINT - the C invocation for compiling the main interpreter module,
#		normally the same as CCC: this is needed because the
#		Borland compiler generates *worse* code for this module
#		(but only this module) when optimization (-O) is turned on.
#	AK - if source files must be converted from ANSI to K&R syntax,
#		this is ansi2knr$(XE); if not, it is null.
#	UNIQ - null on systems that provide the uniq utility,
#		uniq$(XE) on systems where we have to provide our own.
#	DS - the directory separator (/ or \).
# The platform-specific makefiles must also include rules for creating
#   ansi2knr$(XE) and genarch$(XE) from the corresponding .c files,
#   and for making arch.h by executing genarch$(XE).  (This
#   shouldn't really be necessary, but Turbo C and Unix C treat the -o
#   switch slightly differently (Turbo C requires no following space,
#   Unix C requires a following space), and I haven't found a way to capture
#   the difference in a macro; also, Unix requires ./ because . may not be
#   in the search path, whereas MS-DOS always looks in the current
#   directory first.)

default: gs$(XE)

test: gt$(XE)

clean:
	rm -f *.$(OBJ) *.a core gmon.out
	rm -f *.dev gconfig.h gconfig.tr
	rm -f t _temp_* _temp_*.* libc*.tr *.map *.sym
	rm -f ansi2knr$(XE) genarch$(XE) uniq$(XE) arch.h gs$(XE)

# Note: Unix uses malloc.h and memory.h;
# Turbo C uses alloc.h, stdlib.h, and mem.h.
# 4.2bsd uses strings.h; other systems use string.h.
# gcc on VMS doesn't have a math.h.
# We handle this by using local include files called
# malloc_.h, math_.h, memory_.h, and string_.h
# that perform appropriate indirection.

# Auxiliary programs

# genarch may cause a (deliberate) addressing fault,
# so we invoke it with a preceding -.

arch.h: genarch$(XE)
	- .$(DS)genarch arch.h

# -------------------------------- Library -------------------------------- #

gs.h: std.h
	touch gs.h

gx.h: gs.h
	touch gx.h

GX=$(AK) std.h gx.h
GXERR=$(GX) gserrors.h

###### High-level facilities

gschar.$(OBJ): gschar.c $(GXERR) \
  gxfixed.h gxarith.h gxmatrix.h gzdevice.h gxdevmem.h gxfont.h gxchar.h gstype1.h gspath.h gzpath.h gzcolor.h gzstate.h

gschar0.$(OBJ): gschar0.c $(GXERR) \
  gxfixed.h gxmatrix.h gzdevice.h gxdevmem.h gxfont.h gxchar.h gzstate.h

gscolor.$(OBJ): gscolor.c $(GXERR) \
  gxfixed.h gxmatrix.h gxdevice.h gzstate.h gzcolor.h gzht.h

gscoord.$(OBJ): gscoord.c $(GXERR) \
  gxfixed.h gxmatrix.h gzdevice.h gzstate.h gscoord.h

gsdevice.$(OBJ): gsdevice.c $(GXERR) \
  gxfixed.h gxmatrix.h gxbitmap.h gxdevmem.h gzstate.h gzdevice.h

gsfile.$(OBJ): gsfile.c $(GXERR) \
  gsmatrix.h gxdevice.h gxdevmem.h

gsfont.$(OBJ): gsfont.c $(GXERR) \
  gxdevice.h gxfixed.h gxmatrix.h gxfont.h gxfdir.h gzstate.h

gsimage.$(OBJ): gsimage.c $(GXERR) \
  arch.h gxfixed.h gxarith.h gxmatrix.h gspaint.h gzcolor.h gzdevice.h gzpath.h gzstate.h gximage.h

gsim2out.$(OBJ): gsim2out.c $(GXERR) \
  gsstate.h gsmatrix.h gscoord.h gxfixed.h gxtype1.h

gsline.$(OBJ): gsline.c $(GXERR) \
  gxfixed.h gxmatrix.h gzstate.h gzline.h

gsmatrix.$(OBJ): gsmatrix.c $(GXERR) \
  gxfixed.h gxarith.h gxmatrix.h

gsmisc.$(OBJ): gsmisc.c $(GX)

gspaint.$(OBJ): gspaint.c $(GX) \
  gxfixed.h gxmatrix.h gspaint.h gzpath.h gzstate.h gzdevice.h gximage.h

gspath.$(OBJ): gspath.c $(GXERR) \
  gxfixed.h gxmatrix.h gxpath.h gzstate.h

gspath2.$(OBJ): gspath2.c $(GXERR) \
  gspath.h gxfixed.h gxmatrix.h gzstate.h gzpath.h gzdevice.h

gsstate.$(OBJ): gsstate.c $(GXERR) \
  gxfixed.h gxmatrix.h gzstate.h gzcolor.h gzdevice.h gzht.h gzline.h gzpath.h

gstdev.$(OBJ): gstdev.c $(GX) \
  gxbitmap.h gxdevice.h gxfixed.h gxmatrix.h

gstype1.$(OBJ): gstype1.c $(GXERR) \
  gxarith.h gxfixed.h gxmatrix.h gxchar.h gxdevmem.h gxop1.h gxtype1.h \
  gzstate.h gzdevice.h gzpath.h

###### Low-level facilities

### Nested include files

gsstate.h: gscolor.h
	touch gsstate.h

gxchar.h: gschar.h
	touch gxchar.h

gxfont.h: gsfont.h
	touch gxfont.h

gxmatrix.h: gsmatrix.h
	touch gxmatrix.h

gxtype1.h: gstype1.h
	touch gxtype1.h

gzcolor.h: gscolor.h
	touch gzcolor.h

gzdevice.h: gxdevice.h
	touch gzdevice.h

gzpath.h: gxpath.h
	touch gzpath.h

gzstate.h: gsstate.h
	touch gzstate.h

### Executable code

gxcache.$(OBJ): gxcache.c $(GXERR) \
  gxfixed.h gxmatrix.h gspaint.h gzdevice.h gzcolor.h gxdevmem.h gxfont.h gxfdir.h gxchar.h gzstate.h gzpath.h

gxclist.$(OBJ): gxclist.c $(GXERR) \
  gsmatrix.h gxbitmap.h gxclist.h gxdevice.h gxdevmem.h

gxcolor.$(OBJ): gxcolor.c $(GXERR) \
  gxfixed.h gxmatrix.h gxdevice.h gzcolor.h gzht.h gzstate.h

gxdither.$(OBJ): gxdither.c $(GX) \
  gxfixed.h gxmatrix.h gzstate.h gzdevice.h gzcolor.h gzht.h

gxdraw.$(OBJ): gxdraw.c $(GX) \
  gxfixed.h gxmatrix.h gxbitmap.h gzcolor.h gzdevice.h gzstate.h

gxfill.$(OBJ): gxfill.c $(GXERR) \
  gxfixed.h gxmatrix.h gxdevice.h gzcolor.h gzpath.h gzstate.h

gxht.$(OBJ): gxht.c $(GXERR) \
  gxfixed.h gxmatrix.h gxbitmap.h gzstate.h gzcolor.h gzdevice.h gzht.h

gxpath.$(OBJ): gxpath.c $(GXERR) \
  gxfixed.h gzpath.h

gxpath2.$(OBJ): gxpath2.c $(GXERR) \
  gxfixed.h gxarith.h gzpath.h

gxstroke.$(OBJ): gxstroke.c $(GXERR) \
  gxfixed.h gxarith.h gxmatrix.h gzstate.h gzcolor.h gzdevice.h gzline.h gzpath.h

###### The "memory" device

gdevmem.$(OBJ): gdevmem.c $(AK) \
  gs.h arch.h gxbitmap.h gsmatrix.h gxdevice.h gxdevmem.h

###### Files dependent on the set of installed devices.
###### Generating gconfig.h also generates gconfig.tr.

gconfig.h gconfig.tr: gdevs.mak $(MAKEFILE) $(UNIQ) $(DEVICE_DEVS)
	.$(DS)gsconfig $(DEVICES) + $(FEATURES)

gconfig.$(OBJ): gconfig.c $(AK) gconfig.h $(MAKEFILE)
	$(CC0) -DGS_LIB_DEFAULT=$(Q)$(GS_LIB_DEFAULT)$(Q) -DGS_INIT=$(Q)$(GS_INIT)$(Q) gconfig.c

###### On Unix, we pre-link all of the library except the back end.
###### On MS-DOS, we have to do the whole thing at once.

LIB=gschar.$(OBJ) gschar0.$(OBJ) gscolor.$(OBJ) gscoord.$(OBJ) \
 gsdevice.$(OBJ) gsfile.$(OBJ) gsfont.$(OBJ) \
 gsimage.$(OBJ) gsim2out.$(OBJ) \
 gsline.$(OBJ) gsmatrix.$(OBJ) gsmisc.$(OBJ) \
 gspaint.$(OBJ) gspath.$(OBJ) gspath2.$(OBJ) \
 gsstate.$(OBJ) gstdev.$(OBJ) gstype1.$(OBJ) \
 gxcache.$(OBJ) gxclist.$(OBJ) gxcolor.$(OBJ) \
 gxdither.$(OBJ) gxdraw.$(OBJ) gxfill.$(OBJ) \
 gxht.$(OBJ) gxpath.$(OBJ) gxpath2.$(OBJ) gxstroke.$(OBJ) \
 gdevmem.$(OBJ) gconfig.$(OBJ)

# ------------------------------ Interpreter ------------------------------ #

###### Utilities

GH=$(AK) ghost.h

ialloc.$(OBJ): ialloc.c $(AK) gs.h alloc.h astate.h

idebug.$(OBJ): idebug.c $(GH) \
 iutil.h dict.h name.h ostack.h opdef.h packed.h store.h

idict.$(OBJ): idict.c $(GH) alloc.h errors.h name.h save.h store.h dict.h

iinit.$(OBJ): iinit.c $(GH) alloc.h dict.h errors.h name.h oper.h store.h

iname.$(OBJ): iname.c $(GH) alloc.h errors.h name.h store.h

isave.$(OBJ): isave.c $(GH) alloc.h astate.h name.h save.h store.h

iscan.$(OBJ): iscan.c $(GH) arch.h alloc.h dict.h errors.h iutil.h \
 name.h ostack.h packed.h store.h stream.h scanchar.h

iutil.$(OBJ): iutil.c $(GH) \
 errors.h alloc.h iutil.h name.h ostack.h oper.h store.h \
 gsmatrix.h gxdevice.h gzcolor.h

stream.$(OBJ): stream.c $(AK) std.h stream.h scanchar.h gxfixed.h gstype1.h

###### Operators

ghost.h: gx.h
	touch ghost.h

oper.h: iutil.h opdef.h ostack.h
	touch oper.h

OP=$(GH) errors.h oper.h ostack.h

### Non-graphics operators

zarith.$(OBJ): zarith.c $(OP) store.h

zarray.$(OBJ): zarray.c $(OP) alloc.h packed.h store.h

zcontrol.$(OBJ): zcontrol.c $(OP) estack.h iutil.h store.h

zdict.$(OBJ): zdict.c $(OP) dict.h store.h

zfile.$(OBJ): zfile.c $(OP) gp.h \
  alloc.h estack.h file.h iutil.h save.h stream.h store.h

zfileio.$(OBJ): zfileio.c $(OP) \
  estack.h file.h store.h stream.h \
  gsmatrix.h gxdevice.h gxdevmem.h

zgeneric.$(OBJ): zgeneric.c $(OP) dict.h estack.h name.h packed.h store.h

zmath.$(OBJ): zmath.c $(OP) store.h

zmisc.$(OBJ): zmisc.c $(OP) gp.h alloc.h dict.h name.h packed.h store.h \
  gstype1.h gxfixed.h

zpacked.$(OBJ): zpacked.c $(OP) \
  arch.h alloc.h dict.h name.h packed.h save.h store.h

zrelbit.$(OBJ): zrelbit.c $(OP) store.h dict.h

zstack.$(OBJ): zstack.c $(OP) store.h

zstring.$(OBJ): zstring.c $(OP) alloc.h iutil.h name.h store.h stream.h

ztype.$(OBJ): ztype.c $(OP) dict.h iutil.h name.h stream.h store.h

zvmem.$(OBJ): zvmem.c $(OP) alloc.h estack.h save.h state.h store.h \
  gsmatrix.h gsstate.h

###### Graphics operators

zchar.$(OBJ): zchar.c $(OP) gxmatrix.h gschar.h gstype1.h gxdevice.h gxfixed.h gxfont.h gzpath.h gzstate.h alloc.h dict.h font.h estack.h state.h store.h

zcolor.$(OBJ): zcolor.c $(OP) alloc.h estack.h gsmatrix.h gsstate.h gzcolor.h iutil.h state.h store.h

zdevice.$(OBJ): zdevice.c $(OP) alloc.h state.h gsmatrix.h gsstate.h gxdevice.h store.h

zfont.$(OBJ): zfont.c $(OP) gsmatrix.h gxdevice.h gxfont.h gxfdir.h \
 alloc.h font.h dict.h name.h packed.h save.h state.h store.h

zfont0.$(OBJ): zfont0.c $(OP) gsmatrix.h gxdevice.h gxfont.h \
 alloc.h font.h dict.h name.h state.h store.h

zfont2.$(OBJ): zfont2.c $(OP) gsmatrix.h gxdevice.h gschar.h gxfixed.h gxfont.h \
 alloc.h dict.h font.h name.h packed.h store.h

zgstate.$(OBJ): zgstate.c $(OP) alloc.h gsmatrix.h gsstate.h state.h store.h

zht.$(OBJ): zht.c $(OP) alloc.h estack.h gsmatrix.h gsstate.h state.h store.h

zmatrix.$(OBJ): zmatrix.c $(OP) gsmatrix.h state.h gscoord.h store.h

zpaint.$(OBJ): zpaint.c $(OP) alloc.h estack.h gsmatrix.h gspaint.h state.h store.h

zpath.$(OBJ): zpath.c $(OP) gsmatrix.h gspath.h state.h store.h

zpath2.$(OBJ): zpath2.c $(OP) alloc.h estack.h gspath.h state.h store.h

###### Linking

INT=ialloc.$(OBJ) idebug.$(OBJ) idict.$(OBJ) iinit.$(OBJ) iname.$(OBJ) \
 interp.$(OBJ) isave.$(OBJ) iscan.$(OBJ) iutil.$(OBJ) stream.$(OBJ) \
 zarith.$(OBJ) zarray.$(OBJ) zcontrol.$(OBJ) zdict.$(OBJ) \
 zfile.$(OBJ) zfileio.$(OBJ) zgeneric.$(OBJ) \
 zmath.$(OBJ) zmisc.$(OBJ) zpacked.$(OBJ) zrelbit.$(OBJ) \
 zstack.$(OBJ) zstring.$(OBJ) ztype.$(OBJ) zvmem.$(OBJ) \
 zchar.$(OBJ) zcolor.$(OBJ) zfont.$(OBJ) zfont0.$(OBJ) zfont2.$(OBJ) \
 zdevice.$(OBJ) zgstate.$(OBJ) zht.$(OBJ) zmatrix.$(OBJ) \
 zpaint.$(OBJ) zpath.$(OBJ) zpath2.$(OBJ)

# ----------------------------- Main program ------------------------------ #

# Utilities shared between platforms

gsmain.$(OBJ): gsmain.c $(GX) \
  gp.h gsmatrix.h gxdevice.h

# The default font

uglyr.gsf: ugly10.bdf bdftops.ps gs$(XE)
	.$(DS)gs -q -dNODISPLAY -- bdftops.ps ugly10.bdf uglyr.gsf

# Interpreter main program

interp.$(OBJ): interp.c $(GH) \
  errors.h estack.h name.h dict.h oper.h ostack.h packed.h save.h store.h stream.h
	$(CCINT) interp.c

gs.$(OBJ): gs.c $(GH) alloc.h estack.h ostack.h store.h stream.h
