#    Copyright (C) 1989, 1990, 1991 Aladdin Enterprises.  All rights reserved.
#    Distributed by Free Software Foundation, Inc.
#
# This file is part of Ghostscript.
#
# Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
# to anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer
# to the Ghostscript General Public License for full details.
#
# Everyone is granted permission to copy, modify and redistribute
# Ghostscript, but only under the conditions described in the Ghostscript
# General Public License.  A copy of this license is supposed to have been
# given to you along with Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# makefile for Ghostscript device drivers.

# -------------------------------- Catalog ------------------------------- #

# It is possible to build Ghostscript with an arbitrary collection of
# device drivers, although many drivers are supported only on a subset
# of the target platforms.  The currently available drivers are:

# Displays:
#	bgi	Borland Graphics Interface   [MS-DOS only]
#	ega	EGA display   [MS-DOS only]
# +	mdb10	EIZO MDB-10 display (1024 x 768)   [MS-DOS only]
# *	pe	Private Eye display  [MS-DOS only]
# +	sonyfb	Sony Microsystems monochrome display   [Sony only]
#	sunview  SunView window system   [SunOS only]
#	vga	VGA display   [MS-DOS only]
#	x11	X Windows version 11, release >=3   [Unix only]
# Printers:
#	bit	A "bit bucket" device for time benchmarking
# +	bj10e	Canon BubbleJet BJ10e  [MS-DOS only]
# +	deskjet  H-P DeskJet   [MS-DOS & Unix]
#	epson	Epson dot matrix printers   [MS-DOS & Unix]
# +	laserjet  H-P LaserJet   [MS-DOS & Unix]
# +	ljet2p	H-P LaserJet IId/IIp/III* with TIFF compression   [ditto]
# +	ljet3	H-P LaserJet III* with Delta Row compression   [ditto]
# +	nwp533  Sony Microsystems NWP533 laser printer   [Sony only]
# +	paintjet  H-P PaintJet color printer [MS-DOS & Unix]
# *	trufax	TruFax facsimile driver  [Unix only]

# User-contributed drivers marked with * require hardware or software
# that is not available to Aladdin Enterprises.  Please contact the
# original contributors, not Aladdin Enterprises, if you have questions.
# Contact information appears in the driver entry below.  Drivers marked
# with a + are maintained by Aladdin Enterprises with the assistance of
# users, since Aladdin Enterprises doesn't have the hardware for these
# either.

# If you add drivers, it would be nice if you kept each list
# in alphabetical order.

# Each platform-specific makefile must contain lines of the form
#	DEVICES=<dev1> ... <devn>
#	DEVICE_DEVS=<dev1>.dev ... <devn>.dev
#	DEVICE_OBJS=$(<dev1>_) ... $(<devn>_)
# where dev1 ... devn are the devices to be included in the build.
# dev1 will be used as the default device.  Don't forget the _s!
# On MS-DOS platforms, the first two of these lines must appear *before*,
# and the last *after*, the lines
#	(!)include gdevs.mak
#	(!)include ghost.mak
# in the makefile.  On Unix systems, these device definition lines
# may appear anywhere in the makefile.
#
# The executable must be linked with all the files named in DEVICE_OBJS.
# On MS-DOS platforms, this is done by constructing a file called
# gconfig.tr, to get around the limit on the length of a DOS command line.

# ---------------------------- End of catalog ---------------------------- #

# If you want to add a new device driver, the examples below should be
# enough of a guide to the correct form for the makefile rules.
#
# ****** IMPORTANT NOTE ******
#
# The names of the relocatable (.OBJ) files for MS-DOS drivers
# must be unique in the first *7* characters, because of the way
# the makefile eliminates duplicates.

# All device drivers depend on the following
# (note that we include some indirect dependencies explicitly):

GDEV=$(AK) gs.h gx.h gsmatrix.h gxbitmap.h gxdevice.h

###### ------------------- MS-DOS display devices ------------------- ######

### All the devices use the same driver, with different parameters.

gdevegaa.$(OBJ): gdevegaa.asm

ETEST=ega.$(OBJ) trace.$(OBJ) $(ega_)
ega.exe: $(ETEST) libc$(MM).tr
	tlink /m /l $(LIBDIR)\c0$(MM) @ega.tr @libc$(MM).tr

ega.$(OBJ): ega.c $(GDEV)

PCFB=gdevpcfb.$(OBJ) gdevegaa.$(OBJ)

gdevpcfb.$(OBJ): gdevpcfb.c $(GDEV)

### -------------------------- The EGA device -------------------------- ###

ega_=$(PCFB)
ega.dev: $(ega_)
	.$(DS)gssetdev ega.dev $(ega_)

### -------------------------- The VGA device -------------------------- ###

vga_=$(PCFB)
vga.dev: $(vga_)
	.$(DS)gssetdev vga.dev $(vga_)

### ---------------------- The EIZO MDB-10 device ---------------------- ###

mdb10_=$(PCFB)
mdb10.dev: $(mdb10_)
	.$(DS)gssetdev mdb10.dev $(mdb10_)

###### --------- The BGI (Borland Graphics Interface) device -------- ######

bgi_=gdevbgi.$(OBJ) egavga.$(OBJ)
bgi.dev: $(bgi_)
	.$(DS)gssetdev bgi.dev $(bgi_)

gdevbgi.$(OBJ): gdevbgi.c $(GDEV)

egavga.$(OBJ): $(BGIDIR)\egavga.bgi
	$(BGIDIR)\bgiobj $(BGIDIR)\egavga

###### ------------------- The Private Eye display ------------------- ######
### Note: this driver was contributed by a user:                          ###
###   please contact narf@media-lab.media.mit.edu if you have questions.  ###

pe_=gdevpe.$(OBJ)
pe.dev: $(pe_)
	.$(DS)gssetdev pe.dev $(pe_)

gdevpe.$(OBJ): gdevpe.c $(GDEV)

###### --------------- Memory-buffered printer devices --------------- ######

PDEVH=$(GDEV) gxdevmem.h gxclist.h gdevprn.h

gdevprn.$(OBJ): gdevprn.c $(PDEVH)

### ---------------------- The bit bucket device ----------------------- ###

bit_=gdevbit.$(OBJ) gdevprn.$(OBJ)
bit.dev: $(bit_)
	.$(DS)gssetdev bit.dev $(bit_)

gdevbit.$(OBJ): gdevbit.c $(PDEVH)

### ----------------- The Canon BubbleJet BJ10e device ----------------- ###

bj10e_=gdevbj10.$(OBJ) gdevprn.$(OBJ)
bj10e.dev: $(bj10e_)
	.$(DS)gssetdev bj10e.dev $(bj10e_)

gdevbj10.$(OBJ): gdevbj10.c $(PDEVH)

### ----------- The H-P DeskJet and LaserJet printer devices ----------- ###

### These are essentially the same device.

HPMONO=gdevdjet.$(OBJ) gdevprn.$(OBJ)

gdevdjet.$(OBJ): gdevdjet.c $(PDEVH)

deskjet_=$(HPMONO)
deskjet.dev: $(deskjet_)
	.$(DS)gssetdev deskjet.dev $(deskjet_)

laserjet_=$(HPMONO)
laserjet.dev: $(laserjet_)
	.$(DS)gssetdev laserjet.dev $(laserjet_)

### Selecting ljet2p provides TIFF (mode 2) compression on LaserJet III,
### IIIp, IIId, IIIsi, IId, and IIp. 

ljet2p_=$(HPMONO)
ljet2p.dev: $(ljet2p_)
	.$(DS)gssetdev ljet2p.dev $(ljet2p_)

### Selecting ljet3 provides Delta Row (mode 3) compression on LaserJet III,
### IIIp, IIId, IIIsi.

ljet3_=$(HPMONO)
ljet3.dev: $(ljet3_)
	.$(DS)gssetdev ljet3.dev $(ljet3_)

### ----------------- The generic Epson printer device ----------------- ###
### Note that you can set the default density in the command line below. ###

epson_=gdevepsn.$(OBJ) gdevprn.$(OBJ)
epson.dev: $(epson_)
	.$(DS)gssetdev epson.dev $(epson_)

gdevepsn.$(OBJ): gdevepsn.c $(PDEVH) gdevs.mak
	$(CCC) -DX_DPI=180 -DY_DPI=180 gdevepsn.c

### ------------ The H-P PaintJet color printer device ----------------- ###
### Note: this driver was contributed by users:                          ###
###       please contact marc@vlsi.polymtl.ca if you have questions.     ###
### The files are packaged separately from the rest of the fileset.      ###

paintjet_=gdevpjet.$(OBJ) gdevprn.$(OBJ)
paintjet.dev: $(paintjet_)
	.$(DS)gssetdev paintjet.dev $(paintjet_)

gdevpjet.$(OBJ): gdevpjet.c $(PDEVH)

###### ------------------ Sony frame buffer device ----------------- ######

sonyfb_=gdevsnfb.$(OBJ) gdevprn.$(OBJ)
sonyfb.dev: $(sonyfb_)
	.$(DS)gssetdev sonyfb.dev $(sonyfb_)

gdevsnfb.$(OBJ): gdevsnfb.c $(PDEVH)

###### ----------------- Sony NWP533 printer device ----------------- ######

nwp533_=gdevn533.$(OBJ) gdevprn.$(OBJ)
nwp533.dev: $(nwp533_)
	.$(DS)gssetdev nwp533.dev $(nwp533_)

gdevn533.$(OBJ): gdevn533.c $(PDEVH)

###### --------------------- The SunView device --------------------- ######

sunview_=gdevsun.$(OBJ)
sunview.dev: $(sunview_)
	.$(DS)gssetdev sunview.dev $(sunview_)

gdevsun.$(OBJ): gdevsun.c $(GDEV) arch.h

### ----------------- The TruFax facsimile device ---------------------- ###
### Note: this driver was contributed by users:                          ###
###       please contact nao@bellcore.com if you have questions.         ###
### Note that the driver requires a file encode_l.o supplied by the      ###
###   makers of the TruFax product.                                      ###

trufax_=gdevtrfx.$(OBJ) gdevprn.$(OBJ) encode_l.$(OBJ)
trufax.dev: $(trufax_)
	.$(DS)gssetdev trufax.dev $(trufax_)

gdevtrfx.$(OBJ): gdevtrfx.c $(GDEV)

###### ----------------------- The X11 device ----------------------- ######

x11_=gdevx.$(OBJ)
x11.dev: $(x11_)
	.$(DS)gssetdev x11.dev $(x11_)

### Note: if the X11 client header libraries are located in a directory
### which your compiler automatically searches, you may remove the -I switch
### from the compilation line below; if not, you may have to edit the line
### so that it mentions the correct directory.
gdevx.$(OBJ): gdevx.c $(GDEV) gdevx.h
	$(CCC) -I/usr/local/X/include gdevx.c
