/* Copyright (C) 1989, 1990, 1991 Aladdin Enterprises.  All rights reserved.
   Distributed by Free Software Foundation, Inc.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* gdevprn.h */
/* Common header file for memory-buffered black-and-white printers */

#include "memory_.h"
#include "string_.h"
#include "gs.h"
#include "gxbitmap.h"
#include "gsmatrix.h"			/* for gxdevice.h */
#include "gxdevice.h"
#include "gxdevmem.h"
#include "gxclist.h"

/* Define the parameters for the printer rendering method. */
/* If the entire bitmap fits in PRN_MAX_BITMAP, render in RAM, */
/* otherwise use a command list with a size of PRN_BUFFER_SPACE. */
#ifdef __MSDOS__
/* MS-DOS machines have little dinky RAMs.... */
#  define PRN_MAX_BITMAP 20000
#  define PRN_BUFFER_SPACE 20000
#else
/* Unix and VMS machines have great big hulking RAMs.... */
#  define PRN_MAX_BITMAP 300000L
#  define PRN_BUFFER_SPACE 250000L
#endif

/****** ENABLE OR DISABLE DIRECT WRITING TO PRINTER ******/
#ifdef __MSDOS__
#  define WRITE_TO_PRN 1
#else
#  define WRITE_TO_PRN 0
#endif

/* Define the declaration macro for print_page procedures. */
#define dev_proc_print_page(proc)\
  int proc(P2(gx_device_printer *, FILE *))

/* The device descriptor */
typedef struct gx_device_printer_s gx_device_printer;
struct gx_device_printer_s {
	gx_device_common;
	/* The following is required only for devices where */
	/* output_page is gdev_prn_output_page; */
	/* it is ignored for other devices. */
	dev_proc_print_page((*print_page));
	/* The following two items must be set before calling */
	/* the device open routine. */
	long buffer_space;	/* amount of space for clist buffer, */
					/* 0 means don't use clist */
	int write_to_prn;	/* if true, write directly to printer */
	byte *buf;			/* buffer for rendering */
	char cfname[30];		/* clist file name */
	FILE *cfile;			/* command list scratch file */
	gx_device_clist clist;		/* buffer device */
	gx_device *bdev;		/* clist or clist.mem */
	char fname[30];			/* scratch file name, approx */
					/* strlen(SCRATCH_TEMPLATE)+1 */
	FILE *file;			/* scratch file */
};

/* Macro for casting gx_device argument */
#define prn_dev ((gx_device_printer *)dev)

/* Standard device procedures for printers */
dev_proc_open_device(gdev_prn_open);
dev_proc_output_page(gdev_prn_output_page);
dev_proc_close_device(gdev_prn_close);
dev_proc_map_rgb_color(gdev_prn_map_rgb_color);
dev_proc_map_color_rgb(gdev_prn_map_color_rgb);
dev_proc_fill_rectangle(gdev_prn_fill_rectangle);
dev_proc_tile_rectangle(gdev_prn_tile_rectangle);
dev_proc_copy_mono(gdev_prn_copy_mono);
dev_proc_copy_color(gdev_prn_copy_color);

/* Macro for generating procedure table */
#define prn_procs(proc_open, proc_output_page, proc_close)\
  prn_color_procs(proc_open, proc_output_page, proc_close,\
		  gdev_prn_map_rgb_color, gdev_prn_map_color_rgb)
#define prn_color_procs(proc_open, proc_output_page, proc_close, proc_map_rgb_color, proc_map_color_rgb) {\
	proc_open,\
	gx_default_get_initial_matrix,\
	gx_default_sync_output,\
	proc_output_page,\
	proc_close,\
	proc_map_rgb_color,\
	proc_map_color_rgb,\
	gdev_prn_fill_rectangle,\
	gdev_prn_tile_rectangle,\
	gdev_prn_copy_mono,\
	gdev_prn_copy_color,\
	gx_default_draw_line,\
	gx_default_fill_trapezoid,\
	gx_default_tile_trapezoid\
}

/* The standard printer device procedures */
/* (using gdev_prn_open/output_page/close). */
extern gx_device_procs prn_std_procs;

/* Macro for generating the device descriptor. */
/*
 * The computations of page width and height in pixels should really be
 *	((int)(page_width_inches*x_dpi))
 * but some compilers (the Ultrix 3.X pcc compiler and the HPUX compiler)
 * can't cast a computed float to an int.  That's why we specify
 * the page width and height in inches/10 instead of inches.
 */
#define prn_device(procs, dev_name, width_10ths, height_10ths, x_dpi, y_dpi, l_margin, b_margin, r_margin, t_margin, color_bits, print_page) {\
	sizeof(gx_device_printer),\
	&procs,\
	dev_name,\
	(int)((long)width_10ths * x_dpi / 10),	/* width */\
	(int)((long)height_10ths * y_dpi / 10),	/* height */\
	x_dpi,\
	y_dpi,\
	l_margin, b_margin, r_margin, t_margin,\
	color_bits > 1,	/* has_color */\
	1,		/* rgb_max_value */\
	((color_bits > 1) & (color_bits < 8) ? 8 : color_bits),	/* bits per color pixel */\
	0,		/* not initialized yet */\
	print_page,\
	0,\
	WRITE_TO_PRN\
}

/* Common procedures defined in gdevprn.c */
int gdev_prn_open_printer(P1(gx_device *));
int gdev_prn_copy_scan_lines(P4(gx_device_printer *, int, byte *, uint));
void gdev_prn_transpose_8x8(P4(byte *, int, byte *, int));
int gdev_prn_close_printer(P1(gx_device *));
