#    Copyright (C) 1989, 1990, 1991 Aladdin Enterprises.  All rights reserved.
#    Distributed by Free Software Foundation, Inc.
#
# This file is part of Ghostscript.
#
# Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
# to anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer
# to the Ghostscript General Public License for full details.
#
# Everyone is granted permission to copy, modify and redistribute
# Ghostscript, but only under the conditions described in the Ghostscript
# General Public License.  A copy of this license is supposed to have been
# given to you along with Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# makefile for Ghostscript, Unix/gcc/X11 configuration.

# ------------------------------- Options ------------------------------- #

####### The following are the only parts of the file you should need to edit.

# ------ Generic options ------ #

# Define the default directory/ies for the runtime
# initialization and font files.  Separate multiple directories with a :.
# `pwd` means use the directory in which the 'make' is being done.

GS_LIB_DEFAULT=`pwd`:`pwd`/fonts

# Define the name of the Ghostscript initialization file.
# (There is no reason to change this.)

GS_INIT=gs_init.ps

# Choose generic configuration options.

# -DDEBUG
#	includes debugging features (-Z switch) in the code.
#	  Code runs substantially slower even if no debugging switches
#	  are set.
# -DNOPRIVATE
#	makes private (static) procedures and variables public,
#	  so they are visible to the debugger and profiler.
#	  No execution time or space penalty.

GENOPT=

# ------ Platform-specific options ------ #

# Define the name of the C compiler.

CC=gcc

# Define the other compilation flags.
# Add -DBSD4_2 for 4.2bsd systems.
# Add -DUSG (GNU convention) or -DSYSV for System V or DG/UX.
# XCFLAGS can be set from the command line.
# We don't include -ansi, because this gets in the way of the platform-
#   specific stuff that <math.h> typically needs.

CFLAGS=-g -O $(XCFLAGS)

# Define platform flags for ld.
# Most Unix systems accept -X, but some don't.
# Sun OS4.n may need -Bstatic.
# XLDFLAGS can be set from the command line.

LDFLAGS=-X $(XLDFLAGS)

# Define any extra libraries to link into the executable.
# The default is for X Windows.

EXTRALIBS= -lX11

# Define the installation commands and target directories for
# executables and files.  Only relevant to `make install'.

proginstall = install -m 775
fileinstall = install -m 664
bindir = /usr/local/gnu/bin
libdir = /usr/local/gnu/lib/ghostscript

# ------ Devices and features ------ #

# Choose the language option(s) to include.  See ghost.mak for details.

FEATURES=

# Choose the device(s) to include.  See gdevs.mak for details.

DEVICES=x11
DEVICE_DEVS=x11.dev
DEVICE_OBJS=$(x11_)

# ---------------------------- End of options --------------------------- #

# Define the name of the makefile -- used in dependencies.

MAKEFILE=unix-gcc.mak

# Define the extensions for the object and executable files.

OBJ=o
XE=

# Define the ANSI-to-K&R dependency.  (gcc accepts ANSI syntax.)

AK=

# Define the need for uniq.

UNIQ=

# Define the directory separator and shell quote string.

DS=/
Q=\"

# Define the compilation rules.

CCFLAGS=$(GENOPT) $(CFLAGS)

.c.o:
	$(CC) $(CCFLAGS) -c $*.c

CCC=$(CC) $(CCFLAGS) -c
CC0=$(CCC)
CCINT=$(CCC)

# --------------------------- Generic makefile ---------------------------- #

# The remainder of the makefile (ghost.mak, gdevs.mak, and unixtail.mak)
# is generic.  tar_gs concatenates all these together.
#    Copyright (C) 1989, 1990, 1991 Aladdin Enterprises.  All rights reserved.
#    Distributed by Free Software Foundation, Inc.
#
# This file is part of Ghostscript.
#
# Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
# to anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer
# to the Ghostscript General Public License for full details.
#
# Everyone is granted permission to copy, modify and redistribute
# Ghostscript, but only under the conditions described in the Ghostscript
# General Public License.  A copy of this license is supposed to have been
# given to you along with Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# Generic makefile for Ghostscript.
# The platform-specific makefiles `include' this file.
# They define the following symbols:
#	GS_INIT - the name of the initialization file for Ghostscript,
#		normally gs_init.ps.
#	GS_LIB_DEFAULT - the default directory/ies for searching for the
#		initialization and font files at run time.
#	DEVICES, DEVICE_DEVS, DEVICE_OBJS - the devices to include in the
#		executable.  See gdevs.mak for details.
#	FEATURES - the optional features to include in the executable.
#		(Currently no such features are defined; this is just a
#		place-holder.)
# It is very unlikely that anyone would want to edit the remaining
#   symbols, but we describe them here for completeness:
#	Q - the string that causes the shell to pass a " to a program
#		(" on MS-DOS, \" on Unix).
#	XE - the extension for executable files (e.g., null or .exe).
#	OBJ - the extension for relocatable object files (e.g., o or obj).
#	CCC - the C invocation for normal compilation.
#	CC0 - a C invocation with the fewer possible flags.  Needed because
#		MS-DOS limits the length of command lines to 128 characters.
#	CCINT - the C invocation for compiling the main interpreter module,
#		normally the same as CCC: this is needed because the
#		Borland compiler generates *worse* code for this module
#		(but only this module) when optimization (-O) is turned on.
#	AK - if source files must be converted from ANSI to K&R syntax,
#		this is ansi2knr$(XE); if not, it is null.
#	UNIQ - null on systems that provide the uniq utility,
#		uniq$(XE) on systems where we have to provide our own.
#	DS - the directory separator (/ or \).
# The platform-specific makefiles must also include rules for creating
#   ansi2knr$(XE) and genarch$(XE) from the corresponding .c files,
#   and for making arch.h by executing genarch$(XE).  (This
#   shouldn't really be necessary, but Turbo C and Unix C treat the -o
#   switch slightly differently (Turbo C requires no following space,
#   Unix C requires a following space), and I haven't found a way to capture
#   the difference in a macro; also, Unix requires ./ because . may not be
#   in the search path, whereas MS-DOS always looks in the current
#   directory first.)

default: gs$(XE)

test: gt$(XE)

clean:
	rm -f *.$(OBJ) *.a core gmon.out
	rm -f *.dev gconfig.h gconfig.tr
	rm -f t _temp_* _temp_*.* libc*.tr *.map *.sym
	rm -f ansi2knr$(XE) genarch$(XE) uniq$(XE) arch.h gs$(XE)

# Note: Unix uses malloc.h and memory.h;
# Turbo C uses alloc.h, stdlib.h, and mem.h.
# 4.2bsd uses strings.h; other systems use string.h.
# gcc on VMS doesn't have a math.h.
# We handle this by using local include files called
# malloc_.h, math_.h, memory_.h, and string_.h
# that perform appropriate indirection.

# Auxiliary programs

# genarch may cause a (deliberate) addressing fault,
# so we invoke it with a preceding -.

arch.h: genarch$(XE)
	- .$(DS)genarch arch.h

# -------------------------------- Library -------------------------------- #

gs.h: std.h
	touch gs.h

gx.h: gs.h
	touch gx.h

GX=$(AK) std.h gx.h
GXERR=$(GX) gserrors.h

###### High-level facilities

gschar.$(OBJ): gschar.c $(GXERR) \
  gxfixed.h gxarith.h gxmatrix.h gzdevice.h gxdevmem.h gxfont.h gxchar.h gstype1.h gspath.h gzpath.h gzcolor.h gzstate.h

gschar0.$(OBJ): gschar0.c $(GXERR) \
  gxfixed.h gxmatrix.h gzdevice.h gxdevmem.h gxfont.h gxchar.h gzstate.h

gscolor.$(OBJ): gscolor.c $(GXERR) \
  gxfixed.h gxmatrix.h gxdevice.h gzstate.h gzcolor.h gzht.h

gscoord.$(OBJ): gscoord.c $(GXERR) \
  gxfixed.h gxmatrix.h gzdevice.h gzstate.h gscoord.h

gsdevice.$(OBJ): gsdevice.c $(GXERR) \
  gxfixed.h gxmatrix.h gxbitmap.h gxdevmem.h gzstate.h gzdevice.h

gsfile.$(OBJ): gsfile.c $(GXERR) \
  gsmatrix.h gxdevice.h gxdevmem.h

gsfont.$(OBJ): gsfont.c $(GXERR) \
  gxdevice.h gxfixed.h gxmatrix.h gxfont.h gxfdir.h gzstate.h

gsimage.$(OBJ): gsimage.c $(GXERR) \
  arch.h gxfixed.h gxarith.h gxmatrix.h gspaint.h gzcolor.h gzdevice.h gzpath.h gzstate.h gximage.h

gsim2out.$(OBJ): gsim2out.c $(GXERR) \
  gsstate.h gsmatrix.h gscoord.h gxfixed.h gxtype1.h

gsline.$(OBJ): gsline.c $(GXERR) \
  gxfixed.h gxmatrix.h gzstate.h gzline.h

gsmatrix.$(OBJ): gsmatrix.c $(GXERR) \
  gxfixed.h gxarith.h gxmatrix.h

gsmisc.$(OBJ): gsmisc.c $(GX)

gspaint.$(OBJ): gspaint.c $(GX) \
  gxfixed.h gxmatrix.h gspaint.h gzpath.h gzstate.h gzdevice.h gximage.h

gspath.$(OBJ): gspath.c $(GXERR) \
  gxfixed.h gxmatrix.h gxpath.h gzstate.h

gspath2.$(OBJ): gspath2.c $(GXERR) \
  gspath.h gxfixed.h gxmatrix.h gzstate.h gzpath.h gzdevice.h

gsstate.$(OBJ): gsstate.c $(GXERR) \
  gxfixed.h gxmatrix.h gzstate.h gzcolor.h gzdevice.h gzht.h gzline.h gzpath.h

gstdev.$(OBJ): gstdev.c $(GX) \
  gxbitmap.h gxdevice.h gxfixed.h gxmatrix.h

gstype1.$(OBJ): gstype1.c $(GXERR) \
  gxarith.h gxfixed.h gxmatrix.h gxchar.h gxdevmem.h gxop1.h gxtype1.h \
  gzstate.h gzdevice.h gzpath.h

###### Low-level facilities

### Nested include files

gsstate.h: gscolor.h
	touch gsstate.h

gxchar.h: gschar.h
	touch gxchar.h

gxfont.h: gsfont.h
	touch gxfont.h

gxmatrix.h: gsmatrix.h
	touch gxmatrix.h

gxtype1.h: gstype1.h
	touch gxtype1.h

gzcolor.h: gscolor.h
	touch gzcolor.h

gzdevice.h: gxdevice.h
	touch gzdevice.h

gzpath.h: gxpath.h
	touch gzpath.h

gzstate.h: gsstate.h
	touch gzstate.h

### Executable code

gxcache.$(OBJ): gxcache.c $(GXERR) \
  gxfixed.h gxmatrix.h gspaint.h gzdevice.h gzcolor.h gxdevmem.h gxfont.h gxfdir.h gxchar.h gzstate.h gzpath.h

gxclist.$(OBJ): gxclist.c $(GXERR) \
  gsmatrix.h gxbitmap.h gxclist.h gxdevice.h gxdevmem.h

gxcolor.$(OBJ): gxcolor.c $(GXERR) \
  gxfixed.h gxmatrix.h gxdevice.h gzcolor.h gzht.h gzstate.h

gxdither.$(OBJ): gxdither.c $(GX) \
  gxfixed.h gxmatrix.h gzstate.h gzdevice.h gzcolor.h gzht.h

gxdraw.$(OBJ): gxdraw.c $(GX) \
  gxfixed.h gxmatrix.h gxbitmap.h gzcolor.h gzdevice.h gzstate.h

gxfill.$(OBJ): gxfill.c $(GXERR) \
  gxfixed.h gxmatrix.h gxdevice.h gzcolor.h gzpath.h gzstate.h

gxht.$(OBJ): gxht.c $(GXERR) \
  gxfixed.h gxmatrix.h gxbitmap.h gzstate.h gzcolor.h gzdevice.h gzht.h

gxpath.$(OBJ): gxpath.c $(GXERR) \
  gxfixed.h gzpath.h

gxpath2.$(OBJ): gxpath2.c $(GXERR) \
  gxfixed.h gxarith.h gzpath.h

gxstroke.$(OBJ): gxstroke.c $(GXERR) \
  gxfixed.h gxarith.h gxmatrix.h gzstate.h gzcolor.h gzdevice.h gzline.h gzpath.h

###### The "memory" device

gdevmem.$(OBJ): gdevmem.c $(AK) \
  gs.h arch.h gxbitmap.h gsmatrix.h gxdevice.h gxdevmem.h

###### Files dependent on the set of installed devices.
###### Generating gconfig.h also generates gconfig.tr.

gconfig.h gconfig.tr: gdevs.mak $(MAKEFILE) $(UNIQ) $(DEVICE_DEVS)
	.$(DS)gsconfig $(DEVICES) + $(FEATURES)

gconfig.$(OBJ): gconfig.c $(AK) gconfig.h $(MAKEFILE)
	$(CC0) -DGS_LIB_DEFAULT=$(Q)$(GS_LIB_DEFAULT)$(Q) -DGS_INIT=$(Q)$(GS_INIT)$(Q) gconfig.c

###### On Unix, we pre-link all of the library except the back end.
###### On MS-DOS, we have to do the whole thing at once.

LIB=gschar.$(OBJ) gschar0.$(OBJ) gscolor.$(OBJ) gscoord.$(OBJ) \
 gsdevice.$(OBJ) gsfile.$(OBJ) gsfont.$(OBJ) \
 gsimage.$(OBJ) gsim2out.$(OBJ) \
 gsline.$(OBJ) gsmatrix.$(OBJ) gsmisc.$(OBJ) \
 gspaint.$(OBJ) gspath.$(OBJ) gspath2.$(OBJ) \
 gsstate.$(OBJ) gstdev.$(OBJ) gstype1.$(OBJ) \
 gxcache.$(OBJ) gxclist.$(OBJ) gxcolor.$(OBJ) \
 gxdither.$(OBJ) gxdraw.$(OBJ) gxfill.$(OBJ) \
 gxht.$(OBJ) gxpath.$(OBJ) gxpath2.$(OBJ) gxstroke.$(OBJ) \
 gdevmem.$(OBJ) gconfig.$(OBJ)

# ------------------------------ Interpreter ------------------------------ #

###### Utilities

GH=$(AK) ghost.h

ialloc.$(OBJ): ialloc.c $(AK) gs.h alloc.h astate.h

idebug.$(OBJ): idebug.c $(GH) \
 iutil.h dict.h name.h ostack.h opdef.h packed.h store.h

idict.$(OBJ): idict.c $(GH) alloc.h errors.h name.h save.h store.h dict.h

iinit.$(OBJ): iinit.c $(GH) alloc.h dict.h errors.h name.h oper.h store.h

iname.$(OBJ): iname.c $(GH) alloc.h errors.h name.h store.h

isave.$(OBJ): isave.c $(GH) alloc.h astate.h name.h save.h store.h

iscan.$(OBJ): iscan.c $(GH) arch.h alloc.h dict.h errors.h iutil.h \
 name.h ostack.h packed.h store.h stream.h scanchar.h

iutil.$(OBJ): iutil.c $(GH) \
 errors.h alloc.h iutil.h name.h ostack.h oper.h store.h \
 gsmatrix.h gxdevice.h gzcolor.h

stream.$(OBJ): stream.c $(AK) std.h stream.h scanchar.h gxfixed.h gstype1.h

###### Operators

ghost.h: gx.h
	touch ghost.h

oper.h: iutil.h opdef.h ostack.h
	touch oper.h

OP=$(GH) errors.h oper.h ostack.h

### Non-graphics operators

zarith.$(OBJ): zarith.c $(OP) store.h

zarray.$(OBJ): zarray.c $(OP) alloc.h packed.h store.h

zcontrol.$(OBJ): zcontrol.c $(OP) estack.h iutil.h store.h

zdict.$(OBJ): zdict.c $(OP) dict.h store.h

zfile.$(OBJ): zfile.c $(OP) gp.h \
  alloc.h estack.h file.h iutil.h save.h stream.h store.h

zfileio.$(OBJ): zfileio.c $(OP) \
  estack.h file.h store.h stream.h \
  gsmatrix.h gxdevice.h gxdevmem.h

zgeneric.$(OBJ): zgeneric.c $(OP) dict.h estack.h name.h packed.h store.h

zmath.$(OBJ): zmath.c $(OP) store.h

zmisc.$(OBJ): zmisc.c $(OP) gp.h alloc.h dict.h name.h packed.h store.h \
  gstype1.h gxfixed.h

zpacked.$(OBJ): zpacked.c $(OP) \
  arch.h alloc.h dict.h name.h packed.h save.h store.h

zrelbit.$(OBJ): zrelbit.c $(OP) store.h dict.h

zstack.$(OBJ): zstack.c $(OP) store.h

zstring.$(OBJ): zstring.c $(OP) alloc.h iutil.h name.h store.h stream.h

ztype.$(OBJ): ztype.c $(OP) dict.h iutil.h name.h stream.h store.h

zvmem.$(OBJ): zvmem.c $(OP) alloc.h estack.h save.h state.h store.h \
  gsmatrix.h gsstate.h

###### Graphics operators

zchar.$(OBJ): zchar.c $(OP) gxmatrix.h gschar.h gstype1.h gxdevice.h gxfixed.h gxfont.h gzpath.h gzstate.h alloc.h dict.h font.h estack.h state.h store.h

zcolor.$(OBJ): zcolor.c $(OP) alloc.h estack.h gsmatrix.h gsstate.h gzcolor.h iutil.h state.h store.h

zdevice.$(OBJ): zdevice.c $(OP) alloc.h state.h gsmatrix.h gsstate.h gxdevice.h store.h

zfont.$(OBJ): zfont.c $(OP) gsmatrix.h gxdevice.h gxfont.h gxfdir.h \
 alloc.h font.h dict.h name.h packed.h save.h state.h store.h

zfont0.$(OBJ): zfont0.c $(OP) gsmatrix.h gxdevice.h gxfont.h \
 alloc.h font.h dict.h name.h state.h store.h

zfont2.$(OBJ): zfont2.c $(OP) gsmatrix.h gxdevice.h gschar.h gxfixed.h gxfont.h \
 alloc.h dict.h font.h name.h packed.h store.h

zgstate.$(OBJ): zgstate.c $(OP) alloc.h gsmatrix.h gsstate.h state.h store.h

zht.$(OBJ): zht.c $(OP) alloc.h estack.h gsmatrix.h gsstate.h state.h store.h

zmatrix.$(OBJ): zmatrix.c $(OP) gsmatrix.h state.h gscoord.h store.h

zpaint.$(OBJ): zpaint.c $(OP) alloc.h estack.h gsmatrix.h gspaint.h state.h store.h

zpath.$(OBJ): zpath.c $(OP) gsmatrix.h gspath.h state.h store.h

zpath2.$(OBJ): zpath2.c $(OP) alloc.h estack.h gspath.h state.h store.h

###### Linking

INT=ialloc.$(OBJ) idebug.$(OBJ) idict.$(OBJ) iinit.$(OBJ) iname.$(OBJ) \
 interp.$(OBJ) isave.$(OBJ) iscan.$(OBJ) iutil.$(OBJ) stream.$(OBJ) \
 zarith.$(OBJ) zarray.$(OBJ) zcontrol.$(OBJ) zdict.$(OBJ) \
 zfile.$(OBJ) zfileio.$(OBJ) zgeneric.$(OBJ) \
 zmath.$(OBJ) zmisc.$(OBJ) zpacked.$(OBJ) zrelbit.$(OBJ) \
 zstack.$(OBJ) zstring.$(OBJ) ztype.$(OBJ) zvmem.$(OBJ) \
 zchar.$(OBJ) zcolor.$(OBJ) zfont.$(OBJ) zfont0.$(OBJ) zfont2.$(OBJ) \
 zdevice.$(OBJ) zgstate.$(OBJ) zht.$(OBJ) zmatrix.$(OBJ) \
 zpaint.$(OBJ) zpath.$(OBJ) zpath2.$(OBJ)

# ----------------------------- Main program ------------------------------ #

# Utilities shared between platforms

gsmain.$(OBJ): gsmain.c $(GX) \
  gp.h gsmatrix.h gxdevice.h

# The default font

uglyr.gsf: ugly10.bdf bdftops.ps gs$(XE)
	.$(DS)gs -q -dNODISPLAY -- bdftops.ps ugly10.bdf uglyr.gsf

# Interpreter main program

interp.$(OBJ): interp.c $(GH) \
  errors.h estack.h name.h dict.h oper.h ostack.h packed.h save.h store.h stream.h
	$(CCINT) interp.c

gs.$(OBJ): gs.c $(GH) alloc.h estack.h ostack.h store.h stream.h
#    Copyright (C) 1989, 1990, 1991 Aladdin Enterprises.  All rights reserved.
#    Distributed by Free Software Foundation, Inc.
#
# This file is part of Ghostscript.
#
# Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
# to anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer
# to the Ghostscript General Public License for full details.
#
# Everyone is granted permission to copy, modify and redistribute
# Ghostscript, but only under the conditions described in the Ghostscript
# General Public License.  A copy of this license is supposed to have been
# given to you along with Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# makefile for Ghostscript device drivers.

# -------------------------------- Catalog ------------------------------- #

# It is possible to build Ghostscript with an arbitrary collection of
# device drivers, although many drivers are supported only on a subset
# of the target platforms.  The currently available drivers are:

# Displays:
#	bgi	Borland Graphics Interface   [MS-DOS only]
#	ega	EGA display   [MS-DOS only]
# +	mdb10	EIZO MDB-10 display (1024 x 768)   [MS-DOS only]
# *	pe	Private Eye display  [MS-DOS only]
# +	sonyfb	Sony Microsystems monochrome display   [Sony only]
#	sunview  SunView window system   [SunOS only]
#	vga	VGA display   [MS-DOS only]
#	x11	X Windows version 11, release >=3   [Unix only]
# Printers:
#	bit	A "bit bucket" device for time benchmarking
# +	bj10e	Canon BubbleJet BJ10e  [MS-DOS only]
# +	deskjet  H-P DeskJet   [MS-DOS & Unix]
#	epson	Epson dot matrix printers   [MS-DOS & Unix]
# +	laserjet  H-P LaserJet   [MS-DOS & Unix]
# +	ljet2p	H-P LaserJet IId/IIp/III* with TIFF compression   [ditto]
# +	ljet3	H-P LaserJet III* with Delta Row compression   [ditto]
# +	nwp533  Sony Microsystems NWP533 laser printer   [Sony only]
# +	paintjet  H-P PaintJet color printer [MS-DOS & Unix]
# *	trufax	TruFax facsimile driver  [Unix only]

# User-contributed drivers marked with * require hardware or software
# that is not available to Aladdin Enterprises.  Please contact the
# original contributors, not Aladdin Enterprises, if you have questions.
# Contact information appears in the driver entry below.  Drivers marked
# with a + are maintained by Aladdin Enterprises with the assistance of
# users, since Aladdin Enterprises doesn't have the hardware for these
# either.

# If you add drivers, it would be nice if you kept each list
# in alphabetical order.

# Each platform-specific makefile must contain lines of the form
#	DEVICES=<dev1> ... <devn>
#	DEVICE_DEVS=<dev1>.dev ... <devn>.dev
#	DEVICE_OBJS=$(<dev1>_) ... $(<devn>_)
# where dev1 ... devn are the devices to be included in the build.
# dev1 will be used as the default device.  Don't forget the _s!
# On MS-DOS platforms, the first two of these lines must appear *before*,
# and the last *after*, the lines
#	(!)include gdevs.mak
#	(!)include ghost.mak
# in the makefile.  On Unix systems, these device definition lines
# may appear anywhere in the makefile.
#
# The executable must be linked with all the files named in DEVICE_OBJS.
# On MS-DOS platforms, this is done by constructing a file called
# gconfig.tr, to get around the limit on the length of a DOS command line.

# ---------------------------- End of catalog ---------------------------- #

# If you want to add a new device driver, the examples below should be
# enough of a guide to the correct form for the makefile rules.
#
# ****** IMPORTANT NOTE ******
#
# The names of the relocatable (.OBJ) files for MS-DOS drivers
# must be unique in the first *7* characters, because of the way
# the makefile eliminates duplicates.

# All device drivers depend on the following
# (note that we include some indirect dependencies explicitly):

GDEV=$(AK) gs.h gx.h gsmatrix.h gxbitmap.h gxdevice.h

###### ------------------- MS-DOS display devices ------------------- ######

### All the devices use the same driver, with different parameters.

gdevegaa.$(OBJ): gdevegaa.asm

ETEST=ega.$(OBJ) trace.$(OBJ) $(ega_)
ega.exe: $(ETEST) libc$(MM).tr
	tlink /m /l $(LIBDIR)\c0$(MM) @ega.tr @libc$(MM).tr

ega.$(OBJ): ega.c $(GDEV)

PCFB=gdevpcfb.$(OBJ) gdevegaa.$(OBJ)

gdevpcfb.$(OBJ): gdevpcfb.c $(GDEV)

### -------------------------- The EGA device -------------------------- ###

ega_=$(PCFB)
ega.dev: $(ega_)
	.$(DS)gssetdev ega.dev $(ega_)

### -------------------------- The VGA device -------------------------- ###

vga_=$(PCFB)
vga.dev: $(vga_)
	.$(DS)gssetdev vga.dev $(vga_)

### ---------------------- The EIZO MDB-10 device ---------------------- ###

mdb10_=$(PCFB)
mdb10.dev: $(mdb10_)
	.$(DS)gssetdev mdb10.dev $(mdb10_)

###### --------- The BGI (Borland Graphics Interface) device -------- ######

bgi_=gdevbgi.$(OBJ) egavga.$(OBJ)
bgi.dev: $(bgi_)
	.$(DS)gssetdev bgi.dev $(bgi_)

gdevbgi.$(OBJ): gdevbgi.c $(GDEV)

egavga.$(OBJ): $(BGIDIR)\egavga.bgi
	$(BGIDIR)\bgiobj $(BGIDIR)\egavga

###### ------------------- The Private Eye display ------------------- ######
### Note: this driver was contributed by a user:                          ###
###   please contact narf@media-lab.media.mit.edu if you have questions.  ###

pe_=gdevpe.$(OBJ)
pe.dev: $(pe_)
	.$(DS)gssetdev pe.dev $(pe_)

gdevpe.$(OBJ): gdevpe.c $(GDEV)

###### --------------- Memory-buffered printer devices --------------- ######

PDEVH=$(GDEV) gxdevmem.h gxclist.h gdevprn.h

gdevprn.$(OBJ): gdevprn.c $(PDEVH)

### ---------------------- The bit bucket device ----------------------- ###

bit_=gdevbit.$(OBJ) gdevprn.$(OBJ)
bit.dev: $(bit_)
	.$(DS)gssetdev bit.dev $(bit_)

gdevbit.$(OBJ): gdevbit.c $(PDEVH)

### ----------------- The Canon BubbleJet BJ10e device ----------------- ###

bj10e_=gdevbj10.$(OBJ) gdevprn.$(OBJ)
bj10e.dev: $(bj10e_)
	.$(DS)gssetdev bj10e.dev $(bj10e_)

gdevbj10.$(OBJ): gdevbj10.c $(PDEVH)

### ----------- The H-P DeskJet and LaserJet printer devices ----------- ###

### These are essentially the same device.

HPMONO=gdevdjet.$(OBJ) gdevprn.$(OBJ)

gdevdjet.$(OBJ): gdevdjet.c $(PDEVH)

deskjet_=$(HPMONO)
deskjet.dev: $(deskjet_)
	.$(DS)gssetdev deskjet.dev $(deskjet_)

laserjet_=$(HPMONO)
laserjet.dev: $(laserjet_)
	.$(DS)gssetdev laserjet.dev $(laserjet_)

### Selecting ljet2p provides TIFF (mode 2) compression on LaserJet III,
### IIIp, IIId, IIIsi, IId, and IIp. 

ljet2p_=$(HPMONO)
ljet2p.dev: $(ljet2p_)
	.$(DS)gssetdev ljet2p.dev $(ljet2p_)

### Selecting ljet3 provides Delta Row (mode 3) compression on LaserJet III,
### IIIp, IIId, IIIsi.

ljet3_=$(HPMONO)
ljet3.dev: $(ljet3_)
	.$(DS)gssetdev ljet3.dev $(ljet3_)

### ----------------- The generic Epson printer device ----------------- ###
### Note that you can set the default density in the command line below. ###

epson_=gdevepsn.$(OBJ) gdevprn.$(OBJ)
epson.dev: $(epson_)
	.$(DS)gssetdev epson.dev $(epson_)

gdevepsn.$(OBJ): gdevepsn.c $(PDEVH) gdevs.mak
	$(CCC) -DX_DPI=180 -DY_DPI=180 gdevepsn.c

### ------------ The H-P PaintJet color printer device ----------------- ###
### Note: this driver was contributed by users:                          ###
###       please contact marc@vlsi.polymtl.ca if you have questions.     ###
### The files are packaged separately from the rest of the fileset.      ###

paintjet_=gdevpjet.$(OBJ) gdevprn.$(OBJ)
paintjet.dev: $(paintjet_)
	.$(DS)gssetdev paintjet.dev $(paintjet_)

gdevpjet.$(OBJ): gdevpjet.c $(PDEVH)

###### ------------------ Sony frame buffer device ----------------- ######

sonyfb_=gdevsnfb.$(OBJ) gdevprn.$(OBJ)
sonyfb.dev: $(sonyfb_)
	.$(DS)gssetdev sonyfb.dev $(sonyfb_)

gdevsnfb.$(OBJ): gdevsnfb.c $(PDEVH)

###### ----------------- Sony NWP533 printer device ----------------- ######

nwp533_=gdevn533.$(OBJ) gdevprn.$(OBJ)
nwp533.dev: $(nwp533_)
	.$(DS)gssetdev nwp533.dev $(nwp533_)

gdevn533.$(OBJ): gdevn533.c $(PDEVH)

###### --------------------- The SunView device --------------------- ######

sunview_=gdevsun.$(OBJ)
sunview.dev: $(sunview_)
	.$(DS)gssetdev sunview.dev $(sunview_)

gdevsun.$(OBJ): gdevsun.c $(GDEV) arch.h

### ----------------- The TruFax facsimile device ---------------------- ###
### Note: this driver was contributed by users:                          ###
###       please contact nao@bellcore.com if you have questions.         ###
### Note that the driver requires a file encode_l.o supplied by the      ###
###   makers of the TruFax product.                                      ###

trufax_=gdevtrfx.$(OBJ) gdevprn.$(OBJ) encode_l.$(OBJ)
trufax.dev: $(trufax_)
	.$(DS)gssetdev trufax.dev $(trufax_)

gdevtrfx.$(OBJ): gdevtrfx.c $(GDEV)

###### ----------------------- The X11 device ----------------------- ######

x11_=gdevx.$(OBJ)
x11.dev: $(x11_)
	.$(DS)gssetdev x11.dev $(x11_)

### Note: if the X11 client header libraries are located in a directory
### which your compiler automatically searches, you may remove the -I switch
### from the compilation line below; if not, you may have to edit the line
### so that it mentions the correct directory.
gdevx.$(OBJ): gdevx.c $(GDEV) gdevx.h
	$(CCC) -I/usr/local/X/include gdevx.c
#    Copyright (C) 1990, 1991 Aladdin Enterprises.  All rights reserved.
#    Distributed by Free Software Foundation, Inc.
#
# This file is part of Ghostscript.
#
# Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
# to anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer
# to the Ghostscript General Public License for full details.
#
# Everyone is granted permission to copy, modify and redistribute
# Ghostscript, but only under the conditions described in the Ghostscript
# General Public License.  A copy of this license is supposed to have been
# given to you along with Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# Partial makefile for Ghostscript, common to all Unix configurations.

# This is the last part of the makefile for Unix configurations.
# Since Unix make doesn't have an 'include' facility, we concatenate
# the various parts of the makefile together by brute force (in tar_gs).

# -------------------------------- Library -------------------------------- #

## The Unix platform

PLATUNIX=gp_unix.$(OBJ)

gp_unix.$(OBJ): gp_unix.c gp.h

# -------------------------- Auxiliary programs --------------------------- #

ansi2knr$(XE):
	$(CC) -o ansi2knr$(XE) $(CFLAGS) ansi2knr.c $(EXTRALIBS)

genarch$(XE): genarch.c
	$(CC) -o genarch$(XE) $(CFLAGS) genarch.c $(EXTRALIBS)

# ----------------------------- Main program ------------------------------ #

# (Dummy) tracing package

utrace.$(OBJ): utrace.c cframe_.h

# Main program

ALLUNIX=gsmain.$(OBJ) utrace.$(OBJ) $(LIB) $(PLATUNIX) $(DEVICE_OBJS)

# Interpreter main program

GSUNIX=gs.$(OBJ) $(INT) $(ALLUNIX)

gs: $(GSUNIX)
	$(CC) $(LDFLAGS) -o gs $(GSUNIX) $(EXTRALIBS) -lm

# Installation

sysps = gs_init.ps gs_fonts.ps gs_statd.ps symbol_e.ps gconfig.ps quit.ps
sysfiles = $(sysps) Fontmap uglyr.gsf
artps = chess.ps cheq.ps golfer.ps escher.ps
utilps = decrypt.ps bdftops.ps pfbtops.ps pstoppm.ps fcutils.ps prfont.ps

install:
	$(proginstall) gs $(bindir)
	$(proginstall) gsnd $(bindir)
	$(proginstall) bdftops $(bindir)
	$(proginstall) pfbtops $(bindir)
	$(fileinstall) gs_init.ps $(libdir)
	$(fileinstall) gs_fonts.ps $(libdir)
	$(fileinstall) gs_statd.ps $(libdir)
	$(fileinstall) symbol_e.ps $(libdir)
	$(fileinstall) gconfig.ps $(libdir)
	$(fileinstall) quit.ps $(libdir)
	$(fileinstall) Fontmap $(libdir)
	$(fileinstall) uglyr.gsf $(libdir)
	$(fileinstall) chess.ps $(libdir)
	$(fileinstall) cheq.ps $(libdir)
	$(fileinstall) golfer.ps $(libdir)
	$(fileinstall) escher.ps $(libdir)
	$(fileinstall) decrypt.ps $(libdir)
	$(fileinstall) bdftops.ps $(libdir)
	$(fileinstall) pfbtops.ps $(libdir)
	$(fileinstall) pstoppm.ps $(libdir)
	$(fileinstall) fcutils.ps $(libdir)
	$(fileinstall) prfont.ps $(libdir)
