/* Copyright (C) 1991 Aladdin Enterprises.  All rights reserved.
   Distributed by Free Software Foundation, Inc.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* gxclist.h */
/* Command list definitions for Ghostscript. */
/* Requires gxdevice.h and gxdevmem.h */

/*
 * A command list is essentially a compressed list of driver calls.
 * Command lists are used for several purposes:
 *	- Providing a more compact representation of cached characters
 *	than a full bitmap (at high resolution);
 *	- Recording an image that must be rendered in bands for
 *	a high-resolution printer;
 *	- Representing fully rendered user paths.
 * They may be used for other purposes in the future as well.
 */

/* A command list device outputs commands to a stream, */
/* then reads them back to render in bands. */
typedef struct gx_device_clist_s gx_device_clist;
typedef struct gx_clist_state_s gx_clist_state;
struct gx_device_clist_s {
	gx_device_common;		/* (see gxdevice.h) */
	/* Following must be set before writing or reading. */
	gx_device *target;		/* device for which commands */
					/* are being buffered */
	byte *data;			/* buffer area */
	uint data_size;			/* size of buffer */
	FILE *file;			/* command list file */
	/* Following are used only when writing. */
	gx_clist_state *states;		/* current state of each band */
	byte *cbuf;			/* start of command buffer */
	byte *cnext;			/* next slot in command buffer */
	byte *cend;			/* end of command buffer */
	gx_clist_state *ccls;		/* clist_state of last command */
	/* Following are used for both writing and reading. */
	byte *tile_data;		/* data for cached tile */
	uint tile_size;			/* size of tile data */
	/* Following are set when writing, read when reading. */
	int band_height;		/* height of each band */
	int nbands;			/* # of bands */
	/* Following are used only when reading. */
	int ymin, ymax;			/* current band */
	gx_device_memory mdev;
};
extern gx_device_clist
	gs_clist_device;

/* The public interface to command lists */
int clist_render_init(P1(gx_device_clist *));
int clist_copy_scan_lines(P4(gx_device_clist *, int, byte *, uint));
