#    Copyright (C) 1989, 1990, 1991 Aladdin Enterprises.  All rights reserved.
#    Distributed by Free Software Foundation, Inc.
#
# This file is part of Ghostscript.
#
# Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
# to anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer
# to the Ghostscript General Public License for full details.
#
# Everyone is granted permission to copy, modify and redistribute
# Ghostscript, but only under the conditions described in the Ghostscript
# General Public License.  A copy of this license is supposed to have been
# given to you along with Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# makefile for Ghostscript, Unix/cc/X11 configuration.

# ------------------------------- Options ------------------------------- #

####### The following are the only parts of the file you should need to edit.

# ------ Generic options ------ #

# Define the default directory/ies for the runtime
# initialization and font files.  Separate multiple directories with a :.
# `pwd` means use the directory in which the 'make' is being done.

GS_LIB_DEFAULT=`pwd`:`pwd`/fonts

# Define the name of the Ghostscript initialization file.
# (There is no reason to change this.)

GS_INIT=gs_init.ps

# Choose generic configuration options.

# -DDEBUG
#	includes debugging features (-Z switch) in the code.
#	  Code runs substantially slower even if no debugging switches
#	  are set.
# -DNOPRIVATE
#	makes private (static) procedures and variables public,
#	  so they are visible to the debugger and profiler.
#	  No execution time or space penalty.

GENOPT=

# ------ Platform-specific options ------ #

# Define the other compilation flags.
# Add -DBSD4_2 for 4.2bsd systems.
# Add -DSYSV for System V.
# XCFLAGS can be set from the command line.

CFLAGS=-O $(XCFLAGS)

# Define platform flags for ld.
# Most Unix systems accept -X, but some don't.
# Sun OS4.n may need -Bstatic.
# XLDFLAGS can be set from the command line.

LDFLAGS=-X $(XLDFLAGS)

# Define any extra libraries to link into the executable.
# The default is for X Windows.

EXTRALIBS= -lX11

# Define the installation commands and target directories for
# executables and files.  Only relevant to `make install'.

proginstall = install -m 775
fileinstall = install -m 664
bindir = /usr/local/gnu/bin
libdir = /usr/local/gnu/lib/ghostscript

# ------ Devices and features ------ #

# Choose the language feature(s) to include.  See ghost.mak for details.

FEATURES=

# Choose the device(s) to include.  See gdevs.mak for details.

DEVICES=x11
DEVICE_DEVS=x11.dev
DEVICE_OBJS=$(x11_)

# ---------------------------- End of options --------------------------- #

# Define the name of the makefile -- used in dependencies.

MAKEFILE=unix-cc.mak

# Define the extensions for the object and executable files.

OBJ=o
XE=

# Define the ANSI-to-K&R dependency.

AK=ansi2knr$(XE)

# Define the need for uniq.

UNIQ=

# Define the directory separator and shell quote string.

DS=/
Q=\"

# Define the compilation rules and flags.

CCFLAGS=$(GENOPT) $(CFLAGS)

.c.o:
	./ansi2knr $*.c _temp_.c
	$(CC) $(CCFLAGS) -c _temp_.c
	mv _temp_.o $*.o

CCC=./ccgs "$(CC) $(CCFLAGS)" _temp_.c
CC0=$(CCC)
CCINT=$(CCC)

# --------------------------- Generic makefile ---------------------------- #

# The remainder of the makefile (ghost.mak, gdevs.mak, and unixtail.mak)
# is generic.  tar_gs concatenates all these together.
