// Copyright (c) 2001-2002 Alessandro Briosi
//
// Permission is hereby granted, free of charge, to any person 
// obtaining a copy of this software and associated documentation 
// files (the "Software"), to deal in the Software without 
// restriction, including without limitation the rights to use, copy, 
// modify, merge, publish, distribute, sublicense, and/or sell copies 
// of the Software, and to permit persons to whom the Software is 
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be 
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
// BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
// SOFTWARE.
// 
//
// This software was written by Alessandro Briosi with the 
// assistance of Russell Lang, as an example of how the 
// Ghostscript DLL may be used Delphi.
//

unit View;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, StdCtrls;

type
  TF_View = class(TForm)
    pb: TProgressBar;
    Panel1: TPanel;
    B_Previous: TButton;
    B_Next: TButton;
    L_Page: TLabel;
    ScrollBox1: TScrollBox;
    Image: TImage;
    Label1: TLabel;
    CB_Res: TComboBox;
    procedure B_PreviousClick(Sender: TObject);
    procedure B_NextClick(Sender: TObject);
    procedure CB_ResChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    loading:boolean;
    procedure UpdatePage;
  end;

var
  F_View: TF_View;

implementation

uses Main;

{$R *.DFM}



procedure TF_View.UpdatePage;
begin
  L_Page.Caption:=IntToStr(F_Main.gs.ActualPage)+' of '+IntToStr(F_Main.gs.PageCount);
end;

procedure TF_View.B_PreviousClick(Sender: TObject);
begin
  F_Main.gs.Previous;
  UpdatePage;
end;

procedure TF_View.B_NextClick(Sender: TObject);
begin
  F_Main.gs.Next;
  UpdatePage;
end;

procedure TF_View.CB_ResChange(Sender: TObject);
var Ap:integer;
begin
  if loading then exit;
  ap:=F_Main.gs.ActualPage;
  case CB_Res.ItemIndex of
    0:F_Main.gs.Resolution:=50;
    1:F_Main.gs.Resolution:=75;
    2:F_Main.gs.Resolution:=150;
    3:F_Main.gs.Resolution:=300;
    4:F_Main.gs.Resolution:=600;
  end;
  F_Main.LoadFile;
  F_Main.gs.GotoPage(ap);
end;

procedure TF_View.FormCreate(Sender: TObject);
begin
  loading:=true;
  CB_Res.ItemIndex:=1;
  loading:=false;
end;

end.
