// Copyright (c) 2001-2002 Alessandro Briosi
//
// Permission is hereby granted, free of charge, to any person 
// obtaining a copy of this software and associated documentation 
// files (the "Software"), to deal in the Software without 
// restriction, including without limitation the rights to use, copy, 
// modify, merge, publish, distribute, sublicense, and/or sell copies 
// of the Software, and to permit persons to whom the Software is 
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be 
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
// BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN 
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
// SOFTWARE.
// 
//
// This software was written by Alessandro Briosi with the 
// assistance of Russell Lang, as an example of how the 
// Ghostscript DLL may be used Delphi.
//

unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, GhostScript;

type
  TF_Main = class(TForm)
    M_Log: TMemo;
    Panel1: TPanel;
    Button1: TButton;
    M_Debug: TMemo;
    Splitter1: TSplitter;
    OD: TOpenDialog;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    gs:TGhostScript;
    FileName:String;
    viewing:boolean;
    procedure LoadFile;
    procedure gsOnInput(var Value:String;len:integer);
    procedure gsOnOutput(var Value:String;len:integer);
    procedure gsOnError(var Value:String;len:integer);
    procedure gsOnPageGenerated(page:integer);
    procedure gsOnResize(Sender:TObject);
  end;

var
  F_Main: TF_Main;
  Stop:boolean;
  Image:TBitmap;
  Img:PChar;
  sraster:integer;
implementation

{$R *.DFM}
uses  View;


procedure Debug(S:String);
var tmp:String;
    return:boolean;
begin
  tmp:='';
  while S<>'' do
    begin
      if Pos(#10,S)>0 then
        begin
          tmp:=copy(S,1,Pos(#10,S)-1);
          delete(S,1,Pos(#10,S));
          return:=true;
        end
      else
        begin
          tmp:=S;
          S:='';
          return:=false;
        end;
      F_Main.M_Log.Lines[F_Main.M_Log.Lines.Count-1]:=F_Main.M_Log.Lines[F_Main.M_Log.Lines.Count-1]+(tmp);
      if return then F_Main.M_Log.Lines.Add('');
    end;
end;


procedure TF_Main.gsOnResize(Sender:TObject);
begin
  F_View.Image.Width:=gs.PageWidth;
  F_View.Image.Height:=gs.PageHeight;
end;

procedure TF_Main.gsOnPageGenerated(page:integer);
begin
  if (page=1)and(not viewing) then
    gs.First;
  if not viewing then
    begin
      F_View.UpdatePage;
      F_View.Update;
      Application.ProcessMessages;
    end;  
end;

procedure TF_Main.gsOnInput(var Value:String;len:integer);
begin
  M_Debug.Lines.Add('requested input');
  Value:='';
end;

procedure TF_Main.gsOnOutput(var Value:String;len:integer);
begin
  M_Debug.Lines.Add('called output');
  Debug(Value);
end;

procedure TF_Main.gsOnError(var Value:String;len:integer);
begin
  M_Debug.Lines.Add('called Error');
  Debug(Value);
end;

procedure TF_Main.LoadFile;
begin
  F_View.Show;
  gs.gsOpen;
  gs.gsInit;
  gs.LoadFile(FileName,true);
  gs.gsExit;
  gs.gsClose;
  viewing:=true;
end;

procedure TF_Main.Button1Click(Sender: TObject);
begin
  if OD.Execute then
    begin
      viewing:=false;
      FileName:=OD.FileName;
      LoadFile;
    end;
end;

procedure TF_Main.FormCreate(Sender: TObject);
begin
  F_View:=TF_View.Create(Self);
  gs:=TGhostScript.Create(Self);
  gs.ViewBitmap:=F_View.Image.Picture.Bitmap;
  gs.OnPageGenerated:=gsOnPageGenerated;
  gs.OnInput:=gsOnInput;
  gs.OnOutput:=gsOnOutput;
  gs.OnError:=gsOnError;
  gs.OnResizePage:=gsOnResize;
end;

end.
