# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables < %s | FileCheck %s -check-prefixes=ALL,ISN
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables -show-barriers < %s | FileCheck %s -check-prefixes=ALL,ISNB
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables -show-encoding < %s | FileCheck %s -check-prefixes=ALL,ISNE
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables -show-barriers -show-encoding < %s | FileCheck %s -check-prefixes=ALL,ISNBE
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables=normal < %s | FileCheck %s -check-prefixes=ALL,ISN
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables=normal -show-barriers < %s | FileCheck %s -check-prefixes=ALL,ISNB
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables=normal -show-encoding < %s | FileCheck %s -check-prefixes=ALL,ISNE
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables=normal -show-barriers -show-encoding < %s | FileCheck %s -check-prefixes=ALL,ISNBE
# RUN: llvm-mca	-march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables=none < %s | FileCheck %s -check-prefixes=ALL
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables=none -show-barriers < %s | FileCheck %s -check-prefixes=ALL,NISB
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables=none -show-encoding < %s | FileCheck %s -check-prefixes=ALL,NISE
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables=none -show-barriers -show-encoding < %s | FileCheck %s -check-prefixes=ALL,NISBE
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables=full < %s | FileCheck %s -check-prefixes=ALL,ISF
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables=full -show-barriers < %s | FileCheck %s -check-prefixes=ALL,ISFB
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables=full -show-encoding < %s | FileCheck %s -check-prefixes=ALL,ISFE
# RUN: llvm-mca -march=riscv64 -mcpu=sifive-u74 -mattr=+v -instruction-tables=full -show-barriers -show-encoding < %s | FileCheck %s -check-prefixes=ALL,ISFBE

  vsetvli a3, a2, e16, m1, tu, mu   // Comment
  vlm.v   v4, (a1)

# NISB:       Iterations:        100
# NISB-NEXT:  Instructions:      200
# NISB-NEXT:  Total Cycles:      404
# NISB-NEXT:  Total uOps:        200

# NISBE:      Iterations:        100
# NISBE-NEXT: Instructions:      200
# NISBE-NEXT: Total Cycles:      404
# NISBE-NEXT: Total uOps:        200

# NISE:       Iterations:        100
# NISE-NEXT:  Instructions:      200
# NISE-NEXT:  Total Cycles:      404
# NISE-NEXT:  Total uOps:        200

# ISF:        Resources:
# ISF-NEXT:   [0]   - VLEN512SiFive7FDiv:1
# ISF-NEXT:   [1]   - VLEN512SiFive7IDiv:1
# ISF-NEXT:   [2]   - VLEN512SiFive7PipeA:1
# ISF-NEXT:   [3]   - VLEN512SiFive7PipeAB:2 VLEN512SiFive7PipeA, VLEN512SiFive7PipeB
# ISF-NEXT:   [4]   - VLEN512SiFive7PipeB:1
# ISF-NEXT:   [5]   - VLEN512SiFive7VA:1
# ISF-NEXT:   [6]   - VLEN512SiFive7VCQ:1
# ISF-NEXT:   [7]   - VLEN512SiFive7VL:1
# ISF-NEXT:   [8]   - VLEN512SiFive7VS:1

# ISFB:       Resources:
# ISFB-NEXT:  [0]   - VLEN512SiFive7FDiv:1
# ISFB-NEXT:  [1]   - VLEN512SiFive7IDiv:1
# ISFB-NEXT:  [2]   - VLEN512SiFive7PipeA:1
# ISFB-NEXT:  [3]   - VLEN512SiFive7PipeAB:2 VLEN512SiFive7PipeA, VLEN512SiFive7PipeB
# ISFB-NEXT:  [4]   - VLEN512SiFive7PipeB:1
# ISFB-NEXT:  [5]   - VLEN512SiFive7VA:1
# ISFB-NEXT:  [6]   - VLEN512SiFive7VCQ:1
# ISFB-NEXT:  [7]   - VLEN512SiFive7VL:1
# ISFB-NEXT:  [8]   - VLEN512SiFive7VS:1

# ISFBE:      Resources:
# ISFBE-NEXT: [0]   - VLEN512SiFive7FDiv:1
# ISFBE-NEXT: [1]   - VLEN512SiFive7IDiv:1
# ISFBE-NEXT: [2]   - VLEN512SiFive7PipeA:1
# ISFBE-NEXT: [3]   - VLEN512SiFive7PipeAB:2 VLEN512SiFive7PipeA, VLEN512SiFive7PipeB
# ISFBE-NEXT: [4]   - VLEN512SiFive7PipeB:1
# ISFBE-NEXT: [5]   - VLEN512SiFive7VA:1
# ISFBE-NEXT: [6]   - VLEN512SiFive7VCQ:1
# ISFBE-NEXT: [7]   - VLEN512SiFive7VL:1
# ISFBE-NEXT: [8]   - VLEN512SiFive7VS:1

# ISFE:       Resources:
# ISFE-NEXT:  [0]   - VLEN512SiFive7FDiv:1
# ISFE-NEXT:  [1]   - VLEN512SiFive7IDiv:1
# ISFE-NEXT:  [2]   - VLEN512SiFive7PipeA:1
# ISFE-NEXT:  [3]   - VLEN512SiFive7PipeAB:2 VLEN512SiFive7PipeA, VLEN512SiFive7PipeB
# ISFE-NEXT:  [4]   - VLEN512SiFive7PipeB:1
# ISFE-NEXT:  [5]   - VLEN512SiFive7VA:1
# ISFE-NEXT:  [6]   - VLEN512SiFive7VCQ:1
# ISFE-NEXT:  [7]   - VLEN512SiFive7VL:1
# ISFE-NEXT:  [8]   - VLEN512SiFive7VS:1

# ISN:        Instruction Info:
# ISN-NEXT:   [1]: #uOps
# ISN-NEXT:   [2]: Latency
# ISN-NEXT:   [3]: RThroughput
# ISN-NEXT:   [4]: MayLoad
# ISN-NEXT:   [5]: MayStore
# ISN-NEXT:   [6]: HasSideEffects (U)

# ISNB:       Instruction Info:
# ISNB-NEXT:  [1]: #uOps
# ISNB-NEXT:  [2]: Latency
# ISNB-NEXT:  [3]: RThroughput
# ISNB-NEXT:  [4]: MayLoad
# ISNB-NEXT:  [5]: MayStore
# ISNB-NEXT:  [6]: HasSideEffects (U)
# ISNB-NEXT:  [7]: LoadBarrier
# ISNB-NEXT:  [8]: StoreBarrier

# ISNBE:      Instruction Info:
# ISNBE-NEXT: [1]: #uOps
# ISNBE-NEXT: [2]: Latency
# ISNBE-NEXT: [3]: RThroughput
# ISNBE-NEXT: [4]: MayLoad
# ISNBE-NEXT: [5]: MayStore
# ISNBE-NEXT: [6]: HasSideEffects (U)
# ISNBE-NEXT: [7]: LoadBarrier
# ISNBE-NEXT: [8]: StoreBarrier
# ISNBE-NEXT: [9]: Encoding Size

# ISNE:       Instruction Info:
# ISNE-NEXT:  [1]: #uOps
# ISNE-NEXT:  [2]: Latency
# ISNE-NEXT:  [3]: RThroughput
# ISNE-NEXT:  [4]: MayLoad
# ISNE-NEXT:  [5]: MayStore
# ISNE-NEXT:  [6]: HasSideEffects (U)
# ISNE-NEXT:  [7]: Encoding Size

# NISB:       Dispatch Width:    2
# NISB-NEXT:  uOps Per Cycle:    0.50
# NISB-NEXT:  IPC:               0.50
# NISB-NEXT:  Block RThroughput: 3.0

# NISBE:      Dispatch Width:    2
# NISBE-NEXT: uOps Per Cycle:    0.50
# NISBE-NEXT: IPC:               0.50
# NISBE-NEXT: Block RThroughput: 3.0

# NISE:       Dispatch Width:    2
# NISE-NEXT:  uOps Per Cycle:    0.50
# NISE-NEXT:  IPC:               0.50
# NISE-NEXT:  Block RThroughput: 3.0

# ISF:        Instruction Info:
# ISF-NEXT:   [1]: #uOps
# ISF-NEXT:   [2]: Latency
# ISF-NEXT:   [3]: RThroughput
# ISF-NEXT:   [4]: MayLoad
# ISF-NEXT:   [5]: MayStore
# ISF-NEXT:   [6]: HasSideEffects (U)
# ISF-NEXT:   [7]: Bypass Latency
# ISF-NEXT:   [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# ISF-NEXT:   [9]: LLVM Opcode Name

# ISFB:       Instruction Info:
# ISFB-NEXT:  [1]: #uOps
# ISFB-NEXT:  [2]: Latency
# ISFB-NEXT:  [3]: RThroughput
# ISFB-NEXT:  [4]: MayLoad
# ISFB-NEXT:  [5]: MayStore
# ISFB-NEXT:  [6]: HasSideEffects (U)
# ISFB-NEXT:  [7]: Bypass Latency
# ISFB-NEXT:  [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# ISFB-NEXT:  [9]: LLVM Opcode Name
# ISFB-NEXT:  [10]: LoadBarrier
# ISFB-NEXT:  [11]: StoreBarrier

# ISFBE:      Instruction Info:
# ISFBE-NEXT: [1]: #uOps
# ISFBE-NEXT: [2]: Latency
# ISFBE-NEXT: [3]: RThroughput
# ISFBE-NEXT: [4]: MayLoad
# ISFBE-NEXT: [5]: MayStore
# ISFBE-NEXT: [6]: HasSideEffects (U)
# ISFBE-NEXT: [7]: Bypass Latency
# ISFBE-NEXT: [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# ISFBE-NEXT: [9]: LLVM Opcode Name
# ISFBE-NEXT: [10]: LoadBarrier
# ISFBE-NEXT: [11]: StoreBarrier
# ISFBE-NEXT: [12]: Encoding Size

# ISFE:       Instruction Info:
# ISFE-NEXT:  [1]: #uOps
# ISFE-NEXT:  [2]: Latency
# ISFE-NEXT:  [3]: RThroughput
# ISFE-NEXT:  [4]: MayLoad
# ISFE-NEXT:  [5]: MayStore
# ISFE-NEXT:  [6]: HasSideEffects (U)
# ISFE-NEXT:  [7]: Bypass Latency
# ISFE-NEXT:  [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# ISFE-NEXT:  [9]: LLVM Opcode Name
# ISFE-NEXT:  [10]: Encoding Size

# ISN:        [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# ISN-NEXT:    1      3     1.00                  U     vsetvli	a3, a2, e16, m1, tu, mu
# ISN-NEXT:    1      4     2.00    *                   vlm.v	v4, (a1)

# NISB:       Instruction Info:
# NISB-NEXT:  [1]: #uOps
# NISB-NEXT:  [2]: Latency
# NISB-NEXT:  [3]: RThroughput
# NISB-NEXT:  [4]: MayLoad
# NISB-NEXT:  [5]: MayStore
# NISB-NEXT:  [6]: HasSideEffects (U)
# NISB-NEXT:  [7]: LoadBarrier
# NISB-NEXT:  [8]: StoreBarrier

# NISBE:      Instruction Info:
# NISBE-NEXT: [1]: #uOps
# NISBE-NEXT: [2]: Latency
# NISBE-NEXT: [3]: RThroughput
# NISBE-NEXT: [4]: MayLoad
# NISBE-NEXT: [5]: MayStore
# NISBE-NEXT: [6]: HasSideEffects (U)
# NISBE-NEXT: [7]: LoadBarrier
# NISBE-NEXT: [8]: StoreBarrier
# NISBE-NEXT: [9]: Encoding Size

# NISE:       Instruction Info:
# NISE-NEXT:  [1]: #uOps
# NISE-NEXT:  [2]: Latency
# NISE-NEXT:  [3]: RThroughput
# NISE-NEXT:  [4]: MayLoad
# NISE-NEXT:  [5]: MayStore
# NISE-NEXT:  [6]: HasSideEffects (U)
# NISE-NEXT:  [7]: Encoding Size

# ISF:        [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        Instructions:
# ISF-NEXT:    1      3     1.00                  U      1     VLEN512SiFive7PipeA,VLEN512SiFive7PipeAB   VSETVLI                    vsetvli	a3, a2, e16, m1, tu, mu	// Comment
# ISF-NEXT:    1      4     2.00    *                    4     VLEN512SiFive7VCQ,VLEN512SiFive7VL[1,3]    VLM_V                      vlm.v	v4, (a1)

# ISFB:       [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        [10]   [11]   Instructions:
# ISFB-NEXT:   1      3     1.00                  U      1     VLEN512SiFive7PipeA,VLEN512SiFive7PipeAB   VSETVLI                                  vsetvli	a3, a2, e16, m1, tu, mu	// Comment
# ISFB-NEXT:   1      4     2.00    *                    4     VLEN512SiFive7VCQ,VLEN512SiFive7VL[1,3]    VLM_V                                    vlm.v	v4, (a1)

# ISFBE:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        [10]   [11]   [12]   Encodings:                    Instructions:
# ISFBE-NEXT:  1      3     1.00                  U      1     VLEN512SiFive7PipeA,VLEN512SiFive7PipeAB   VSETVLI                                   4     d7 76 86 00                   vsetvli	a3, a2, e16, m1, tu, mu	// Comment
# ISFBE-NEXT:  1      4     2.00    *                    4     VLEN512SiFive7VCQ,VLEN512SiFive7VL[1,3]    VLM_V                                     4     07 82 b5 02                   vlm.v	v4, (a1)

# ISFE:       [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        [10]   Encodings:                    Instructions:
# ISFE-NEXT:   1      3     1.00                  U      1     VLEN512SiFive7PipeA,VLEN512SiFive7PipeAB   VSETVLI                     4     d7 76 86 00                   vsetvli	a3, a2, e16, m1, tu, mu	// Comment
# ISFE-NEXT:   1      4     2.00    *                    4     VLEN512SiFive7VCQ,VLEN512SiFive7VL[1,3]    VLM_V                       4     07 82 b5 02                   vlm.v	v4, (a1)

# ISNB:       [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    Instructions:
# ISNB-NEXT:   1      3     1.00                  U                   vsetvli	a3, a2, e16, m1, tu, mu
# ISNB-NEXT:   1      4     2.00    *                                 vlm.v	v4, (a1)

# ISNBE:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    Encodings:                    Instructions:
# ISNBE-NEXT:  1      3     1.00                  U                    4     d7 76 86 00                   vsetvli	a3, a2, e16, m1, tu, mu
# ISNBE-NEXT:  1      4     2.00    *                                  4     07 82 b5 02                   vlm.v	v4, (a1)

# ISNE:       [1]    [2]    [3]    [4]    [5]    [6]    [7]    Encodings:                    Instructions:
# ISNE-NEXT:   1      3     1.00                  U      4     d7 76 86 00                   vsetvli	a3, a2, e16, m1, tu, mu
# ISNE-NEXT:   1      4     2.00    *                    4     07 82 b5 02                   vlm.v	v4, (a1)

# NISB:       [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    Instructions:
# NISB-NEXT:   1      3     1.00                  U                   vsetvli	a3, a2, e16, m1, tu, mu
# NISB-NEXT:   1      4     2.00    *                                 vlm.v	v4, (a1)

# NISBE:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    Encodings:                    Instructions:
# NISBE-NEXT:  1      3     1.00                  U                    4     d7 76 86 00                   vsetvli	a3, a2, e16, m1, tu, mu
# NISBE-NEXT:  1      4     2.00    *                                  4     07 82 b5 02                   vlm.v	v4, (a1)

# NISE:       [1]    [2]    [3]    [4]    [5]    [6]    [7]    Encodings:                    Instructions:
# NISE-NEXT:   1      3     1.00                  U      4     d7 76 86 00                   vsetvli	a3, a2, e16, m1, tu, mu
# NISE-NEXT:   1      4     2.00    *                    4     07 82 b5 02                   vlm.v	v4, (a1)

# ISN:        Resources:
# ISN-NEXT:   [0]   - VLEN512SiFive7FDiv
# ISN-NEXT:   [1]   - VLEN512SiFive7IDiv
# ISN-NEXT:   [2]   - VLEN512SiFive7PipeA
# ISN-NEXT:   [3]   - VLEN512SiFive7PipeB
# ISN-NEXT:   [4]   - VLEN512SiFive7VA
# ISN-NEXT:   [5]   - VLEN512SiFive7VCQ
# ISN-NEXT:   [6]   - VLEN512SiFive7VL
# ISN-NEXT:   [7]   - VLEN512SiFive7VS

# ISF:        Resources:
# ISF-NEXT:   [0]   - VLEN512SiFive7FDiv
# ISF-NEXT:   [1]   - VLEN512SiFive7IDiv
# ISF-NEXT:   [2]   - VLEN512SiFive7PipeA
# ISF-NEXT:   [3]   - VLEN512SiFive7PipeB
# ISF-NEXT:   [4]   - VLEN512SiFive7VA
# ISF-NEXT:   [5]   - VLEN512SiFive7VCQ
# ISF-NEXT:   [6]   - VLEN512SiFive7VL
# ISF-NEXT:   [7]   - VLEN512SiFive7VS

# ISFB:       Resources:
# ISFB-NEXT:  [0]   - VLEN512SiFive7FDiv
# ISFB-NEXT:  [1]   - VLEN512SiFive7IDiv
# ISFB-NEXT:  [2]   - VLEN512SiFive7PipeA
# ISFB-NEXT:  [3]   - VLEN512SiFive7PipeB
# ISFB-NEXT:  [4]   - VLEN512SiFive7VA
# ISFB-NEXT:  [5]   - VLEN512SiFive7VCQ
# ISFB-NEXT:  [6]   - VLEN512SiFive7VL
# ISFB-NEXT:  [7]   - VLEN512SiFive7VS

# ISFBE:      Resources:
# ISFBE-NEXT: [0]   - VLEN512SiFive7FDiv
# ISFBE-NEXT: [1]   - VLEN512SiFive7IDiv
# ISFBE-NEXT: [2]   - VLEN512SiFive7PipeA
# ISFBE-NEXT: [3]   - VLEN512SiFive7PipeB
# ISFBE-NEXT: [4]   - VLEN512SiFive7VA
# ISFBE-NEXT: [5]   - VLEN512SiFive7VCQ
# ISFBE-NEXT: [6]   - VLEN512SiFive7VL
# ISFBE-NEXT: [7]   - VLEN512SiFive7VS

# ISFE:       Resources:
# ISFE-NEXT:  [0]   - VLEN512SiFive7FDiv
# ISFE-NEXT:  [1]   - VLEN512SiFive7IDiv
# ISFE-NEXT:  [2]   - VLEN512SiFive7PipeA
# ISFE-NEXT:  [3]   - VLEN512SiFive7PipeB
# ISFE-NEXT:  [4]   - VLEN512SiFive7VA
# ISFE-NEXT:  [5]   - VLEN512SiFive7VCQ
# ISFE-NEXT:  [6]   - VLEN512SiFive7VL
# ISFE-NEXT:  [7]   - VLEN512SiFive7VS

# ISNB:       Resources:
# ISNB-NEXT:  [0]   - VLEN512SiFive7FDiv
# ISNB-NEXT:  [1]   - VLEN512SiFive7IDiv
# ISNB-NEXT:  [2]   - VLEN512SiFive7PipeA
# ISNB-NEXT:  [3]   - VLEN512SiFive7PipeB
# ISNB-NEXT:  [4]   - VLEN512SiFive7VA
# ISNB-NEXT:  [5]   - VLEN512SiFive7VCQ
# ISNB-NEXT:  [6]   - VLEN512SiFive7VL
# ISNB-NEXT:  [7]   - VLEN512SiFive7VS

# ISNBE:      Resources:
# ISNBE-NEXT: [0]   - VLEN512SiFive7FDiv
# ISNBE-NEXT: [1]   - VLEN512SiFive7IDiv
# ISNBE-NEXT: [2]   - VLEN512SiFive7PipeA
# ISNBE-NEXT: [3]   - VLEN512SiFive7PipeB
# ISNBE-NEXT: [4]   - VLEN512SiFive7VA
# ISNBE-NEXT: [5]   - VLEN512SiFive7VCQ
# ISNBE-NEXT: [6]   - VLEN512SiFive7VL
# ISNBE-NEXT: [7]   - VLEN512SiFive7VS

# ISNE:       Resources:
# ISNE-NEXT:  [0]   - VLEN512SiFive7FDiv
# ISNE-NEXT:  [1]   - VLEN512SiFive7IDiv
# ISNE-NEXT:  [2]   - VLEN512SiFive7PipeA
# ISNE-NEXT:  [3]   - VLEN512SiFive7PipeB
# ISNE-NEXT:  [4]   - VLEN512SiFive7VA
# ISNE-NEXT:  [5]   - VLEN512SiFive7VCQ
# ISNE-NEXT:  [6]   - VLEN512SiFive7VL
# ISNE-NEXT:  [7]   - VLEN512SiFive7VS

# NISB:       Resources:
# NISB-NEXT:  [0]   - VLEN512SiFive7FDiv
# NISB-NEXT:  [1]   - VLEN512SiFive7IDiv
# NISB-NEXT:  [2]   - VLEN512SiFive7PipeA
# NISB-NEXT:  [3]   - VLEN512SiFive7PipeB
# NISB-NEXT:  [4]   - VLEN512SiFive7VA
# NISB-NEXT:  [5]   - VLEN512SiFive7VCQ
# NISB-NEXT:  [6]   - VLEN512SiFive7VL
# NISB-NEXT:  [7]   - VLEN512SiFive7VS

# NISBE:      Resources:
# NISBE-NEXT: [0]   - VLEN512SiFive7FDiv
# NISBE-NEXT: [1]   - VLEN512SiFive7IDiv
# NISBE-NEXT: [2]   - VLEN512SiFive7PipeA
# NISBE-NEXT: [3]   - VLEN512SiFive7PipeB
# NISBE-NEXT: [4]   - VLEN512SiFive7VA
# NISBE-NEXT: [5]   - VLEN512SiFive7VCQ
# NISBE-NEXT: [6]   - VLEN512SiFive7VL
# NISBE-NEXT: [7]   - VLEN512SiFive7VS

# NISE:       Resources:
# NISE-NEXT:  [0]   - VLEN512SiFive7FDiv
# NISE-NEXT:  [1]   - VLEN512SiFive7IDiv
# NISE-NEXT:  [2]   - VLEN512SiFive7PipeA
# NISE-NEXT:  [3]   - VLEN512SiFive7PipeB
# NISE-NEXT:  [4]   - VLEN512SiFive7VA
# NISE-NEXT:  [5]   - VLEN512SiFive7VCQ
# NISE-NEXT:  [6]   - VLEN512SiFive7VL
# NISE-NEXT:  [7]   - VLEN512SiFive7VS

# ISN:        Resource pressure per iteration:
# ISN-NEXT:   [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# ISN-NEXT:    -      -     1.00    -      -     1.00   3.00    -

# ISF:        Resource pressure per iteration:
# ISF-NEXT:   [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# ISF-NEXT:    -      -     1.00    -      -     1.00   3.00    -

# ISFB:       Resource pressure per iteration:
# ISFB-NEXT:  [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# ISFB-NEXT:   -      -     1.00    -      -     1.00   3.00    -

# ISFBE:      Resource pressure per iteration:
# ISFBE-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# ISFBE-NEXT:  -      -     1.00    -      -     1.00   3.00    -

# ISFE:       Resource pressure per iteration:
# ISFE-NEXT:  [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# ISFE-NEXT:   -      -     1.00    -      -     1.00   3.00    -

# ISNB:       Resource pressure per iteration:
# ISNB-NEXT:  [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# ISNB-NEXT:   -      -     1.00    -      -     1.00   3.00    -

# ISNBE:      Resource pressure per iteration:
# ISNBE-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# ISNBE-NEXT:  -      -     1.00    -      -     1.00   3.00    -

# ISNE:       Resource pressure per iteration:
# ISNE-NEXT:  [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# ISNE-NEXT:   -      -     1.00    -      -     1.00   3.00    -

# NISB:       Resource pressure per iteration:
# NISB-NEXT:  [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# NISB-NEXT:   -      -     1.00    -      -     1.00   3.00    -

# NISBE:      Resource pressure per iteration:
# NISBE-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# NISBE-NEXT:  -      -     1.00    -      -     1.00   3.00    -

# NISE:       Resource pressure per iteration:
# NISE-NEXT:  [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# NISE-NEXT:   -      -     1.00    -      -     1.00   3.00    -

# ALL:        Resource pressure by instruction:
# ALL-NEXT:   [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    Instructions:
# ALL-NEXT:    -      -     1.00    -      -      -      -      -     vsetvli	a3, a2, e16, m1, tu, mu
# ALL-NEXT:    -      -      -      -      -     1.00   3.00    -     vlm.v	v4, (a1)
