; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

target datalayout = "E-p:64:64:64-a0:0:8-f32:32:32-f64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-v64:64:64-v128:128:128"

%struct.ss = type { i32, i64 }

define internal i32 @f(ptr byval(%struct.ss)  %b) nounwind  {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@f
; CHECK-SAME: (i32 [[TMP0:%.*]], i64 [[TMP1:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B_PRIV:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
; CHECK-NEXT:    store i32 [[TMP0]], ptr [[B_PRIV]], align 4
; CHECK-NEXT:    [[B_PRIV_B4:%.*]] = getelementptr i8, ptr [[B_PRIV]], i64 4
; CHECK-NEXT:    store i64 [[TMP1]], ptr [[B_PRIV_B4]], align 4
; CHECK-NEXT:    [[VAL1:%.*]] = load i32, ptr [[B_PRIV]], align 8
; CHECK-NEXT:    [[VAL2:%.*]] = add i32 [[VAL1]], 1
; CHECK-NEXT:    store i32 [[VAL2]], ptr [[B_PRIV]], align 8
; CHECK-NEXT:    ret i32 [[VAL1]]
;
entry:
  %val1 = load i32, ptr %b, align 4
  %val2 = add i32 %val1, 1
  store i32 %val2, ptr %b, align 4
  ret i32 %val1
}


define internal i32 @g(ptr byval(%struct.ss) align 32 %b) nounwind {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@g
; CHECK-SAME: (i32 [[TMP0:%.*]], i64 [[TMP1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B_PRIV:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
; CHECK-NEXT:    store i32 [[TMP0]], ptr [[B_PRIV]], align 4
; CHECK-NEXT:    [[B_PRIV_B4:%.*]] = getelementptr i8, ptr [[B_PRIV]], i64 4
; CHECK-NEXT:    store i64 [[TMP1]], ptr [[B_PRIV_B4]], align 4
; CHECK-NEXT:    [[VAL1:%.*]] = load i32, ptr [[B_PRIV]], align 32
; CHECK-NEXT:    [[VAL2:%.*]] = add i32 [[VAL1]], 1
; CHECK-NEXT:    store i32 [[VAL2]], ptr [[B_PRIV]], align 32
; CHECK-NEXT:    ret i32 [[VAL2]]
;
entry:
  %val1 = load i32, ptr %b, align 4
  %val2 = add i32 %val1, 1
  store i32 %val2, ptr %b, align 4
  ret i32 %val2
}


define i32 @main() nounwind  {
; TUNIT: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@main
; TUNIT-SAME: () #[[ATTR0]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[S:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
; TUNIT-NEXT:    store i32 1, ptr [[S]], align 32
; TUNIT-NEXT:    [[VAL4:%.*]] = getelementptr [[STRUCT_SS]], ptr [[S]], i32 0, i32 1
; TUNIT-NEXT:    [[TMP0:%.*]] = load i32, ptr [[S]], align 8
; TUNIT-NEXT:    [[S_B4:%.*]] = getelementptr i8, ptr [[S]], i64 4
; TUNIT-NEXT:    [[TMP1:%.*]] = load i64, ptr [[S_B4]], align 8
; TUNIT-NEXT:    [[C0:%.*]] = call i32 @f(i32 [[TMP0]], i64 [[TMP1]]) #[[ATTR1:[0-9]+]]
; TUNIT-NEXT:    [[TMP2:%.*]] = load i32, ptr [[S]], align 32
; TUNIT-NEXT:    [[S_B41:%.*]] = getelementptr i8, ptr [[S]], i64 4
; TUNIT-NEXT:    [[TMP3:%.*]] = load i64, ptr [[S_B41]], align 32
; TUNIT-NEXT:    [[C1:%.*]] = call i32 @g(i32 [[TMP2]], i64 [[TMP3]]) #[[ATTR1]]
; TUNIT-NEXT:    [[A:%.*]] = add i32 [[C0]], [[C1]]
; TUNIT-NEXT:    ret i32 [[A]]
;
; CGSCC: Function Attrs: mustprogress nofree nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@main
; CGSCC-SAME: () #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[S:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
; CGSCC-NEXT:    [[VAL4:%.*]] = getelementptr [[STRUCT_SS]], ptr [[S]], i32 0, i32 1
; CGSCC-NEXT:    [[C0:%.*]] = call i32 @f(i32 noundef 1, i64 noundef 2) #[[ATTR2:[0-9]+]]
; CGSCC-NEXT:    [[C1:%.*]] = call i32 @g(i32 noundef 1, i64 noundef 2) #[[ATTR2]]
; CGSCC-NEXT:    [[A:%.*]] = add i32 [[C0]], [[C1]]
; CGSCC-NEXT:    ret i32 [[A]]
;
entry:
  %S = alloca %struct.ss
  store i32 1, ptr %S, align 8
  %val4 = getelementptr %struct.ss, ptr %S, i32 0, i32 1
  store i64 2, ptr %val4, align 4
  %c0 = call i32 @f(ptr byval(%struct.ss) %S) nounwind
  %c1 = call i32 @g(ptr byval(%struct.ss) %S) nounwind
  %a = add i32 %c0, %c1
  ret i32 %a
}


;.
; TUNIT: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR1]] = { nofree nosync nounwind willreturn }
;.
; CGSCC: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR1]] = { mustprogress nofree nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR2]] = { nofree nosync nounwind willreturn }
;.
