; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test use of VECTOR EVALUATE for combined boolean operations.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z17 | FileCheck %s

define <16 x i8> @eval0(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vgbm %v24, 0
; CHECK-NEXT:    br %r14
entry:
  ret <16 x i8> zeroinitializer
}

define <16 x i8> @eval1(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v24, %v28, 1
; CHECK-NEXT:    br %r14
entry:
  %and = and <16 x i8> %src2, %src1
  %and1 = and <16 x i8> %and, %src3
  ret <16 x i8> %and1
}

define <16 x i8> @eval2(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v24, %v28, 2
; CHECK-NEXT:    br %r14
entry:
  %and = and <16 x i8> %src2, %src1
  %not = xor <16 x i8> %src3, splat(i8 -1)
  %and1 = and <16 x i8> %and, %not
  ret <16 x i8> %and1
}

define <16 x i8> @eval3(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vn %v24, %v26, %v24
; CHECK-NEXT:    br %r14
entry:
  %and = and <16 x i8> %src2, %src1
  ret <16 x i8> %and
}

define <16 x i8> @eval4(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v24, %v28, %v26, 2
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not, %src1
  %and1 = and <16 x i8> %and, %src3
  ret <16 x i8> %and1
}

define <16 x i8> @eval5(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vn %v24, %v28, %v24
; CHECK-NEXT:    br %r14
entry:
  %or4 = and <16 x i8> %src3, %src1
  ret <16 x i8> %or4
}

define <16 x i8> @eval6(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v24, %v28, %v26, 6
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %or5 = and <16 x i8> %0, %src1
  ret <16 x i8> %or5
}

define <16 x i8> @eval7(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v24, %v28, %v26, 7
; CHECK-NEXT:    br %r14
entry:
  %and118 = or <16 x i8> %src3, %src2
  %or8 = and <16 x i8> %and118, %src1
  ret <16 x i8> %or8
}

define <16 x i8> @eval8(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v24, %v28, %v26, 8
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and2 = and <16 x i8> %1, %src1
  ret <16 x i8> %and2
}

define <16 x i8> @eval9(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval9:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v24, %v26, %v28, 9
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src2, %src3
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %or5 = and <16 x i8> %1, %src1
  ret <16 x i8> %or5
}

define <16 x i8> @eval10(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval10:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v24, %v24, %v28
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src3, splat(i8 -1)
  %or6 = and <16 x i8> %not1, %src1
  ret <16 x i8> %or6
}

define <16 x i8> @eval11(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval11:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v24, %v26, %v28, 11
; CHECK-NEXT:    br %r14
entry:
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and219 = or <16 x i8> %src3.not, %src2
  %or9 = and <16 x i8> %and219, %src1
  ret <16 x i8> %or9
}

define <16 x i8> @eval12(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval12:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v24, %v24, %v26
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not, %src1
  ret <16 x i8> %and
}

define <16 x i8> @eval13(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval13:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v24, %v28, %v26, 11
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src2, splat(i8 -1)
  %and19 = or <16 x i8> %not, %src3
  %or9 = and <16 x i8> %and19, %src1
  ret <16 x i8> %or9
}

define <16 x i8> @eval14(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval14:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v24, %v28, %v26, 14
; CHECK-NEXT:    br %r14
entry:
  %and20.demorgan = and <16 x i8> %src3, %src2
  %and20 = xor <16 x i8> %and20.demorgan, splat(i8 -1)
  %or10 = and <16 x i8> %and20, %src1
  ret <16 x i8> %or10
}

define <16 x i8> @eval15(<16 x i8> returned %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval15:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    br %r14
entry:
  ret <16 x i8> %src1
}

define <16 x i8> @eval16(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v28, %v24, 2
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %and = and <16 x i8> %not, %src2
  %and1 = and <16 x i8> %and, %src3
  ret <16 x i8> %and1
}

define <16 x i8> @eval17(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval17:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vn %v24, %v28, %v26
; CHECK-NEXT:    br %r14
entry:
  %or4 = and <16 x i8> %src3, %src2
  ret <16 x i8> %or4
}

define <16 x i8> @eval18(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval18:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v28, %v24, 6
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src1
  %or5 = and <16 x i8> %0, %src2
  ret <16 x i8> %or5
}

define <16 x i8> @eval19(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval19:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v28, %v24, 7
; CHECK-NEXT:    br %r14
entry:
  %and118 = or <16 x i8> %src3, %src1
  %or8 = and <16 x i8> %and118, %src2
  ret <16 x i8> %or8
}

define <16 x i8> @eval20(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval20:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 6
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src2, %src1
  %or5 = and <16 x i8> %0, %src3
  ret <16 x i8> %or5
}

define <16 x i8> @eval21(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval21:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 7
; CHECK-NEXT:    br %r14
entry:
  %or518 = or <16 x i8> %src2, %src1
  %or8 = and <16 x i8> %or518, %src3
  ret <16 x i8> %or8
}

define <16 x i8> @eval22(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval22:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v26, %v24
; CHECK-NEXT:    veval %v1, %v24, %v26, %v28, 2
; CHECK-NEXT:    veval %v24, %v1, %v0, %v28, 31
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src2, %src1
  %or5 = and <16 x i8> %0, %src3
  %not7 = xor <16 x i8> %src3, splat(i8 -1)
  %1 = and <16 x i8> %not7, %src1
  %and8 = and <16 x i8> %1, %src2
  %or9 = or <16 x i8> %and8, %or5
  ret <16 x i8> %or9
}

define <16 x i8> @eval23(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval23:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v28, %v26, %v24, 6
; CHECK-NEXT:    veval %v24, %v0, %v26, %v24, 31
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src2, %src1
  %or5 = and <16 x i8> %0, %src3
  %and6 = and <16 x i8> %src2, %src1
  %or12 = or <16 x i8> %or5, %and6
  ret <16 x i8> %or12
}

define <16 x i8> @eval24(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval24:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v26, %v28, %v24, 2
; CHECK-NEXT:    vo %v1, %v28, %v26
; CHECK-NEXT:    veval %v24, %v0, %v24, %v1, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %and = and <16 x i8> %not, %src2
  %and1 = and <16 x i8> %and, %src3
  %0 = or <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and5 = and <16 x i8> %1, %src1
  %or6 = or <16 x i8> %and5, %and1
  ret <16 x i8> %or6
}

define <16 x i8> @eval25(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval25:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v28, %v26
; CHECK-NEXT:    vn %v1, %v28, %v26
; CHECK-NEXT:    veval %v24, %v1, %v24, %v0, 47
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and5 = and <16 x i8> %1, %src1
  %2 = and <16 x i8> %src3, %src2
  %or9 = or <16 x i8> %and5, %2
  ret <16 x i8> %or9
}

define <16 x i8> @eval26(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval26:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v0, %v26, %v24
; CHECK-NEXT:    vsel %v24, %v0, %v24, %v28
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %and = and <16 x i8> %not, %src2
  %and1 = and <16 x i8> %and, %src3
  %not4 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = and <16 x i8> %not4, %src1
  %or10 = or <16 x i8> %and1, %0
  ret <16 x i8> %or10
}

define <16 x i8> @eval27(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval27:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v0, %v26, %v24
; CHECK-NEXT:    veval %v1, %v24, %v26, %v28, 11
; CHECK-NEXT:    veval %v24, %v1, %v0, %v28, 31
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %and = and <16 x i8> %not, %src2
  %and1 = and <16 x i8> %and, %src3
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and527 = or <16 x i8> %src3.not, %src2
  %0 = and <16 x i8> %and527, %src1
  %or13 = or <16 x i8> %0, %and1
  ret <16 x i8> %or13
}

define <16 x i8> @eval28(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval28:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v0, %v28, %v24
; CHECK-NEXT:    vsel %v24, %v0, %v24, %v26
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %0 = and <16 x i8> %not, %src3
  %and1 = and <16 x i8> %0, %src2
  %not2 = xor <16 x i8> %src2, splat(i8 -1)
  %and3 = and <16 x i8> %not2, %src1
  %or10 = or <16 x i8> %and1, %and3
  ret <16 x i8> %or10
}

define <16 x i8> @eval29(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval29:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsel %v24, %v28, %v24, %v26
; CHECK-NEXT:    br %r14
entry:
  %not2 = xor <16 x i8> %src2, splat(i8 -1)
  %and3 = and <16 x i8> %not2, %src1
  %0 = and <16 x i8> %src3, %src2
  %or13 = or <16 x i8> %0, %and3
  ret <16 x i8> %or13
}

define <16 x i8> @eval30(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval30:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v26, %v28, %v24, 2
; CHECK-NEXT:    vn %v1, %v28, %v26
; CHECK-NEXT:    veval %v24, %v0, %v24, %v1, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %0 = and <16 x i8> %not, %src2
  %and1 = and <16 x i8> %0, %src3
  %and328.demorgan = and <16 x i8> %src3, %src2
  %and328 = xor <16 x i8> %and328.demorgan, splat(i8 -1)
  %1 = and <16 x i8> %and328, %src1
  %or14 = or <16 x i8> %1, %and1
  ret <16 x i8> %or14
}

define <16 x i8> @eval31(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval31:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v0, %v26, %v24
; CHECK-NEXT:    veval %v24, %v24, %v0, %v28, 31
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %and = and <16 x i8> %not, %src2
  %and1 = and <16 x i8> %and, %src3
  %or17 = or <16 x i8> %and1, %src1
  ret <16 x i8> %or17
}

define <16 x i8> @eval32(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v28, %v24, 8
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and2 = and <16 x i8> %1, %src2
  ret <16 x i8> %and2
}

define <16 x i8> @eval33(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval33:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v24, %v28, 9
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src1, %src3
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %or5 = and <16 x i8> %1, %src2
  ret <16 x i8> %or5
}

define <16 x i8> @eval34(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval34:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v24, %v26, %v28
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src3, splat(i8 -1)
  %or6 = and <16 x i8> %not1, %src2
  ret <16 x i8> %or6
}

define <16 x i8> @eval35(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval35:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v24, %v28, 11
; CHECK-NEXT:    br %r14
entry:
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and219 = or <16 x i8> %src3.not, %src1
  %or9 = and <16 x i8> %and219, %src2
  ret <16 x i8> %or9
}

define <16 x i8> @eval36(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval36:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v28, %v24
; CHECK-NEXT:    veval %v1, %v24, %v28, %v26, 2
; CHECK-NEXT:    veval %v24, %v1, %v26, %v0, 47
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and2 = and <16 x i8> %1, %src2
  %not3 = xor <16 x i8> %src2, splat(i8 -1)
  %and4 = and <16 x i8> %not3, %src1
  %and5 = and <16 x i8> %and4, %src3
  %or6 = or <16 x i8> %and2, %and5
  ret <16 x i8> %or6
}

define <16 x i8> @eval37(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval37:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v28, %v24
; CHECK-NEXT:    vn %v1, %v28, %v24
; CHECK-NEXT:    veval %v24, %v1, %v26, %v0, 47
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and2 = and <16 x i8> %1, %src2
  %2 = and <16 x i8> %src3, %src1
  %or9 = or <16 x i8> %and2, %2
  ret <16 x i8> %or9
}

define <16 x i8> @eval38(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval38:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v0, %v24, %v26
; CHECK-NEXT:    vsel %v24, %v0, %v26, %v28
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src3, splat(i8 -1)
  %not3 = xor <16 x i8> %src2, splat(i8 -1)
  %and4 = and <16 x i8> %not3, %src1
  %and5 = and <16 x i8> %and4, %src3
  %0 = and <16 x i8> %not1, %src2
  %or10 = or <16 x i8> %0, %and5
  ret <16 x i8> %or10
}

define <16 x i8> @eval39(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval39:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v0, %v24, %v26
; CHECK-NEXT:    veval %v1, %v26, %v24, %v28, 11
; CHECK-NEXT:    veval %v24, %v1, %v0, %v28, 31
; CHECK-NEXT:    br %r14
entry:
  %not3 = xor <16 x i8> %src2, splat(i8 -1)
  %and4 = and <16 x i8> %not3, %src1
  %and5 = and <16 x i8> %and4, %src3
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and227 = or <16 x i8> %src3.not, %src1
  %0 = and <16 x i8> %and227, %src2
  %or13 = or <16 x i8> %0, %and5
  ret <16 x i8> %or13
}

define <16 x i8> @eval40(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval40:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v24, %v28, 40
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src2, %src1
  %1 = xor <16 x i8> %src3, splat(i8 -1)
  %or7 = and <16 x i8> %0, %1
  ret <16 x i8> %or7
}

define <16 x i8> @eval41(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval41:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v26, %v24
; CHECK-NEXT:    vn %v1, %v26, %v24
; CHECK-NEXT:    vsel %v24, %v1, %v0, %v28
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src2, %src1
  %1 = xor <16 x i8> %src3, splat(i8 -1)
  %or7 = and <16 x i8> %0, %1
  %and8 = and <16 x i8> %src2, %src1
  %and9 = and <16 x i8> %and8, %src3
  %or10 = or <16 x i8> %or7, %and9
  ret <16 x i8> %or10
}

define <16 x i8> @eval42(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval42:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v24, %v28, 42
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src3, splat(i8 -1)
  %and1021 = or <16 x i8> %src2, %src1
  %or11 = and <16 x i8> %and1021, %not1
  ret <16 x i8> %or11
}

define <16 x i8> @eval43(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval43:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v26, %v24
; CHECK-NEXT:    vn %v1, %v26, %v24
; CHECK-NEXT:    veval %v24, %v1, %v0, %v28, 47
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src2, %src1
  %1 = xor <16 x i8> %src3, splat(i8 -1)
  %or7 = and <16 x i8> %0, %1
  %and8 = and <16 x i8> %src2, %src1
  %or14 = or <16 x i8> %or7, %and8
  ret <16 x i8> %or14
}

define <16 x i8> @eval44(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval44:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v28, %v24
; CHECK-NEXT:    vsel %v24, %v0, %v24, %v26
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and2 = and <16 x i8> %1, %src2
  %not3 = xor <16 x i8> %src2, splat(i8 -1)
  %and4 = and <16 x i8> %not3, %src1
  %or11 = or <16 x i8> %and2, %and4
  ret <16 x i8> %or11
}

define <16 x i8> @eval45(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval45:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v1, %v26, %v24, %v28, 1
; CHECK-NEXT:    vo %v0, %v28, %v24
; CHECK-NEXT:    veval %v1, %v1, %v24, %v26, 47
; CHECK-NEXT:    veval %v24, %v1, %v26, %v0, 47
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and2 = and <16 x i8> %1, %src2
  %not3 = xor <16 x i8> %src2, splat(i8 -1)
  %and4 = and <16 x i8> %not3, %src1
  %and12 = and <16 x i8> %src2, %src1
  %and13 = and <16 x i8> %and12, %src3
  %or11 = or <16 x i8> %and13, %and4
  %or14 = or <16 x i8> %or11, %and2
  ret <16 x i8> %or14
}

define <16 x i8> @eval46(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval46:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v26, %v28, %v24, 8
; CHECK-NEXT:    vn %v1, %v28, %v26
; CHECK-NEXT:    veval %v24, %v0, %v24, %v1, 47
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and2 = and <16 x i8> %1, %src2
  %and429.demorgan = and <16 x i8> %src3, %src2
  %and429 = xor <16 x i8> %and429.demorgan, splat(i8 -1)
  %2 = and <16 x i8> %and429, %src1
  %or15 = or <16 x i8> %and2, %2
  ret <16 x i8> %or15
}

define <16 x i8> @eval47(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval47:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v28, %v24
; CHECK-NEXT:    veval %v24, %v24, %v26, %v0, 47
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and2 = and <16 x i8> %1, %src2
  %or18 = or <16 x i8> %and2, %src1
  ret <16 x i8> %or18
}

define <16 x i8> @eval48(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval48:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v24, %v26, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %and = and <16 x i8> %not, %src2
  ret <16 x i8> %and
}

define <16 x i8> @eval49(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval49:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v28, %v24, 11
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %and819 = or <16 x i8> %not, %src3
  %or9 = and <16 x i8> %and819, %src2
  ret <16 x i8> %or9
}

define <16 x i8> @eval50(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval50:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v28, %v24, 14
; CHECK-NEXT:    br %r14
entry:
  %and920.demorgan = and <16 x i8> %src3, %src1
  %and920 = xor <16 x i8> %and920.demorgan, splat(i8 -1)
  %or10 = and <16 x i8> %and920, %src2
  ret <16 x i8> %or10
}

define <16 x i8> @eval51(<16 x i8> %src1, <16 x i8> returned %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval51:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vlr %v24, %v26
; CHECK-NEXT:    br %r14
entry:
  ret <16 x i8> %src2
}

define <16 x i8> @eval52(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval52:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v0, %v28, %v26
; CHECK-NEXT:    vsel %v24, %v0, %v26, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %and = and <16 x i8> %not, %src2
  %not7 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = and <16 x i8> %not7, %src3
  %and9 = and <16 x i8> %0, %src1
  %or10 = or <16 x i8> %and9, %and
  ret <16 x i8> %or10
}

define <16 x i8> @eval53(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval53:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsel %v24, %v28, %v26, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %and = and <16 x i8> %not, %src2
  %0 = and <16 x i8> %src3, %src1
  %or13 = or <16 x i8> %0, %and
  ret <16 x i8> %or13
}

define <16 x i8> @eval54(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval54:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v24, %v28, %v26, 2
; CHECK-NEXT:    vn %v1, %v28, %v24
; CHECK-NEXT:    veval %v24, %v0, %v26, %v1, 47
; CHECK-NEXT:    br %r14
entry:
  %not7 = xor <16 x i8> %src2, splat(i8 -1)
  %and8 = and <16 x i8> %not7, %src1
  %and9 = and <16 x i8> %and8, %src3
  %and28.demorgan = and <16 x i8> %src3, %src1
  %and28 = xor <16 x i8> %and28.demorgan, splat(i8 -1)
  %0 = and <16 x i8> %and28, %src2
  %or14 = or <16 x i8> %and9, %0
  ret <16 x i8> %or14
}

define <16 x i8> @eval55(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval55:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v0, %v24, %v26
; CHECK-NEXT:    veval %v24, %v26, %v0, %v28, 31
; CHECK-NEXT:    br %r14
entry:
  %not7 = xor <16 x i8> %src2, splat(i8 -1)
  %and8 = and <16 x i8> %not7, %src1
  %and9 = and <16 x i8> %and8, %src3
  %or17 = or <16 x i8> %and9, %src2
  ret <16 x i8> %or17
}

define <16 x i8> @eval56(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval56:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v28, %v26
; CHECK-NEXT:    vsel %v24, %v0, %v26, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %and = and <16 x i8> %not, %src2
  %0 = or <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and10 = and <16 x i8> %1, %src1
  %or11 = or <16 x i8> %and10, %and
  ret <16 x i8> %or11
}

define <16 x i8> @eval57(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval57:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v1, %v26, %v24, %v28, 1
; CHECK-NEXT:    vo %v0, %v28, %v26
; CHECK-NEXT:    veval %v1, %v1, %v26, %v24, 47
; CHECK-NEXT:    veval %v24, %v1, %v24, %v0, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %and = and <16 x i8> %not, %src2
  %0 = or <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and10 = and <16 x i8> %1, %src1
  %and12 = and <16 x i8> %src2, %src1
  %and13 = and <16 x i8> %and12, %src3
  %or11 = or <16 x i8> %and13, %and
  %or14 = or <16 x i8> %or11, %and10
  ret <16 x i8> %or14
}

define <16 x i8> @eval58(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval58:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v28, %v28
; CHECK-NEXT:    vsel %v24, %v0, %v26, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %and = and <16 x i8> %not, %src2
  %not1 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = and <16 x i8> %not1, %src1
  %or15 = or <16 x i8> %0, %and
  ret <16 x i8> %or15
}

define <16 x i8> @eval59(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval59:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v26, %v28
; CHECK-NEXT:    vsel %v24, %v0, %v26, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %and = and <16 x i8> %not, %src2
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and1036 = or <16 x i8> %src3.not, %src2
  %0 = and <16 x i8> %and1036, %src1
  %or18 = or <16 x i8> %0, %and
  ret <16 x i8> %or18
}

define <16 x i8> @eval60(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval60:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v24, %v26, %v24
; CHECK-NEXT:    br %r14
entry:
  %or15 = xor <16 x i8> %src2, %src1
  ret <16 x i8> %or15
}

define <16 x i8> @eval61(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval61:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vn %v0, %v24, %v28
; CHECK-NEXT:    veval %v24, %v26, %v24, %v0, 61
; CHECK-NEXT:    br %r14
entry:
  %or15 = xor <16 x i8> %src2, %src1
  %0 = and <16 x i8> %src1, %src3
  %and17 = and <16 x i8> %0, %src2
  %or18 = or <16 x i8> %and17, %or15
  ret <16 x i8> %or18
}

define <16 x i8> @eval62(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval62:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v0, %v24, %v28
; CHECK-NEXT:    veval %v24, %v26, %v24, %v0, 61
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src3, splat(i8 -1)
  %or15 = xor <16 x i8> %src2, %src1
  %0 = and <16 x i8> %not1, %src1
  %and18 = and <16 x i8> %0, %src2
  %or19 = or <16 x i8> %and18, %or15
  ret <16 x i8> %or19
}

define <16 x i8> @eval63(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval63:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v24, %v26, %v24
; CHECK-NEXT:    br %r14
entry:
  %or22 = or <16 x i8> %src2, %src1
  ret <16 x i8> %or22
}

define <16 x i8> @eval64(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 8
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and = xor <16 x i8> %and.demorgan, splat(i8 -1)
  %and2 = and <16 x i8> %and, %src3
  ret <16 x i8> %and2
}

define <16 x i8> @eval65(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval65:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v24, %v26, 9
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src1, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %or5 = and <16 x i8> %1, %src3
  ret <16 x i8> %or5
}

define <16 x i8> @eval66(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval66:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v26, %v24
; CHECK-NEXT:    veval %v1, %v24, %v26, %v28, 2
; CHECK-NEXT:    veval %v24, %v1, %v28, %v0, 47
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and = xor <16 x i8> %and.demorgan, splat(i8 -1)
  %and2 = and <16 x i8> %and, %src3
  %not4 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = and <16 x i8> %not4, %src1
  %and5 = and <16 x i8> %0, %src2
  %or6 = or <16 x i8> %and5, %and2
  ret <16 x i8> %or6
}

define <16 x i8> @eval67(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval67:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v26, %v24
; CHECK-NEXT:    vn %v1, %v26, %v24
; CHECK-NEXT:    veval %v24, %v1, %v28, %v0, 47
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and = xor <16 x i8> %and.demorgan, splat(i8 -1)
  %and2 = and <16 x i8> %and, %src3
  %and3 = and <16 x i8> %src2, %src1
  %or9 = or <16 x i8> %and2, %and3
  ret <16 x i8> %or9
}

define <16 x i8> @eval68(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval68:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v24, %v28, %v26
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %or6 = and <16 x i8> %not1, %src3
  ret <16 x i8> %or6
}

define <16 x i8> @eval69(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval69:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v24, %v26, 11
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %or620 = or <16 x i8> %not1, %src1
  %or9 = and <16 x i8> %or620, %src3
  ret <16 x i8> %or9
}

define <16 x i8> @eval70(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval70:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v0, %v24, %v28
; CHECK-NEXT:    vsel %v24, %v0, %v28, %v26
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %or6 = and <16 x i8> %not1, %src3
  %not8 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = and <16 x i8> %not8, %src1
  %and9 = and <16 x i8> %0, %src2
  %or10 = or <16 x i8> %and9, %or6
  ret <16 x i8> %or10
}

define <16 x i8> @eval71(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval71:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsel %v24, %v24, %v28, %v26
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %or6 = and <16 x i8> %not1, %src3
  %and7 = and <16 x i8> %src2, %src1
  %or13 = or <16 x i8> %or6, %and7
  ret <16 x i8> %or13
}

define <16 x i8> @eval72(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval72:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v24, %v26, 40
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %src2, splat(i8 -1)
  %or7 = and <16 x i8> %0, %1
  ret <16 x i8> %or7
}

define <16 x i8> @eval73(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval73:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v24
; CHECK-NEXT:    veval %v1, %v26, %v24, %v28, 1
; CHECK-NEXT:    veval %v24, %v1, %v0, %v26, 47
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %src2, splat(i8 -1)
  %or7 = and <16 x i8> %0, %1
  %and8 = and <16 x i8> %src2, %src1
  %and9 = and <16 x i8> %and8, %src3
  %or10 = or <16 x i8> %or7, %and9
  ret <16 x i8> %or10
}

define <16 x i8> @eval74(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval74:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v24
; CHECK-NEXT:    vnc %v1, %v24, %v28
; CHECK-NEXT:    vsel %v24, %v1, %v0, %v26
; CHECK-NEXT:    br %r14
entry:
  %not5 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = xor <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %src2, splat(i8 -1)
  %or7 = and <16 x i8> %0, %1
  %2 = and <16 x i8> %not5, %src1
  %and10 = and <16 x i8> %2, %src2
  %or11 = or <16 x i8> %or7, %and10
  ret <16 x i8> %or11
}

define <16 x i8> @eval75(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval75:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v24
; CHECK-NEXT:    vsel %v24, %v24, %v0, %v26
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %src2, splat(i8 -1)
  %or7 = and <16 x i8> %0, %1
  %and8 = and <16 x i8> %src2, %src1
  %or14 = or <16 x i8> %or7, %and8
  ret <16 x i8> %or14
}

define <16 x i8> @eval76(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval76:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v28, %v26, %v24, 8
; CHECK-NEXT:    veval %v24, %v0, %v24, %v26, 47
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = or <16 x i8> %src2, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and2 = and <16 x i8> %1, %src3
  %and4 = and <16 x i8> %not1, %src1
  %or11 = or <16 x i8> %and2, %and4
  ret <16 x i8> %or11
}

define <16 x i8> @eval77(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval77:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vgbm %v0, 65535
; CHECK-NEXT:    veval %v0, %v24, %v0, %v26, 40
; CHECK-NEXT:    vn %v1, %v26, %v24
; CHECK-NEXT:    veval %v0, %v28, %v0, %v1, 7
; CHECK-NEXT:    veval %v24, %v0, %v24, %v26, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %and4 = and <16 x i8> %not1, %src1
  %and12 = and <16 x i8> %src2, %src1
  %and228 = or <16 x i8> %and, %and12
  %0 = and <16 x i8> %and228, %src3
  %or14 = or <16 x i8> %0, %and4
  ret <16 x i8> %or14
}

define <16 x i8> @eval78(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval78:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vgbm %v0, 65535
; CHECK-NEXT:    vno %v1, %v28, %v28
; CHECK-NEXT:    veval %v0, %v24, %v0, %v26, 40
; CHECK-NEXT:    veval %v1, %v24, %v1, %v26, 11
; CHECK-NEXT:    veval %v24, %v1, %v0, %v28, 31
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %and2 = and <16 x i8> %and, %src3
  %not5 = xor <16 x i8> %src3, splat(i8 -1)
  %and429 = or <16 x i8> %not5, %not1
  %0 = and <16 x i8> %and429, %src1
  %or15 = or <16 x i8> %0, %and2
  ret <16 x i8> %or15
}

define <16 x i8> @eval79(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval79:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v26, %v24
; CHECK-NEXT:    veval %v24, %v24, %v28, %v0, 47
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and = xor <16 x i8> %and.demorgan, splat(i8 -1)
  %and2 = and <16 x i8> %and, %src3
  %or18 = or <16 x i8> %and2, %src1
  ret <16 x i8> %or18
}

define <16 x i8> @eval80(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval80:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v24, %v28, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %or6 = and <16 x i8> %not, %src3
  ret <16 x i8> %or6
}

define <16 x i8> @eval81(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval81:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 11
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %or620 = or <16 x i8> %not, %src2
  %or9 = and <16 x i8> %or620, %src3
  ret <16 x i8> %or9
}

define <16 x i8> @eval82(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval82:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v0, %v26, %v28
; CHECK-NEXT:    vsel %v24, %v0, %v28, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %or6 = and <16 x i8> %not, %src3
  %not8 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = and <16 x i8> %not8, %src2
  %and9 = and <16 x i8> %0, %src1
  %or10 = or <16 x i8> %and9, %or6
  ret <16 x i8> %or10
}

define <16 x i8> @eval83(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval83:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsel %v24, %v26, %v28, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %or6 = and <16 x i8> %not, %src3
  %and7 = and <16 x i8> %src2, %src1
  %or13 = or <16 x i8> %or6, %and7
  ret <16 x i8> %or13
}

define <16 x i8> @eval84(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval84:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 14
; CHECK-NEXT:    br %r14
entry:
  %or621.demorgan = and <16 x i8> %src2, %src1
  %or621 = xor <16 x i8> %or621.demorgan, splat(i8 -1)
  %or10 = and <16 x i8> %or621, %src3
  ret <16 x i8> %or10
}

define <16 x i8> @eval85(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> returned %src3) {
; CHECK-LABEL: eval85:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vlr %v24, %v28
; CHECK-NEXT:    br %r14
entry:
  ret <16 x i8> %src3
}

define <16 x i8> @eval86(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval86:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vn %v0, %v26, %v24
; CHECK-NEXT:    veval %v1, %v24, %v26, %v28, 2
; CHECK-NEXT:    veval %v24, %v1, %v28, %v0, 47
; CHECK-NEXT:    br %r14
entry:
  %or629.demorgan = and <16 x i8> %src2, %src1
  %or629 = xor <16 x i8> %or629.demorgan, splat(i8 -1)
  %or10 = and <16 x i8> %or629, %src3
  %not12 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = and <16 x i8> %not12, %src1
  %and13 = and <16 x i8> %0, %src2
  %or14 = or <16 x i8> %and13, %or10
  ret <16 x i8> %or14
}

define <16 x i8> @eval87(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval87:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 31
; CHECK-NEXT:    br %r14
entry:
  %and11 = and <16 x i8> %src2, %src1
  %or17 = or <16 x i8> %and11, %src3
  ret <16 x i8> %or17
}

define <16 x i8> @eval88(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval88:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v28, %v26
; CHECK-NEXT:    vsel %v24, %v0, %v28, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %or6 = and <16 x i8> %not, %src3
  %0 = or <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and10 = and <16 x i8> %1, %src1
  %or11 = or <16 x i8> %and10, %or6
  ret <16 x i8> %or11
}

define <16 x i8> @eval89(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval89:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v28, %v26
; CHECK-NEXT:    veval %v1, %v28, %v26, %v24, 11
; CHECK-NEXT:    veval %v24, %v1, %v24, %v0, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %0 = or <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and10 = and <16 x i8> %1, %src1
  %or629 = or <16 x i8> %not, %src2
  %2 = and <16 x i8> %or629, %src3
  %or14 = or <16 x i8> %and10, %2
  ret <16 x i8> %or14
}

define <16 x i8> @eval90(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval90:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v24, %v28, %v24
; CHECK-NEXT:    br %r14
entry:
  %or15 = xor <16 x i8> %src3, %src1
  ret <16 x i8> %or15
}

define <16 x i8> @eval91(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval91:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v26, %v28
; CHECK-NEXT:    vsel %v24, %v0, %v28, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %or6 = and <16 x i8> %not, %src3
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and1037 = or <16 x i8> %src3.not, %src2
  %0 = and <16 x i8> %and1037, %src1
  %or18 = or <16 x i8> %0, %or6
  ret <16 x i8> %or18
}

define <16 x i8> @eval92(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval92:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v26, %v26
; CHECK-NEXT:    vsel %v24, %v0, %v28, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %or6 = and <16 x i8> %not, %src3
  %and8 = and <16 x i8> %not1, %src1
  %or15 = or <16 x i8> %or6, %and8
  ret <16 x i8> %or15
}

define <16 x i8> @eval93(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval93:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v24, %v26, 47
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and8 = and <16 x i8> %not1, %src1
  %or18 = or <16 x i8> %and8, %src3
  ret <16 x i8> %or18
}

define <16 x i8> @eval94(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval94:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnn %v0, %v28, %v26
; CHECK-NEXT:    vsel %v24, %v0, %v28, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %or6 = and <16 x i8> %not, %src3
  %and838.demorgan = and <16 x i8> %src3, %src2
  %and838 = xor <16 x i8> %and838.demorgan, splat(i8 -1)
  %0 = and <16 x i8> %and838, %src1
  %or19 = or <16 x i8> %0, %or6
  ret <16 x i8> %or19
}

define <16 x i8> @eval95(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval95:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v24, %v28, %v24
; CHECK-NEXT:    br %r14
entry:
  %or22 = or <16 x i8> %src3, %src1
  ret <16 x i8> %or22
}

define <16 x i8> @eval96(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval96:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 40
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %src1, splat(i8 -1)
  %or7 = and <16 x i8> %0, %1
  ret <16 x i8> %or7
}

define <16 x i8> @eval97(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval97:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v26
; CHECK-NEXT:    veval %v1, %v26, %v24, %v28, 1
; CHECK-NEXT:    veval %v24, %v1, %v0, %v24, 47
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %src1, splat(i8 -1)
  %or7 = and <16 x i8> %0, %1
  %and8 = and <16 x i8> %src2, %src1
  %and9 = and <16 x i8> %and8, %src3
  %or10 = or <16 x i8> %or7, %and9
  ret <16 x i8> %or10
}

define <16 x i8> @eval98(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval98:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v26
; CHECK-NEXT:    veval %v1, %v24, %v26, %v28, 2
; CHECK-NEXT:    veval %v24, %v1, %v0, %v24, 47
; CHECK-NEXT:    br %r14
entry:
  %not5 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = xor <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %src1, splat(i8 -1)
  %or7 = and <16 x i8> %0, %1
  %2 = and <16 x i8> %not5, %src1
  %and10 = and <16 x i8> %2, %src2
  %or11 = or <16 x i8> %or7, %and10
  ret <16 x i8> %or11
}

define <16 x i8> @eval99(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval99:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v26
; CHECK-NEXT:    vsel %v24, %v26, %v0, %v24
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %src1, splat(i8 -1)
  %or7 = and <16 x i8> %0, %1
  %and8 = and <16 x i8> %src2, %src1
  %or14 = or <16 x i8> %or7, %and8
  ret <16 x i8> %or14
}

define <16 x i8> @eval100(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval100:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v28, %v24
; CHECK-NEXT:    vsel %v24, %v0, %v28, %v26
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and6 = and <16 x i8> %1, %src2
  %2 = and <16 x i8> %not1, %src3
  %or11 = or <16 x i8> %and6, %2
  ret <16 x i8> %or11
}

define <16 x i8> @eval101(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval101:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v28, %v24
; CHECK-NEXT:    veval %v1, %v28, %v24, %v26, 11
; CHECK-NEXT:    veval %v24, %v1, %v26, %v0, 47
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and6 = and <16 x i8> %1, %src2
  %2 = or <16 x i8> %not1, %src1
  %3 = and <16 x i8> %2, %src3
  %or14 = or <16 x i8> %and6, %3
  ret <16 x i8> %or14
}

define <16 x i8> @eval102(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval102:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v24, %v26, %v28
; CHECK-NEXT:    br %r14
entry:
  %or15 = xor <16 x i8> %src2, %src3
  ret <16 x i8> %or15
}

define <16 x i8> @eval103(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval103:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v24, %v28
; CHECK-NEXT:    vsel %v24, %v0, %v28, %v26
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = and <16 x i8> %not1, %src3
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and637 = or <16 x i8> %src3.not, %src1
  %1 = and <16 x i8> %and637, %src2
  %or18 = or <16 x i8> %1, %0
  ret <16 x i8> %or18
}

define <16 x i8> @eval104(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval104:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v26
; CHECK-NEXT:    vno %v1, %v28, %v26
; CHECK-NEXT:    vsel %v24, %v1, %v0, %v24
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %src1, splat(i8 -1)
  %or7 = and <16 x i8> %0, %1
  %2 = or <16 x i8> %src3, %src2
  %3 = xor <16 x i8> %2, splat(i8 -1)
  %and11 = and <16 x i8> %3, %src1
  %or12 = or <16 x i8> %or7, %and11
  ret <16 x i8> %or12
}

define <16 x i8> @eval105(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval105:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 105
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %or15 = xor <16 x i8> %0, %src1
  ret <16 x i8> %or15
}

define <16 x i8> @eval106(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval106:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v28, %v28
; CHECK-NEXT:    vx %v1, %v28, %v26
; CHECK-NEXT:    vsel %v24, %v0, %v1, %v24
; CHECK-NEXT:    br %r14
entry:
  %not5 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = xor <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %src1, splat(i8 -1)
  %or7 = and <16 x i8> %0, %1
  %2 = and <16 x i8> %not5, %src1
  %or16 = or <16 x i8> %or7, %2
  ret <16 x i8> %or16
}

define <16 x i8> @eval107(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval107:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v26
; CHECK-NEXT:    voc %v1, %v26, %v28
; CHECK-NEXT:    vsel %v24, %v1, %v0, %v24
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %src1, splat(i8 -1)
  %or7 = and <16 x i8> %0, %1
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and1137 = or <16 x i8> %src3.not, %src2
  %2 = and <16 x i8> %and1137, %src1
  %or19 = or <16 x i8> %or7, %2
  ret <16 x i8> %or19
}

define <16 x i8> @eval108(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval108:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v24, %v24
; CHECK-NEXT:    veval %v0, %v0, %v28, %v26, 2
; CHECK-NEXT:    vo %v1, %v28, %v24
; CHECK-NEXT:    veval %v0, %v0, %v24, %v26, 47
; CHECK-NEXT:    veval %v24, %v0, %v26, %v1, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %and2 = and <16 x i8> %and, %src3
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and6 = and <16 x i8> %1, %src2
  %and9 = and <16 x i8> %not1, %src1
  %or7 = or <16 x i8> %and2, %and9
  %or16 = or <16 x i8> %or7, %and6
  ret <16 x i8> %or16
}

define <16 x i8> @eval109(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval109:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vgbm %v0, 65535
; CHECK-NEXT:    veval %v0, %v24, %v0, %v26, 40
; CHECK-NEXT:    vn %v2, %v26, %v24
; CHECK-NEXT:    veval %v0, %v28, %v0, %v2, 7
; CHECK-NEXT:    vo %v1, %v28, %v24
; CHECK-NEXT:    veval %v0, %v0, %v24, %v26, 47
; CHECK-NEXT:    veval %v24, %v0, %v26, %v1, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and6 = and <16 x i8> %1, %src2
  %and9 = and <16 x i8> %not1, %src1
  %and17 = and <16 x i8> %src2, %src1
  %and237 = or <16 x i8> %and, %and17
  %2 = and <16 x i8> %and237, %src3
  %or16 = or <16 x i8> %2, %and9
  %or19 = or <16 x i8> %or16, %and6
  ret <16 x i8> %or19
}

define <16 x i8> @eval110(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval110:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v24, %v24
; CHECK-NEXT:    vgbm %v1, 65535
; CHECK-NEXT:    vo %v2, %v28, %v24
; CHECK-NEXT:    veval %v0, %v0, %v28, %v26, 2
; CHECK-NEXT:    veval %v0, %v0, %v26, %v2, 47
; CHECK-NEXT:    veval %v1, %v26, %v1, %v28, 190
; CHECK-NEXT:    veval %v24, %v0, %v1, %v24, 31
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %and2 = and <16 x i8> %and, %src3
  %not5 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and6 = and <16 x i8> %1, %src2
  %or7 = or <16 x i8> %and6, %and2
  %and938 = or <16 x i8> %not5, %not1
  %2 = and <16 x i8> %and938, %src1
  %or20 = or <16 x i8> %or7, %2
  ret <16 x i8> %or20
}

define <16 x i8> @eval111(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval111:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v24, %v28, %v26, 111
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %or23 = or <16 x i8> %0, %src1
  ret <16 x i8> %or23
}

define <16 x i8> @eval112(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval112:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v28, %v26, %v24, 8
; CHECK-NEXT:    veval %v24, %v0, %v26, %v24, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %0 = or <16 x i8> %src2, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and2 = and <16 x i8> %1, %src3
  %and4 = and <16 x i8> %not, %src2
  %or11 = or <16 x i8> %and2, %and4
  ret <16 x i8> %or11
}

define <16 x i8> @eval113(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval113:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vgbm %v0, 65535
; CHECK-NEXT:    veval %v0, %v24, %v0, %v26, 40
; CHECK-NEXT:    vn %v1, %v26, %v24
; CHECK-NEXT:    veval %v0, %v28, %v0, %v1, 7
; CHECK-NEXT:    veval %v24, %v0, %v26, %v24, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %and4 = and <16 x i8> %not, %src2
  %and12 = and <16 x i8> %src2, %src1
  %and228 = or <16 x i8> %and, %and12
  %0 = and <16 x i8> %and228, %src3
  %or14 = or <16 x i8> %0, %and4
  ret <16 x i8> %or14
}

define <16 x i8> @eval114(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval114:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v24, %v24
; CHECK-NEXT:    vgbm %v1, 65535
; CHECK-NEXT:    veval %v0, %v0, %v28, %v26, 2
; CHECK-NEXT:    veval %v1, %v24, %v1, %v28, 190
; CHECK-NEXT:    veval %v24, %v0, %v1, %v26, 31
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %and2 = and <16 x i8> %and, %src3
  %not5 = xor <16 x i8> %src3, splat(i8 -1)
  %and429 = or <16 x i8> %not5, %not
  %0 = and <16 x i8> %and429, %src2
  %or15 = or <16 x i8> %and2, %0
  ret <16 x i8> %or15
}

define <16 x i8> @eval115(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval115:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v26, %v24
; CHECK-NEXT:    veval %v24, %v26, %v28, %v0, 47
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and = xor <16 x i8> %and.demorgan, splat(i8 -1)
  %and2 = and <16 x i8> %and, %src3
  %or18 = or <16 x i8> %and2, %src2
  ret <16 x i8> %or18
}

define <16 x i8> @eval116(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval116:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v24, %v24
; CHECK-NEXT:    vsel %v24, %v0, %v28, %v26
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and4 = and <16 x i8> %not, %src2
  %0 = and <16 x i8> %not1, %src3
  %or15 = or <16 x i8> %0, %and4
  ret <16 x i8> %or15
}

define <16 x i8> @eval117(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval117:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %and4 = and <16 x i8> %not, %src2
  %or18 = or <16 x i8> %and4, %src3
  ret <16 x i8> %or18
}

define <16 x i8> @eval118(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval118:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnn %v0, %v28, %v24
; CHECK-NEXT:    vsel %v24, %v0, %v28, %v26
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = and <16 x i8> %not1, %src3
  %and438.demorgan = and <16 x i8> %src3, %src1
  %and438 = xor <16 x i8> %and438.demorgan, splat(i8 -1)
  %1 = and <16 x i8> %and438, %src2
  %or19 = or <16 x i8> %0, %1
  ret <16 x i8> %or19
}

define <16 x i8> @eval119(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval119:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v24, %v28, %v26
; CHECK-NEXT:    br %r14
entry:
  %or22 = or <16 x i8> %src3, %src2
  ret <16 x i8> %or22
}

define <16 x i8> @eval120(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval120:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v24, %v24
; CHECK-NEXT:    veval %v0, %v0, %v28, %v26, 2
; CHECK-NEXT:    veval %v0, %v0, %v26, %v24, 47
; CHECK-NEXT:    vo %v1, %v28, %v26
; CHECK-NEXT:    veval %v24, %v0, %v24, %v1, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %and2 = and <16 x i8> %and, %src3
  %and4 = and <16 x i8> %not, %src2
  %or11 = or <16 x i8> %and2, %and4
  %0 = or <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and15 = and <16 x i8> %1, %src1
  %or16 = or <16 x i8> %or11, %and15
  ret <16 x i8> %or16
}

define <16 x i8> @eval121(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval121:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vgbm %v0, 65535
; CHECK-NEXT:    veval %v0, %v24, %v0, %v26, 40
; CHECK-NEXT:    vn %v2, %v26, %v24
; CHECK-NEXT:    veval %v0, %v28, %v0, %v2, 7
; CHECK-NEXT:    vo %v1, %v28, %v26
; CHECK-NEXT:    veval %v0, %v0, %v26, %v24, 47
; CHECK-NEXT:    veval %v24, %v0, %v24, %v1, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %and4 = and <16 x i8> %not, %src2
  %0 = or <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and15 = and <16 x i8> %1, %src1
  %and17 = and <16 x i8> %src2, %src1
  %and237 = or <16 x i8> %and, %and17
  %2 = and <16 x i8> %and237, %src3
  %or16 = or <16 x i8> %2, %and4
  %or19 = or <16 x i8> %or16, %and15
  ret <16 x i8> %or19
}

define <16 x i8> @eval122(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval122:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v24, %v24
; CHECK-NEXT:    veval %v0, %v0, %v28, %v26, 2
; CHECK-NEXT:    veval %v0, %v0, %v26, %v24, 47
; CHECK-NEXT:    veval %v24, %v0, %v24, %v28, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %and2 = and <16 x i8> %and, %src3
  %and4 = and <16 x i8> %not, %src2
  %not5 = xor <16 x i8> %src3, splat(i8 -1)
  %or11 = or <16 x i8> %and2, %and4
  %0 = and <16 x i8> %not5, %src1
  %or20 = or <16 x i8> %or11, %0
  ret <16 x i8> %or20
}

define <16 x i8> @eval123(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval123:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v24, %v24
; CHECK-NEXT:    veval %v0, %v0, %v28, %v26, 2
; CHECK-NEXT:    veval %v0, %v0, %v26, %v24, 47
; CHECK-NEXT:    voc %v1, %v26, %v28
; CHECK-NEXT:    veval %v24, %v0, %v1, %v24, 31
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %and2 = and <16 x i8> %and, %src3
  %and4 = and <16 x i8> %not, %src2
  %or11 = or <16 x i8> %and2, %and4
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and1545 = or <16 x i8> %src3.not, %src2
  %0 = and <16 x i8> %and1545, %src1
  %or23 = or <16 x i8> %or11, %0
  ret <16 x i8> %or23
}

define <16 x i8> @eval124(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval124:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v26, %v24
; CHECK-NEXT:    vx %v1, %v24, %v26
; CHECK-NEXT:    veval %v24, %v1, %v28, %v0, 47
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src2, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and2 = and <16 x i8> %1, %src3
  %or11 = xor <16 x i8> %src1, %src2
  %or20 = or <16 x i8> %or11, %and2
  ret <16 x i8> %or20
}

define <16 x i8> @eval125(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval125:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v24, %v26, 111
; CHECK-NEXT:    br %r14
entry:
  %or11 = xor <16 x i8> %src1, %src2
  %or23 = or <16 x i8> %or11, %src3
  ret <16 x i8> %or23
}

define <16 x i8> @eval126(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval126:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v24, %v24
; CHECK-NEXT:    vgbm %v1, 65535
; CHECK-NEXT:    veval %v0, %v0, %v28, %v26, 2
; CHECK-NEXT:    veval %v0, %v0, %v26, %v24, 47
; CHECK-NEXT:    veval %v1, %v26, %v1, %v28, 190
; CHECK-NEXT:    veval %v24, %v0, %v1, %v24, 31
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %and2 = and <16 x i8> %and, %src3
  %and4 = and <16 x i8> %not, %src2
  %not5 = xor <16 x i8> %src3, splat(i8 -1)
  %or11 = or <16 x i8> %and2, %and4
  %and1346 = or <16 x i8> %not5, %not1
  %0 = and <16 x i8> %and1346, %src1
  %or24 = or <16 x i8> %or11, %0
  ret <16 x i8> %or24
}

define <16 x i8> @eval127(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval127:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v28, %v26, %v24, 8
; CHECK-NEXT:    veval %v24, %v0, %v24, %v26, 127
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src2, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and2 = and <16 x i8> %1, %src3
  %2 = or <16 x i8> %and2, %src1
  %or27 = or <16 x i8> %2, %src2
  ret <16 x i8> %or27
}

define <16 x i8> @eval128(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v24, %v28, 128
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and3.demorgan = or <16 x i8> %and.demorgan, %src3
  %and3 = xor <16 x i8> %and3.demorgan, splat(i8 -1)
  ret <16 x i8> %and3
}

define <16 x i8> @eval129(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval129:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v26, %v24
; CHECK-NEXT:    vn %v1, %v26, %v24
; CHECK-NEXT:    veval %v24, %v1, %v28, %v0, 139
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and3.demorgan = or <16 x i8> %and.demorgan, %src3
  %and3 = xor <16 x i8> %and3.demorgan, splat(i8 -1)
  %and4 = and <16 x i8> %src2, %src1
  %and5 = and <16 x i8> %and4, %src3
  %or6 = or <16 x i8> %and5, %and3
  ret <16 x i8> %or6
}

define <16 x i8> @eval130(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval130:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v24, %v28, 130
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src2, %src1
  %or7.demorgan = or <16 x i8> %0, %src3
  %or7 = xor <16 x i8> %or7.demorgan, splat(i8 -1)
  ret <16 x i8> %or7
}

define <16 x i8> @eval131(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval131:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vn %v0, %v26, %v24
; CHECK-NEXT:    vx %v1, %v26, %v24
; CHECK-NEXT:    veval %v24, %v0, %v28, %v1, 139
; CHECK-NEXT:    br %r14
entry:
  %and4 = and <16 x i8> %src2, %src1
  %0 = xor <16 x i8> %src2, %src1
  %or7.demorgan = or <16 x i8> %0, %src3
  %or7 = xor <16 x i8> %or7.demorgan, splat(i8 -1)
  %and9 = and <16 x i8> %and4, %src3
  %or10 = or <16 x i8> %and9, %or7
  ret <16 x i8> %or10
}

define <16 x i8> @eval132(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval132:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v24, %v26, 130
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src1
  %1 = or <16 x i8> %0, %src2
  %or7 = xor <16 x i8> %1, splat(i8 -1)
  ret <16 x i8> %or7
}

define <16 x i8> @eval133(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval133:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v24
; CHECK-NEXT:    veval %v1, %v26, %v24, %v28, 1
; CHECK-NEXT:    veval %v24, %v1, %v0, %v26, 143
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src1
  %1 = or <16 x i8> %0, %src2
  %or7 = xor <16 x i8> %1, splat(i8 -1)
  %and8 = and <16 x i8> %src2, %src1
  %and9 = and <16 x i8> %and8, %src3
  %or10 = or <16 x i8> %and9, %or7
  ret <16 x i8> %or10
}

define <16 x i8> @eval134(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval134:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v24
; CHECK-NEXT:    vnc %v1, %v24, %v28
; CHECK-NEXT:    veval %v24, %v1, %v26, %v0, 139
; CHECK-NEXT:    br %r14
entry:
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = xor <16 x i8> %src3, %src1
  %1 = or <16 x i8> %0, %src2
  %or7 = xor <16 x i8> %1, splat(i8 -1)
  %2 = and <16 x i8> %not2, %src1
  %and10 = and <16 x i8> %2, %src2
  %or11 = or <16 x i8> %and10, %or7
  ret <16 x i8> %or11
}

define <16 x i8> @eval135(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval135:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v24
; CHECK-NEXT:    veval %v24, %v24, %v26, %v0, 139
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src1
  %1 = or <16 x i8> %0, %src2
  %or7 = xor <16 x i8> %1, splat(i8 -1)
  %and8 = and <16 x i8> %src2, %src1
  %or14 = or <16 x i8> %and8, %or7
  ret <16 x i8> %or14
}

define <16 x i8> @eval136(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval136:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v24, %v28, %v26
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  ret <16 x i8> %1
}

define <16 x i8> @eval137(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval137:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v24, %v26, %v28, 137
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and9 = and <16 x i8> %src2, %src1
  %and10 = and <16 x i8> %and9, %src3
  %or11 = or <16 x i8> %and10, %1
  ret <16 x i8> %or11
}

define <16 x i8> @eval138(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval138:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v26, %v24, %v28, 127
; CHECK-NEXT:    veval %v24, %v24, %v28, %v0, 174
; CHECK-NEXT:    br %r14
entry:
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = or <16 x i8> %src2, %src1
  %and3.demorgan = or <16 x i8> %0, %src3
  %and3 = xor <16 x i8> %and3.demorgan, splat(i8 -1)
  %1 = and <16 x i8> %not2, %src1
  %or12 = or <16 x i8> %1, %and3
  ret <16 x i8> %or12
}

define <16 x i8> @eval139(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval139:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v26, %v24
; CHECK-NEXT:    veval %v1, %v24, %v26, %v28, 11
; CHECK-NEXT:    veval %v24, %v1, %v0, %v28, 143
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src2, %src1
  %and3.demorgan = or <16 x i8> %0, %src3
  %and3 = xor <16 x i8> %and3.demorgan, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and729 = or <16 x i8> %src3.not, %src2
  %1 = and <16 x i8> %and729, %src1
  %or15 = or <16 x i8> %1, %and3
  ret <16 x i8> %or15
}

define <16 x i8> @eval140(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval140:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v24, %v28, %v26, 127
; CHECK-NEXT:    veval %v24, %v24, %v26, %v0, 174
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = or <16 x i8> %src1, %src3
  %and3.demorgan = or <16 x i8> %0, %src2
  %and3 = xor <16 x i8> %and3.demorgan, splat(i8 -1)
  %and5 = and <16 x i8> %not1, %src1
  %or12 = or <16 x i8> %and5, %and3
  ret <16 x i8> %or12
}

define <16 x i8> @eval141(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval141:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v1, %v26, %v24, %v28, 1
; CHECK-NEXT:    vo %v0, %v26, %v24
; CHECK-NEXT:    veval %v1, %v1, %v24, %v26, 47
; CHECK-NEXT:    veval %v24, %v1, %v0, %v28, 143
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = or <16 x i8> %src2, %src1
  %and3.demorgan = or <16 x i8> %0, %src3
  %and3 = xor <16 x i8> %and3.demorgan, splat(i8 -1)
  %and5 = and <16 x i8> %not1, %src1
  %and13 = and <16 x i8> %src2, %src1
  %and14 = and <16 x i8> %and13, %src3
  %or12 = or <16 x i8> %and14, %and5
  %or15 = or <16 x i8> %or12, %and3
  ret <16 x i8> %or15
}

define <16 x i8> @eval142(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval142:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v26, %v24, %v28, 127
; CHECK-NEXT:    vn %v1, %v28, %v26
; CHECK-NEXT:    veval %v24, %v24, %v1, %v0, 174
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src2, %src1
  %and3.demorgan = or <16 x i8> %0, %src3
  %and3 = xor <16 x i8> %and3.demorgan, splat(i8 -1)
  %and530.demorgan = and <16 x i8> %src3, %src2
  %and530 = xor <16 x i8> %and530.demorgan, splat(i8 -1)
  %1 = and <16 x i8> %and530, %src1
  %or16 = or <16 x i8> %1, %and3
  ret <16 x i8> %or16
}

define <16 x i8> @eval143(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval143:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v24, %v28, %v26, 143
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src2
  %.not = xor <16 x i8> %0, splat(i8 -1)
  %or19 = or <16 x i8> %.not, %src1
  ret <16 x i8> %or19
}

define <16 x i8> @eval144(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval144:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 130
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %or7 = xor <16 x i8> %or7.demorgan, splat(i8 -1)
  ret <16 x i8> %or7
}

define <16 x i8> @eval145(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval145:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v26
; CHECK-NEXT:    veval %v1, %v26, %v24, %v28, 1
; CHECK-NEXT:    veval %v24, %v1, %v0, %v24, 143
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %or7 = xor <16 x i8> %or7.demorgan, splat(i8 -1)
  %and8 = and <16 x i8> %src2, %src1
  %and9 = and <16 x i8> %and8, %src3
  %or10 = or <16 x i8> %and9, %or7
  ret <16 x i8> %or10
}

define <16 x i8> @eval146(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval146:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v26
; CHECK-NEXT:    veval %v1, %v24, %v26, %v28, 2
; CHECK-NEXT:    veval %v24, %v1, %v0, %v24, 143
; CHECK-NEXT:    br %r14
entry:
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %or7 = xor <16 x i8> %or7.demorgan, splat(i8 -1)
  %1 = and <16 x i8> %not2, %src1
  %and10 = and <16 x i8> %1, %src2
  %or11 = or <16 x i8> %and10, %or7
  ret <16 x i8> %or11
}

define <16 x i8> @eval147(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval147:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v26
; CHECK-NEXT:    veval %v24, %v26, %v24, %v0, 139
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %or7 = xor <16 x i8> %or7.demorgan, splat(i8 -1)
  %and8 = and <16 x i8> %src2, %src1
  %or14 = or <16 x i8> %and8, %or7
  ret <16 x i8> %or14
}

define <16 x i8> @eval148(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval148:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v26
; CHECK-NEXT:    veval %v1, %v24, %v28, %v26, 2
; CHECK-NEXT:    veval %v24, %v1, %v0, %v24, 143
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %or7 = xor <16 x i8> %or7.demorgan, splat(i8 -1)
  %and9 = and <16 x i8> %not1, %src1
  %and10 = and <16 x i8> %and9, %src3
  %or11 = or <16 x i8> %and10, %or7
  ret <16 x i8> %or11
}

define <16 x i8> @eval149(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval149:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vx %v0, %v28, %v26
; CHECK-NEXT:    veval %v24, %v28, %v24, %v0, 139
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %or7 = xor <16 x i8> %or7.demorgan, splat(i8 -1)
  %1 = and <16 x i8> %src3, %src1
  %or14 = or <16 x i8> %1, %or7
  ret <16 x i8> %or14
}

define <16 x i8> @eval150(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval150:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v24, %v28, %v26, 111
; CHECK-NEXT:    veval %v1, %v24, %v28, %v26, 2
; CHECK-NEXT:    veval %v2, %v24, %v26, %v28, 2
; CHECK-NEXT:    veval %v24, %v1, %v2, %v0, 191
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %or7 = xor <16 x i8> %or7.demorgan, splat(i8 -1)
  %and9 = and <16 x i8> %not1, %src1
  %and10 = and <16 x i8> %and9, %src3
  %or11 = or <16 x i8> %and10, %or7
  %1 = and <16 x i8> %not2, %src1
  %and14 = and <16 x i8> %1, %src2
  %or15 = or <16 x i8> %or11, %and14
  ret <16 x i8> %or15
}

define <16 x i8> @eval151(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval151:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v1, %v24, %v28, %v26, 2
; CHECK-NEXT:    vx %v0, %v28, %v26
; CHECK-NEXT:    veval %v1, %v1, %v26, %v24, 31
; CHECK-NEXT:    veval %v24, %v1, %v0, %v24, 143
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %or7 = xor <16 x i8> %or7.demorgan, splat(i8 -1)
  %and9 = and <16 x i8> %not1, %src1
  %and10 = and <16 x i8> %and9, %src3
  %and12 = and <16 x i8> %src2, %src1
  %or11 = or <16 x i8> %and10, %and12
  %or18 = or <16 x i8> %or11, %or7
  ret <16 x i8> %or18
}

define <16 x i8> @eval152(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval152:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v24, %v28, %v26, 111
; CHECK-NEXT:    veval %v24, %v28, %v26, %v0, 234
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %1 = or <16 x i8> %src3, %src2
  %2 = and <16 x i8> %or7.demorgan, %1
  %or12 = xor <16 x i8> %2, splat(i8 -1)
  ret <16 x i8> %or12
}

define <16 x i8> @eval153(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval153:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v24, %v28, %v26, 111
; CHECK-NEXT:    vo %v1, %v28, %v26
; CHECK-NEXT:    veval %v2, %v26, %v24, %v28, 1
; CHECK-NEXT:    veval %v24, %v2, %v0, %v1, 239
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %1 = or <16 x i8> %src3, %src2
  %2 = and <16 x i8> %or7.demorgan, %1
  %or12 = xor <16 x i8> %2, splat(i8 -1)
  %and13 = and <16 x i8> %src2, %src1
  %and14 = and <16 x i8> %and13, %src3
  %or15 = or <16 x i8> %and14, %or12
  ret <16 x i8> %or15
}

define <16 x i8> @eval154(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval154:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v24, %v28, %v26, 111
; CHECK-NEXT:    vo %v1, %v28, %v26
; CHECK-NEXT:    veval %v2, %v24, %v26, %v28, 2
; CHECK-NEXT:    veval %v24, %v2, %v0, %v1, 239
; CHECK-NEXT:    br %r14
entry:
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %1 = or <16 x i8> %src3, %src2
  %2 = and <16 x i8> %or7.demorgan, %1
  %or12 = xor <16 x i8> %2, splat(i8 -1)
  %3 = and <16 x i8> %not2, %src1
  %and15 = and <16 x i8> %3, %src2
  %or16 = or <16 x i8> %and15, %or12
  ret <16 x i8> %or16
}

define <16 x i8> @eval155(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval155:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v24, %v28, %v26, 111
; CHECK-NEXT:    vo %v1, %v28, %v26
; CHECK-NEXT:    vn %v2, %v26, %v24
; CHECK-NEXT:    veval %v24, %v2, %v0, %v1, 239
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %1 = or <16 x i8> %src3, %src2
  %2 = and <16 x i8> %or7.demorgan, %1
  %or12 = xor <16 x i8> %2, splat(i8 -1)
  %and13 = and <16 x i8> %src2, %src1
  %or19 = or <16 x i8> %and13, %or12
  ret <16 x i8> %or19
}

define <16 x i8> @eval156(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval156:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v24, %v28, %v26, 111
; CHECK-NEXT:    veval %v24, %v24, %v26, %v0, 174
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %or7 = xor <16 x i8> %or7.demorgan, splat(i8 -1)
  %and9 = and <16 x i8> %not1, %src1
  %or16 = or <16 x i8> %and9, %or7
  ret <16 x i8> %or16
}

define <16 x i8> @eval157(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval157:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v1, %v26, %v24, %v28, 1
; CHECK-NEXT:    vx %v0, %v28, %v26
; CHECK-NEXT:    veval %v1, %v1, %v24, %v26, 47
; CHECK-NEXT:    veval %v24, %v1, %v0, %v24, 143
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %or7 = xor <16 x i8> %or7.demorgan, splat(i8 -1)
  %and9 = and <16 x i8> %not1, %src1
  %and17 = and <16 x i8> %src2, %src1
  %and18 = and <16 x i8> %and17, %src3
  %or16 = or <16 x i8> %and18, %and9
  %or19 = or <16 x i8> %or16, %or7
  ret <16 x i8> %or19
}

define <16 x i8> @eval158(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval158:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v24, %v28, %v26, 111
; CHECK-NEXT:    vn %v1, %v28, %v26
; CHECK-NEXT:    veval %v24, %v24, %v1, %v0, 174
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src2
  %or7.demorgan = or <16 x i8> %0, %src1
  %or7 = xor <16 x i8> %or7.demorgan, splat(i8 -1)
  %and938.demorgan = and <16 x i8> %src3, %src2
  %and938 = xor <16 x i8> %and938.demorgan, splat(i8 -1)
  %1 = and <16 x i8> %and938, %src1
  %or20 = or <16 x i8> %1, %or7
  ret <16 x i8> %or20
}

define <16 x i8> @eval159(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval159:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v24, %v26, %v28, 159
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src2, %src3
  %.not = xor <16 x i8> %0, splat(i8 -1)
  %or23 = or <16 x i8> %.not, %src1
  ret <16 x i8> %or23
}

define <16 x i8> @eval160(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval160:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v24, %v28, %v24
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  ret <16 x i8> %1
}

define <16 x i8> @eval161(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval161:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v24, %v28, 137
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and9 = and <16 x i8> %src2, %src1
  %and10 = and <16 x i8> %and9, %src3
  %or11 = or <16 x i8> %and10, %1
  ret <16 x i8> %or11
}

define <16 x i8> @eval162(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval162:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v28, %v24, %v26, 127
; CHECK-NEXT:    veval %v24, %v26, %v28, %v0, 174
; CHECK-NEXT:    br %r14
entry:
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = or <16 x i8> %src3, %src1
  %and3.demorgan = or <16 x i8> %0, %src2
  %and3 = xor <16 x i8> %and3.demorgan, splat(i8 -1)
  %1 = and <16 x i8> %not2, %src2
  %or12 = or <16 x i8> %1, %and3
  ret <16 x i8> %or12
}

define <16 x i8> @eval163(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval163:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v26, %v24
; CHECK-NEXT:    veval %v1, %v26, %v24, %v28, 11
; CHECK-NEXT:    veval %v24, %v1, %v0, %v28, 143
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src2, %src1
  %and3.demorgan = or <16 x i8> %0, %src3
  %and3 = xor <16 x i8> %and3.demorgan, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and729 = or <16 x i8> %src3.not, %src1
  %1 = and <16 x i8> %and729, %src2
  %or15 = or <16 x i8> %1, %and3
  ret <16 x i8> %or15
}

define <16 x i8> @eval164(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval164:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v28, %v24
; CHECK-NEXT:    vx %v1, %v28, %v24
; CHECK-NEXT:    veval %v24, %v1, %v26, %v0, 234
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %src3, %src1
  %2 = or <16 x i8> %1, %src2
  %3 = and <16 x i8> %0, %2
  %or12 = xor <16 x i8> %3, splat(i8 -1)
  ret <16 x i8> %or12
}

define <16 x i8> @eval165(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval165:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnx %v24, %v28, %v24
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src3, %src1
  %or15 = xor <16 x i8> %0, splat(i8 -1)
  ret <16 x i8> %or15
}

define <16 x i8> @eval166(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval166:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v28, %v24
; CHECK-NEXT:    veval %v1, %v24, %v26, %v28, 2
; CHECK-NEXT:    veval %v2, %v26, %v28, %v24, 111
; CHECK-NEXT:    veval %v24, %v1, %v0, %v2, 239
; CHECK-NEXT:    br %r14
entry:
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = or <16 x i8> %src3, %src1
  %1 = and <16 x i8> %not2, %src1
  %and15 = and <16 x i8> %1, %src2
  %2 = xor <16 x i8> %src3, %src1
  %3 = or <16 x i8> %2, %src2
  %4 = and <16 x i8> %0, %3
  %or12 = xor <16 x i8> %4, splat(i8 -1)
  %or16 = or <16 x i8> %and15, %or12
  ret <16 x i8> %or16
}

define <16 x i8> @eval167(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval167:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v24, %v28, %v26, 2
; CHECK-NEXT:    veval %v0, %v0, %v26, %v24, 31
; CHECK-NEXT:    veval %v24, %v0, %v28, %v24, 143
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and10 = and <16 x i8> %not1, %src1
  %and11 = and <16 x i8> %and10, %src3
  %and13 = and <16 x i8> %src2, %src1
  %or8 = or <16 x i8> %and11, %and13
  %or19 = or <16 x i8> %or8, %1
  ret <16 x i8> %or19
}

define <16 x i8> @eval168(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval168:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v24, %v28, 168
; CHECK-NEXT:    br %r14
entry:
  %0 = and <16 x i8> %src2, %src1
  %1 = or <16 x i8> %0, %src3
  %or13 = xor <16 x i8> %1, splat(i8 -1)
  ret <16 x i8> %or13
}

define <16 x i8> @eval169(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval169:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v24, %v28, 169
; CHECK-NEXT:    br %r14
entry:
  %0 = and <16 x i8> %src2, %src1
  %1 = xor <16 x i8> %0, %src3
  %or16 = xor <16 x i8> %1, splat(i8 -1)
  ret <16 x i8> %or16
}

define <16 x i8> @eval170(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval170:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v24, %v28, %v28
; CHECK-NEXT:    br %r14
entry:
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  ret <16 x i8> %not2
}

define <16 x i8> @eval171(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval171:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v26, %v28
; CHECK-NEXT:    veval %v24, %v0, %v24, %v28, 139
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and1238 = or <16 x i8> %src3.not, %src2
  %2 = and <16 x i8> %and1238, %src1
  %or20 = or <16 x i8> %2, %1
  ret <16 x i8> %or20
}

define <16 x i8> @eval172(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval172:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v28, %v24
; CHECK-NEXT:    veval %v24, %v24, %v26, %v0, 174
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and10 = and <16 x i8> %not1, %src1
  %or17 = or <16 x i8> %and10, %1
  ret <16 x i8> %or17
}

define <16 x i8> @eval173(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval173:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v26, %v24, %v28, 1
; CHECK-NEXT:    veval %v0, %v0, %v24, %v26, 47
; CHECK-NEXT:    veval %v24, %v0, %v28, %v24, 143
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and10 = and <16 x i8> %not1, %src1
  %and18 = and <16 x i8> %src2, %src1
  %and19 = and <16 x i8> %and18, %src3
  %or8 = or <16 x i8> %and19, %and10
  %or20 = or <16 x i8> %or8, %1
  ret <16 x i8> %or20
}

define <16 x i8> @eval174(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval174:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v28, %v24
; CHECK-NEXT:    vn %v1, %v28, %v26
; CHECK-NEXT:    veval %v24, %v24, %v1, %v0, 174
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and1039.demorgan = and <16 x i8> %src3, %src2
  %and1039 = xor <16 x i8> %and1039.demorgan, splat(i8 -1)
  %2 = and <16 x i8> %and1039, %src1
  %or21 = or <16 x i8> %2, %1
  ret <16 x i8> %or21
}

define <16 x i8> @eval175(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval175:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v24, %v24, %v28
; CHECK-NEXT:    br %r14
entry:
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %or24 = or <16 x i8> %src3.not, %src1
  ret <16 x i8> %or24
}

define <16 x i8> @eval176(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval176:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v28, %v24, 138
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and522 = or <16 x i8> %src3.not, %src2
  %or12 = and <16 x i8> %and522, %not
  ret <16 x i8> %or12
}

define <16 x i8> @eval177(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval177:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v26, %v28
; CHECK-NEXT:    veval %v1, %v26, %v24, %v28, 1
; CHECK-NEXT:    veval %v24, %v1, %v0, %v24, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and529 = or <16 x i8> %src3.not, %src2
  %or12 = and <16 x i8> %and529, %not
  %and13 = and <16 x i8> %src2, %src1
  %and14 = and <16 x i8> %and13, %src3
  %or15 = or <16 x i8> %or12, %and14
  ret <16 x i8> %or15
}

define <16 x i8> @eval178(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval178:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v26, %v28, %v24, 138
; CHECK-NEXT:    vn %v1, %v26, %v24
; CHECK-NEXT:    veval %v24, %v0, %v1, %v28, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %and530 = or <16 x i8> %not2, %src2
  %or12 = and <16 x i8> %and530, %not
  %0 = and <16 x i8> %src2, %src1
  %and15 = and <16 x i8> %0, %not2
  %or16 = or <16 x i8> %or12, %and15
  ret <16 x i8> %or16
}

define <16 x i8> @eval179(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval179:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v26, %v28
; CHECK-NEXT:    vsel %v24, %v26, %v0, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and537 = or <16 x i8> %src3.not, %src2
  %or12 = and <16 x i8> %and537, %not
  %and13 = and <16 x i8> %src2, %src1
  %or19 = or <16 x i8> %or12, %and13
  ret <16 x i8> %or19
}

define <16 x i8> @eval180(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval180:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v26, %v28
; CHECK-NEXT:    veval %v1, %v24, %v28, %v26, 2
; CHECK-NEXT:    veval %v24, %v1, %v0, %v24, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and530 = or <16 x i8> %src3.not, %src2
  %or12 = and <16 x i8> %and530, %not
  %and14 = and <16 x i8> %not1, %src1
  %and15 = and <16 x i8> %and14, %src3
  %or16 = or <16 x i8> %or12, %and15
  ret <16 x i8> %or16
}

define <16 x i8> @eval181(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval181:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v26, %v28
; CHECK-NEXT:    vsel %v24, %v28, %v0, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and537 = or <16 x i8> %src3.not, %src2
  %or12 = and <16 x i8> %and537, %not
  %0 = and <16 x i8> %src3, %src1
  %or19 = or <16 x i8> %or12, %0
  ret <16 x i8> %or19
}

define <16 x i8> @eval182(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval182:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v26, %v28
; CHECK-NEXT:    veval %v1, %v24, %v28, %v26, 2
; CHECK-NEXT:    veval %v0, %v1, %v0, %v24, 47
; CHECK-NEXT:    vn %v1, %v26, %v24
; CHECK-NEXT:    veval %v24, %v0, %v1, %v28, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %and538 = or <16 x i8> %not2, %src2
  %or12 = and <16 x i8> %and538, %not
  %and14 = and <16 x i8> %not1, %src1
  %and15 = and <16 x i8> %and14, %src3
  %or16 = or <16 x i8> %or12, %and15
  %0 = and <16 x i8> %src2, %src1
  %and19 = and <16 x i8> %0, %not2
  %or20 = or <16 x i8> %or16, %and19
  ret <16 x i8> %or20
}

define <16 x i8> @eval183(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval183:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v1, %v24, %v28, %v26, 2
; CHECK-NEXT:    voc %v0, %v26, %v28
; CHECK-NEXT:    veval %v1, %v1, %v26, %v24, 31
; CHECK-NEXT:    veval %v24, %v1, %v0, %v24, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and545 = or <16 x i8> %src3.not, %src2
  %or12 = and <16 x i8> %and545, %not
  %and14 = and <16 x i8> %not1, %src1
  %and15 = and <16 x i8> %and14, %src3
  %and17 = and <16 x i8> %src2, %src1
  %or16 = or <16 x i8> %and15, %and17
  %or23 = or <16 x i8> %or16, %or12
  ret <16 x i8> %or23
}

define <16 x i8> @eval184(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval184:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v26, %v28
; CHECK-NEXT:    vno %v1, %v28, %v26
; CHECK-NEXT:    vsel %v24, %v1, %v0, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and531 = or <16 x i8> %src3.not, %src2
  %or12 = and <16 x i8> %and531, %not
  %0 = or <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and16 = and <16 x i8> %1, %src1
  %or17 = or <16 x i8> %or12, %and16
  ret <16 x i8> %or17
}

define <16 x i8> @eval185(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval185:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v26, %v28
; CHECK-NEXT:    vnx %v1, %v28, %v26
; CHECK-NEXT:    vsel %v24, %v1, %v0, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and538 = or <16 x i8> %src3.not, %src2
  %or12 = and <16 x i8> %and538, %not
  %0 = xor <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %or17 = and <16 x i8> %1, %src1
  %or20 = or <16 x i8> %or17, %or12
  ret <16 x i8> %or20
}

define <16 x i8> @eval186(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval186:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v28, %v28
; CHECK-NEXT:    voc %v1, %v26, %v28
; CHECK-NEXT:    vsel %v24, %v0, %v1, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %and539 = or <16 x i8> %not2, %src2
  %or12 = and <16 x i8> %and539, %not
  %0 = and <16 x i8> %not2, %src1
  %or21 = or <16 x i8> %or12, %0
  ret <16 x i8> %or21
}

define <16 x i8> @eval187(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval187:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v24, %v26, %v28
; CHECK-NEXT:    br %r14
entry:
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and546 = or <16 x i8> %src3.not, %src2
  ret <16 x i8> %and546
}

define <16 x i8> @eval188(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval188:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v26, %v26
; CHECK-NEXT:    voc %v1, %v26, %v28
; CHECK-NEXT:    vsel %v24, %v0, %v1, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and539 = or <16 x i8> %src3.not, %src2
  %or12 = and <16 x i8> %and539, %not
  %and14 = and <16 x i8> %not1, %src1
  %or21 = or <16 x i8> %or12, %and14
  ret <16 x i8> %or21
}

define <16 x i8> @eval189(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval189:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v1, %v26, %v24, %v28, 1
; CHECK-NEXT:    voc %v0, %v26, %v28
; CHECK-NEXT:    veval %v1, %v1, %v24, %v26, 47
; CHECK-NEXT:    veval %v24, %v1, %v0, %v24, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and546 = or <16 x i8> %src3.not, %src2
  %or12 = and <16 x i8> %and546, %not
  %and14 = and <16 x i8> %not1, %src1
  %and22 = and <16 x i8> %src2, %src1
  %and23 = and <16 x i8> %and22, %src3
  %or21 = or <16 x i8> %and23, %and14
  %or24 = or <16 x i8> %or21, %or12
  ret <16 x i8> %or24
}

define <16 x i8> @eval190(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval190:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v26, %v28
; CHECK-NEXT:    vnn %v1, %v28, %v26
; CHECK-NEXT:    vsel %v24, %v1, %v0, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and547 = or <16 x i8> %src3.not, %src2
  %or12 = and <16 x i8> %and547, %not
  %and1448.demorgan = and <16 x i8> %src3, %src2
  %and1448 = xor <16 x i8> %and1448.demorgan, splat(i8 -1)
  %0 = and <16 x i8> %and1448, %src1
  %or25 = or <16 x i8> %or12, %0
  ret <16 x i8> %or25
}

define <16 x i8> @eval191(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval191:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v24, %v28, 191
; CHECK-NEXT:    br %r14
entry:
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and554 = or <16 x i8> %src2, %src1
  %or28 = or <16 x i8> %and554, %src3.not
  ret <16 x i8> %or28
}

define <16 x i8> @eval192(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval192:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v24, %v26, %v24
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and = xor <16 x i8> %and.demorgan, splat(i8 -1)
  ret <16 x i8> %and
}

define <16 x i8> @eval193(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval193:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v24, %v26, 137
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and = xor <16 x i8> %and.demorgan, splat(i8 -1)
  %0 = and <16 x i8> %src1, %src3
  %and10 = and <16 x i8> %0, %src2
  %or11 = or <16 x i8> %and10, %and
  ret <16 x i8> %or11
}

define <16 x i8> @eval194(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval194:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v28, %v28
; CHECK-NEXT:    veval %v24, %v0, %v24, %v26, 137
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and = xor <16 x i8> %and.demorgan, splat(i8 -1)
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = and <16 x i8> %not2, %src1
  %and11 = and <16 x i8> %0, %src2
  %or12 = or <16 x i8> %and11, %and
  ret <16 x i8> %or12
}

define <16 x i8> @eval195(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval195:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnx %v24, %v24, %v26
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src1, %src2
  %or15 = xor <16 x i8> %0, splat(i8 -1)
  ret <16 x i8> %or15
}

define <16 x i8> @eval196(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval196:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v24, %v26, 138
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and22 = or <16 x i8> %not, %src3
  %or12 = and <16 x i8> %and22, %not1
  ret <16 x i8> %or12
}

define <16 x i8> @eval197(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval197:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v24, %v26, 139
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and = xor <16 x i8> %and.demorgan, splat(i8 -1)
  %0 = and <16 x i8> %src3, %src1
  %or15 = or <16 x i8> %0, %and
  ret <16 x i8> %or15
}

define <16 x i8> @eval198(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval198:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v26, %v26
; CHECK-NEXT:    veval %v1, %v24, %v28, %v26, 2
; CHECK-NEXT:    veval %v0, %v1, %v0, %v24, 47
; CHECK-NEXT:    vnc %v1, %v24, %v28
; CHECK-NEXT:    veval %v24, %v0, %v1, %v26, 31
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %and10 = and <16 x i8> %not1, %src1
  %and11 = and <16 x i8> %and10, %src3
  %or12 = or <16 x i8> %and11, %and
  %0 = and <16 x i8> %not2, %src1
  %and15 = and <16 x i8> %0, %src2
  %or16 = or <16 x i8> %or12, %and15
  ret <16 x i8> %or16
}

define <16 x i8> @eval199(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval199:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v28, %v24
; CHECK-NEXT:    vsel %v24, %v24, %v0, %v26
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and37 = or <16 x i8> %not, %src3
  %or12 = and <16 x i8> %and37, %not1
  %and13 = and <16 x i8> %src2, %src1
  %or19 = or <16 x i8> %or12, %and13
  ret <16 x i8> %or19
}

define <16 x i8> @eval200(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval200:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v24, %v26, 168
; CHECK-NEXT:    br %r14
entry:
  %0 = and <16 x i8> %src3, %src1
  %1 = or <16 x i8> %0, %src2
  %or13 = xor <16 x i8> %1, splat(i8 -1)
  ret <16 x i8> %or13
}

define <16 x i8> @eval201(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval201:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v24, %v26, 169
; CHECK-NEXT:    br %r14
entry:
  %0 = and <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, %src2
  %or16 = xor <16 x i8> %1, splat(i8 -1)
  ret <16 x i8> %or16
}

define <16 x i8> @eval202(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval202:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vn %v0, %v28, %v24
; CHECK-NEXT:    vnc %v1, %v24, %v28
; CHECK-NEXT:    veval %v24, %v1, %v26, %v0, 139
; CHECK-NEXT:    br %r14
entry:
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = and <16 x i8> %src3, %src1
  %1 = or <16 x i8> %0, %src2
  %or13 = xor <16 x i8> %1, splat(i8 -1)
  %2 = and <16 x i8> %not2, %src1
  %and16 = and <16 x i8> %2, %src2
  %or17 = or <16 x i8> %and16, %or13
  ret <16 x i8> %or17
}

define <16 x i8> @eval203(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval203:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vn %v0, %v28, %v24
; CHECK-NEXT:    veval %v24, %v24, %v26, %v0, 139
; CHECK-NEXT:    br %r14
entry:
  %0 = and <16 x i8> %src3, %src1
  %1 = or <16 x i8> %0, %src2
  %or13 = xor <16 x i8> %1, splat(i8 -1)
  %and14 = and <16 x i8> %src2, %src1
  %or20 = or <16 x i8> %and14, %or13
  ret <16 x i8> %or20
}

define <16 x i8> @eval204(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval204:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v24, %v26, %v26
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  ret <16 x i8> %not1
}

define <16 x i8> @eval205(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval205:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v24, %v26, 171
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = and <16 x i8> %src3, %src1
  %or20 = or <16 x i8> %0, %not1
  ret <16 x i8> %or20
}

define <16 x i8> @eval206(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval206:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v24, %v28, %v26, 174
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = and <16 x i8> %not2, %src1
  %or21 = or <16 x i8> %0, %not1
  ret <16 x i8> %or21
}

define <16 x i8> @eval207(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval207:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v24, %v24, %v26
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %or24 = or <16 x i8> %not1, %src1
  ret <16 x i8> %or24
}

define <16 x i8> @eval208(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval208:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 138
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and1122 = or <16 x i8> %not1, %src3
  %or12 = and <16 x i8> %and1122, %not
  ret <16 x i8> %or12
}

define <16 x i8> @eval209(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval209:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 139
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and = xor <16 x i8> %and.demorgan, splat(i8 -1)
  %0 = and <16 x i8> %src3, %src2
  %or15 = or <16 x i8> %0, %and
  ret <16 x i8> %or15
}

define <16 x i8> @eval210(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval210:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v26, %v26
; CHECK-NEXT:    veval %v1, %v26, %v28, %v24, 2
; CHECK-NEXT:    veval %v0, %v1, %v0, %v24, 47
; CHECK-NEXT:    vnc %v1, %v24, %v28
; CHECK-NEXT:    veval %v24, %v0, %v1, %v26, 31
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %and10 = and <16 x i8> %not, %src2
  %and11 = and <16 x i8> %and10, %src3
  %or12 = or <16 x i8> %and11, %and
  %0 = and <16 x i8> %not2, %src1
  %and15 = and <16 x i8> %0, %src2
  %or16 = or <16 x i8> %or12, %and15
  ret <16 x i8> %or16
}

define <16 x i8> @eval211(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval211:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v28, %v26
; CHECK-NEXT:    vsel %v24, %v26, %v0, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and1137 = or <16 x i8> %not1, %src3
  %or12 = and <16 x i8> %and1137, %not
  %and13 = and <16 x i8> %src2, %src1
  %or19 = or <16 x i8> %or12, %and13
  ret <16 x i8> %or19
}

define <16 x i8> @eval212(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval212:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 142
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and = xor <16 x i8> %and.demorgan, splat(i8 -1)
  %0 = xor <16 x i8> %src2, %src1
  %1 = and <16 x i8> %0, %src3
  %or16 = or <16 x i8> %1, %and
  ret <16 x i8> %or16
}

define <16 x i8> @eval213(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval213:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 143
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and = xor <16 x i8> %and.demorgan, splat(i8 -1)
  %or19 = or <16 x i8> %and, %src3
  ret <16 x i8> %or19
}

define <16 x i8> @eval214(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval214:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v26, %v24
; CHECK-NEXT:    veval %v1, %v28, %v26, %v24, 6
; CHECK-NEXT:    veval %v2, %v24, %v26, %v28, 2
; CHECK-NEXT:    veval %v24, %v1, %v2, %v0, 191
; CHECK-NEXT:    br %r14
entry:
  %and.demorgan = or <16 x i8> %src2, %src1
  %and = xor <16 x i8> %and.demorgan, splat(i8 -1)
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = xor <16 x i8> %src2, %src1
  %1 = and <16 x i8> %0, %src3
  %or16 = or <16 x i8> %1, %and
  %2 = and <16 x i8> %not2, %src1
  %and19 = and <16 x i8> %2, %src2
  %or20 = or <16 x i8> %or16, %and19
  ret <16 x i8> %or20
}

define <16 x i8> @eval215(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval215:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 159
; CHECK-NEXT:    br %r14
entry:
  %0 = xor <16 x i8> %src2, %src1
  %or16 = xor <16 x i8> %0, splat(i8 -1)
  %or23 = or <16 x i8> %or16, %src3
  ret <16 x i8> %or23
}

define <16 x i8> @eval216(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval216:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v26, %v26
; CHECK-NEXT:    veval %v1, %v26, %v28, %v24, 2
; CHECK-NEXT:    veval %v0, %v1, %v0, %v24, 47
; CHECK-NEXT:    vo %v1, %v28, %v26
; CHECK-NEXT:    veval %v24, %v0, %v24, %v1, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %and10 = and <16 x i8> %not, %src2
  %and11 = and <16 x i8> %and10, %src3
  %or12 = or <16 x i8> %and11, %and
  %0 = or <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and16 = and <16 x i8> %1, %src1
  %or17 = or <16 x i8> %or12, %and16
  ret <16 x i8> %or17
}

define <16 x i8> @eval217(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval217:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v0, %v28, %v26
; CHECK-NEXT:    vnx %v1, %v26, %v28
; CHECK-NEXT:    vsel %v24, %v1, %v0, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and1138 = or <16 x i8> %not1, %src3
  %or12 = and <16 x i8> %and1138, %not
  %0 = xor <16 x i8> %src3, %src2
  %and1939 = xor <16 x i8> %0, splat(i8 -1)
  %1 = and <16 x i8> %and1939, %src1
  %or20 = or <16 x i8> %or12, %1
  ret <16 x i8> %or20
}

define <16 x i8> @eval218(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval218:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v26, %v26
; CHECK-NEXT:    veval %v1, %v26, %v28, %v24, 2
; CHECK-NEXT:    veval %v0, %v1, %v0, %v24, 47
; CHECK-NEXT:    veval %v24, %v0, %v24, %v28, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %and10 = and <16 x i8> %not, %src2
  %and11 = and <16 x i8> %and10, %src3
  %or12 = or <16 x i8> %and11, %and
  %0 = and <16 x i8> %not2, %src1
  %or21 = or <16 x i8> %or12, %0
  ret <16 x i8> %or21
}

define <16 x i8> @eval219(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval219:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v26, %v26
; CHECK-NEXT:    veval %v1, %v26, %v28, %v24, 2
; CHECK-NEXT:    veval %v0, %v1, %v0, %v24, 47
; CHECK-NEXT:    voc %v1, %v26, %v28
; CHECK-NEXT:    veval %v24, %v0, %v1, %v24, 31
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %and10 = and <16 x i8> %not, %src2
  %and11 = and <16 x i8> %and10, %src3
  %or12 = or <16 x i8> %and11, %and
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and1646 = or <16 x i8> %src3.not, %src2
  %0 = and <16 x i8> %and1646, %src1
  %or24 = or <16 x i8> %or12, %0
  ret <16 x i8> %or24
}

define <16 x i8> @eval220(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval220:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v24, %v26, 174
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = and <16 x i8> %not, %src3
  %or21 = or <16 x i8> %0, %not1
  ret <16 x i8> %or21
}

define <16 x i8> @eval221(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval221:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v24, %v28, %v26
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %or24 = or <16 x i8> %not1, %src3
  ret <16 x i8> %or24
}

define <16 x i8> @eval222(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval222:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v0, %v26, %v24
; CHECK-NEXT:    veval %v0, %v0, %v28, %v26, 171
; CHECK-NEXT:    veval %v24, %v0, %v24, %v28, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %and10 = and <16 x i8> %not, %src2
  %and11 = and <16 x i8> %and10, %src3
  %or21 = or <16 x i8> %and11, %not1
  %0 = and <16 x i8> %not2, %src1
  %or25 = or <16 x i8> %or21, %0
  ret <16 x i8> %or25
}

define <16 x i8> @eval223(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval223:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v24, %v28, %v26, 191
; CHECK-NEXT:    br %r14
entry:
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %or21 = or <16 x i8> %not1, %src1
  %or28 = or <16 x i8> %or21, %src3
  ret <16 x i8> %or28
}

define <16 x i8> @eval224(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval224:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 168
; CHECK-NEXT:    br %r14
entry:
  %0 = and <16 x i8> %src3, %src2
  %1 = or <16 x i8> %0, %src1
  %or13 = xor <16 x i8> %1, splat(i8 -1)
  ret <16 x i8> %or13
}

define <16 x i8> @eval225(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval225:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 169
; CHECK-NEXT:    br %r14
entry:
  %0 = and <16 x i8> %src3, %src2
  %1 = xor <16 x i8> %0, %src1
  %or16 = xor <16 x i8> %1, splat(i8 -1)
  ret <16 x i8> %or16
}

define <16 x i8> @eval226(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval226:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vn %v0, %v28, %v26
; CHECK-NEXT:    veval %v1, %v24, %v26, %v28, 2
; CHECK-NEXT:    veval %v24, %v1, %v0, %v24, 143
; CHECK-NEXT:    br %r14
entry:
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = and <16 x i8> %src3, %src2
  %1 = or <16 x i8> %0, %src1
  %or13 = xor <16 x i8> %1, splat(i8 -1)
  %2 = and <16 x i8> %not2, %src1
  %and16 = and <16 x i8> %2, %src2
  %or17 = or <16 x i8> %and16, %or13
  ret <16 x i8> %or17
}

define <16 x i8> @eval227(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval227:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vn %v0, %v28, %v26
; CHECK-NEXT:    veval %v24, %v26, %v24, %v0, 139
; CHECK-NEXT:    br %r14
entry:
  %0 = and <16 x i8> %src3, %src2
  %1 = or <16 x i8> %0, %src1
  %or13 = xor <16 x i8> %1, splat(i8 -1)
  %and14 = and <16 x i8> %src2, %src1
  %or20 = or <16 x i8> %and14, %or13
  ret <16 x i8> %or20
}

define <16 x i8> @eval228(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval228:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v26, %v26
; CHECK-NEXT:    veval %v2, %v24, %v28, %v26, 2
; CHECK-NEXT:    vo %v1, %v28, %v24
; CHECK-NEXT:    veval %v0, %v2, %v0, %v24, 47
; CHECK-NEXT:    veval %v24, %v0, %v26, %v1, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and12 = and <16 x i8> %1, %src2
  %and15 = and <16 x i8> %not1, %src1
  %and16 = and <16 x i8> %and15, %src3
  %or13 = or <16 x i8> %and16, %and
  %or17 = or <16 x i8> %or13, %and12
  ret <16 x i8> %or17
}

define <16 x i8> @eval229(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval229:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vn %v0, %v28, %v26
; CHECK-NEXT:    veval %v24, %v28, %v24, %v0, 139
; CHECK-NEXT:    br %r14
entry:
  %0 = and <16 x i8> %src3, %src2
  %1 = or <16 x i8> %0, %src1
  %or13 = xor <16 x i8> %1, splat(i8 -1)
  %2 = and <16 x i8> %src3, %src1
  %or20 = or <16 x i8> %2, %or13
  ret <16 x i8> %or20
}

define <16 x i8> @eval230(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval230:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v26, %v26
; CHECK-NEXT:    veval %v1, %v24, %v28, %v26, 2
; CHECK-NEXT:    veval %v0, %v1, %v0, %v24, 47
; CHECK-NEXT:    veval %v24, %v0, %v26, %v28, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %and15 = and <16 x i8> %not1, %src1
  %and16 = and <16 x i8> %and15, %src3
  %or13 = or <16 x i8> %and16, %and
  %0 = and <16 x i8> %not2, %src2
  %or21 = or <16 x i8> %or13, %0
  ret <16 x i8> %or21
}

define <16 x i8> @eval231(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval231:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v0, %v26, %v26
; CHECK-NEXT:    vnc %v2, %v24, %v26
; CHECK-NEXT:    vo %v1, %v28, %v24
; CHECK-NEXT:    vsel %v0, %v26, %v0, %v24
; CHECK-NEXT:    veval %v0, %v0, %v2, %v28, 31
; CHECK-NEXT:    veval %v24, %v0, %v26, %v1, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %and = and <16 x i8> %not1, %not
  %0 = or <16 x i8> %src3, %src1
  %1 = xor <16 x i8> %0, splat(i8 -1)
  %and12 = and <16 x i8> %1, %src2
  %and15 = and <16 x i8> %not1, %src1
  %and16 = and <16 x i8> %and15, %src3
  %and18 = and <16 x i8> %src2, %src1
  %or13 = or <16 x i8> %and18, %and
  %or17 = or <16 x i8> %or13, %and16
  %or24 = or <16 x i8> %or17, %and12
  ret <16 x i8> %or24
}

define <16 x i8> @eval232(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval232:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v24, %v28, %v26, 31
; CHECK-NEXT:    vo %v1, %v28, %v26
; CHECK-NEXT:    veval %v24, %v24, %v1, %v0, 174
; CHECK-NEXT:    br %r14
entry:
  %0 = and <16 x i8> %src3, %src2
  %1 = or <16 x i8> %0, %src1
  %or13 = xor <16 x i8> %1, splat(i8 -1)
  %2 = or <16 x i8> %src3, %src2
  %3 = xor <16 x i8> %2, splat(i8 -1)
  %and17 = and <16 x i8> %3, %src1
  %or18 = or <16 x i8> %and17, %or13
  ret <16 x i8> %or18
}

define <16 x i8> @eval233(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval233:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v24, %v28, %v26, 31
; CHECK-NEXT:    vx %v1, %v28, %v26
; CHECK-NEXT:    veval %v24, %v24, %v1, %v0, 174
; CHECK-NEXT:    br %r14
entry:
  %0 = and <16 x i8> %src3, %src2
  %1 = or <16 x i8> %0, %src1
  %or13 = xor <16 x i8> %1, splat(i8 -1)
  %2 = xor <16 x i8> %src3, %src2
  %and2039 = xor <16 x i8> %2, splat(i8 -1)
  %3 = and <16 x i8> %and2039, %src1
  %or21 = or <16 x i8> %3, %or13
  ret <16 x i8> %or21
}

define <16 x i8> @eval234(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval234:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v24, %v28, %v26, 31
; CHECK-NEXT:    veval %v24, %v24, %v28, %v0, 174
; CHECK-NEXT:    br %r14
entry:
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = and <16 x i8> %src3, %src2
  %1 = or <16 x i8> %0, %src1
  %or13 = xor <16 x i8> %1, splat(i8 -1)
  %2 = and <16 x i8> %not2, %src1
  %or22 = or <16 x i8> %2, %or13
  ret <16 x i8> %or22
}

define <16 x i8> @eval235(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval235:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vn %v0, %v28, %v26
; CHECK-NEXT:    voc %v1, %v26, %v28
; CHECK-NEXT:    veval %v24, %v1, %v24, %v0, 139
; CHECK-NEXT:    br %r14
entry:
  %0 = and <16 x i8> %src3, %src2
  %1 = or <16 x i8> %0, %src1
  %or13 = xor <16 x i8> %1, splat(i8 -1)
  %src3.not = xor <16 x i8> %src3, splat(i8 -1)
  %and1747 = or <16 x i8> %src3.not, %src2
  %2 = and <16 x i8> %and1747, %src1
  %or25 = or <16 x i8> %2, %or13
  ret <16 x i8> %or25
}

define <16 x i8> @eval236(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval236:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v24, %v26, 234
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %or22.demorgan = and <16 x i8> %0, %src2
  %or22 = xor <16 x i8> %or22.demorgan, splat(i8 -1)
  ret <16 x i8> %or22
}

define <16 x i8> @eval237(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval237:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v28, %v24
; CHECK-NEXT:    veval %v1, %v26, %v24, %v28, 1
; CHECK-NEXT:    veval %v24, %v1, %v0, %v26, 239
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %or22.demorgan = and <16 x i8> %0, %src2
  %or22 = xor <16 x i8> %or22.demorgan, splat(i8 -1)
  %and23 = and <16 x i8> %src2, %src1
  %and24 = and <16 x i8> %and23, %src3
  %or25 = or <16 x i8> %and24, %or22
  ret <16 x i8> %or25
}

define <16 x i8> @eval238(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval238:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v26, %v28, %v24, 7
; CHECK-NEXT:    veval %v24, %v24, %v28, %v0, 174
; CHECK-NEXT:    br %r14
entry:
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = or <16 x i8> %src3, %src1
  %or22.demorgan = and <16 x i8> %0, %src2
  %or22 = xor <16 x i8> %or22.demorgan, splat(i8 -1)
  %1 = and <16 x i8> %not2, %src1
  %or26 = or <16 x i8> %1, %or22
  ret <16 x i8> %or26
}

define <16 x i8> @eval239(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval239:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v28, %v24
; CHECK-NEXT:    veval %v24, %v24, %v0, %v26, 239
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src1
  %or22.demorgan = and <16 x i8> %0, %src2
  %or22 = xor <16 x i8> %or22.demorgan, splat(i8 -1)
  %or29 = or <16 x i8> %or22, %src1
  ret <16 x i8> %or29
}

define <16 x i8> @eval240(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval240:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vno %v24, %v24, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  ret <16 x i8> %not
}

define <16 x i8> @eval241(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval241:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 171
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %0 = and <16 x i8> %src3, %src2
  %or20 = or <16 x i8> %0, %not
  ret <16 x i8> %or20
}

define <16 x i8> @eval242(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval242:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v28, %v24, 174
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = and <16 x i8> %not2, %src2
  %or21 = or <16 x i8> %0, %not
  ret <16 x i8> %or21
}

define <16 x i8> @eval243(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval243:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v24, %v26, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %or24 = or <16 x i8> %not, %src2
  ret <16 x i8> %or24
}

define <16 x i8> @eval244(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval244:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 174
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %0 = and <16 x i8> %not1, %src3
  %or21 = or <16 x i8> %0, %not
  ret <16 x i8> %or21
}

define <16 x i8> @eval245(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval245:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    voc %v24, %v28, %v24
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %or24 = or <16 x i8> %not, %src3
  ret <16 x i8> %or24
}

define <16 x i8> @eval246(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval246:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnc %v0, %v24, %v26
; CHECK-NEXT:    veval %v0, %v0, %v28, %v24, 171
; CHECK-NEXT:    veval %v24, %v0, %v26, %v28, 47
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %not1 = xor <16 x i8> %src2, splat(i8 -1)
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %and19 = and <16 x i8> %not1, %src1
  %and20 = and <16 x i8> %and19, %src3
  %or21 = or <16 x i8> %and20, %not
  %0 = and <16 x i8> %not2, %src2
  %or25 = or <16 x i8> %or21, %0
  ret <16 x i8> %or25
}

define <16 x i8> @eval247(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval247:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v28, %v24, 191
; CHECK-NEXT:    br %r14
entry:
  %not = xor <16 x i8> %src1, splat(i8 -1)
  %or21 = or <16 x i8> %not, %src2
  %or28 = or <16 x i8> %or21, %src3
  ret <16 x i8> %or28
}

define <16 x i8> @eval248(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval248:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 234
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src2
  %or22.demorgan = and <16 x i8> %0, %src1
  %or22 = xor <16 x i8> %or22.demorgan, splat(i8 -1)
  ret <16 x i8> %or22
}

define <16 x i8> @eval249(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval249:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v28, %v26
; CHECK-NEXT:    veval %v1, %v26, %v24, %v28, 1
; CHECK-NEXT:    veval %v24, %v1, %v0, %v24, 239
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src2
  %or22.demorgan = and <16 x i8> %0, %src1
  %or22 = xor <16 x i8> %or22.demorgan, splat(i8 -1)
  %and23 = and <16 x i8> %src2, %src1
  %and24 = and <16 x i8> %and23, %src3
  %or25 = or <16 x i8> %and24, %or22
  ret <16 x i8> %or25
}

define <16 x i8> @eval250(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval250:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v0, %v24, %v28, %v26, 7
; CHECK-NEXT:    veval %v24, %v26, %v28, %v0, 174
; CHECK-NEXT:    br %r14
entry:
  %not2 = xor <16 x i8> %src3, splat(i8 -1)
  %0 = or <16 x i8> %src3, %src2
  %or22.demorgan = and <16 x i8> %0, %src1
  %or22 = xor <16 x i8> %or22.demorgan, splat(i8 -1)
  %1 = and <16 x i8> %not2, %src2
  %or26 = or <16 x i8> %1, %or22
  ret <16 x i8> %or26
}

define <16 x i8> @eval251(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval251:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vo %v0, %v28, %v26
; CHECK-NEXT:    veval %v24, %v26, %v0, %v24, 239
; CHECK-NEXT:    br %r14
entry:
  %0 = or <16 x i8> %src3, %src2
  %or22.demorgan = and <16 x i8> %0, %src1
  %or22 = xor <16 x i8> %or22.demorgan, splat(i8 -1)
  %or29 = or <16 x i8> %or22, %src2
  ret <16 x i8> %or29
}

define <16 x i8> @eval252(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval252:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vnn %v24, %v26, %v24
; CHECK-NEXT:    br %r14
entry:
  %or26.demorgan = and <16 x i8> %src2, %src1
  %or26 = xor <16 x i8> %or26.demorgan, splat(i8 -1)
  ret <16 x i8> %or26
}

define <16 x i8> @eval253(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval253:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v28, %v26, %v24, 239
; CHECK-NEXT:    br %r14
entry:
  %or26.demorgan = and <16 x i8> %src2, %src1
  %or26 = xor <16 x i8> %or26.demorgan, splat(i8 -1)
  %or29 = or <16 x i8> %or26, %src3
  ret <16 x i8> %or29
}

define <16 x i8> @eval254(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval254:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    veval %v24, %v26, %v24, %v28, 254
; CHECK-NEXT:    br %r14
entry:
  %or26.demorgan = and <16 x i8> %src2, %src1
  %or30.demorgan = and <16 x i8> %or26.demorgan, %src3
  %or30 = xor <16 x i8> %or30.demorgan, splat(i8 -1)
  ret <16 x i8> %or30
}

define <16 x i8> @eval255(<16 x i8> %src1, <16 x i8> %src2, <16 x i8> %src3) {
; CHECK-LABEL: eval255:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vgbm %v24, 65535
; CHECK-NEXT:    br %r14
entry:
  ret <16 x i8> splat(i8 -1)
}

