; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+sse2 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+ssse3 | FileCheck %s --check-prefixes=SSSE3
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE41
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=AVX512

define void @reduce_f64(double %arg) {
; SSE2-LABEL: 'reduce_f64'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V1 = call double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V2 = call double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:6 Lat:22 SizeLat:6 for: %V4 = call double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:12 Lat:44 SizeLat:12 for: %V8 = call double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:24 Lat:88 SizeLat:24 for: %V16 = call double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'reduce_f64'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V1 = call double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V2 = call double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:6 Lat:22 SizeLat:6 for: %V4 = call double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:12 Lat:44 SizeLat:12 for: %V8 = call double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:24 Lat:88 SizeLat:24 for: %V16 = call double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE41-LABEL: 'reduce_f64'
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V1 = call double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V2 = call double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:6 Lat:22 SizeLat:6 for: %V4 = call double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:12 Lat:44 SizeLat:12 for: %V8 = call double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:24 Lat:88 SizeLat:24 for: %V16 = call double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE42-LABEL: 'reduce_f64'
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V1 = call double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:11 SizeLat:3 for: %V2 = call double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:22 SizeLat:6 for: %V4 = call double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:12 Lat:44 SizeLat:12 for: %V8 = call double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:24 Lat:88 SizeLat:24 for: %V16 = call double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'reduce_f64'
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V1 = call double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V2 = call double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:7 Lat:23 SizeLat:7 for: %V4 = call double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:14 Lat:46 SizeLat:14 for: %V8 = call double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:28 Lat:92 SizeLat:28 for: %V16 = call double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'reduce_f64'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V1 = call double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:11 SizeLat:3 for: %V2 = call double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:23 SizeLat:7 for: %V4 = call double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:46 SizeLat:14 for: %V8 = call double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:92 SizeLat:28 for: %V16 = call double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512-LABEL: 'reduce_f64'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V1 = call double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:9 SizeLat:3 for: %V2 = call double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:19 SizeLat:7 for: %V4 = call double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:15 Lat:39 SizeLat:15 for: %V8 = call double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:30 Lat:78 SizeLat:30 for: %V16 = call double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V1  = call double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
  %V2  = call double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
  %V4  = call double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
  %V8  = call double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
  %V16 = call double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
  ret void
}

define void @reduce_f32(float %arg) {
; SSE2-LABEL: 'reduce_f32'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V1 = call float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V2 = call float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:7 Lat:23 SizeLat:7 for: %V4 = call float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:14 Lat:46 SizeLat:14 for: %V8 = call float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:28 Lat:92 SizeLat:28 for: %V16 = call float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:88 CodeSize:56 Lat:184 SizeLat:56 for: %V32 = call float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'reduce_f32'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V1 = call float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V2 = call float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:7 Lat:23 SizeLat:7 for: %V4 = call float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:14 Lat:46 SizeLat:14 for: %V8 = call float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:28 Lat:92 SizeLat:28 for: %V16 = call float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:88 CodeSize:56 Lat:184 SizeLat:56 for: %V32 = call float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE41-LABEL: 'reduce_f32'
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V1 = call float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V2 = call float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:7 Lat:23 SizeLat:7 for: %V4 = call float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:14 Lat:46 SizeLat:14 for: %V8 = call float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:28 Lat:92 SizeLat:28 for: %V16 = call float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:88 CodeSize:56 Lat:184 SizeLat:56 for: %V32 = call float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE42-LABEL: 'reduce_f32'
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V1 = call float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:11 SizeLat:3 for: %V2 = call float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:23 SizeLat:7 for: %V4 = call float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:14 Lat:46 SizeLat:14 for: %V8 = call float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:28 Lat:92 SizeLat:28 for: %V16 = call float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:56 Lat:184 SizeLat:56 for: %V32 = call float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'reduce_f32'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V1 = call float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:11 SizeLat:3 for: %V2 = call float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:23 SizeLat:7 for: %V4 = call float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:15 Lat:47 SizeLat:15 for: %V8 = call float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:30 Lat:94 SizeLat:30 for: %V16 = call float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:60 CodeSize:60 Lat:188 SizeLat:60 for: %V32 = call float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'reduce_f32'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V1 = call float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:11 SizeLat:3 for: %V2 = call float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:23 SizeLat:7 for: %V4 = call float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:15 Lat:47 SizeLat:15 for: %V8 = call float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:30 Lat:94 SizeLat:30 for: %V16 = call float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:60 CodeSize:60 Lat:188 SizeLat:60 for: %V32 = call float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512-LABEL: 'reduce_f32'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V1 = call float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:9 SizeLat:3 for: %V2 = call float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:19 SizeLat:7 for: %V4 = call float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:15 Lat:39 SizeLat:15 for: %V8 = call float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:31 CodeSize:31 Lat:79 SizeLat:31 for: %V16 = call float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:62 CodeSize:62 Lat:158 SizeLat:62 for: %V32 = call float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V1  = call float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
  %V2  = call float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
  %V4  = call float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
  %V8  = call float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
  %V16 = call float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
  %V32 = call float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
  ret void
}

; Fast Reductions

define void @reduce_f64_fast(double %arg) {
; SSE2-LABEL: 'reduce_f64_fast'
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:2 for: %V2 = call fast double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V4 = call fast double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:5 Lat:21 SizeLat:5 for: %V8 = call fast double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:9 Lat:41 SizeLat:9 for: %V16 = call fast double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'reduce_f64_fast'
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:2 for: %V2 = call fast double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V4 = call fast double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:5 Lat:21 SizeLat:5 for: %V8 = call fast double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:9 Lat:41 SizeLat:9 for: %V16 = call fast double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE41-LABEL: 'reduce_f64_fast'
; SSE41-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:2 for: %V2 = call fast double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V4 = call fast double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:5 Lat:21 SizeLat:5 for: %V8 = call fast double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:9 Lat:41 SizeLat:9 for: %V16 = call fast double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE42-LABEL: 'reduce_f64_fast'
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V2 = call fast double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:11 SizeLat:3 for: %V4 = call fast double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:21 SizeLat:5 for: %V8 = call fast double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:41 SizeLat:9 for: %V16 = call fast double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'reduce_f64_fast'
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:2 for: %V2 = call fast double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:12 SizeLat:4 for: %V4 = call fast double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:5 Lat:17 SizeLat:6 for: %V8 = call fast double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:7 Lat:27 SizeLat:10 for: %V16 = call fast double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'reduce_f64_fast'
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V2 = call fast double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V4 = call fast double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:17 SizeLat:6 for: %V8 = call fast double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:27 SizeLat:10 for: %V16 = call fast double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512-LABEL: 'reduce_f64_fast'
; AVX512-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:7 SizeLat:2 for: %V2 = call fast double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V4 = call fast double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:17 SizeLat:6 for: %V8 = call fast double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:21 SizeLat:7 for: %V16 = call fast double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V1  = call fast double @llvm.vector.reduce.fmul.v1f64(double %arg, <1 x double> undef)
  %V2  = call fast double @llvm.vector.reduce.fmul.v2f64(double %arg, <2 x double> undef)
  %V4  = call fast double @llvm.vector.reduce.fmul.v4f64(double %arg, <4 x double> undef)
  %V8  = call fast double @llvm.vector.reduce.fmul.v8f64(double %arg, <8 x double> undef)
  %V16 = call fast double @llvm.vector.reduce.fmul.v16f64(double %arg, <16 x double> undef)
  ret void
}

define void @reduce_f32_fast(float %arg) {
; SSE2-LABEL: 'reduce_f32_fast'
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:2 for: %V2 = call fast float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:12 SizeLat:4 for: %V4 = call fast float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:5 Lat:17 SizeLat:5 for: %V8 = call fast float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:7 Lat:27 SizeLat:7 for: %V16 = call fast float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:11 Lat:47 SizeLat:11 for: %V32 = call fast float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSSE3-LABEL: 'reduce_f32_fast'
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:2 for: %V2 = call fast float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:12 SizeLat:4 for: %V4 = call fast float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:5 Lat:17 SizeLat:5 for: %V8 = call fast float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:7 Lat:27 SizeLat:7 for: %V16 = call fast float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:11 Lat:47 SizeLat:11 for: %V32 = call fast float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE41-LABEL: 'reduce_f32_fast'
; SSE41-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:2 for: %V2 = call fast float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:12 SizeLat:4 for: %V4 = call fast float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:5 Lat:17 SizeLat:5 for: %V8 = call fast float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:7 Lat:27 SizeLat:7 for: %V16 = call fast float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:11 Lat:47 SizeLat:11 for: %V32 = call fast float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SSE42-LABEL: 'reduce_f32_fast'
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V2 = call fast float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V4 = call fast float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:17 SizeLat:5 for: %V8 = call fast float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:27 SizeLat:7 for: %V16 = call fast float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:11 Lat:47 SizeLat:11 for: %V32 = call fast float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX1-LABEL: 'reduce_f32_fast'
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V2 = call fast float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V4 = call fast float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:18 SizeLat:6 for: %V8 = call fast float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:7 Lat:23 SizeLat:8 for: %V16 = call fast float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:9 Lat:33 SizeLat:12 for: %V32 = call fast float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX2-LABEL: 'reduce_f32_fast'
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V2 = call fast float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:12 SizeLat:4 for: %V4 = call fast float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:18 SizeLat:6 for: %V8 = call fast float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:23 SizeLat:8 for: %V16 = call fast float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:33 SizeLat:12 for: %V32 = call fast float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; AVX512-LABEL: 'reduce_f32_fast'
; AVX512-NEXT:  Cost Model: Found costs of 0 for: %V1 = call fast float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:7 SizeLat:2 for: %V2 = call fast float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:14 SizeLat:4 for: %V4 = call fast float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:19 SizeLat:6 for: %V8 = call fast float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:24 SizeLat:8 for: %V16 = call fast float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:28 SizeLat:9 for: %V32 = call fast float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V1  = call fast float @llvm.vector.reduce.fmul.v1f32(float %arg, <1 x float> undef)
  %V2  = call fast float @llvm.vector.reduce.fmul.v2f32(float %arg, <2 x float> undef)
  %V4  = call fast float @llvm.vector.reduce.fmul.v4f32(float %arg, <4 x float> undef)
  %V8  = call fast float @llvm.vector.reduce.fmul.v8f32(float %arg, <8 x float> undef)
  %V16 = call fast float @llvm.vector.reduce.fmul.v16f32(float %arg, <16 x float> undef)
  %V32 = call fast float @llvm.vector.reduce.fmul.v32f32(float %arg, <32 x float> undef)
  ret void
}

declare double @llvm.vector.reduce.fmul.v1f64(double, <1 x double>)
declare double @llvm.vector.reduce.fmul.v2f64(double, <2 x double>)
declare double @llvm.vector.reduce.fmul.v4f64(double, <4 x double>)
declare double @llvm.vector.reduce.fmul.v8f64(double, <8 x double>)
declare double @llvm.vector.reduce.fmul.v16f64(double, <16 x double>)

declare float @llvm.vector.reduce.fmul.v1f32(float, <1 x float>)
declare float @llvm.vector.reduce.fmul.v2f32(float, <2 x float>)
declare float @llvm.vector.reduce.fmul.v4f32(float, <4 x float>)
declare float @llvm.vector.reduce.fmul.v8f32(float, <8 x float>)
declare float @llvm.vector.reduce.fmul.v16f32(float, <16 x float>)
declare float @llvm.vector.reduce.fmul.v32f32(float, <32 x float>)
