; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx10.2-256 --show-mc-encoding | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx10.2-256 --show-mc-encoding | FileCheck %s --check-prefixes=CHECK,X64

; VNNI FP16

define <4 x float> @test_mm_dpph_ps(<4 x float> %__W, <8 x half> %__A, <8 x half> %__B) {
; CHECK-LABEL: test_mm_dpph_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vdpphps %xmm2, %xmm1, %xmm0 # encoding: [0x62,0xf2,0x74,0x08,0x52,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = tail call <4 x float> @llvm.x86.avx10.vdpphps.128(<4 x float> %__W, <8 x half> %__A, <8 x half> %__B)
  ret <4 x float> %res
}

define <4 x float> @test_mm_mask_dpph_ps(<4 x float> %__W, i8 zeroext %__U, <8 x half> %__A, <8 x half> %__B) {
; X86-LABEL: test_mm_mask_dpph_ps:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vdpphps %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x74,0x09,0x52,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm_mask_dpph_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vdpphps %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x74,0x09,0x52,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dph = tail call <4 x float> @llvm.x86.avx10.vdpphps.128(<4 x float> %__W, <8 x half> %__A, <8 x half> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %ext = shufflevector <8 x i1> %bst, <8 x i1> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %ext, <4 x float> %dph, <4 x float> %__W
  ret <4 x float> %res
}

define <4 x float> @test_mm_maskz_dpph_ps(i8 zeroext %__U, <4 x float> %__W, <8 x half> %__A, <8 x half> %__B) {
; X86-LABEL: test_mm_maskz_dpph_ps:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vdpphps %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x74,0x89,0x52,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm_maskz_dpph_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vdpphps %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x74,0x89,0x52,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dph = tail call <4 x float> @llvm.x86.avx10.vdpphps.128(<4 x float> %__W, <8 x half> %__A, <8 x half> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %ext = shufflevector <8 x i1> %bst, <8 x i1> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %ext, <4 x float> %dph, <4 x float> zeroinitializer
  ret <4 x float> %res
}

define <8 x float> @test_mm256_dpph_ps(<8 x float> %__W, <16 x half> %__A, <16 x half> %__B) {
; CHECK-LABEL: test_mm256_dpph_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vdpphps %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf2,0x74,0x28,0x52,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = tail call <8 x float> @llvm.x86.avx10.vdpphps.256(<8 x float> %__W, <16 x half> %__A, <16 x half> %__B)
  ret <8 x float> %res
}

define <8 x float> @test_mm256_mask_dpph_ps(<8 x float> %__W, i8 zeroext %__U, <16 x half> %__A, <16 x half> %__B) {
; X86-LABEL: test_mm256_mask_dpph_ps:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vdpphps %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x74,0x29,0x52,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm256_mask_dpph_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vdpphps %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x74,0x29,0x52,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dph = tail call <8 x float> @llvm.x86.avx10.vdpphps.256(<8 x float> %__W, <16 x half> %__A, <16 x half> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %res = select <8 x i1> %bst, <8 x float> %dph, <8 x float> %__W
  ret <8 x float> %res
}

define <8 x float> @test_mm256_maskz_dpph_ps(i8 zeroext %__U, <8 x float> %__W, <16 x half> %__A, <16 x half> %__B) {
; X86-LABEL: test_mm256_maskz_dpph_ps:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vdpphps %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x74,0xa9,0x52,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm256_maskz_dpph_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vdpphps %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x74,0xa9,0x52,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dph = tail call <8 x float> @llvm.x86.avx10.vdpphps.256(<8 x float> %__W, <16 x half> %__A, <16 x half> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %res = select <8 x i1> %bst, <8 x float> %dph, <8 x float> zeroinitializer
  ret <8 x float> %res
}

declare <4 x float> @llvm.x86.avx10.vdpphps.128(<4 x float>, <8 x half>, <8 x half>)
declare <8 x float> @llvm.x86.avx10.vdpphps.256(<8 x float>, <16 x half>, <16 x half>)

; VNNI INT8

define <4 x i32> @test_mm_mask_dpbssd_epi32(<4 x i32> %__W, i4 zeroext %__U, <4 x i32> %__A, <4 x i32> %__B) {
; X86-LABEL: test_mm_mask_dpbssd_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpbssd %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x77,0x09,0x50,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm_mask_dpbssd_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpbssd %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x77,0x09,0x50,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <4 x i32> @llvm.x86.avx2.vpdpbssd.128(<4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B)
  %bst = bitcast i4 %__U to <4 x i1>
  %res = select <4 x i1> %bst, <4 x i32> %dpi, <4 x i32> %__W
  ret <4 x i32> %res
}

define <4 x i32> @test_mm_maskz_dpbssds_epi32(i4 zeroext %__U, <4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B) {
; X86-LABEL: test_mm_maskz_dpbssds_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpbssds %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x77,0x89,0x51,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm_maskz_dpbssds_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpbssds %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x77,0x89,0x51,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <4 x i32> @llvm.x86.avx2.vpdpbssds.128(<4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B)
  %bst = bitcast i4 %__U to <4 x i1>
  %res = select <4 x i1> %bst, <4 x i32> %dpi, <4 x i32> zeroinitializer
  ret <4 x i32> %res
}

define <8 x i32> @test_mm256_maskz_dpbssds_epi32(<8 x i32> %__W, i8 zeroext %__U, <8 x i32> %__A, <8 x i32> %__B) {
; X86-LABEL: test_mm256_maskz_dpbssds_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpbssds %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x77,0x29,0x51,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm256_maskz_dpbssds_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpbssds %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x77,0x29,0x51,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <8 x i32> @llvm.x86.avx2.vpdpbssds.256(<8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %res = select <8 x i1> %bst, <8 x i32> %dpi, <8 x i32> %__W
  ret <8 x i32> %res
}

define <8 x i32> @test_mm256_mask_dpbssd_epi32(i8 zeroext %__U, <8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B) {
; X86-LABEL: test_mm256_mask_dpbssd_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpbssd %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x77,0xa9,0x50,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm256_mask_dpbssd_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpbssd %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x77,0xa9,0x50,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <8 x i32> @llvm.x86.avx2.vpdpbssd.256(<8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %res = select <8 x i1> %bst, <8 x i32> %dpi, <8 x i32> zeroinitializer
  ret <8 x i32> %res
}

declare <4 x i32> @llvm.x86.avx2.vpdpbssd.128(<4 x i32>, <4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.x86.avx2.vpdpbssds.128(<4 x i32>, <4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.x86.avx2.vpdpbssd.256(<8 x i32>, <8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.x86.avx2.vpdpbssds.256(<8 x i32>, <8 x i32>, <8 x i32>)

define <4 x i32> @test_mm_mask_dpbsud_epi32(<4 x i32> %__W, i4 zeroext %__U, <4 x i32> %__A, <4 x i32> %__B) {
; X86-LABEL: test_mm_mask_dpbsud_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpbsud %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x76,0x09,0x50,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm_mask_dpbsud_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpbsud %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x76,0x09,0x50,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <4 x i32> @llvm.x86.avx2.vpdpbsud.128(<4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B)
  %bst = bitcast i4 %__U to <4 x i1>
  %res = select <4 x i1> %bst, <4 x i32> %dpi, <4 x i32> %__W
  ret <4 x i32> %res
}

define <4 x i32> @test_mm_maskz_dpbsuds_epi32(i4 zeroext %__U, <4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B) {
; X86-LABEL: test_mm_maskz_dpbsuds_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpbsuds %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x76,0x89,0x51,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm_maskz_dpbsuds_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpbsuds %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x76,0x89,0x51,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <4 x i32> @llvm.x86.avx2.vpdpbsuds.128(<4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B)
  %bst = bitcast i4 %__U to <4 x i1>
  %res = select <4 x i1> %bst, <4 x i32> %dpi, <4 x i32> zeroinitializer
  ret <4 x i32> %res
}

define <8 x i32> @test_mm256_maskz_dpbsuds_epi32(<8 x i32> %__W, i8 zeroext %__U, <8 x i32> %__A, <8 x i32> %__B) {
; X86-LABEL: test_mm256_maskz_dpbsuds_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpbsuds %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x76,0x29,0x51,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm256_maskz_dpbsuds_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpbsuds %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x76,0x29,0x51,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <8 x i32> @llvm.x86.avx2.vpdpbsuds.256(<8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %res = select <8 x i1> %bst, <8 x i32> %dpi, <8 x i32> %__W
  ret <8 x i32> %res
}

define <8 x i32> @test_mm256_mask_dpbsud_epi32(i8 zeroext %__U, <8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B) {
; X86-LABEL: test_mm256_mask_dpbsud_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpbsud %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x76,0xa9,0x50,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm256_mask_dpbsud_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpbsud %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x76,0xa9,0x50,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <8 x i32> @llvm.x86.avx2.vpdpbsud.256(<8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %res = select <8 x i1> %bst, <8 x i32> %dpi, <8 x i32> zeroinitializer
  ret <8 x i32> %res
}

declare <4 x i32> @llvm.x86.avx2.vpdpbsud.128(<4 x i32>, <4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.x86.avx2.vpdpbsuds.128(<4 x i32>, <4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.x86.avx2.vpdpbsud.256(<8 x i32>, <8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.x86.avx2.vpdpbsuds.256(<8 x i32>, <8 x i32>, <8 x i32>)

define <4 x i32> @test_mm_mask_dpbuud_epi32(<4 x i32> %__W, i4 zeroext %__U, <4 x i32> %__A, <4 x i32> %__B) {
; X86-LABEL: test_mm_mask_dpbuud_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpbuud %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x74,0x09,0x50,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm_mask_dpbuud_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpbuud %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x74,0x09,0x50,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <4 x i32> @llvm.x86.avx2.vpdpbuud.128(<4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B)
  %bst = bitcast i4 %__U to <4 x i1>
  %res = select <4 x i1> %bst, <4 x i32> %dpi, <4 x i32> %__W
  ret <4 x i32> %res
}

define <4 x i32> @test_mm_maskz_dpbuuds_epi32(i4 zeroext %__U, <4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B) {
; X86-LABEL: test_mm_maskz_dpbuuds_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpbuuds %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x74,0x89,0x51,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm_maskz_dpbuuds_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpbuuds %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x74,0x89,0x51,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <4 x i32> @llvm.x86.avx2.vpdpbuuds.128(<4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B)
  %bst = bitcast i4 %__U to <4 x i1>
  %res = select <4 x i1> %bst, <4 x i32> %dpi, <4 x i32> zeroinitializer
  ret <4 x i32> %res
}

define <8 x i32> @test_mm256_maskz_dpbuuds_epi32(<8 x i32> %__W, i8 zeroext %__U, <8 x i32> %__A, <8 x i32> %__B) {
; X86-LABEL: test_mm256_maskz_dpbuuds_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpbuuds %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x74,0x29,0x51,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm256_maskz_dpbuuds_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpbuuds %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x74,0x29,0x51,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <8 x i32> @llvm.x86.avx2.vpdpbuuds.256(<8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %res = select <8 x i1> %bst, <8 x i32> %dpi, <8 x i32> %__W
  ret <8 x i32> %res
}

define <8 x i32> @test_mm256_mask_dpbuud_epi32(i8 zeroext %__U, <8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B) {
; X86-LABEL: test_mm256_mask_dpbuud_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpbuud %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x74,0xa9,0x50,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm256_mask_dpbuud_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpbuud %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x74,0xa9,0x50,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <8 x i32> @llvm.x86.avx2.vpdpbuud.256(<8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %res = select <8 x i1> %bst, <8 x i32> %dpi, <8 x i32> zeroinitializer
  ret <8 x i32> %res
}

declare <4 x i32> @llvm.x86.avx2.vpdpbuud.128(<4 x i32>, <4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.x86.avx2.vpdpbuuds.128(<4 x i32>, <4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.x86.avx2.vpdpbuud.256(<8 x i32>, <8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.x86.avx2.vpdpbuuds.256(<8 x i32>, <8 x i32>, <8 x i32>)

; VNNI INT16

define <4 x i32> @test_mm_mask_dpwsud_epi32(<4 x i32> %__W, i4 zeroext %__U, <4 x i32> %__A, <4 x i32> %__B) {
; X86-LABEL: test_mm_mask_dpwsud_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpwsud %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x76,0x09,0xd2,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm_mask_dpwsud_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpwsud %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x76,0x09,0xd2,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <4 x i32> @llvm.x86.avx2.vpdpwsud.128(<4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B)
  %bst = bitcast i4 %__U to <4 x i1>
  %res = select <4 x i1> %bst, <4 x i32> %dpi, <4 x i32> %__W
  ret <4 x i32> %res
}

define <4 x i32> @test_mm_maskz_dpwsuds_epi32(i4 zeroext %__U, <4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B) {
; X86-LABEL: test_mm_maskz_dpwsuds_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpwsuds %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x76,0x89,0xd3,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm_maskz_dpwsuds_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpwsuds %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x76,0x89,0xd3,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <4 x i32> @llvm.x86.avx2.vpdpwsuds.128(<4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B)
  %bst = bitcast i4 %__U to <4 x i1>
  %res = select <4 x i1> %bst, <4 x i32> %dpi, <4 x i32> zeroinitializer
  ret <4 x i32> %res
}

define <8 x i32> @test_mm256_maskz_dpwsuds_epi32(<8 x i32> %__W, i8 zeroext %__U, <8 x i32> %__A, <8 x i32> %__B) {
; X86-LABEL: test_mm256_maskz_dpwsuds_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpwsuds %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x76,0x29,0xd3,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm256_maskz_dpwsuds_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpwsuds %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x76,0x29,0xd3,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <8 x i32> @llvm.x86.avx2.vpdpwsuds.256(<8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %res = select <8 x i1> %bst, <8 x i32> %dpi, <8 x i32> %__W
  ret <8 x i32> %res
}

define <8 x i32> @test_mm256_mask_dpwsud_epi32(i8 zeroext %__U, <8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B) {
; X86-LABEL: test_mm256_mask_dpwsud_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpwsud %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x76,0xa9,0xd2,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm256_mask_dpwsud_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpwsud %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x76,0xa9,0xd2,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <8 x i32> @llvm.x86.avx2.vpdpwsud.256(<8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %res = select <8 x i1> %bst, <8 x i32> %dpi, <8 x i32> zeroinitializer
  ret <8 x i32> %res
}

declare <4 x i32> @llvm.x86.avx2.vpdpwsud.128(<4 x i32>, <4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.x86.avx2.vpdpwsuds.128(<4 x i32>, <4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.x86.avx2.vpdpwsud.256(<8 x i32>, <8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.x86.avx2.vpdpwsuds.256(<8 x i32>, <8 x i32>, <8 x i32>)

define <4 x i32> @test_mm_mask_dpwusd_epi32(<4 x i32> %__W, i4 zeroext %__U, <4 x i32> %__A, <4 x i32> %__B) {
; X86-LABEL: test_mm_mask_dpwusd_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpwusd %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x75,0x09,0xd2,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm_mask_dpwusd_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpwusd %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x75,0x09,0xd2,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <4 x i32> @llvm.x86.avx2.vpdpwusd.128(<4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B)
  %bst = bitcast i4 %__U to <4 x i1>
  %res = select <4 x i1> %bst, <4 x i32> %dpi, <4 x i32> %__W
  ret <4 x i32> %res
}

define <4 x i32> @test_mm_maskz_dpwusds_epi32(i4 zeroext %__U, <4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B) {
; X86-LABEL: test_mm_maskz_dpwusds_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpwusds %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x75,0x89,0xd3,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm_maskz_dpwusds_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpwusds %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x75,0x89,0xd3,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <4 x i32> @llvm.x86.avx2.vpdpwusds.128(<4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B)
  %bst = bitcast i4 %__U to <4 x i1>
  %res = select <4 x i1> %bst, <4 x i32> %dpi, <4 x i32> zeroinitializer
  ret <4 x i32> %res
}

define <8 x i32> @test_mm256_maskz_dpwusds_epi32(<8 x i32> %__W, i8 zeroext %__U, <8 x i32> %__A, <8 x i32> %__B) {
; X86-LABEL: test_mm256_maskz_dpwusds_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpwusds %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x75,0x29,0xd3,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm256_maskz_dpwusds_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpwusds %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x75,0x29,0xd3,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <8 x i32> @llvm.x86.avx2.vpdpwusds.256(<8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %res = select <8 x i1> %bst, <8 x i32> %dpi, <8 x i32> %__W
  ret <8 x i32> %res
}

define <8 x i32> @test_mm256_mask_dpwusd_epi32(i8 zeroext %__U, <8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B) {
; X86-LABEL: test_mm256_mask_dpwusd_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpwusd %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x75,0xa9,0xd2,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm256_mask_dpwusd_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpwusd %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x75,0xa9,0xd2,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <8 x i32> @llvm.x86.avx2.vpdpwusd.256(<8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %res = select <8 x i1> %bst, <8 x i32> %dpi, <8 x i32> zeroinitializer
  ret <8 x i32> %res
}

declare <4 x i32> @llvm.x86.avx2.vpdpwusd.128(<4 x i32>, <4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.x86.avx2.vpdpwusds.128(<4 x i32>, <4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.x86.avx2.vpdpwusd.256(<8 x i32>, <8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.x86.avx2.vpdpwusds.256(<8 x i32>, <8 x i32>, <8 x i32>)

define <4 x i32> @test_mm_mask_dpwuud_epi32(<4 x i32> %__W, i4 zeroext %__U, <4 x i32> %__A, <4 x i32> %__B) {
; X86-LABEL: test_mm_mask_dpwuud_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpwuud %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x74,0x09,0xd2,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm_mask_dpwuud_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpwuud %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x74,0x09,0xd2,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <4 x i32> @llvm.x86.avx2.vpdpwuud.128(<4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B)
  %bst = bitcast i4 %__U to <4 x i1>
  %res = select <4 x i1> %bst, <4 x i32> %dpi, <4 x i32> %__W
  ret <4 x i32> %res
}

define <4 x i32> @test_mm_maskz_dpwuuds_epi32(i4 zeroext %__U, <4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B) {
; X86-LABEL: test_mm_maskz_dpwuuds_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpwuuds %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x74,0x89,0xd3,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm_maskz_dpwuuds_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpwuuds %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x74,0x89,0xd3,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <4 x i32> @llvm.x86.avx2.vpdpwuuds.128(<4 x i32> %__W, <4 x i32> %__A, <4 x i32> %__B)
  %bst = bitcast i4 %__U to <4 x i1>
  %res = select <4 x i1> %bst, <4 x i32> %dpi, <4 x i32> zeroinitializer
  ret <4 x i32> %res
}

define <8 x i32> @test_mm256_maskz_dpwuuds_epi32(<8 x i32> %__W, i8 zeroext %__U, <8 x i32> %__A, <8 x i32> %__B) {
; X86-LABEL: test_mm256_maskz_dpwuuds_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpwuuds %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x74,0x29,0xd3,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm256_maskz_dpwuuds_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpwuuds %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x74,0x29,0xd3,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <8 x i32> @llvm.x86.avx2.vpdpwuuds.256(<8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %res = select <8 x i1> %bst, <8 x i32> %dpi, <8 x i32> %__W
  ret <8 x i32> %res
}

define <8 x i32> @test_mm256_mask_dpwuud_epi32(i8 zeroext %__U, <8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B) {
; X86-LABEL: test_mm256_mask_dpwuud_epi32:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vpdpwuud %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x74,0xa9,0xd2,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mm256_mask_dpwuud_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vpdpwuud %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x74,0xa9,0xd2,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %dpi = tail call <8 x i32> @llvm.x86.avx2.vpdpwuud.256(<8 x i32> %__W, <8 x i32> %__A, <8 x i32> %__B)
  %bst = bitcast i8 %__U to <8 x i1>
  %res = select <8 x i1> %bst, <8 x i32> %dpi, <8 x i32> zeroinitializer
  ret <8 x i32> %res
}

declare <4 x i32> @llvm.x86.avx2.vpdpwuud.128(<4 x i32>, <4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.x86.avx2.vpdpwuuds.128(<4 x i32>, <4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.x86.avx2.vpdpwuud.256(<8 x i32>, <8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.x86.avx2.vpdpwuuds.256(<8 x i32>, <8 x i32>, <8 x i32>)

; VMPSADBW

define { <8 x i16>, <8 x i16>, <8 x i16> } @test_mask_mpsadbw_128(<16 x i8> %x0, <16 x i8> %x1, <8 x i16> %x3, i8 %x4) {
; X86-LABEL: test_mask_mpsadbw_128:
; X86:       # %bb.0:
; X86-NEXT:    vmovdqa %xmm2, %xmm4 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x6f,0xe2]
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmpsadbw $2, %xmm1, %xmm0, %xmm3 # EVEX TO VEX Compression encoding: [0xc4,0xe3,0x79,0x42,0xd9,0x02]
; X86-NEXT:    vmpsadbw $3, %xmm1, %xmm0, %xmm4 {%k1} # encoding: [0x62,0xf3,0x7e,0x09,0x42,0xe1,0x03]
; X86-NEXT:    vmpsadbw $4, %xmm1, %xmm0, %xmm2 {%k1} {z} # encoding: [0x62,0xf3,0x7e,0x89,0x42,0xd1,0x04]
; X86-NEXT:    vmovdqa %xmm3, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x6f,0xc3]
; X86-NEXT:    vmovdqa %xmm4, %xmm1 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x6f,0xcc]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_mpsadbw_128:
; X64:       # %bb.0:
; X64-NEXT:    vmovdqa %xmm2, %xmm4 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x6f,0xe2]
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmpsadbw $2, %xmm1, %xmm0, %xmm3 # EVEX TO VEX Compression encoding: [0xc4,0xe3,0x79,0x42,0xd9,0x02]
; X64-NEXT:    vmpsadbw $3, %xmm1, %xmm0, %xmm4 {%k1} # encoding: [0x62,0xf3,0x7e,0x09,0x42,0xe1,0x03]
; X64-NEXT:    vmpsadbw $4, %xmm1, %xmm0, %xmm2 {%k1} {z} # encoding: [0x62,0xf3,0x7e,0x89,0x42,0xd1,0x04]
; X64-NEXT:    vmovdqa %xmm3, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x6f,0xc3]
; X64-NEXT:    vmovdqa %xmm4, %xmm1 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x6f,0xcc]
; X64-NEXT:    retq # encoding: [0xc3]
  %msk = bitcast i8 %x4 to <8 x i1>
  %rs1 = call <8 x i16> @llvm.x86.sse41.mpsadbw(<16 x i8> %x0, <16 x i8> %x1, i8 2)
  %ad2 = call <8 x i16> @llvm.x86.sse41.mpsadbw(<16 x i8> %x0, <16 x i8> %x1, i8 3)
  %rs2 = select <8 x i1> %msk, <8 x i16> %ad2, <8 x i16> %x3
  %ad3 = call <8 x i16> @llvm.x86.sse41.mpsadbw(<16 x i8> %x0, <16 x i8> %x1, i8 4)
  %rs3 = select <8 x i1> %msk, <8 x i16> %ad3, <8 x i16> zeroinitializer
  %rs4 = insertvalue { <8 x i16>, <8 x i16>, <8 x i16> } undef, <8 x i16> %rs1, 0
  %rs5 = insertvalue { <8 x i16>, <8 x i16>, <8 x i16> } %rs4, <8 x i16> %rs2, 1
  %rs6 = insertvalue { <8 x i16>, <8 x i16>, <8 x i16> } %rs5, <8 x i16> %rs3, 2
  ret { <8 x i16>, <8 x i16>, <8 x i16> } %rs6
}

define { <16 x i16>, <16 x i16>, <16 x i16> } @test_mask_mpsadbw_256(<32 x i8> %x0, <32 x i8> %x1, <16 x i16> %x3, i16 %x4) {
; X86-LABEL: test_mask_mpsadbw_256:
; X86:       # %bb.0:
; X86-NEXT:    vmovdqa %ymm2, %ymm4 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x6f,0xe2]
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmpsadbw $2, %ymm1, %ymm0, %ymm3 # EVEX TO VEX Compression encoding: [0xc4,0xe3,0x7d,0x42,0xd9,0x02]
; X86-NEXT:    vmpsadbw $3, %ymm1, %ymm0, %ymm4 {%k1} # encoding: [0x62,0xf3,0x7e,0x29,0x42,0xe1,0x03]
; X86-NEXT:    vmpsadbw $4, %ymm1, %ymm0, %ymm2 {%k1} {z} # encoding: [0x62,0xf3,0x7e,0xa9,0x42,0xd1,0x04]
; X86-NEXT:    vmovdqa %ymm3, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x6f,0xc3]
; X86-NEXT:    vmovdqa %ymm4, %ymm1 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x6f,0xcc]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_mask_mpsadbw_256:
; X64:       # %bb.0:
; X64-NEXT:    vmovdqa %ymm2, %ymm4 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x6f,0xe2]
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmpsadbw $2, %ymm1, %ymm0, %ymm3 # EVEX TO VEX Compression encoding: [0xc4,0xe3,0x7d,0x42,0xd9,0x02]
; X64-NEXT:    vmpsadbw $3, %ymm1, %ymm0, %ymm4 {%k1} # encoding: [0x62,0xf3,0x7e,0x29,0x42,0xe1,0x03]
; X64-NEXT:    vmpsadbw $4, %ymm1, %ymm0, %ymm2 {%k1} {z} # encoding: [0x62,0xf3,0x7e,0xa9,0x42,0xd1,0x04]
; X64-NEXT:    vmovdqa %ymm3, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x6f,0xc3]
; X64-NEXT:    vmovdqa %ymm4, %ymm1 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x6f,0xcc]
; X64-NEXT:    retq # encoding: [0xc3]
  %msk = bitcast i16 %x4 to <16 x i1>
  %rs1 = call <16 x i16> @llvm.x86.avx2.mpsadbw(<32 x i8> %x0, <32 x i8> %x1, i8 2)
  %ad2 = call <16 x i16> @llvm.x86.avx2.mpsadbw(<32 x i8> %x0, <32 x i8> %x1, i8 3)
  %rs2 = select <16 x i1> %msk, <16 x i16> %ad2, <16 x i16> %x3
  %ad3 = call <16 x i16> @llvm.x86.avx2.mpsadbw(<32 x i8> %x0, <32 x i8> %x1, i8 4)
  %rs3 = select <16 x i1> %msk, <16 x i16> %ad3, <16 x i16> zeroinitializer
  %rs4 = insertvalue { <16 x i16>, <16 x i16>, <16 x i16> } undef, <16 x i16> %rs1, 0
  %rs5 = insertvalue { <16 x i16>, <16 x i16>, <16 x i16> } %rs4, <16 x i16> %rs2, 1
  %rs6 = insertvalue { <16 x i16>, <16 x i16>, <16 x i16> } %rs5, <16 x i16> %rs3, 2
  ret { <16 x i16>, <16 x i16>, <16 x i16> } %rs6
}

declare <8 x i16> @llvm.x86.sse41.mpsadbw(<16 x i8>, <16 x i8>, i8)
declare <16 x i16> @llvm.x86.avx2.mpsadbw(<32 x i8>, <32 x i8>, i8)

; YMM Rounding

declare <4 x double> @llvm.x86.avx10.vaddpd256(<4 x double>, <4 x double>, i32)
define <4 x double> @test_int_x86_vaddpd256(<4 x double> %A, <4 x double> %B) nounwind {
; CHECK-LABEL: test_int_x86_vaddpd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaddpd {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf1,0xf9,0x78,0x58,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.vaddpd256(<4 x double> %A, <4 x double> %B, i32 11)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vaddpd256(<4 x double> %A, i4 %B, <4 x double> %C, <4 x double> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vaddpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vaddpd {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf1,0x59,0x58,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vaddpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vaddpd {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf1,0x59,0x58,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vaddpd256(<4 x double> %C, <4 x double> %D, i32 10)
  %msk = bitcast i4 %B to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> %A
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vaddpd256(i4 %A, <4 x double> %B, <4 x double> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vaddpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vaddpd {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vaddpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vaddpd {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vaddpd256(<4 x double> %B, <4 x double> %C, i32 9)
  %msk = bitcast i4 %A to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> zeroinitializer
  ret <4 x double> %ret
}

declare <16 x half> @llvm.x86.avx10.vaddph256(<16 x half>, <16 x half>, i32)
define <16 x half> @test_int_x86_vaddph256(<16 x half> %A, <16 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_vaddph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaddph {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x78,0x78,0x58,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.vaddph256(<16 x half> %A, <16 x half> %B, i32 11)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vaddph256(<16 x half> %A, i16 %B, <16 x half> %C, <16 x half> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vaddph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vaddph {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x70,0x59,0x58,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vaddph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vaddph {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x70,0x59,0x58,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vaddph256(<16 x half> %C, <16 x half> %D, i32 10)
  %msk = bitcast i16 %B to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> %A
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vaddph256(i16 %A, <16 x half> %B, <16 x half> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vaddph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vaddph {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vaddph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vaddph {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vaddph256(<16 x half> %B, <16 x half> %C, i32 9)
  %msk = bitcast i16 %A to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> zeroinitializer
  ret <16 x half> %ret
}

declare <8 x float> @llvm.x86.avx10.vaddps256(<8 x float>, <8 x float>, i32)
define <8 x float> @test_int_x86_vaddps256(<8 x float> %A, <8 x float> %B) nounwind {
; CHECK-LABEL: test_int_x86_vaddps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaddps {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf1,0x78,0x78,0x58,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.vaddps256(<8 x float> %A, <8 x float> %B, i32 11)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vaddps256(<8 x float> %A, i8 %B, <8 x float> %C, <8 x float> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vaddps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vaddps {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x70,0x59,0x58,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vaddps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vaddps {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x70,0x59,0x58,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vaddps256(<8 x float> %C, <8 x float> %D, i32 10)
  %msk = bitcast i8 %B to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> %A
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vaddps256(i8 %A, <8 x float> %B, <8 x float> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vaddps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vaddps {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0xb9,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vaddps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vaddps {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0xb9,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vaddps256(<8 x float> %B, <8 x float> %C, i32 9)
  %msk = bitcast i8 %A to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> zeroinitializer
  ret <8 x float> %ret
}

declare <4 x i1> @llvm.x86.avx10.mask.vcmppd256(<4 x double>, <4 x double>, i32, <4 x i1>, i32)
define i4 @test_int_x86_vcmppd256(<4 x double> %A, <4 x double> %B, i4 %C) nounwind {
; CHECK-LABEL: test_int_x86_vcmppd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcmppd $0, {sae}, %ymm1, %ymm0, %k0 # encoding: [0x62,0xf1,0xf9,0x18,0xc2,0xc1,0x00]
; CHECK-NEXT:    kmovd %k0, %eax # encoding: [0xc5,0xfb,0x93,0xc0]
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret0 = call <4 x i1> @llvm.x86.avx10.mask.vcmppd256(<4 x double> %A, <4 x double> %B, i32 0, <4 x i1> <i1 1, i1 1, i1 1, i1 1>, i32 8)
  %ret = bitcast <4 x i1> %ret0 to i4
  ret i4 %ret
}

define i4 @test_int_x86_mask_vcmppd256(<4 x double> %A, <4 x double> %B, i4 %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcmppd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcmpeqpd %ymm1, %ymm0, %k0 {%k1} # encoding: [0x62,0xf1,0xfd,0x29,0xc2,0xc1,0x00]
; X86-NEXT:    kmovd %k0, %eax # encoding: [0xc5,0xfb,0x93,0xc0]
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcmppd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcmpeqpd %ymm1, %ymm0, %k0 {%k1} # encoding: [0x62,0xf1,0xfd,0x29,0xc2,0xc1,0x00]
; X64-NEXT:    kmovd %k0, %eax # encoding: [0xc5,0xfb,0x93,0xc0]
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %msk = bitcast i4 %C to <4 x i1>
  %ret0 = call <4 x i1> @llvm.x86.avx10.mask.vcmppd256(<4 x double> %A, <4 x double> %B, i32 0, <4 x i1> %msk, i32 4)
  %ret = bitcast <4 x i1> %ret0 to i4
  ret i4 %ret
}

declare <16 x i1> @llvm.x86.avx10.mask.vcmpph256(<16 x half>, <16 x half>, i32, <16 x i1>, i32)
define i16 @test_int_x86_vcmpph256(<16 x half> %A, <16 x half> %B, i16 %C) nounwind {
; CHECK-LABEL: test_int_x86_vcmpph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcmpph $0, {sae}, %ymm1, %ymm0, %k0 # encoding: [0x62,0xf3,0x78,0x18,0xc2,0xc1,0x00]
; CHECK-NEXT:    kmovd %k0, %eax # encoding: [0xc5,0xfb,0x93,0xc0]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret0 = call <16 x i1> @llvm.x86.avx10.mask.vcmpph256(<16 x half> %A, <16 x half> %B, i32 0, <16 x i1> <i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1>, i32 8)
  %ret = bitcast <16 x i1> %ret0 to i16
  ret i16 %ret
}

define i16 @test_int_x86_mask_vcmpph256(<16 x half> %A, <16 x half> %B, i16 %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcmpph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcmpeqph %ymm1, %ymm0, %k0 {%k1} # encoding: [0x62,0xf3,0x7c,0x29,0xc2,0xc1,0x00]
; X86-NEXT:    kmovd %k0, %eax # encoding: [0xc5,0xfb,0x93,0xc0]
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcmpph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcmpeqph %ymm1, %ymm0, %k0 {%k1} # encoding: [0x62,0xf3,0x7c,0x29,0xc2,0xc1,0x00]
; X64-NEXT:    kmovd %k0, %eax # encoding: [0xc5,0xfb,0x93,0xc0]
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %msk = bitcast i16 %C to <16 x i1>
  %ret0 = call <16 x i1> @llvm.x86.avx10.mask.vcmpph256(<16 x half> %A, <16 x half> %B, i32 0, <16 x i1> %msk, i32 4)
  %ret = bitcast <16 x i1> %ret0 to i16
  ret i16 %ret
}

declare <8 x i1> @llvm.x86.avx10.mask.vcmpps256(<8 x float>, <8 x float>, i32, <8 x i1>, i32)
define i8 @test_int_x86_vcmpps256(<8 x float> %A, <8 x float> %B, i8 %C) nounwind {
; CHECK-LABEL: test_int_x86_vcmpps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcmpps $0, {sae}, %ymm1, %ymm0, %k0 # encoding: [0x62,0xf1,0x78,0x18,0xc2,0xc1,0x00]
; CHECK-NEXT:    kmovd %k0, %eax # encoding: [0xc5,0xfb,0x93,0xc0]
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret0 = call <8 x i1> @llvm.x86.avx10.mask.vcmpps256(<8 x float> %A, <8 x float> %B, i32 0, <8 x i1> <i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1>, i32 8)
  %ret = bitcast <8 x i1> %ret0 to i8
  ret i8 %ret
}

define i8 @test_int_x86_mask_vcmpps256(<8 x float> %A, <8 x float> %B, i8 %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcmpps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcmpeqps %ymm1, %ymm0, %k0 {%k1} # encoding: [0x62,0xf1,0x7c,0x29,0xc2,0xc1,0x00]
; X86-NEXT:    kmovd %k0, %eax # encoding: [0xc5,0xfb,0x93,0xc0]
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcmpps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcmpeqps %ymm1, %ymm0, %k0 {%k1} # encoding: [0x62,0xf1,0x7c,0x29,0xc2,0xc1,0x00]
; X64-NEXT:    kmovd %k0, %eax # encoding: [0xc5,0xfb,0x93,0xc0]
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %msk = bitcast i8 %C to <8 x i1>
  %ret0 = call <8 x i1> @llvm.x86.avx10.mask.vcmpps256(<8 x float> %A, <8 x float> %B, i32 0, <8 x i1> %msk, i32 4)
  %ret = bitcast <8 x i1> %ret0 to i8
  ret i8 %ret
}

declare <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v8i32(<8 x i32>, i32)
define <8 x half> @test_int_x86_vcvtdq2ph256(<8 x i32> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtdq2ph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtdq2ph {rz-sae}, %ymm0, %xmm0 # encoding: [0x62,0xf5,0x78,0x78,0x5b,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v8i32(<8 x i32> %A, i32 11)
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_mask_vcvtdq2ph256(<8 x half> %A, i8 %B, <8 x i32> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtdq2ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtdq2ph {ru-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x78,0x59,0x5b,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtdq2ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtdq2ph {ru-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x78,0x59,0x5b,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v8i32(<8 x i32> %C, i32 10)
  %msk = bitcast i8 %B to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x half> %ret0, <8 x half> %A
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_maskz_vcvtdq2ph256(i8 %A, <8 x i32> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtdq2ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtdq2ph {rd-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x5b,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtdq2ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtdq2ph {rd-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x5b,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v8i32(<8 x i32> %B, i32 9)
  %msk = bitcast i8 %A to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x half> %ret0, <8 x half> zeroinitializer
  ret <8 x half> %ret
}

declare <8 x float> @llvm.x86.avx512.sitofp.round.v8f32.v8i32(<8 x i32>, i32)
define <8 x float> @test_int_x86_vcvtdq2ps256(<8 x i32> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtdq2ps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtdq2ps {rz-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf1,0x78,0x78,0x5b,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx512.sitofp.round.v8f32.v8i32(<8 x i32> %A, i32 11)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vcvtdq2ps256(<8 x float> %A, i8 %B, <8 x i32> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtdq2ps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtdq2ps {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x78,0x59,0x5b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtdq2ps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtdq2ps {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x78,0x59,0x5b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx512.sitofp.round.v8f32.v8i32(<8 x i32> %C, i32 10)
  %msk = bitcast i8 %B to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> %A
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vcvtdq2ps256(i8 %A, <8 x i32> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtdq2ps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtdq2ps {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0xb9,0x5b,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtdq2ps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtdq2ps {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0xb9,0x5b,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx512.sitofp.round.v8f32.v8i32(<8 x i32> %B, i32 9)
  %msk = bitcast i8 %A to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> zeroinitializer
  ret <8 x float> %ret
}

declare <4 x i32> @llvm.x86.avx10.mask.vcvtpd2dq256(<4 x double>, <4 x i32>, i8, i32)
define <4 x i32> @test_int_x86_vcvtpd2dq256(<4 x double> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtpd2dq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtpd2dq {rz-sae}, %ymm0, %xmm0 # encoding: [0x62,0xf1,0xfb,0x78,0xe6,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx10.mask.vcvtpd2dq256(<4 x double> %A, <4 x i32> undef, i8 -1, i32 11)
  ret <4 x i32> %ret
}

define <4 x i32> @test_int_x86_mask_vcvtpd2dq256(<4 x i32> %A, i8 %B, <4 x double> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtpd2dq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtpd2dq {ru-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf1,0xfb,0x59,0xe6,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtpd2dq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtpd2dq {ru-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf1,0xfb,0x59,0xe6,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx10.mask.vcvtpd2dq256(<4 x double> %C, <4 x i32> %A, i8 %B, i32 10)
  ret <4 x i32> %ret
}

define <4 x i32> @test_int_x86_maskz_vcvtpd2dq256(i8 %A, <4 x double> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtpd2dq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtpd2dq {rd-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf1,0xfb,0xb9,0xe6,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtpd2dq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtpd2dq {rd-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf1,0xfb,0xb9,0xe6,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx10.mask.vcvtpd2dq256(<4 x double> %B, <4 x i32> zeroinitializer, i8 %A, i32 9)
  ret <4 x i32> %ret
}

declare <8 x half> @llvm.x86.avx10.mask.vcvtpd2ph256(<4 x double>, <8 x half>, i8, i32)
define <8 x half> @test_int_x86_vcvtpd2ph256(<4 x double> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtpd2ph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtpd2ph {rz-sae}, %ymm0, %xmm0 # encoding: [0x62,0xf5,0xf9,0x78,0x5a,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vcvtpd2ph256(<4 x double> %A, <8 x half> undef, i8 -1, i32 11)
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_mask_vcvtpd2ph256(<8 x half> %A, i8 %B, <4 x double> %C) {
; X86-LABEL: test_int_x86_mask_vcvtpd2ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtpd2ph {ru-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0xf9,0x59,0x5a,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtpd2ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtpd2ph {ru-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0xf9,0x59,0x5a,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vcvtpd2ph256(<4 x double> %C, <8 x half> %A, i8 %B, i32 10)
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_maskz_vcvtpd2ph256(i8 %A, <4 x double> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtpd2ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtpd2ph {rd-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xf9,0xb9,0x5a,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtpd2ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtpd2ph {rd-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xf9,0xb9,0x5a,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vcvtpd2ph256(<4 x double> %B, <8 x half> zeroinitializer, i8 %A, i32 9)
  ret <8 x half> %ret
}

declare <4 x float> @llvm.x86.avx10.mask.vcvtpd2ps256(<4 x double>, <4 x float>, i8, i32)
define <4 x float> @test_int_x86_vcvtpd2ps256(<4 x double> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtpd2ps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtpd2ps {rz-sae}, %ymm0, %xmm0 # encoding: [0x62,0xf1,0xf9,0x78,0x5a,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x float> @llvm.x86.avx10.mask.vcvtpd2ps256(<4 x double> %A, <4 x float> undef, i8 -1, i32 11)
  ret <4 x float> %ret
}

define <4 x float> @test_int_x86_mask_vcvtpd2ps256(<4 x float> %A, i8 %B, <4 x double> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtpd2ps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtpd2ps {ru-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf1,0xf9,0x59,0x5a,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtpd2ps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtpd2ps {ru-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf1,0xf9,0x59,0x5a,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x float> @llvm.x86.avx10.mask.vcvtpd2ps256(<4 x double> %C, <4 x float> %A, i8 %B, i32 10)
  ret <4 x float> %ret
}

define <4 x float> @test_int_x86_maskz_vcvtpd2ps256(i8 %A, <4 x double> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtpd2ps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtpd2ps {rd-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x5a,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtpd2ps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtpd2ps {rd-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x5a,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x float> @llvm.x86.avx10.mask.vcvtpd2ps256(<4 x double> %B, <4 x float> zeroinitializer, i8 %A, i32 9)
  ret <4 x float> %ret
}

declare <4 x i64> @llvm.x86.avx10.mask.vcvtpd2qq256(<4 x double>, <4 x i64>, i8, i32)
define <4 x i64> @test_int_x86_vcvtpd2qq256(<4 x double> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtpd2qq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtpd2qq {rz-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf1,0xf9,0x78,0x7b,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtpd2qq256(<4 x double> %A, <4 x i64> undef, i8 -1, i32 11)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_mask_vcvtpd2qq256(<4 x i64> %A, i8 %B, <4 x double> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtpd2qq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtpd2qq {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf9,0x59,0x7b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtpd2qq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtpd2qq {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf9,0x59,0x7b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtpd2qq256(<4 x double> %C, <4 x i64> %A, i8 %B, i32 10)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_maskz_vcvtpd2qq256(i8 %A, <4 x double> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtpd2qq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtpd2qq {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x7b,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtpd2qq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtpd2qq {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x7b,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtpd2qq256(<4 x double> %B, <4 x i64> zeroinitializer, i8 %A, i32 9)
  ret <4 x i64> %ret
}

declare <4 x i32> @llvm.x86.avx10.mask.vcvtpd2udq256(<4 x double>, <4 x i32>, i8, i32)
define <4 x i32> @test_int_x86_vcvtpd2udq256(<4 x double> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtpd2udq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtpd2udq {rz-sae}, %ymm0, %xmm0 # encoding: [0x62,0xf1,0xf8,0x78,0x79,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx10.mask.vcvtpd2udq256(<4 x double> %A, <4 x i32> undef, i8 -1, i32 11)
  ret <4 x i32> %ret
}

define <4 x i32> @test_int_x86_mask_vcvtpd2udq256(<4 x i32> %A, i8 %B, <4 x double> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtpd2udq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtpd2udq {ru-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf1,0xf8,0x59,0x79,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtpd2udq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtpd2udq {ru-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf1,0xf8,0x59,0x79,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx10.mask.vcvtpd2udq256(<4 x double> %C, <4 x i32> %A, i8 %B, i32 10)
  ret <4 x i32> %ret
}

define <4 x i32> @test_int_x86_maskz_vcvtpd2udq256(i8 %A, <4 x double> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtpd2udq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtpd2udq {rd-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf1,0xf8,0xb9,0x79,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtpd2udq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtpd2udq {rd-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf1,0xf8,0xb9,0x79,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx10.mask.vcvtpd2udq256(<4 x double> %B, <4 x i32> zeroinitializer, i8 %A, i32 9)
  ret <4 x i32> %ret
}

declare <4 x i64> @llvm.x86.avx10.mask.vcvtpd2uqq256(<4 x double>, <4 x i64>, i8, i32)
define <4 x i64> @test_int_x86_vcvtpd2uqq256(<4 x double> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtpd2uqq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtpd2uqq {rz-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf1,0xf9,0x78,0x79,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtpd2uqq256(<4 x double> %A, <4 x i64> undef, i8 -1, i32 11)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_mask_vcvtpd2uqq256(<4 x i64> %A, i8 %B, <4 x double> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtpd2uqq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtpd2uqq {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf9,0x59,0x79,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtpd2uqq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtpd2uqq {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf9,0x59,0x79,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtpd2uqq256(<4 x double> %C, <4 x i64> %A, i8 %B, i32 10)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_maskz_vcvtpd2uqq256(i8 %A, <4 x double> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtpd2uqq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtpd2uqq {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x79,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtpd2uqq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtpd2uqq {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x79,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtpd2uqq256(<4 x double> %B, <4 x i64> zeroinitializer, i8 %A, i32 9)
  ret <4 x i64> %ret
}

declare <8 x i32> @llvm.x86.avx10.mask.vcvtph2dq256(<8 x half>, <8 x i32>, i8, i32)
define <8 x i32> @test_int_x86_vcvtph2dq256(<8 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtph2dq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2dq {rz-sae}, %xmm0, %ymm0 # encoding: [0x62,0xf5,0x79,0x78,0x5b,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvtph2dq256(<8 x half> %A, <8 x i32> undef, i8 -1, i32 11)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_mask_vcvtph2dq256(<8 x i32> %A, i8 %B, <8 x half> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtph2dq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2dq {ru-sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x79,0x59,0x5b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtph2dq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2dq {ru-sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x79,0x59,0x5b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvtph2dq256(<8 x half> %C, <8 x i32> %A, i8 %B, i32 10)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_maskz_vcvtph2dq256(i8 %A, <8 x half> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtph2dq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2dq {rd-sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0xb9,0x5b,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtph2dq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2dq {rd-sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0xb9,0x5b,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvtph2dq256(<8 x half> %B, <8 x i32> zeroinitializer, i8 %A, i32 9)
  ret <8 x i32> %ret
}

declare <4 x double> @llvm.x86.avx10.mask.vcvtph2pd256(<8 x half>, <4 x double>, i8, i32)
define <4 x double> @test_int_x86_vcvtph2pd256(<8 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtph2pd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2pd {sae}, %xmm0, %ymm0 # encoding: [0x62,0xf5,0x78,0x18,0x5a,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vcvtph2pd256(<8 x half> %A, <4 x double> undef, i8 -1, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vcvtph2pd256(<4 x double> %A, i8 %B, <8 x half> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtph2pd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2pd {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x78,0x19,0x5a,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtph2pd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2pd {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x78,0x19,0x5a,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vcvtph2pd256(<8 x half> %C, <4 x double> %A, i8 %B, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vcvtph2pd256(i8 %A, <8 x half> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtph2pd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2pd {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0x99,0x5a,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtph2pd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2pd {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0x99,0x5a,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vcvtph2pd256(<8 x half> %B, <4 x double> zeroinitializer, i8 %A, i32 8)
  ret <4 x double> %ret
}

declare <8 x float> @llvm.x86.avx10.mask.vcvtph2psx256(<8 x half>, <8 x float>, i8, i32)
define <8 x float> @test_int_x86_vcvtph2psx256(<8 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtph2psx256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2psx {sae}, %xmm0, %ymm0 # encoding: [0x62,0xf6,0x79,0x18,0x13,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vcvtph2psx256(<8 x half> %A, <8 x float> undef, i8 -1, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vcvtph2psx256(<8 x float> %A, i8 %B, <8 x half> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtph2psx256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2psx {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf6,0x79,0x19,0x13,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtph2psx256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2psx {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf6,0x79,0x19,0x13,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vcvtph2psx256(<8 x half> %C, <8 x float> %A, i8 %B, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vcvtph2psx256(i8 %A, <8 x half> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtph2psx256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2psx {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf6,0x79,0x99,0x13,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtph2psx256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2psx {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf6,0x79,0x99,0x13,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vcvtph2psx256(<8 x half> %B, <8 x float> zeroinitializer, i8 %A, i32 8)
  ret <8 x float> %ret
}

declare <4 x i64> @llvm.x86.avx10.mask.vcvtph2qq256(<8 x half>, <4 x i64>, i8, i32)
define <4 x i64> @test_int_x86_vcvtph2qq256(<8 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtph2qq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2qq {rz-sae}, %xmm0, %ymm0 # encoding: [0x62,0xf5,0x79,0x78,0x7b,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtph2qq256(<8 x half> %A, <4 x i64> undef, i8 -1, i32 11)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_mask_vcvtph2qq256(<4 x i64> %A, i8 %B, <8 x half> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtph2qq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2qq {ru-sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x79,0x59,0x7b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtph2qq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2qq {ru-sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x79,0x59,0x7b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtph2qq256(<8 x half> %C, <4 x i64> %A, i8 %B, i32 10)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_maskz_vcvtph2qq256(i8 %A, <8 x half> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtph2qq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2qq {rd-sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0xb9,0x7b,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtph2qq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2qq {rd-sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0xb9,0x7b,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtph2qq256(<8 x half> %B, <4 x i64> zeroinitializer, i8 %A, i32 9)
  ret <4 x i64> %ret
}

declare <8 x i32> @llvm.x86.avx10.mask.vcvtph2udq256(<8 x half>, <8 x i32>, i8, i32)
define <8 x i32> @test_int_x86_vcvtph2udq256(<8 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtph2udq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2udq {rz-sae}, %xmm0, %ymm0 # encoding: [0x62,0xf5,0x78,0x78,0x79,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvtph2udq256(<8 x half> %A, <8 x i32> undef, i8 -1, i32 11)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_mask_vcvtph2udq256(<8 x i32> %A, i8 %B, <8 x half> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtph2udq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2udq {ru-sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x78,0x59,0x79,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtph2udq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2udq {ru-sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x78,0x59,0x79,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvtph2udq256(<8 x half> %C, <8 x i32> %A, i8 %B, i32 10)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_maskz_vcvtph2udq256(i8 %A, <8 x half> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtph2udq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2udq {rd-sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x79,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtph2udq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2udq {rd-sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x79,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvtph2udq256(<8 x half> %B, <8 x i32> zeroinitializer, i8 %A, i32 9)
  ret <8 x i32> %ret
}

declare <4 x i64> @llvm.x86.avx10.mask.vcvtph2uqq256(<8 x half>, <4 x i64>, i8, i32)
define <4 x i64> @test_int_x86_vcvtph2uqq256(<8 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtph2uqq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2uqq {rz-sae}, %xmm0, %ymm0 # encoding: [0x62,0xf5,0x79,0x78,0x79,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtph2uqq256(<8 x half> %A, <4 x i64> undef, i8 -1, i32 11)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_mask_vcvtph2uqq256(<4 x i64> %A, i8 %B, <8 x half> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtph2uqq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2uqq {ru-sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x79,0x59,0x79,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtph2uqq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2uqq {ru-sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x79,0x59,0x79,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtph2uqq256(<8 x half> %C, <4 x i64> %A, i8 %B, i32 10)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_maskz_vcvtph2uqq256(i8 %A, <8 x half> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtph2uqq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2uqq {rd-sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0xb9,0x79,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtph2uqq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2uqq {rd-sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0xb9,0x79,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtph2uqq256(<8 x half> %B, <4 x i64> zeroinitializer, i8 %A, i32 9)
  ret <4 x i64> %ret
}

declare <16 x i16> @llvm.x86.avx10.mask.vcvtph2uw256(<16 x half>, <16 x i16>, i16, i32)
define <16 x i16> @test_int_x86_vcvtph2uw256(<16 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtph2uw256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2uw {rz-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x78,0x78,0x7d,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i16> @llvm.x86.avx10.mask.vcvtph2uw256(<16 x half> %A, <16 x i16> undef, i16 -1, i32 11)
  ret <16 x i16> %ret
}

define <16 x i16> @test_int_x86_mask_vcvtph2uw256(<16 x i16> %A, i16 %B, <16 x half> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtph2uw256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2uw {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x78,0x59,0x7d,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtph2uw256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2uw {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x78,0x59,0x7d,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x i16> @llvm.x86.avx10.mask.vcvtph2uw256(<16 x half> %C, <16 x i16> %A, i16 %B, i32 10)
  ret <16 x i16> %ret
}

define <16 x i16> @test_int_x86_maskz_vcvtph2uw256(i16 %A, <16 x half> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtph2uw256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2uw {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x7d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtph2uw256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2uw {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x7d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x i16> @llvm.x86.avx10.mask.vcvtph2uw256(<16 x half> %B, <16 x i16> zeroinitializer, i16 %A, i32 9)
  ret <16 x i16> %ret
}

declare <16 x i16> @llvm.x86.avx10.mask.vcvtph2w256(<16 x half>, <16 x i16>, i16, i32)
define <16 x i16> @test_int_x86_vcvtph2w256(<16 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtph2w256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2w {rz-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x79,0x78,0x7d,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i16> @llvm.x86.avx10.mask.vcvtph2w256(<16 x half> %A, <16 x i16> undef, i16 -1, i32 11)
  ret <16 x i16> %ret
}

define <16 x i16> @test_int_x86_mask_vcvtph2w256(<16 x i16> %A, i16 %B, <16 x half> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtph2w256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2w {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x79,0x59,0x7d,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtph2w256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2w {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x79,0x59,0x7d,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x i16> @llvm.x86.avx10.mask.vcvtph2w256(<16 x half> %C, <16 x i16> %A, i16 %B, i32 10)
  ret <16 x i16> %ret
}

define <16 x i16> @test_int_x86_maskz_vcvtph2w256(i16 %A, <16 x half> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtph2w256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2w {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0xb9,0x7d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtph2w256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2w {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0xb9,0x7d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x i16> @llvm.x86.avx10.mask.vcvtph2w256(<16 x half> %B, <16 x i16> zeroinitializer, i16 %A, i32 9)
  ret <16 x i16> %ret
}

declare <8 x i32> @llvm.x86.avx10.mask.vcvtps2dq256(<8 x float>, <8 x i32>, i8, i32)
define <8 x i32> @test_int_x86_vcvtps2dq256(<8 x float> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvtps2dq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtps2dq {rz-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf1,0x79,0x78,0x5b,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvtps2dq256(<8 x float> %a, <8 x i32> undef, i8 -1, i32 11)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_mask_vcvtps2dq256(<8 x i32> %a, i8 %b, <8 x float> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtps2dq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2dq {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x79,0x59,0x5b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtps2dq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2dq {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x79,0x59,0x5b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvtps2dq256(<8 x float> %c, <8 x i32> %a, i8 %b, i32 10)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_maskz_vcvtps2dq256(i8 %a, <8 x float> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtps2dq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2dq {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x79,0xb9,0x5b,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtps2dq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2dq {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x79,0xb9,0x5b,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvtps2dq256(<8 x float> %b, <8 x i32> zeroinitializer, i8 %a, i32 9)
  ret <8 x i32> %ret
}

declare <4 x double> @llvm.x86.avx10.mask.vcvtps2pd256(<4 x float>, <4 x double>, i8, i32)
define <4 x double> @test_int_x86_vcvtps2pd256(<4 x float> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvtps2pd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtps2pd {sae}, %xmm0, %ymm0 # encoding: [0x62,0xf1,0x78,0x18,0x5a,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vcvtps2pd256(<4 x float> %a, <4 x double> undef, i8 -1, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vcvtps2pd256(<4 x double> %a, i8 %b, <4 x float> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtps2pd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2pd {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x78,0x19,0x5a,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtps2pd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2pd {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x78,0x19,0x5a,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vcvtps2pd256(<4 x float> %c, <4 x double> %a, i8 %b, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vcvtps2pd256(i8 %a, <4 x float> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtps2pd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2pd {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0x99,0x5a,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtps2pd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2pd {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0x99,0x5a,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vcvtps2pd256(<4 x float> %b, <4 x double> zeroinitializer, i8 %a, i32 8)
  ret <4 x double> %ret
}

declare <8 x half> @llvm.x86.avx10.mask.vcvtps2phx256(<8 x float>, <8 x half>, i8, i32)
define <8 x half> @test_int_x86_vcvtps2phx256(<8 x float> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvtps2phx256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtps2phx {rz-sae}, %ymm0, %xmm0 # encoding: [0x62,0xf5,0x79,0x78,0x1d,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vcvtps2phx256(<8 x float> %a, <8 x half> undef, i8 -1, i32 11)
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_mask_vcvtps2phx256(<8 x half> %a, i8 %b, <8 x float> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtps2phx256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2phx {ru-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x79,0x59,0x1d,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtps2phx256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2phx {ru-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x79,0x59,0x1d,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vcvtps2phx256(<8 x float> %c, <8 x half> %a, i8 %b, i32 10)
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_maskz_vcvtps2phx256(i8 %a, <8 x float> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtps2phx256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2phx {rd-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0xb9,0x1d,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtps2phx256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2phx {rd-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0xb9,0x1d,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vcvtps2phx256(<8 x float> %b, <8 x half> zeroinitializer, i8 %a, i32 9)
  ret <8 x half> %ret
}

declare <4 x i64> @llvm.x86.avx10.mask.vcvtps2qq256(<4 x float>, <4 x i64>, i8, i32)
define <4 x i64> @test_int_x86_vcvtps2qq256(<4 x float> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvtps2qq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtps2qq {rz-sae}, %xmm0, %ymm0 # encoding: [0x62,0xf1,0x79,0x78,0x7b,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtps2qq256(<4 x float> %a, <4 x i64> undef, i8 -1, i32 11)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_mask_vcvtps2qq256(<4 x i64> %a, i8 %b, <4 x float> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtps2qq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2qq {ru-sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x79,0x59,0x7b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtps2qq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2qq {ru-sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x79,0x59,0x7b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtps2qq256(<4 x float> %c, <4 x i64> %a, i8 %b, i32 10)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_maskz_vcvtps2qq256(i8 %a, <4 x float> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtps2qq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2qq {rd-sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x79,0xb9,0x7b,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtps2qq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2qq {rd-sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x79,0xb9,0x7b,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtps2qq256(<4 x float> %b, <4 x i64> zeroinitializer, i8 %a, i32 9)
  ret <4 x i64> %ret
}

declare <8 x i32> @llvm.x86.avx10.mask.vcvtps2udq256(<8 x float>, <8 x i32>, i8, i32)
define <8 x i32> @test_int_x86_vcvtps2udq256(<8 x float> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvtps2udq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtps2udq {rz-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf1,0x78,0x78,0x79,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvtps2udq256(<8 x float> %a, <8 x i32> undef, i8 -1, i32 11)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_mask_vcvtps2udq256(<8 x i32> %a, i8 %b, <8 x float> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtps2udq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2udq {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x78,0x59,0x79,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtps2udq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2udq {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x78,0x59,0x79,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvtps2udq256(<8 x float> %c, <8 x i32> %a, i8 %b, i32 10)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_maskz_vcvtps2udq256(i8 %a, <8 x float> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtps2udq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2udq {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0xb9,0x79,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtps2udq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2udq {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0xb9,0x79,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvtps2udq256(<8 x float> %b, <8 x i32> zeroinitializer, i8 %a, i32 9)
  ret <8 x i32> %ret
}

declare <4 x i64> @llvm.x86.avx10.mask.vcvtps2uqq256(<4 x float>, <4 x i64>, i8, i32)
define <4 x i64> @test_int_x86_vcvtps2uqq256(<4 x float> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvtps2uqq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtps2uqq {rz-sae}, %xmm0, %ymm0 # encoding: [0x62,0xf1,0x79,0x78,0x79,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtps2uqq256(<4 x float> %a, <4 x i64> undef, i8 -1, i32 11)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_mask_vcvtps2uqq256(<4 x i64> %a, i8 %b, <4 x float> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtps2uqq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2uqq {ru-sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x79,0x59,0x79,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtps2uqq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2uqq {ru-sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x79,0x59,0x79,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtps2uqq256(<4 x float> %c, <4 x i64> %a, i8 %b, i32 10)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_maskz_vcvtps2uqq256(i8 %a, <4 x float> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtps2uqq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtps2uqq {rd-sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x79,0xb9,0x79,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtps2uqq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtps2uqq {rd-sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x79,0xb9,0x79,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvtps2uqq256(<4 x float> %b, <4 x i64> zeroinitializer, i8 %a, i32 9)
  ret <4 x i64> %ret
}

declare <4 x double> @llvm.x86.avx512.sitofp.round.v4f64.v4i64(<4 x i64>, i32)
define <4 x double> @test_int_x86_vcvtqq2pd256(<4 x i64> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvtqq2pd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtqq2pd {rn-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf1,0xfa,0x18,0xe6,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx512.sitofp.round.v4f64.v4i64(<4 x i64> %a, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vcvtqq2pd256(<4 x double> %a, i4 %b, <4 x i64> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtqq2pd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtqq2pd {rn-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xfa,0x19,0xe6,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtqq2pd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtqq2pd {rn-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xfa,0x19,0xe6,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx512.sitofp.round.v4f64.v4i64(<4 x i64> %c, i32 8)
  %msk = bitcast i4 %b to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> %a
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vcvtqq2pd256(i4 %a, <4 x i64> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtqq2pd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtqq2pd {rn-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xfa,0x99,0xe6,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtqq2pd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtqq2pd {rn-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xfa,0x99,0xe6,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx512.sitofp.round.v4f64.v4i64(<4 x i64> %b, i32 8)
  %msk = bitcast i4 %a to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> zeroinitializer
  ret <4 x double> %ret
}

declare <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v4i64(<4 x i64>, i32)
define <8 x half> @test_int_x86_vcvtqq2ph256(<4 x i64> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvtqq2ph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtqq2ph {rn-sae}, %ymm0, %xmm0 # encoding: [0x62,0xf5,0xf8,0x18,0x5b,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v4i64(<4 x i64> %a, i32 8)
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_mask_vcvtqq2ph256(<8 x half> %a, i8 %b, <4 x i64> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtqq2ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtqq2ph {rn-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0xf8,0x19,0x5b,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtqq2ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtqq2ph {rn-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0xf8,0x19,0x5b,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v4i64(<4 x i64> %c, i32 8)
  %msk = bitcast i8 %b to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x half> %ret0, <8 x half> %a
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_maskz_vcvtqq2ph256(i8 %a, <4 x i64> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtqq2ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtqq2ph {rn-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xf8,0x99,0x5b,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtqq2ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtqq2ph {rn-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xf8,0x99,0x5b,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v4i64(<4 x i64> %b, i32 8)
  %msk = bitcast i8 %a to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x half> %ret0, <8 x half> zeroinitializer
  ret <8 x half> %ret
}

declare <4 x float> @llvm.x86.avx512.sitofp.round.v4f32.v4i64(<4 x i64>, i32)
define <4 x float> @test_int_x86_vcvtqq2ps256(<4 x i64> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvtqq2ps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtqq2ps {rn-sae}, %ymm0, %xmm0 # encoding: [0x62,0xf1,0xf8,0x18,0x5b,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x float> @llvm.x86.avx512.sitofp.round.v4f32.v4i64(<4 x i64> %a, i32 8)
  ret <4 x float> %ret
}

define <4 x float> @test_int_x86_mask_vcvtqq2ps256(<4 x float> %a, i4 %b, <4 x i64> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtqq2ps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtqq2ps {rn-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf1,0xf8,0x19,0x5b,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtqq2ps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtqq2ps {rn-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf1,0xf8,0x19,0x5b,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x float> @llvm.x86.avx512.sitofp.round.v4f32.v4i64(<4 x i64> %c, i32 8)
  %msk = bitcast i4 %b to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x float> %ret0, <4 x float> %a
  ret <4 x float> %ret
}

define <4 x float> @test_int_x86_maskz_vcvtqq2ps256(i4 %a, <4 x i64> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtqq2ps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtqq2ps {rn-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf1,0xf8,0x99,0x5b,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtqq2ps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtqq2ps {rn-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf1,0xf8,0x99,0x5b,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x float> @llvm.x86.avx512.sitofp.round.v4f32.v4i64(<4 x i64> %b, i32 8)
  %msk = bitcast i4 %a to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x float> %ret0, <4 x float> zeroinitializer
  ret <4 x float> %ret
}

declare <4 x i32> @llvm.x86.avx10.mask.vcvttpd2dq256(<4 x double>, <4 x i32>, i8, i32)
define <4 x i32> @test_int_x86_vcvttpd2dq256(<4 x double> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvttpd2dq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2dq {sae}, %ymm0, %xmm0 # encoding: [0x62,0xf1,0xf9,0x18,0xe6,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2dq256(<4 x double> %a, <4 x i32> undef, i8 -1, i32 8)
  ret <4 x i32> %ret
}

define <4 x i32> @test_int_x86_mask_vcvttpd2dq256(<4 x i32> %a, i8 %b, <4 x double> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvttpd2dq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2dq {sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf1,0xf9,0x19,0xe6,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvttpd2dq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2dq {sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf1,0xf9,0x19,0xe6,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2dq256(<4 x double> %c, <4 x i32> %a, i8 %b, i32 8)
  ret <4 x i32> %ret
}

define <4 x i32> @test_int_x86_maskz_vcvttpd2dq256(i8 %a, <4 x double> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvttpd2dq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2dq {sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0x99,0xe6,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvttpd2dq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2dq {sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0x99,0xe6,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2dq256(<4 x double> %b, <4 x i32> zeroinitializer, i8 %a, i32 8)
  ret <4 x i32> %ret
}

declare <4 x i64> @llvm.x86.avx10.mask.vcvttpd2qq256(<4 x double>, <4 x i64>, i8, i32)
define <4 x i64> @test_int_x86_vcvttpd2qq256(<4 x double> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvttpd2qq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2qq {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf1,0xf9,0x18,0x7a,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttpd2qq256(<4 x double> %a, <4 x i64> undef, i8 -1, i32 8)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_mask_vcvttpd2qq256(<4 x i64> %a, i8 %b, <4 x double> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvttpd2qq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2qq {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf9,0x19,0x7a,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvttpd2qq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2qq {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf9,0x19,0x7a,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttpd2qq256(<4 x double> %c, <4 x i64> %a, i8 %b, i32 8)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_maskz_vcvttpd2qq256(i8 %a, <4 x double> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvttpd2qq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2qq {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0x99,0x7a,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvttpd2qq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2qq {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0x99,0x7a,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttpd2qq256(<4 x double> %b, <4 x i64> zeroinitializer, i8 %a, i32 8)
  ret <4 x i64> %ret
}

declare <4 x i32> @llvm.x86.avx10.mask.vcvttpd2udq256(<4 x double>, <4 x i32>, i8, i32)
define <4 x i32> @test_int_x86_vcvttpd2udq256(<4 x double> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvttpd2udq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2udq {sae}, %ymm0, %xmm0 # encoding: [0x62,0xf1,0xf8,0x18,0x78,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2udq256(<4 x double> %a, <4 x i32> undef, i8 -1, i32 8)
  ret <4 x i32> %ret
}

define <4 x i32> @test_int_x86_mask_vcvttpd2udq256(<4 x i32> %a, i8 %b, <4 x double> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvttpd2udq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2udq {sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf1,0xf8,0x19,0x78,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvttpd2udq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2udq {sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf1,0xf8,0x19,0x78,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2udq256(<4 x double> %c, <4 x i32> %a, i8 %b, i32 8)
  ret <4 x i32> %ret
}

define <4 x i32> @test_int_x86_maskz_vcvttpd2udq256(i8 %a, <4 x double> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvttpd2udq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2udq {sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf1,0xf8,0x99,0x78,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvttpd2udq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2udq {sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf1,0xf8,0x99,0x78,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2udq256(<4 x double> %b, <4 x i32> zeroinitializer, i8 %a, i32 8)
  ret <4 x i32> %ret
}

declare <4 x i64> @llvm.x86.avx10.mask.vcvttpd2uqq256(<4 x double>, <4 x i64>, i8, i32)
define <4 x i64> @test_int_x86_vcvttpd2uqq256(<4 x double> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvttpd2uqq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2uqq {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf1,0xf9,0x18,0x78,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttpd2uqq256(<4 x double> %a, <4 x i64> undef, i8 -1, i32 8)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_mask_vcvttpd2uqq256(<4 x i64> %a, i8 %b, <4 x double> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvttpd2uqq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2uqq {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf9,0x19,0x78,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvttpd2uqq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2uqq {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf9,0x19,0x78,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttpd2uqq256(<4 x double> %c, <4 x i64> %a, i8 %b, i32 8)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_maskz_vcvttpd2uqq256(i8 %a, <4 x double> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvttpd2uqq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2uqq {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0x99,0x78,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvttpd2uqq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2uqq {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0x99,0x78,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttpd2uqq256(<4 x double> %b, <4 x i64> zeroinitializer, i8 %a, i32 8)
  ret <4 x i64> %ret
}

declare <8 x i32> @llvm.x86.avx10.mask.vcvttph2dq256(<8 x half>, <8 x i32>, i8, i32)
define <8 x i32> @test_int_x86_vcvttph2dq256(<8 x half> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvttph2dq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2dq {sae}, %xmm0, %ymm0 # encoding: [0x62,0xf5,0x7a,0x18,0x5b,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvttph2dq256(<8 x half> %a, <8 x i32> undef, i8 -1, i32 8)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_mask_vcvttph2dq256(<8 x i32> %a, i8 %b, <8 x half> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvttph2dq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2dq {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x7a,0x19,0x5b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvttph2dq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2dq {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x7a,0x19,0x5b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvttph2dq256(<8 x half> %c, <8 x i32> %a, i8 %b, i32 8)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_maskz_vcvttph2dq256(i8 %a, <8 x half> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvttph2dq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2dq {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7a,0x99,0x5b,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvttph2dq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2dq {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7a,0x99,0x5b,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvttph2dq256(<8 x half> %b, <8 x i32> zeroinitializer, i8 %a, i32 8)
  ret <8 x i32> %ret
}

declare <4 x i64> @llvm.x86.avx10.mask.vcvttph2qq256(<8 x half>, <4 x i64>, i8, i32)
define <4 x i64> @test_int_x86_vcvttph2qq256(<8 x half> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvttph2qq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2qq {sae}, %xmm0, %ymm0 # encoding: [0x62,0xf5,0x79,0x18,0x7a,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttph2qq256(<8 x half> %a, <4 x i64> undef, i8 -1, i32 8)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_mask_vcvttph2qq256(<4 x i64> %a, i8 %b, <8 x half> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvttph2qq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2qq {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x79,0x19,0x7a,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvttph2qq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2qq {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x79,0x19,0x7a,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttph2qq256(<8 x half> %c, <4 x i64> %a, i8 %b, i32 8)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_maskz_vcvttph2qq256(i8 %a, <8 x half> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvttph2qq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2qq {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0x99,0x7a,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvttph2qq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2qq {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0x99,0x7a,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttph2qq256(<8 x half> %b, <4 x i64> zeroinitializer, i8 %a, i32 8)
  ret <4 x i64> %ret
}

declare <8 x i32> @llvm.x86.avx10.mask.vcvttph2udq256(<8 x half>, <8 x i32>, i8, i32)
define <8 x i32> @test_int_x86_vcvttph2udq256(<8 x half> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvttph2udq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2udq {sae}, %xmm0, %ymm0 # encoding: [0x62,0xf5,0x78,0x18,0x78,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvttph2udq256(<8 x half> %a, <8 x i32> undef, i8 -1, i32 8)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_mask_vcvttph2udq256(<8 x i32> %a, i8 %b, <8 x half> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvttph2udq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2udq {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x78,0x19,0x78,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvttph2udq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2udq {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x78,0x19,0x78,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvttph2udq256(<8 x half> %c, <8 x i32> %a, i8 %b, i32 8)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_maskz_vcvttph2udq256(i8 %a, <8 x half> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvttph2udq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2udq {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0x99,0x78,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvttph2udq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2udq {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0x99,0x78,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvttph2udq256(<8 x half> %b, <8 x i32> zeroinitializer, i8 %a, i32 8)
  ret <8 x i32> %ret
}

declare <4 x i64> @llvm.x86.avx10.mask.vcvttph2uqq256(<8 x half>, <4 x i64>, i8, i32)
define <4 x i64> @test_int_x86_vcvttph2uqq256(<8 x half> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvttph2uqq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2uqq {sae}, %xmm0, %ymm0 # encoding: [0x62,0xf5,0x79,0x18,0x78,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttph2uqq256(<8 x half> %a, <4 x i64> undef, i8 -1, i32 8)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_mask_vcvttph2uqq256(<4 x i64> %a, i8 %b, <8 x half> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvttph2uqq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2uqq {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x79,0x19,0x78,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvttph2uqq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2uqq {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x79,0x19,0x78,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttph2uqq256(<8 x half> %c, <4 x i64> %a, i8 %b, i32 8)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_maskz_vcvttph2uqq256(i8 %a, <8 x half> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvttph2uqq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2uqq {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0x99,0x78,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvttph2uqq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2uqq {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0x99,0x78,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttph2uqq256(<8 x half> %b, <4 x i64> zeroinitializer, i8 %a, i32 8)
  ret <4 x i64> %ret
}

declare <16 x i16> @llvm.x86.avx10.mask.vcvttph2uw256(<16 x half>, <16 x i16>, i16, i32)
define <16 x i16> @test_int_x86_vcvttph2uw256(<16 x half> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvttph2uw256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2uw {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x78,0x18,0x7c,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i16> @llvm.x86.avx10.mask.vcvttph2uw256(<16 x half> %a, <16 x i16> undef, i16 -1, i32 8)
  ret <16 x i16> %ret
}

define <16 x i16> @test_int_x86_mask_vcvttph2uw256(<16 x i16> %a, i16 %b, <16 x half> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvttph2uw256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2uw {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x78,0x19,0x7c,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvttph2uw256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2uw {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x78,0x19,0x7c,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x i16> @llvm.x86.avx10.mask.vcvttph2uw256(<16 x half> %c, <16 x i16> %a, i16 %b, i32 8)
  ret <16 x i16> %ret
}

define <16 x i16> @test_int_x86_maskz_vcvttph2uw256(i16 %a, <16 x half> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvttph2uw256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2uw {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0x99,0x7c,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvttph2uw256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2uw {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0x99,0x7c,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x i16> @llvm.x86.avx10.mask.vcvttph2uw256(<16 x half> %b, <16 x i16> zeroinitializer, i16 %a, i32 8)
  ret <16 x i16> %ret
}

declare <16 x i16> @llvm.x86.avx10.mask.vcvttph2w256(<16 x half>, <16 x i16>, i16, i32)
define <16 x i16> @test_int_x86_vcvttph2w256(<16 x half> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvttph2w256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2w {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x79,0x18,0x7c,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i16> @llvm.x86.avx10.mask.vcvttph2w256(<16 x half> %a, <16 x i16> undef, i16 -1, i32 8)
  ret <16 x i16> %ret
}

define <16 x i16> @test_int_x86_mask_vcvttph2w256(<16 x i16> %a, i16 %b, <16 x half> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvttph2w256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2w {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x79,0x19,0x7c,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvttph2w256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2w {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x79,0x19,0x7c,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x i16> @llvm.x86.avx10.mask.vcvttph2w256(<16 x half> %c, <16 x i16> %a, i16 %b, i32 8)
  ret <16 x i16> %ret
}

define <16 x i16> @test_int_x86_maskz_vcvttph2w256(i16 %a, <16 x half> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvttph2w256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttph2w {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0x99,0x7c,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvttph2w256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttph2w {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x79,0x99,0x7c,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x i16> @llvm.x86.avx10.mask.vcvttph2w256(<16 x half> %b, <16 x i16> zeroinitializer, i16 %a, i32 8)
  ret <16 x i16> %ret
}

declare <8 x i32> @llvm.x86.avx10.mask.vcvttps2dq256(<8 x float>, <8 x i32>, i8, i32)
define <8 x i32> @test_int_x86_vcvttps2dq256(<8 x float> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvttps2dq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2dq {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf1,0x7a,0x18,0x5b,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvttps2dq256(<8 x float> %a, <8 x i32> undef, i8 -1, i32 8)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_mask_vcvttps2dq256(<8 x i32> %a, i8 %b, <8 x float> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvttps2dq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2dq {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x7a,0x19,0x5b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvttps2dq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2dq {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x7a,0x19,0x5b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvttps2dq256(<8 x float> %c, <8 x i32> %a, i8 %b, i32 8)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_maskz_vcvttps2dq256(i8 %a, <8 x float> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvttps2dq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2dq {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x7a,0x99,0x5b,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvttps2dq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2dq {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x7a,0x99,0x5b,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvttps2dq256(<8 x float> %b, <8 x i32> zeroinitializer, i8 %a, i32 8)
  ret <8 x i32> %ret
}

declare <4 x i64> @llvm.x86.avx10.mask.vcvttps2qq256(<4 x float>, <4 x i64>, i8, i32)
define <4 x i64> @test_int_x86_vcvttps2qq256(<4 x float> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvttps2qq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2qq {sae}, %xmm0, %ymm0 # encoding: [0x62,0xf1,0x79,0x18,0x7a,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttps2qq256(<4 x float> %a, <4 x i64> undef, i8 -1, i32 8)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_mask_vcvttps2qq256(<4 x i64> %a, i8 %b, <4 x float> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvttps2qq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2qq {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x79,0x19,0x7a,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvttps2qq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2qq {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x79,0x19,0x7a,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttps2qq256(<4 x float> %c, <4 x i64> %a, i8 %b, i32 8)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_maskz_vcvttps2qq256(i8 %a, <4 x float> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvttps2qq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2qq {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x79,0x99,0x7a,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvttps2qq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2qq {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x79,0x99,0x7a,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttps2qq256(<4 x float> %b, <4 x i64> zeroinitializer, i8 %a, i32 8)
  ret <4 x i64> %ret
}

declare <8 x i32> @llvm.x86.avx10.mask.vcvttps2udq256(<8 x float>, <8 x i32>, i8, i32)
define <8 x i32> @test_int_x86_vcvttps2udq256(<8 x float> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvttps2udq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2udq {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf1,0x78,0x18,0x78,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvttps2udq256(<8 x float> %a, <8 x i32> undef, i8 -1, i32 8)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_mask_vcvttps2udq256(<8 x i32> %a, i8 %b, <8 x float> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvttps2udq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2udq {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x78,0x19,0x78,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvttps2udq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2udq {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x78,0x19,0x78,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvttps2udq256(<8 x float> %c, <8 x i32> %a, i8 %b, i32 8)
  ret <8 x i32> %ret
}

define <8 x i32> @test_int_x86_maskz_vcvttps2udq256(i8 %a, <8 x float> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvttps2udq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2udq {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0x99,0x78,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvttps2udq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2udq {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0x99,0x78,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x i32> @llvm.x86.avx10.mask.vcvttps2udq256(<8 x float> %b, <8 x i32> zeroinitializer, i8 %a, i32 8)
  ret <8 x i32> %ret
}

declare <4 x i64> @llvm.x86.avx10.mask.vcvttps2uqq256(<4 x float>, <4 x i64>, i8, i32)
define <4 x i64> @test_int_x86_vcvttps2uqq256(<4 x float> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvttps2uqq256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2uqq {sae}, %xmm0, %ymm0 # encoding: [0x62,0xf1,0x79,0x18,0x78,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttps2uqq256(<4 x float> %a, <4 x i64> undef, i8 -1, i32 8)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_mask_vcvttps2uqq256(<4 x i64> %a, i8 %b, <4 x float> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvttps2uqq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2uqq {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x79,0x19,0x78,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvttps2uqq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2uqq {sae}, %xmm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x79,0x19,0x78,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttps2uqq256(<4 x float> %c, <4 x i64> %a, i8 %b, i32 8)
  ret <4 x i64> %ret
}

define <4 x i64> @test_int_x86_maskz_vcvttps2uqq256(i8 %a, <4 x float> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvttps2uqq256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2uqq {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x79,0x99,0x78,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvttps2uqq256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2uqq {sae}, %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x79,0x99,0x78,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x i64> @llvm.x86.avx10.mask.vcvttps2uqq256(<4 x float> %b, <4 x i64> zeroinitializer, i8 %a, i32 8)
  ret <4 x i64> %ret
}

declare <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v8i32(<8 x i32>, i32)
define <8 x half> @test_int_x86_vcvtudq2ph256(<8 x i32> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtudq2ph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtudq2ph {rz-sae}, %ymm0, %xmm0 # encoding: [0x62,0xf5,0x7b,0x78,0x7a,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v8i32(<8 x i32> %A, i32 11)
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_mask_vcvtudq2ph256(<8 x half> %A, i8 %B, <8 x i32> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtudq2ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtudq2ph {ru-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x7b,0x59,0x7a,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtudq2ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtudq2ph {ru-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x7b,0x59,0x7a,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v8i32(<8 x i32> %C, i32 10)
  %msk = bitcast i8 %B to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x half> %ret0, <8 x half> %A
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_maskz_vcvtudq2ph256(i8 %A, <8 x i32> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtudq2ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtudq2ph {rd-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7b,0xb9,0x7a,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtudq2ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtudq2ph {rd-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7b,0xb9,0x7a,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v8i32(<8 x i32> %B, i32 9)
  %msk = bitcast i8 %A to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x half> %ret0, <8 x half> zeroinitializer
  ret <8 x half> %ret
}

declare <8 x float> @llvm.x86.avx512.uitofp.round.v8f32.v8i32(<8 x i32>, i32)
define <8 x float> @test_int_x86_vcvtudq2ps256(<8 x i32> %A) nounwind {
; CHECK-LABEL: test_int_x86_vcvtudq2ps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtudq2ps {rz-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf1,0x7b,0x78,0x7a,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx512.uitofp.round.v8f32.v8i32(<8 x i32> %A, i32 11)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vcvtudq2ps256(<8 x float> %A, i8 %B, <8 x i32> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtudq2ps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtudq2ps {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x7b,0x59,0x7a,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtudq2ps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtudq2ps {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x7b,0x59,0x7a,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx512.uitofp.round.v8f32.v8i32(<8 x i32> %C, i32 10)
  %msk = bitcast i8 %B to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> %A
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vcvtudq2ps256(i8 %A, <8 x i32> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtudq2ps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtudq2ps {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x7b,0xb9,0x7a,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtudq2ps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtudq2ps {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x7b,0xb9,0x7a,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx512.uitofp.round.v8f32.v8i32(<8 x i32> %B, i32 9)
  %msk = bitcast i8 %A to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> zeroinitializer
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx512.uitofp.round.v4f64.v4i64(<4 x i64>, i32)
define <4 x double> @test_int_x86_vcvtuqq2pd256(<4 x i64> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvtuqq2pd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtuqq2pd {rn-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf1,0xfa,0x18,0x7a,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx512.uitofp.round.v4f64.v4i64(<4 x i64> %a, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vcvtuqq2pd256(<4 x double> %a, i4 %b, <4 x i64> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtuqq2pd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtuqq2pd {rn-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xfa,0x19,0x7a,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtuqq2pd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtuqq2pd {rn-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xfa,0x19,0x7a,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx512.uitofp.round.v4f64.v4i64(<4 x i64> %c, i32 8)
  %msk = bitcast i4 %b to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> %a
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vcvtuqq2pd256(i4 %a, <4 x i64> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtuqq2pd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtuqq2pd {rn-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xfa,0x99,0x7a,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtuqq2pd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtuqq2pd {rn-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xfa,0x99,0x7a,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx512.uitofp.round.v4f64.v4i64(<4 x i64> %b, i32 8)
  %msk = bitcast i4 %a to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> zeroinitializer
  ret <4 x double> %ret
}

declare <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v4i64(<4 x i64>, i32)
define <8 x half> @test_int_x86_vcvtuqq2ph256(<4 x i64> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvtuqq2ph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtuqq2ph {rn-sae}, %ymm0, %xmm0 # encoding: [0x62,0xf5,0xfb,0x18,0x7a,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v4i64(<4 x i64> %a, i32 8)
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_mask_vcvtuqq2ph256(<8 x half> %a, i8 %b, <4 x i64> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtuqq2ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtuqq2ph {rn-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0xfb,0x19,0x7a,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtuqq2ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtuqq2ph {rn-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0xfb,0x19,0x7a,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v4i64(<4 x i64> %c, i32 8)
  %msk = bitcast i8 %b to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x half> %ret0, <8 x half> %a
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_maskz_vcvtuqq2ph256(i8 %a, <4 x i64> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtuqq2ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtuqq2ph {rn-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfb,0x99,0x7a,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtuqq2ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtuqq2ph {rn-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfb,0x99,0x7a,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v4i64(<4 x i64> %b, i32 8)
  %msk = bitcast i8 %a to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x half> %ret0, <8 x half> zeroinitializer
  ret <8 x half> %ret
}

declare <4 x float> @llvm.x86.avx512.uitofp.round.v4f32.v4i64(<4 x i64>, i32)
define <4 x float> @test_int_x86_vcvtuqq2ps256(<4 x i64> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvtuqq2ps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtuqq2ps {rn-sae}, %ymm0, %xmm0 # encoding: [0x62,0xf1,0xfb,0x18,0x7a,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x float> @llvm.x86.avx512.uitofp.round.v4f32.v4i64(<4 x i64> %a, i32 8)
  ret <4 x float> %ret
}

define <4 x float> @test_int_x86_mask_vcvtuqq2ps256(<4 x float> %a, i4 %b, <4 x i64> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtuqq2ps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtuqq2ps {rn-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf1,0xfb,0x19,0x7a,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtuqq2ps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtuqq2ps {rn-sae}, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf1,0xfb,0x19,0x7a,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x float> @llvm.x86.avx512.uitofp.round.v4f32.v4i64(<4 x i64> %c, i32 8)
  %msk = bitcast i4 %b to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x float> %ret0, <4 x float> %a
  ret <4 x float> %ret
}

define <4 x float> @test_int_x86_maskz_vcvtuqq2ps256(i4 %a, <4 x i64> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtuqq2ps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtuqq2ps {rn-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf1,0xfb,0x99,0x7a,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtuqq2ps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtuqq2ps {rn-sae}, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf1,0xfb,0x99,0x7a,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x float> @llvm.x86.avx512.uitofp.round.v4f32.v4i64(<4 x i64> %b, i32 8)
  %msk = bitcast i4 %a to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x float> %ret0, <4 x float> zeroinitializer
  ret <4 x float> %ret
}

declare <16 x half> @llvm.x86.avx512.uitofp.round.v16f16.v16i16(<16 x i16>, i32)
define <16 x half> @test_int_x86_vcvtuw2ph256(<16 x i16> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvtuw2ph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtuw2ph {rn-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x7b,0x18,0x7d,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx512.uitofp.round.v16f16.v16i16(<16 x i16> %a, i32 8)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vcvtuw2ph256(<16 x half> %a, i16 %b, <16 x i16> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtuw2ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtuw2ph {rn-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x7b,0x19,0x7d,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtuw2ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtuw2ph {rn-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x7b,0x19,0x7d,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx512.uitofp.round.v16f16.v16i16(<16 x i16> %c, i32 8)
  %msk = bitcast i16 %b to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> %a
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vcvtuw2ph256(i16 %a, <16 x i16> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtuw2ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtuw2ph {rn-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7b,0x99,0x7d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtuw2ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtuw2ph {rn-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7b,0x99,0x7d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx512.uitofp.round.v16f16.v16i16(<16 x i16> %b, i32 8)
  %msk = bitcast i16 %a to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> zeroinitializer
  ret <16 x half> %ret
}

declare <16 x half> @llvm.x86.avx512.sitofp.round.v16f16.v16i16(<16 x i16>, i32)
define <16 x half> @test_int_x86_vcvtw2ph256(<16 x i16> %a) nounwind {
; CHECK-LABEL: test_int_x86_vcvtw2ph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtw2ph {rn-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x7a,0x18,0x7d,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx512.sitofp.round.v16f16.v16i16(<16 x i16> %a, i32 8)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vcvtw2ph256(<16 x half> %a, i16 %b, <16 x i16> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vcvtw2ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtw2ph {rn-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x7a,0x19,0x7d,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vcvtw2ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtw2ph {rn-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x7a,0x19,0x7d,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx512.sitofp.round.v16f16.v16i16(<16 x i16> %c, i32 8)
  %msk = bitcast i16 %b to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> %a
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vcvtw2ph256(i16 %a, <16 x i16> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vcvtw2ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtw2ph {rn-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7a,0x99,0x7d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vcvtw2ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtw2ph {rn-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7a,0x99,0x7d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx512.sitofp.round.v16f16.v16i16(<16 x i16> %b, i32 8)
  %msk = bitcast i16 %a to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> zeroinitializer
  ret <16 x half> %ret
}

declare <4 x double> @llvm.x86.avx10.vdivpd256(<4 x double>, <4 x double>, i32)
define <4 x double> @test_int_x86_vdivpd256(<4 x double> %A, <4 x double> %B) nounwind {
; CHECK-LABEL: test_int_x86_vdivpd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vdivpd {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf1,0xf9,0x78,0x5e,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.vdivpd256(<4 x double> %A, <4 x double> %B, i32 11)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vdivpd256(<4 x double> %A, i4 %B, <4 x double> %C, <4 x double> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vdivpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vdivpd {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf1,0x59,0x5e,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vdivpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vdivpd {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf1,0x59,0x5e,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vdivpd256(<4 x double> %C, <4 x double> %D, i32 10)
  %msk = bitcast i4 %B to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> %A
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vdivpd256(i4 %A, <4 x double> %B, <4 x double> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vdivpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vdivpd {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x5e,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vdivpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vdivpd {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x5e,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vdivpd256(<4 x double> %B, <4 x double> %C, i32 9)
  %msk = bitcast i4 %A to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> zeroinitializer
  ret <4 x double> %ret
}

declare <16 x half> @llvm.x86.avx10.vdivph256(<16 x half>, <16 x half>, i32)
define <16 x half> @test_int_x86_vdivph256(<16 x half> %A, <16 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_vdivph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vdivph {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x78,0x78,0x5e,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.vdivph256(<16 x half> %A, <16 x half> %B, i32 11)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vdivph256(<16 x half> %A, i16 %B, <16 x half> %C, <16 x half> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vdivph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vdivph {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x70,0x59,0x5e,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vdivph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vdivph {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x70,0x59,0x5e,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vdivph256(<16 x half> %C, <16 x half> %D, i32 10)
  %msk = bitcast i16 %B to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> %A
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vdivph256(i16 %A, <16 x half> %B, <16 x half> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vdivph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vdivph {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x5e,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vdivph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vdivph {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x5e,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vdivph256(<16 x half> %B, <16 x half> %C, i32 9)
  %msk = bitcast i16 %A to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> zeroinitializer
  ret <16 x half> %ret
}

declare <8 x float> @llvm.x86.avx10.vdivps256(<8 x float>, <8 x float>, i32)
define <8 x float> @test_int_x86_vdivps256(<8 x float> %A, <8 x float> %B) nounwind {
; CHECK-LABEL: test_int_x86_vdivps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vdivps {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf1,0x78,0x78,0x5e,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.vdivps256(<8 x float> %A, <8 x float> %B, i32 11)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vdivps256(<8 x float> %A, i8 %B, <8 x float> %C, <8 x float> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vdivps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vdivps {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x70,0x59,0x5e,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vdivps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vdivps {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x70,0x59,0x5e,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vdivps256(<8 x float> %C, <8 x float> %D, i32 10)
  %msk = bitcast i8 %B to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> %A
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vdivps256(i8 %A, <8 x float> %B, <8 x float> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vdivps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vdivps {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0xb9,0x5e,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vdivps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vdivps {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0xb9,0x5e,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vdivps256(<8 x float> %B, <8 x float> %C, i32 9)
  %msk = bitcast i8 %A to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> zeroinitializer
  ret <8 x float> %ret
}

declare <8 x float> @llvm.x86.avx10.mask.vfcmaddcph256(<8 x float>, <8 x float>, <8 x float>, i8, i32)
define <8 x float> @test_int_x86_vfcmaddcph256(<8 x float> %a, <8 x float> %b, <8 x float> %c) nounwind {
; CHECK-LABEL: test_int_x86_vfcmaddcph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfcmaddcph {rz-sae}, %ymm1, %ymm0, %ymm2 # encoding: [0x62,0xf6,0x7b,0x78,0x56,0xd1]
; CHECK-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vfcmaddcph256(<8 x float> %a, <8 x float> %b, <8 x float> %c, i8 -1, i32 11)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vfcmaddcph256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x float> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vfcmaddcph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfcmaddcph {ru-sae}, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf6,0x7b,0x59,0x56,0xd1]
; X86-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vfcmaddcph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfcmaddcph {ru-sae}, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf6,0x7b,0x59,0x56,0xd1]
; X64-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vfcmaddcph256(<8 x float> %a, <8 x float> %c, <8 x float> %d, i8 %b, i32 10)
  ret <8 x float> %ret
}

declare <8 x float> @llvm.x86.avx10.maskz.vfcmaddcph256(<8 x float>, <8 x float>, <8 x float>, i8, i32)
define <8 x float> @test_int_x86_maskz_vfcmaddcph256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x float> %d) nounwind {
; X86-LABEL: test_int_x86_maskz_vfcmaddcph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfcmaddcph {rd-sae}, %ymm1, %ymm0, %ymm2 {%k1} {z} # encoding: [0x62,0xf6,0x7b,0xb9,0x56,0xd1]
; X86-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vfcmaddcph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfcmaddcph {rd-sae}, %ymm1, %ymm0, %ymm2 {%k1} {z} # encoding: [0x62,0xf6,0x7b,0xb9,0x56,0xd1]
; X64-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.maskz.vfcmaddcph256(<8 x float> %a, <8 x float> %c, <8 x float> %d, i8 %b, i32 9)
  ret <8 x float> %ret
}

declare <8 x float> @llvm.x86.avx10.mask.vfcmulcph256(<8 x float>, <8 x float>, <8 x float>, i8, i32)
define <8 x float> @test_int_x86_vfcmulcph256(<8 x float> %a, <8 x float> %b, <8 x float> %c) nounwind {
; CHECK-LABEL: test_int_x86_vfcmulcph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfcmulcph {rz-sae}, %ymm1, %ymm0, %ymm2 # encoding: [0x62,0xf6,0x7b,0x78,0xd6,0xd1]
; CHECK-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vfcmulcph256(<8 x float> %a, <8 x float> %b, <8 x float> %c, i8 -1, i32 11)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vfcmulcph256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x float> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vfcmulcph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfcmulcph {ru-sae}, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf6,0x7b,0x59,0xd6,0xd1]
; X86-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vfcmulcph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfcmulcph {ru-sae}, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf6,0x7b,0x59,0xd6,0xd1]
; X64-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vfcmulcph256(<8 x float> %a, <8 x float> %c, <8 x float> %d, i8 %b, i32 10)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vfcmulcph256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x float> %d) nounwind {
; X86-LABEL: test_int_x86_maskz_vfcmulcph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfcmulcph {rd-sae}, %ymm1, %ymm0, %ymm2 {%k1} {z} # encoding: [0x62,0xf6,0x7b,0xb9,0xd6,0xd1]
; X86-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vfcmulcph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfcmulcph {rd-sae}, %ymm1, %ymm0, %ymm2 {%k1} {z} # encoding: [0x62,0xf6,0x7b,0xb9,0xd6,0xd1]
; X64-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vfcmulcph256(<8 x float> %a, <8 x float> %c, <8 x float> zeroinitializer, i8 %b, i32 9)
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx10.mask.vfixupimmpd256(<4 x double>, <4 x double>, <4 x i64>, i32, i8, i32)
define <4 x double> @test_int_x86_vfixupimmpd256(<4 x double> %a, <4 x double> %b, <4 x i64> %c) nounwind {
; CHECK-LABEL: test_int_x86_vfixupimmpd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfixupimmpd $127, {sae}, %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf3,0xf1,0x18,0x54,0xc2,0x7f]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vfixupimmpd256(<4 x double> %a, <4 x double> %b, <4 x i64> %c, i32 127, i8 -1, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vfixupimmpd256(<4 x double> %a, i8 %b, <4 x double> %c, <4 x i64> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vfixupimmpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfixupimmpd $127, {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0xf1,0x19,0x54,0xc2,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vfixupimmpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfixupimmpd $127, {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0xf1,0x19,0x54,0xc2,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vfixupimmpd256(<4 x double> %a, <4 x double> %c, <4 x i64> %d, i32 127, i8 %b, i32 8)
  ret <4 x double> %ret
}

declare <4 x double> @llvm.x86.avx10.maskz.vfixupimmpd256(<4 x double>, <4 x double>, <4 x i64>, i32, i8, i32)
define <4 x double> @test_int_x86_maskz_vfixupimmpd256(<4 x double> %a, i8 %b, <4 x double> %c, <4 x i64> %d) nounwind {
; X86-LABEL: test_int_x86_maskz_vfixupimmpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfixupimmpd $127, {sae}, %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0xf1,0x99,0x54,0xc2,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vfixupimmpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfixupimmpd $127, {sae}, %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0xf1,0x99,0x54,0xc2,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.maskz.vfixupimmpd256(<4 x double> %a, <4 x double> %c, <4 x i64> %d, i32 127, i8 %b, i32 8)
  ret <4 x double> %ret
}

declare <8 x float> @llvm.x86.avx10.mask.vfixupimmps256(<8 x float>, <8 x float>, <8 x i32>, i32, i8, i32)
define <8 x float> @test_int_x86_vfixupimmps256(<8 x float> %a, <8 x float> %b, <8 x i32> %c) nounwind {
; CHECK-LABEL: test_int_x86_vfixupimmps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfixupimmps $127, {sae}, %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf3,0x71,0x18,0x54,0xc2,0x7f]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vfixupimmps256(<8 x float> %a, <8 x float> %b, <8 x i32> %c, i32 127, i8 -1, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vfixupimmps256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x i32> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vfixupimmps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfixupimmps $127, {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x71,0x19,0x54,0xc2,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vfixupimmps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfixupimmps $127, {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x71,0x19,0x54,0xc2,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vfixupimmps256(<8 x float> %a, <8 x float> %c, <8 x i32> %d, i32 127, i8 %b, i32 8)
  ret <8 x float> %ret
}

declare <8 x float> @llvm.x86.avx10.maskz.vfixupimmps256(<8 x float>, <8 x float>, <8 x i32>, i32, i8, i32)
define <8 x float> @test_int_x86_maskz_vfixupimmps256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x i32> %d) nounwind {
; X86-LABEL: test_int_x86_maskz_vfixupimmps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfixupimmps $127, {sae}, %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x71,0x99,0x54,0xc2,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vfixupimmps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfixupimmps $127, {sae}, %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x71,0x99,0x54,0xc2,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.maskz.vfixupimmps256(<8 x float> %a, <8 x float> %c, <8 x i32> %d, i32 127, i8 %b, i32 8)
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx10.vfmaddpd256(<4 x double>, <4 x double>, <4 x double>, i32)
define <4 x double> @test_int_x86_vfmaddpd256(<4 x double> %a, <4 x double> %b, <4 x double> %c) nounwind {
; CHECK-LABEL: test_int_x86_vfmaddpd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213pd {rz-sae}, %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf2,0xf1,0x78,0xa8,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.vfmaddpd256(<4 x double> %a, <4 x double> %b, <4 x double> %c, i32 11)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vfmaddpd256(<4 x double> %a, i4 %b, <4 x double> %c, <4 x double> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vfmaddpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmadd132pd {ru-sae}, %ymm1, %ymm2, %ymm0 {%k1} # encoding: [0x62,0xf2,0xe9,0x59,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vfmaddpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmadd132pd {ru-sae}, %ymm1, %ymm2, %ymm0 {%k1} # encoding: [0x62,0xf2,0xe9,0x59,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vfmaddpd256(<4 x double> %a, <4 x double> %c, <4 x double> %d, i32 10)
  %msk = bitcast i4 %b to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> %a
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vfmaddpd256(<4 x double> %a, i4 %b, <4 x double> %c, <4 x double> %d) nounwind {
; X86-LABEL: test_int_x86_maskz_vfmaddpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmadd132pd {rd-sae}, %ymm1, %ymm2, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0xe9,0xb9,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vfmaddpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmadd132pd {rd-sae}, %ymm1, %ymm2, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0xe9,0xb9,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vfmaddpd256(<4 x double> %a, <4 x double> %c, <4 x double> %d, i32 9)
  %msk = bitcast i4 %b to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> zeroinitializer
  ret <4 x double> %ret
}

declare <16 x half> @llvm.x86.avx10.vfmaddph256(<16 x half>, <16 x half>, <16 x half>, i32)
define <16 x half> @test_int_x86_vfmaddph256(<16 x half> %a, <16 x half> %b, <16 x half> %c) nounwind {
; CHECK-LABEL: test_int_x86_vfmaddph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213ph {rz-sae}, %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf6,0x71,0x78,0xa8,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.vfmaddph256(<16 x half> %a, <16 x half> %b, <16 x half> %c, i32 11)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vfmaddph256(<16 x half> %a, i16 %b, <16 x half> %c, <16 x half> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vfmaddph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmadd132ph {ru-sae}, %ymm1, %ymm2, %ymm0 {%k1} # encoding: [0x62,0xf6,0x69,0x59,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vfmaddph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmadd132ph {ru-sae}, %ymm1, %ymm2, %ymm0 {%k1} # encoding: [0x62,0xf6,0x69,0x59,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vfmaddph256(<16 x half> %a, <16 x half> %c, <16 x half> %d, i32 10)
  %msk = bitcast i16 %b to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> %a
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vfmaddph256(<16 x half> %a, i16 %b, <16 x half> %c, <16 x half> %d) nounwind {
; X86-LABEL: test_int_x86_maskz_vfmaddph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmadd132ph {rd-sae}, %ymm1, %ymm2, %ymm0 {%k1} {z} # encoding: [0x62,0xf6,0x69,0xb9,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vfmaddph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmadd132ph {rd-sae}, %ymm1, %ymm2, %ymm0 {%k1} {z} # encoding: [0x62,0xf6,0x69,0xb9,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vfmaddph256(<16 x half> %a, <16 x half> %c, <16 x half> %d, i32 9)
  %msk = bitcast i16 %b to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> zeroinitializer
  ret <16 x half> %ret
}

declare <8 x float> @llvm.x86.avx10.vfmaddps256(<8 x float>, <8 x float>, <8 x float>, i32)
define <8 x float> @test_int_x86_vfmaddps256(<8 x float> %a, <8 x float> %b, <8 x float> %c) nounwind {
; CHECK-LABEL: test_int_x86_vfmaddps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213ps {rz-sae}, %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf2,0x71,0x78,0xa8,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.vfmaddps256(<8 x float> %a, <8 x float> %b, <8 x float> %c, i32 11)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vfmaddps256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x float> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vfmaddps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmadd132ps {ru-sae}, %ymm1, %ymm2, %ymm0 {%k1} # encoding: [0x62,0xf2,0x69,0x59,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vfmaddps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmadd132ps {ru-sae}, %ymm1, %ymm2, %ymm0 {%k1} # encoding: [0x62,0xf2,0x69,0x59,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vfmaddps256(<8 x float> %a, <8 x float> %c, <8 x float> %d, i32 10)
  %msk = bitcast i8 %b to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> %a
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vfmaddps256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x float> %d) nounwind {
; X86-LABEL: test_int_x86_maskz_vfmaddps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmadd132ps {rd-sae}, %ymm1, %ymm2, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x69,0xb9,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vfmaddps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmadd132ps {rd-sae}, %ymm1, %ymm2, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x69,0xb9,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vfmaddps256(<8 x float> %a, <8 x float> %c, <8 x float> %d, i32 9)
  %msk = bitcast i8 %b to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> zeroinitializer
  ret <8 x float> %ret
}

declare <8 x float> @llvm.x86.avx10.mask.vfmaddcph256(<8 x float>, <8 x float>, <8 x float>, i8, i32)
define <8 x float> @test_int_x86_vfmaddcph256(<8 x float> %a, <8 x float> %b, <8 x float> %c) nounwind {
; CHECK-LABEL: test_int_x86_vfmaddcph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmaddcph {rz-sae}, %ymm1, %ymm0, %ymm2 # encoding: [0x62,0xf6,0x7a,0x78,0x56,0xd1]
; CHECK-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vfmaddcph256(<8 x float> %a, <8 x float> %b, <8 x float> %c, i8 -1, i32 11)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vfmaddcph256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x float> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vfmaddcph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmaddcph {ru-sae}, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf6,0x7a,0x59,0x56,0xd1]
; X86-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vfmaddcph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmaddcph {ru-sae}, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf6,0x7a,0x59,0x56,0xd1]
; X64-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vfmaddcph256(<8 x float> %a, <8 x float> %c, <8 x float> %d, i8 %b, i32 10)
  ret <8 x float> %ret
}

declare <8 x float> @llvm.x86.avx10.maskz.vfmaddcph256(<8 x float>, <8 x float>, <8 x float>, i8, i32)
define <8 x float> @test_int_x86_maskz_vfmaddcph256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x float> %d) nounwind {
; X86-LABEL: test_int_x86_maskz_vfmaddcph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmaddcph {rd-sae}, %ymm1, %ymm0, %ymm2 {%k1} {z} # encoding: [0x62,0xf6,0x7a,0xb9,0x56,0xd1]
; X86-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vfmaddcph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmaddcph {rd-sae}, %ymm1, %ymm0, %ymm2 {%k1} {z} # encoding: [0x62,0xf6,0x7a,0xb9,0x56,0xd1]
; X64-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.maskz.vfmaddcph256(<8 x float> %a, <8 x float> %c, <8 x float> %d, i8 %b, i32 9)
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx10.vfmaddsubpd256(<4 x double>, <4 x double>, <4 x double>, i32)
define <4 x double> @test_int_x86_vfmaddsubpd256(<4 x double> %a, <4 x double> %b, <4 x double> %c) nounwind {
; CHECK-LABEL: test_int_x86_vfmaddsubpd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmaddsub213pd {rz-sae}, %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf2,0xf1,0x78,0xa6,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.vfmaddsubpd256(<4 x double> %a, <4 x double> %b, <4 x double> %c, i32 11)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vfmaddsubpd256(<4 x double> %a, i4 %b, <4 x double> %c, <4 x double> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vfmaddsubpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmaddsub132pd {ru-sae}, %ymm1, %ymm2, %ymm0 {%k1} # encoding: [0x62,0xf2,0xe9,0x59,0x96,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vfmaddsubpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmaddsub132pd {ru-sae}, %ymm1, %ymm2, %ymm0 {%k1} # encoding: [0x62,0xf2,0xe9,0x59,0x96,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vfmaddsubpd256(<4 x double> %a, <4 x double> %c, <4 x double> %d, i32 10)
  %msk = bitcast i4 %b to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> %a
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vfmaddsubpd256(<4 x double> %a, i4 %b, <4 x double> %c, <4 x double> %d) nounwind {
; X86-LABEL: test_int_x86_maskz_vfmaddsubpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmaddsub132pd {rd-sae}, %ymm1, %ymm2, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0xe9,0xb9,0x96,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vfmaddsubpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmaddsub132pd {rd-sae}, %ymm1, %ymm2, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0xe9,0xb9,0x96,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vfmaddsubpd256(<4 x double> %a, <4 x double> %c, <4 x double> %d, i32 9)
  %msk = bitcast i4 %b to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> zeroinitializer
  ret <4 x double> %ret
}

declare <16 x half> @llvm.x86.avx10.vfmaddsubph256(<16 x half>, <16 x half>, <16 x half>, i32)
define <16 x half> @test_int_x86_vfmaddsubph256(<16 x half> %a, <16 x half> %b, <16 x half> %c) nounwind {
; CHECK-LABEL: test_int_x86_vfmaddsubph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmaddsub213ph {rz-sae}, %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf6,0x71,0x78,0xa6,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.vfmaddsubph256(<16 x half> %a, <16 x half> %b, <16 x half> %c, i32 11)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vfmaddsubph256(<16 x half> %a, i16 %b, <16 x half> %c, <16 x half> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vfmaddsubph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmaddsub132ph {ru-sae}, %ymm1, %ymm2, %ymm0 {%k1} # encoding: [0x62,0xf6,0x69,0x59,0x96,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vfmaddsubph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmaddsub132ph {ru-sae}, %ymm1, %ymm2, %ymm0 {%k1} # encoding: [0x62,0xf6,0x69,0x59,0x96,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vfmaddsubph256(<16 x half> %a, <16 x half> %c, <16 x half> %d, i32 10)
  %msk = bitcast i16 %b to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> %a
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vfmaddsubph256(<16 x half> %a, i16 %b, <16 x half> %c, <16 x half> %d) nounwind {
; X86-LABEL: test_int_x86_maskz_vfmaddsubph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmaddsub132ph {rd-sae}, %ymm1, %ymm2, %ymm0 {%k1} {z} # encoding: [0x62,0xf6,0x69,0xb9,0x96,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vfmaddsubph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmaddsub132ph {rd-sae}, %ymm1, %ymm2, %ymm0 {%k1} {z} # encoding: [0x62,0xf6,0x69,0xb9,0x96,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vfmaddsubph256(<16 x half> %a, <16 x half> %c, <16 x half> %d, i32 9)
  %msk = bitcast i16 %b to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> zeroinitializer
  ret <16 x half> %ret
}

declare <8 x float> @llvm.x86.avx10.vfmaddsubps256(<8 x float>, <8 x float>, <8 x float>, i32)
define <8 x float> @test_int_x86_vfmaddsubps256(<8 x float> %a, <8 x float> %b, <8 x float> %c) nounwind {
; CHECK-LABEL: test_int_x86_vfmaddsubps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmaddsub213ps {rz-sae}, %ymm2, %ymm1, %ymm0 # encoding: [0x62,0xf2,0x71,0x78,0xa6,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.vfmaddsubps256(<8 x float> %a, <8 x float> %b, <8 x float> %c, i32 11)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vfmaddsubps256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x float> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vfmaddsubps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmaddsub132ps {ru-sae}, %ymm1, %ymm2, %ymm0 {%k1} # encoding: [0x62,0xf2,0x69,0x59,0x96,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vfmaddsubps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmaddsub132ps {ru-sae}, %ymm1, %ymm2, %ymm0 {%k1} # encoding: [0x62,0xf2,0x69,0x59,0x96,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vfmaddsubps256(<8 x float> %a, <8 x float> %c, <8 x float> %d, i32 10)
  %msk = bitcast i8 %b to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> %a
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vfmaddsubps256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x float> %d) nounwind {
; X86-LABEL: test_int_x86_maskz_vfmaddsubps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmaddsub132ps {rd-sae}, %ymm1, %ymm2, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x69,0xb9,0x96,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vfmaddsubps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmaddsub132ps {rd-sae}, %ymm1, %ymm2, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x69,0xb9,0x96,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vfmaddsubps256(<8 x float> %a, <8 x float> %c, <8 x float> %d, i32 9)
  %msk = bitcast i8 %b to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> zeroinitializer
  ret <8 x float> %ret
}

declare <8 x float> @llvm.x86.avx10.mask.vfmulcph256(<8 x float>, <8 x float>, <8 x float>, i8, i32)
define <8 x float> @test_int_x86_vfmulcph256(<8 x float> %a, <8 x float> %b, <8 x float> %c) nounwind {
; CHECK-LABEL: test_int_x86_vfmulcph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmulcph {rz-sae}, %ymm1, %ymm0, %ymm2 # encoding: [0x62,0xf6,0x7a,0x78,0xd6,0xd1]
; CHECK-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vfmulcph256(<8 x float> %a, <8 x float> %b, <8 x float> %c, i8 -1, i32 11)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vfmulcph256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x float> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vfmulcph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmulcph {ru-sae}, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf6,0x7a,0x59,0xd6,0xd1]
; X86-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vfmulcph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmulcph {ru-sae}, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf6,0x7a,0x59,0xd6,0xd1]
; X64-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vfmulcph256(<8 x float> %a, <8 x float> %c, <8 x float> %d, i8 %b, i32 10)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vfmulcph256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x float> %d) nounwind {
; X86-LABEL: test_int_x86_maskz_vfmulcph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmulcph {rd-sae}, %ymm1, %ymm0, %ymm2 {%k1} {z} # encoding: [0x62,0xf6,0x7a,0xb9,0xd6,0xd1]
; X86-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vfmulcph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmulcph {rd-sae}, %ymm1, %ymm0, %ymm2 {%k1} {z} # encoding: [0x62,0xf6,0x7a,0xb9,0xd6,0xd1]
; X64-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vfmulcph256(<8 x float> %a, <8 x float> %c, <8 x float> zeroinitializer, i8 %b, i32 9)
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx10.mask.vgetexppd256(<4 x double>, <4 x double>, i8, i32)
define <4 x double> @test_int_x86_vgetexppd256(<4 x double> %a) nounwind {
; CHECK-LABEL: test_int_x86_vgetexppd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgetexppd {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf2,0xf9,0x18,0x42,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vgetexppd256(<4 x double> %a, <4 x double> undef, i8 -1, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vgetexppd256(<4 x double> %a, i8 %b, <4 x double> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vgetexppd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetexppd {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0xf9,0x19,0x42,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vgetexppd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetexppd {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0xf9,0x19,0x42,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vgetexppd256(<4 x double> %c, <4 x double> %a, i8 %b, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vgetexppd256(i8 %a, <4 x double> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vgetexppd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetexppd {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0xf9,0x99,0x42,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vgetexppd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetexppd {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0xf9,0x99,0x42,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vgetexppd256(<4 x double> %b, <4 x double> zeroinitializer, i8 %a, i32 8)
  ret <4 x double> %ret
}

declare <16 x half> @llvm.x86.avx10.mask.vgetexpph256(<16 x half>, <16 x half>, i16, i32)
define <16 x half> @test_int_x86_vgetexpph256(<16 x half> %a) nounwind {
; CHECK-LABEL: test_int_x86_vgetexpph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgetexpph {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf6,0x79,0x18,0x42,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vgetexpph256(<16 x half> %a, <16 x half> undef, i16 -1, i32 8)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vgetexpph256(<16 x half> %a, i16 %b, <16 x half> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vgetexpph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetexpph {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf6,0x79,0x19,0x42,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vgetexpph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetexpph {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf6,0x79,0x19,0x42,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vgetexpph256(<16 x half> %c, <16 x half> %a, i16 %b, i32 8)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vgetexpph256(i16 %a, <16 x half> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vgetexpph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetexpph {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf6,0x79,0x99,0x42,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vgetexpph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetexpph {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf6,0x79,0x99,0x42,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vgetexpph256(<16 x half> %b, <16 x half> zeroinitializer, i16 %a, i32 8)
  ret <16 x half> %ret
}

declare <8 x float> @llvm.x86.avx10.mask.vgetexpps256(<8 x float>, <8 x float>, i8, i32)
define <8 x float> @test_int_x86_vgetexpps256(<8 x float> %a) nounwind {
; CHECK-LABEL: test_int_x86_vgetexpps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgetexpps {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf2,0x79,0x18,0x42,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vgetexpps256(<8 x float> %a, <8 x float> undef, i8 -1, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vgetexpps256(<8 x float> %a, i8 %b, <8 x float> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vgetexpps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetexpps {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x79,0x19,0x42,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vgetexpps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetexpps {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x79,0x19,0x42,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vgetexpps256(<8 x float> %c, <8 x float> %a, i8 %b, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vgetexpps256(i8 %a, <8 x float> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vgetexpps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetexpps {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x79,0x99,0x42,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vgetexpps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetexpps {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x79,0x99,0x42,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vgetexpps256(<8 x float> %b, <8 x float> zeroinitializer, i8 %a, i32 8)
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx10.mask.vgetmantpd256(<4 x double>, i32, <4 x double>, i8, i32)
define <4 x double> @test_int_x86_vgetmantpd256(<4 x double> %a) nounwind {
; CHECK-LABEL: test_int_x86_vgetmantpd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgetmantpd $127, {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf3,0xf9,0x18,0x26,0xc0,0x7f]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vgetmantpd256(<4 x double> %a, i32 127, <4 x double> undef, i8 -1, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vgetmantpd256(<4 x double> %a, i8 %b, <4 x double> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vgetmantpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetmantpd $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0xf9,0x19,0x26,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vgetmantpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetmantpd $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0xf9,0x19,0x26,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vgetmantpd256(<4 x double> %c, i32 127, <4 x double> %a, i8 %b, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vgetmantpd256(i8 %a, <4 x double> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vgetmantpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetmantpd $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0xf9,0x99,0x26,0xc0,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vgetmantpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetmantpd $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0xf9,0x99,0x26,0xc0,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vgetmantpd256(<4 x double> %b, i32 127, <4 x double> zeroinitializer, i8 %a, i32 8)
  ret <4 x double> %ret
}

declare <16 x half> @llvm.x86.avx10.mask.vgetmantph256(<16 x half>, i32, <16 x half>, i16, i32)
define <16 x half> @test_int_x86_vgetmantph256(<16 x half> %a) nounwind {
; CHECK-LABEL: test_int_x86_vgetmantph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgetmantph $127, {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x78,0x18,0x26,0xc0,0x7f]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vgetmantph256(<16 x half> %a, i32 127, <16 x half> undef, i16 -1, i32 8)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vgetmantph256(<16 x half> %a, i16 %b, <16 x half> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vgetmantph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetmantph $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x78,0x19,0x26,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vgetmantph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetmantph $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x78,0x19,0x26,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vgetmantph256(<16 x half> %c, i32 127, <16 x half> %a, i16 %b, i32 8)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vgetmantph256(i16 %a, <16 x half> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vgetmantph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetmantph $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x78,0x99,0x26,0xc0,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vgetmantph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetmantph $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x78,0x99,0x26,0xc0,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vgetmantph256(<16 x half> %b, i32 127, <16 x half> zeroinitializer, i16 %a, i32 8)
  ret <16 x half> %ret
}

declare <8 x float> @llvm.x86.avx10.mask.vgetmantps256(<8 x float>, i32, <8 x float>, i8, i32)
define <8 x float> @test_int_x86_vgetmantps256(<8 x float> %a) nounwind {
; CHECK-LABEL: test_int_x86_vgetmantps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgetmantps $127, {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x79,0x18,0x26,0xc0,0x7f]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vgetmantps256(<8 x float> %a, i32 127, <8 x float> undef, i8 -1, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vgetmantps256(<8 x float> %a, i8 %b, <8 x float> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vgetmantps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetmantps $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x79,0x19,0x26,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vgetmantps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetmantps $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x79,0x19,0x26,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vgetmantps256(<8 x float> %c, i32 127, <8 x float> %a, i8 %b, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vgetmantps256(i8 %a, <8 x float> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vgetmantps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetmantps $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x79,0x99,0x26,0xc0,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vgetmantps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetmantps $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x79,0x99,0x26,0xc0,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vgetmantps256(<8 x float> %b, i32 127, <8 x float> zeroinitializer, i8 %a, i32 8)
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx10.vmaxpd256(<4 x double>, <4 x double>, i32)
define <4 x double> @test_int_x86_vmaxpd256(<4 x double> %A, <4 x double> %B) nounwind {
; CHECK-LABEL: test_int_x86_vmaxpd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaxpd {sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf1,0xf9,0x18,0x5f,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.vmaxpd256(<4 x double> %A, <4 x double> %B, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vmaxpd256(<4 x double> %A, i4 %B, <4 x double> %C, <4 x double> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vmaxpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmaxpd {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf1,0x19,0x5f,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vmaxpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmaxpd {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf1,0x19,0x5f,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vmaxpd256(<4 x double> %C, <4 x double> %D, i32 8)
  %msk = bitcast i4 %B to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> %A
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vmaxpd256(i4 %A, <4 x double> %B, <4 x double> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vmaxpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmaxpd {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0x99,0x5f,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vmaxpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmaxpd {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0x99,0x5f,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vmaxpd256(<4 x double> %B, <4 x double> %C, i32 8)
  %msk = bitcast i4 %A to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> zeroinitializer
  ret <4 x double> %ret
}

declare <16 x half> @llvm.x86.avx10.vmaxph256(<16 x half>, <16 x half>, i32)
define <16 x half> @test_int_x86_vmaxph256(<16 x half> %A, <16 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_vmaxph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaxph {sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x78,0x18,0x5f,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.vmaxph256(<16 x half> %A, <16 x half> %B, i32 8)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vmaxph256(<16 x half> %A, i16 %B, <16 x half> %C, <16 x half> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vmaxph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmaxph {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x70,0x19,0x5f,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vmaxph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmaxph {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x70,0x19,0x5f,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vmaxph256(<16 x half> %C, <16 x half> %D, i32 8)
  %msk = bitcast i16 %B to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> %A
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vmaxph256(i16 %A, <16 x half> %B, <16 x half> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vmaxph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmaxph {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0x99,0x5f,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vmaxph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmaxph {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0x99,0x5f,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vmaxph256(<16 x half> %B, <16 x half> %C, i32 8)
  %msk = bitcast i16 %A to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> zeroinitializer
  ret <16 x half> %ret
}

declare <8 x float> @llvm.x86.avx10.vmaxps256(<8 x float>, <8 x float>, i32)
define <8 x float> @test_int_x86_vmaxps256(<8 x float> %A, <8 x float> %B) nounwind {
; CHECK-LABEL: test_int_x86_vmaxps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaxps {sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf1,0x78,0x18,0x5f,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.vmaxps256(<8 x float> %A, <8 x float> %B, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vmaxps256(<8 x float> %A, i8 %B, <8 x float> %C, <8 x float> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vmaxps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmaxps {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x70,0x19,0x5f,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vmaxps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmaxps {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x70,0x19,0x5f,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vmaxps256(<8 x float> %C, <8 x float> %D, i32 8)
  %msk = bitcast i8 %B to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> %A
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vmaxps256(i8 %A, <8 x float> %B, <8 x float> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vmaxps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmaxps {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0x99,0x5f,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vmaxps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmaxps {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0x99,0x5f,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vmaxps256(<8 x float> %B, <8 x float> %C, i32 8)
  %msk = bitcast i8 %A to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> zeroinitializer
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx10.vminpd256(<4 x double>, <4 x double>, i32)
define <4 x double> @test_int_x86_vminpd256(<4 x double> %A, <4 x double> %B) nounwind {
; CHECK-LABEL: test_int_x86_vminpd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vminpd {sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf1,0xf9,0x18,0x5d,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.vminpd256(<4 x double> %A, <4 x double> %B, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vminpd256(<4 x double> %A, i4 %B, <4 x double> %C, <4 x double> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vminpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminpd {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf1,0x19,0x5d,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vminpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminpd {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf1,0x19,0x5d,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vminpd256(<4 x double> %C, <4 x double> %D, i32 8)
  %msk = bitcast i4 %B to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> %A
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vminpd256(i4 %A, <4 x double> %B, <4 x double> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vminpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminpd {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0x99,0x5d,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vminpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminpd {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0x99,0x5d,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vminpd256(<4 x double> %B, <4 x double> %C, i32 8)
  %msk = bitcast i4 %A to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> zeroinitializer
  ret <4 x double> %ret
}

declare <16 x half> @llvm.x86.avx10.vminph256(<16 x half>, <16 x half>, i32)
define <16 x half> @test_int_x86_vminph256(<16 x half> %A, <16 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_vminph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vminph {sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x78,0x18,0x5d,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.vminph256(<16 x half> %A, <16 x half> %B, i32 8)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vminph256(<16 x half> %A, i16 %B, <16 x half> %C, <16 x half> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vminph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminph {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x70,0x19,0x5d,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vminph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminph {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x70,0x19,0x5d,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vminph256(<16 x half> %C, <16 x half> %D, i32 8)
  %msk = bitcast i16 %B to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> %A
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vminph256(i16 %A, <16 x half> %B, <16 x half> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vminph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminph {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0x99,0x5d,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vminph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminph {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0x99,0x5d,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vminph256(<16 x half> %B, <16 x half> %C, i32 8)
  %msk = bitcast i16 %A to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> zeroinitializer
  ret <16 x half> %ret
}

declare <8 x float> @llvm.x86.avx10.vminps256(<8 x float>, <8 x float>, i32)
define <8 x float> @test_int_x86_vminps256(<8 x float> %A, <8 x float> %B) nounwind {
; CHECK-LABEL: test_int_x86_vminps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vminps {sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf1,0x78,0x18,0x5d,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.vminps256(<8 x float> %A, <8 x float> %B, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vminps256(<8 x float> %A, i8 %B, <8 x float> %C, <8 x float> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vminps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminps {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x70,0x19,0x5d,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vminps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminps {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x70,0x19,0x5d,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vminps256(<8 x float> %C, <8 x float> %D, i32 8)
  %msk = bitcast i8 %B to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> %A
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vminps256(i8 %A, <8 x float> %B, <8 x float> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vminps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminps {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0x99,0x5d,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vminps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminps {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0x99,0x5d,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vminps256(<8 x float> %B, <8 x float> %C, i32 8)
  %msk = bitcast i8 %A to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> zeroinitializer
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx10.vmulpd256(<4 x double>, <4 x double>, i32)
define <4 x double> @test_int_x86_vmulpd256(<4 x double> %A, <4 x double> %B) nounwind {
; CHECK-LABEL: test_int_x86_vmulpd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmulpd {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf1,0xf9,0x78,0x59,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.vmulpd256(<4 x double> %A, <4 x double> %B, i32 11)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vmulpd256(<4 x double> %A, i4 %B, <4 x double> %C, <4 x double> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vmulpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmulpd {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf1,0x59,0x59,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vmulpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmulpd {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf1,0x59,0x59,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vmulpd256(<4 x double> %C, <4 x double> %D, i32 10)
  %msk = bitcast i4 %B to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> %A
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vmulpd256(i4 %A, <4 x double> %B, <4 x double> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vmulpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmulpd {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x59,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vmulpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmulpd {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x59,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vmulpd256(<4 x double> %B, <4 x double> %C, i32 9)
  %msk = bitcast i4 %A to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> zeroinitializer
  ret <4 x double> %ret
}

declare <16 x half> @llvm.x86.avx10.vmulph256(<16 x half>, <16 x half>, i32)
define <16 x half> @test_int_x86_vmulph256(<16 x half> %A, <16 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_vmulph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmulph {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x78,0x78,0x59,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.vmulph256(<16 x half> %A, <16 x half> %B, i32 11)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vmulph256(<16 x half> %A, i16 %B, <16 x half> %C, <16 x half> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vmulph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmulph {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x70,0x59,0x59,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vmulph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmulph {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x70,0x59,0x59,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vmulph256(<16 x half> %C, <16 x half> %D, i32 10)
  %msk = bitcast i16 %B to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> %A
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vmulph256(i16 %A, <16 x half> %B, <16 x half> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vmulph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmulph {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x59,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vmulph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmulph {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x59,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vmulph256(<16 x half> %B, <16 x half> %C, i32 9)
  %msk = bitcast i16 %A to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> zeroinitializer
  ret <16 x half> %ret
}

declare <8 x float> @llvm.x86.avx10.vmulps256(<8 x float>, <8 x float>, i32)
define <8 x float> @test_int_x86_vmulps256(<8 x float> %A, <8 x float> %B) nounwind {
; CHECK-LABEL: test_int_x86_vmulps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmulps {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf1,0x78,0x78,0x59,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.vmulps256(<8 x float> %A, <8 x float> %B, i32 11)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vmulps256(<8 x float> %A, i8 %B, <8 x float> %C, <8 x float> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vmulps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmulps {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x70,0x59,0x59,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vmulps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmulps {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x70,0x59,0x59,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vmulps256(<8 x float> %C, <8 x float> %D, i32 10)
  %msk = bitcast i8 %B to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> %A
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vmulps256(i8 %A, <8 x float> %B, <8 x float> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vmulps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmulps {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0xb9,0x59,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vmulps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmulps {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0xb9,0x59,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vmulps256(<8 x float> %B, <8 x float> %C, i32 9)
  %msk = bitcast i8 %A to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> zeroinitializer
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx10.mask.vrangepd256(<4 x double>, <4 x double>, i32, <4 x double>, i8, i32)
define <4 x double> @test_int_x86_vrangepd256(<4 x double> %a, <4 x double> %b) nounwind {
; CHECK-LABEL: test_int_x86_vrangepd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrangepd $127, {sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf3,0xf9,0x18,0x50,0xc1,0x7f]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vrangepd256(<4 x double> %a, <4 x double> %b, i32 127, <4 x double> undef, i8 -1, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vrangepd256(<4 x double> %a, i8 %b, <4 x double> %c, <4 x double> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vrangepd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrangepd $127, {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0xf1,0x19,0x50,0xc2,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vrangepd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrangepd $127, {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0xf1,0x19,0x50,0xc2,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vrangepd256(<4 x double> %c, <4 x double> %d, i32 127, <4 x double> %a, i8 %b, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vrangepd256(i8 %a, <4 x double> %b, <4 x double> %c) nounwind {
; X86-LABEL: test_int_x86_maskz_vrangepd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrangepd $127, {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0xf9,0x99,0x50,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vrangepd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrangepd $127, {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0xf9,0x99,0x50,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vrangepd256(<4 x double> %b, <4 x double> %c, i32 127, <4 x double> zeroinitializer, i8 %a, i32 8)
  ret <4 x double> %ret
}

declare <8 x float> @llvm.x86.avx10.mask.vrangeps256(<8 x float>, <8 x float>, i32, <8 x float>, i8, i32)
define <8 x float> @test_int_x86_vrangeps256(<8 x float> %a, <8 x float> %b) nounwind {
; CHECK-LABEL: test_int_x86_vrangeps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrangeps $127, {sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x79,0x18,0x50,0xc1,0x7f]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vrangeps256(<8 x float> %a, <8 x float> %b, i32 127, <8 x float> undef, i8 -1, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vrangeps256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x float> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vrangeps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrangeps $127, {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x71,0x19,0x50,0xc2,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vrangeps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrangeps $127, {sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x71,0x19,0x50,0xc2,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vrangeps256(<8 x float> %c, <8 x float> %d, i32 127, <8 x float> %a, i8 %b, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vrangeps256(i8 %a, <8 x float> %b, <8 x float> %c) nounwind {
; X86-LABEL: test_int_x86_maskz_vrangeps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrangeps $127, {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x79,0x99,0x50,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vrangeps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrangeps $127, {sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x79,0x99,0x50,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vrangeps256(<8 x float> %b, <8 x float> %c, i32 127, <8 x float> zeroinitializer, i8 %a, i32 8)
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx10.mask.vreducepd256(<4 x double>, i32, <4 x double>, i8, i32)
define <4 x double> @test_int_x86_vreducepd256(<4 x double> %a) nounwind {
; CHECK-LABEL: test_int_x86_vreducepd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vreducepd $127, {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf3,0xf9,0x18,0x56,0xc0,0x7f]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vreducepd256(<4 x double> %a, i32 127, <4 x double> undef, i8 -1, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vreducepd256(<4 x double> %a, i8 %b, <4 x double> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vreducepd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vreducepd $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0xf9,0x19,0x56,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vreducepd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vreducepd $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0xf9,0x19,0x56,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vreducepd256(<4 x double> %c, i32 127, <4 x double> %a, i8 %b, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vreducepd256(i8 %a, <4 x double> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vreducepd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vreducepd $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0xf9,0x99,0x56,0xc0,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vreducepd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vreducepd $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0xf9,0x99,0x56,0xc0,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vreducepd256(<4 x double> %b, i32 127, <4 x double> zeroinitializer, i8 %a, i32 8)
  ret <4 x double> %ret
}

declare <16 x half> @llvm.x86.avx10.mask.vreduceph256(<16 x half>, i32, <16 x half>, i16, i32)
define <16 x half> @test_int_x86_vreduceph256(<16 x half> %a) nounwind {
; CHECK-LABEL: test_int_x86_vreduceph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vreduceph $127, {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x78,0x18,0x56,0xc0,0x7f]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vreduceph256(<16 x half> %a, i32 127, <16 x half> undef, i16 -1, i32 8)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vreduceph256(<16 x half> %a, i16 %b, <16 x half> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vreduceph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vreduceph $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x78,0x19,0x56,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vreduceph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vreduceph $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x78,0x19,0x56,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vreduceph256(<16 x half> %c, i32 127, <16 x half> %a, i16 %b, i32 8)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vreduceph256(i16 %a, <16 x half> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vreduceph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vreduceph $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x78,0x99,0x56,0xc0,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vreduceph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vreduceph $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x78,0x99,0x56,0xc0,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vreduceph256(<16 x half> %b, i32 127, <16 x half> zeroinitializer, i16 %a, i32 8)
  ret <16 x half> %ret
}

declare <8 x float> @llvm.x86.avx10.mask.vreduceps256(<8 x float>, i32, <8 x float>, i8, i32)
define <8 x float> @test_int_x86_vreduceps256(<8 x float> %a) nounwind {
; CHECK-LABEL: test_int_x86_vreduceps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vreduceps $127, {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x79,0x18,0x56,0xc0,0x7f]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vreduceps256(<8 x float> %a, i32 127, <8 x float> undef, i8 -1, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vreduceps256(<8 x float> %a, i8 %b, <8 x float> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vreduceps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vreduceps $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x79,0x19,0x56,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vreduceps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vreduceps $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x79,0x19,0x56,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vreduceps256(<8 x float> %c, i32 127, <8 x float> %a, i8 %b, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vreduceps256(i8 %a, <8 x float> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vreduceps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vreduceps $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x79,0x99,0x56,0xc0,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vreduceps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vreduceps $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x79,0x99,0x56,0xc0,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vreduceps256(<8 x float> %b, i32 127, <8 x float> zeroinitializer, i8 %a, i32 8)
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx10.mask.vrndscalepd256(<4 x double>, i32, <4 x double>, i8, i32)
define <4 x double> @test_int_x86_vrndscalepd256(<4 x double> %a) nounwind {
; CHECK-LABEL: test_int_x86_vrndscalepd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrndscalepd $127, {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf3,0xf9,0x18,0x09,0xc0,0x7f]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vrndscalepd256(<4 x double> %a, i32 127, <4 x double> undef, i8 -1, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vrndscalepd256(<4 x double> %a, i8 %b, <4 x double> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vrndscalepd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrndscalepd $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0xf9,0x19,0x09,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vrndscalepd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrndscalepd $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0xf9,0x19,0x09,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vrndscalepd256(<4 x double> %c, i32 127, <4 x double> %a, i8 %b, i32 8)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vrndscalepd256(i8 %a, <4 x double> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vrndscalepd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrndscalepd $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0xf9,0x99,0x09,0xc0,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vrndscalepd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrndscalepd $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0xf9,0x99,0x09,0xc0,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vrndscalepd256(<4 x double> %b, i32 127, <4 x double> zeroinitializer, i8 %a, i32 8)
  ret <4 x double> %ret
}

declare <16 x half> @llvm.x86.avx10.mask.vrndscaleph256(<16 x half>, i32, <16 x half>, i16, i32)
define <16 x half> @test_int_x86_vrndscaleph256(<16 x half> %a) nounwind {
; CHECK-LABEL: test_int_x86_vrndscaleph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrndscaleph $127, {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x78,0x18,0x08,0xc0,0x7f]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vrndscaleph256(<16 x half> %a, i32 127, <16 x half> undef, i16 -1, i32 8)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vrndscaleph256(<16 x half> %a, i16 %b, <16 x half> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vrndscaleph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrndscaleph $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x78,0x19,0x08,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vrndscaleph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrndscaleph $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x78,0x19,0x08,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vrndscaleph256(<16 x half> %c, i32 127, <16 x half> %a, i16 %b, i32 8)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vrndscaleph256(i16 %a, <16 x half> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vrndscaleph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrndscaleph $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x78,0x99,0x08,0xc0,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vrndscaleph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrndscaleph $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x78,0x99,0x08,0xc0,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vrndscaleph256(<16 x half> %b, i32 127, <16 x half> zeroinitializer, i16 %a, i32 8)
  ret <16 x half> %ret
}

declare <8 x float> @llvm.x86.avx10.mask.vrndscaleps256(<8 x float>, i32, <8 x float>, i8, i32)
define <8 x float> @test_int_x86_vrndscaleps256(<8 x float> %a) nounwind {
; CHECK-LABEL: test_int_x86_vrndscaleps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrndscaleps $127, {sae}, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x79,0x18,0x08,0xc0,0x7f]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vrndscaleps256(<8 x float> %a, i32 127, <8 x float> undef, i8 -1, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vrndscaleps256(<8 x float> %a, i8 %b, <8 x float> %c) nounwind {
; X86-LABEL: test_int_x86_mask_vrndscaleps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrndscaleps $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x79,0x19,0x08,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vrndscaleps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrndscaleps $127, {sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x79,0x19,0x08,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vrndscaleps256(<8 x float> %c, i32 127, <8 x float> %a, i8 %b, i32 8)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vrndscaleps256(i8 %a, <8 x float> %b) nounwind {
; X86-LABEL: test_int_x86_maskz_vrndscaleps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrndscaleps $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x79,0x99,0x08,0xc0,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vrndscaleps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrndscaleps $127, {sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x79,0x99,0x08,0xc0,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vrndscaleps256(<8 x float> %b, i32 127, <8 x float> zeroinitializer, i8 %a, i32 8)
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx10.mask.vscalefpd256(<4 x double>, <4 x double>, <4 x double>, i8, i32)
define <4 x double> @test_int_x86_vscalefpd256(<4 x double> %a, <4 x double> %b) nounwind {
; CHECK-LABEL: test_int_x86_vscalefpd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscalefpd {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf2,0xf9,0x78,0x2c,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vscalefpd256(<4 x double> %a, <4 x double> %b, <4 x double> undef, i8 -1, i32 11)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vscalefpd256(<4 x double> %a, i8 %b, <4 x double> %c, <4 x double> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vscalefpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vscalefpd {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0xf1,0x59,0x2c,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vscalefpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vscalefpd {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0xf1,0x59,0x2c,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vscalefpd256(<4 x double> %c, <4 x double> %d, <4 x double> %a, i8 %b, i32 10)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vscalefpd256(i8 %a, <4 x double> %b, <4 x double> %c) nounwind {
; X86-LABEL: test_int_x86_maskz_vscalefpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vscalefpd {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0xf9,0xb9,0x2c,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vscalefpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vscalefpd {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0xf9,0xb9,0x2c,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vscalefpd256(<4 x double> %b, <4 x double> %c, <4 x double> zeroinitializer, i8 %a, i32 9)
  ret <4 x double> %ret
}

declare <16 x half> @llvm.x86.avx10.mask.vscalefph256(<16 x half>, <16 x half>, <16 x half>, i16, i32)
define <16 x half> @test_int_x86_vscalefph256(<16 x half> %a, <16 x half> %b) nounwind {
; CHECK-LABEL: test_int_x86_vscalefph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscalefph {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf6,0x79,0x78,0x2c,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vscalefph256(<16 x half> %a, <16 x half> %b, <16 x half> undef, i16 -1, i32 11)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vscalefph256(<16 x half> %a, i16 %b, <16 x half> %c, <16 x half> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vscalefph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vscalefph {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf6,0x71,0x59,0x2c,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vscalefph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vscalefph {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf6,0x71,0x59,0x2c,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vscalefph256(<16 x half> %c, <16 x half> %d, <16 x half> %a, i16 %b, i32 10)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vscalefph256(i16 %a, <16 x half> %b, <16 x half> %c) nounwind {
; X86-LABEL: test_int_x86_maskz_vscalefph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vscalefph {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf6,0x79,0xb9,0x2c,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vscalefph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vscalefph {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf6,0x79,0xb9,0x2c,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vscalefph256(<16 x half> %b, <16 x half> %c, <16 x half> zeroinitializer, i16 %a, i32 9)
  ret <16 x half> %ret
}

declare <8 x float> @llvm.x86.avx10.mask.vscalefps256(<8 x float>, <8 x float>, <8 x float>, i8, i32)
define <8 x float> @test_int_x86_vscalefps256(<8 x float> %a, <8 x float> %b) nounwind {
; CHECK-LABEL: test_int_x86_vscalefps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscalefps {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf2,0x79,0x78,0x2c,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vscalefps256(<8 x float> %a, <8 x float> %b, <8 x float> undef, i8 -1, i32 11)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vscalefps256(<8 x float> %a, i8 %b, <8 x float> %c, <8 x float> %d) nounwind {
; X86-LABEL: test_int_x86_mask_vscalefps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vscalefps {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x71,0x59,0x2c,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vscalefps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vscalefps {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x71,0x59,0x2c,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vscalefps256(<8 x float> %c, <8 x float> %d, <8 x float> %a, i8 %b, i32 10)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vscalefps256(i8 %a, <8 x float> %b, <8 x float> %c) nounwind {
; X86-LABEL: test_int_x86_maskz_vscalefps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vscalefps {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x79,0xb9,0x2c,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vscalefps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vscalefps {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x79,0xb9,0x2c,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vscalefps256(<8 x float> %b, <8 x float> %c, <8 x float> zeroinitializer, i8 %a, i32 9)
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx10.vsqrtpd256(<4 x double>, i32)
define <4 x double> @test_int_x86_vsqrtpd256(<4 x double> %A) nounwind {
; CHECK-LABEL: test_int_x86_vsqrtpd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsqrtpd {rz-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf1,0xf9,0x78,0x51,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.vsqrtpd256(<4 x double> %A, i32 11)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vsqrtpd256(<4 x double> %A, i4 %B, <4 x double> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vsqrtpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsqrtpd {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf9,0x59,0x51,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vsqrtpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsqrtpd {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf9,0x59,0x51,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vsqrtpd256(<4 x double> %C, i32 10)
  %msk = bitcast i4 %B to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> %A
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vsqrtpd256(i4 %A, <4 x double> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vsqrtpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsqrtpd {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x51,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vsqrtpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsqrtpd {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x51,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vsqrtpd256(<4 x double> %B, i32 9)
  %msk = bitcast i4 %A to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> zeroinitializer
  ret <4 x double> %ret
}

declare <16 x half> @llvm.x86.avx10.vsqrtph256(<16 x half>, i32)
define <16 x half> @test_int_x86_vsqrtph256(<16 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_vsqrtph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsqrtph {rz-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x78,0x78,0x51,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.vsqrtph256(<16 x half> %A, i32 11)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vsqrtph256(<16 x half> %A, i16 %B, <16 x half> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vsqrtph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsqrtph {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x78,0x59,0x51,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vsqrtph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsqrtph {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x78,0x59,0x51,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vsqrtph256(<16 x half> %C, i32 10)
  %msk = bitcast i16 %B to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> %A
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vsqrtph256(i16 %A, <16 x half> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vsqrtph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsqrtph {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x51,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vsqrtph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsqrtph {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x51,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vsqrtph256(<16 x half> %B, i32 9)
  %msk = bitcast i16 %A to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> zeroinitializer
  ret <16 x half> %ret
}

declare <8 x float> @llvm.x86.avx10.vsqrtps256(<8 x float>, i32)
define <8 x float> @test_int_x86_vsqrtps256(<8 x float> %A) nounwind {
; CHECK-LABEL: test_int_x86_vsqrtps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsqrtps {rz-sae}, %ymm0, %ymm0 # encoding: [0x62,0xf1,0x78,0x78,0x51,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.vsqrtps256(<8 x float> %A, i32 11)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vsqrtps256(<8 x float> %A, i8 %B, <8 x float> %C) nounwind {
; X86-LABEL: test_int_x86_mask_vsqrtps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsqrtps {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x78,0x59,0x51,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vsqrtps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsqrtps {ru-sae}, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x78,0x59,0x51,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vsqrtps256(<8 x float> %C, i32 10)
  %msk = bitcast i8 %B to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> %A
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vsqrtps256(i8 %A, <8 x float> %B) nounwind {
; X86-LABEL: test_int_x86_maskz_vsqrtps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsqrtps {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0xb9,0x51,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vsqrtps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsqrtps {rd-sae}, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0xb9,0x51,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vsqrtps256(<8 x float> %B, i32 9)
  %msk = bitcast i8 %A to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> zeroinitializer
  ret <8 x float> %ret
}

declare <4 x double> @llvm.x86.avx10.vsubpd256(<4 x double>, <4 x double>, i32)
define <4 x double> @test_int_x86_vsubpd256(<4 x double> %A, <4 x double> %B) nounwind {
; CHECK-LABEL: test_int_x86_vsubpd256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsubpd {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf1,0xf9,0x78,0x5c,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.vsubpd256(<4 x double> %A, <4 x double> %B, i32 11)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_mask_vsubpd256(<4 x double> %A, i4 %B, <4 x double> %C, <4 x double> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vsubpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsubpd {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf1,0x59,0x5c,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vsubpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsubpd {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0xf1,0x59,0x5c,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vsubpd256(<4 x double> %C, <4 x double> %D, i32 10)
  %msk = bitcast i4 %B to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> %A
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_maskz_vsubpd256(i4 %A, <4 x double> %B, <4 x double> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vsubpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsubpd {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x5c,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vsubpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsubpd {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0xf9,0xb9,0x5c,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <4 x double> @llvm.x86.avx10.vsubpd256(<4 x double> %B, <4 x double> %C, i32 9)
  %msk = bitcast i4 %A to <4 x i1>
  %ret = select <4 x i1> %msk, <4 x double> %ret0, <4 x double> zeroinitializer
  ret <4 x double> %ret
}

declare <16 x half> @llvm.x86.avx10.vsubph256(<16 x half>, <16 x half>, i32)
define <16 x half> @test_int_x86_vsubph256(<16 x half> %A, <16 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_vsubph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsubph {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x78,0x78,0x5c,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.vsubph256(<16 x half> %A, <16 x half> %B, i32 11)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_mask_vsubph256(<16 x half> %A, i16 %B, <16 x half> %C, <16 x half> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vsubph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsubph {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x70,0x59,0x5c,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vsubph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsubph {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x70,0x59,0x5c,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vsubph256(<16 x half> %C, <16 x half> %D, i32 10)
  %msk = bitcast i16 %B to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> %A
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_maskz_vsubph256(i16 %A, <16 x half> %B, <16 x half> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vsubph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsubph {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x5c,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vsubph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsubph {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x78,0xb9,0x5c,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <16 x half> @llvm.x86.avx10.vsubph256(<16 x half> %B, <16 x half> %C, i32 9)
  %msk = bitcast i16 %A to <16 x i1>
  %ret = select <16 x i1> %msk, <16 x half> %ret0, <16 x half> zeroinitializer
  ret <16 x half> %ret
}

declare <8 x float> @llvm.x86.avx10.vsubps256(<8 x float>, <8 x float>, i32)
define <8 x float> @test_int_x86_vsubps256(<8 x float> %A, <8 x float> %B) nounwind {
; CHECK-LABEL: test_int_x86_vsubps256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsubps {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf1,0x78,0x78,0x5c,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.vsubps256(<8 x float> %A, <8 x float> %B, i32 11)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vsubps256(<8 x float> %A, i8 %B, <8 x float> %C, <8 x float> %D) nounwind {
; X86-LABEL: test_int_x86_mask_vsubps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsubps {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x70,0x59,0x5c,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_mask_vsubps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsubps {ru-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf1,0x70,0x59,0x5c,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vsubps256(<8 x float> %C, <8 x float> %D, i32 10)
  %msk = bitcast i8 %B to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> %A
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vsubps256(i8 %A, <8 x float> %B, <8 x float> %C) nounwind {
; X86-LABEL: test_int_x86_maskz_vsubps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsubps {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0xb9,0x5c,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
;
; X64-LABEL: test_int_x86_maskz_vsubps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsubps {rd-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf1,0x78,0xb9,0x5c,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
  %ret0 = call <8 x float> @llvm.x86.avx10.vsubps256(<8 x float> %B, <8 x float> %C, i32 9)
  %msk = bitcast i8 %A to <8 x i1>
  %ret = select <8 x i1> %msk, <8 x float> %ret0, <8 x float> zeroinitializer
  ret <8 x float> %ret
}
