; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefixes=CHECK %s

; Test that s_wqm is executed before lds.param.load.
define amdgpu_ps <3 x float> @test_param_load(i32 inreg %attr, <3 x float> %to_add) {
; CHECK-LABEL: test_param_load:
; CHECK:       ; %bb.0: ; %main_body
; CHECK-NEXT:    s_mov_b32 m0, s0
; CHECK-NEXT:    s_mov_b32 s0, exec_lo
; CHECK-NEXT:    s_wqm_b32 exec_lo, exec_lo
; CHECK-NEXT:    lds_param_load v3, attr0.x wait_vdst:15
; CHECK-NEXT:    lds_param_load v4, attr0.y wait_vdst:15
; CHECK-NEXT:    lds_param_load v5, attr0.z wait_vdst:15
; CHECK-NEXT:    s_mov_b32 exec_lo, s0
; CHECK-NEXT:    s_waitcnt expcnt(1)
; CHECK-NEXT:    v_dual_add_f32 v0, v3, v0 :: v_dual_add_f32 v1, v4, v1
; CHECK-NEXT:    s_waitcnt expcnt(0)
; CHECK-NEXT:    v_add_f32_e32 v2, v5, v2
; CHECK-NEXT:    ; return to shader part epilog
main_body:
  %a = call float @llvm.amdgcn.lds.param.load(i32 0, i32 0, i32 %attr) #1
  %b = call float @llvm.amdgcn.lds.param.load(i32 1, i32 0, i32 %attr) #1
  %c = call float @llvm.amdgcn.lds.param.load(i32 2, i32 0, i32 %attr) #1
  %tmp_0 = insertelement <3 x float> undef, float %a, i32 0
  %tmp_1 = insertelement <3 x float> %tmp_0, float %b, i32 1
  %tmp_2 = insertelement <3 x float> %tmp_1, float %c, i32 2
  %res = fadd <3 x float> %tmp_2, %to_add
  ret  <3 x float> %res
}

; Test that s_wqm is executed before lds.direct.load.
define amdgpu_ps <3 x float> @test_direct_load(i32 inreg %arg_0, i32 inreg %arg_1, i32 inreg %arg_2, <3 x float> %to_add) {
; CHECK-LABEL: test_direct_load:
; CHECK:       ; %bb.0: ; %main_body
; CHECK-NEXT:    s_mov_b32 m0, s0
; CHECK-NEXT:    s_mov_b32 s0, exec_lo
; CHECK-NEXT:    s_wqm_b32 exec_lo, exec_lo
; CHECK-NEXT:    lds_direct_load v3 wait_vdst:15
; CHECK-NEXT:    s_mov_b32 m0, s1
; CHECK-NEXT:    lds_direct_load v4 wait_vdst:15
; CHECK-NEXT:    s_mov_b32 m0, s2
; CHECK-NEXT:    lds_direct_load v5 wait_vdst:15
; CHECK-NEXT:    s_mov_b32 exec_lo, s0
; CHECK-NEXT:    s_waitcnt expcnt(1)
; CHECK-NEXT:    v_dual_add_f32 v0, v3, v0 :: v_dual_add_f32 v1, v4, v1
; CHECK-NEXT:    s_waitcnt expcnt(0)
; CHECK-NEXT:    v_add_f32_e32 v2, v5, v2
; CHECK-NEXT:    ; return to shader part epilog
main_body:
  %a = call float @llvm.amdgcn.lds.direct.load(i32 %arg_0) #1
  %b = call float @llvm.amdgcn.lds.direct.load(i32 %arg_1) #1
  %c = call float @llvm.amdgcn.lds.direct.load(i32 %arg_2) #1
  %tmp_0 = insertelement <3 x float> undef, float %a, i32 0
  %tmp_1 = insertelement <3 x float> %tmp_0, float %b, i32 1
  %tmp_2 = insertelement <3 x float> %tmp_1, float %c, i32 2
  %res = fadd <3 x float> %tmp_2, %to_add
  ret  <3 x float> %res
}

attributes #1 = { nounwind readnone speculatable willreturn }
declare float @llvm.amdgcn.lds.param.load(i32 immarg, i32 immarg, i32) #1
declare float @llvm.amdgcn.lds.direct.load(i32) #1
