; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9,GFX900 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx90a < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX90A %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx940 < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX940 %s


define void @v_shuffle_v2bf16_v2bf16__u_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2bf16_v2bf16__u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> poison
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__0_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__0_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 0, i32 poison>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__1_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    v_alignbit_b32 v1, s4, v1, 16
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    v_alignbit_b32 v1, s4, v1, 16
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__1_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    v_alignbit_b32 v1, s0, v1, 16
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 1, i32 poison>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__2_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2bf16_v2bf16__2_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 2, i32 poison>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__3_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    v_alignbit_b32 v1, s4, v1, 16
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    v_alignbit_b32 v1, s4, v1, 16
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__3_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    v_alignbit_b32 v1, s0, v1, 16
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 3, i32 poison>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__3_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v2
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_alignbit_b32 v1, v1, v2, 16
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v2
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_alignbit_b32 v1, v1, v2, 16
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__3_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v2
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_alignbit_b32 v1, v1, v2, 16
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 3, i32 0>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__3_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__3_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v2
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v1, v1, v2, s4
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__3_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v2
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v1, v2, s4
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__3_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s2, 0x7060302
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v2
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_perm_b32 v1, v1, v2, s2
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 3, i32 1>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__3_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    v_alignbit_b32 v1, v1, v1, 16
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    v_alignbit_b32 v1, v1, v1, 16
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__3_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    v_alignbit_b32 v1, v1, v1, 16
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 3, i32 2>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__3_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s2, 0x7060302
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 3, i32 3>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__u_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__u_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 poison, i32 0>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__0_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s2, 0x5040100
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> zeroinitializer
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__1_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    v_alignbit_b32 v1, v1, v1, 16
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    v_alignbit_b32 v1, v1, v1, 16
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__1_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    v_alignbit_b32 v1, v1, v1, 16
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 1, i32 0>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__2_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__2_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__2_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__2_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 2, i32 0>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__u_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__u_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 poison, i32 1>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__0_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__0_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 0, i32 1>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__1_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s2, 0x7060302
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 1, i32 1>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__2_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__2_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__2_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__2_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 2, i32 1>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__u_2(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2bf16_v2bf16__u_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 poison, i32 2>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__0_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__0_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__0_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__0_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 0, i32 2>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__1_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    v_alignbit_b32 v1, s4, v1, 16
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    v_alignbit_b32 v1, s4, v1, 16
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__1_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    v_alignbit_b32 v1, s0, v1, 16
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 1, i32 2>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__2_2(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2bf16_v2bf16__2_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 2, i32 2>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__u_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__u_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 poison, i32 3>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__0_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__0_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v2
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_bfi_b32 v1, s4, v1, v2
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__0_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v2
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v1, s4, v1, v2
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__0_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s2, 0xffff
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v2
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_bfi_b32 v1, s2, v1, v2
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 0, i32 3>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__1_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__1_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v2
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v1, v2, v1, s4
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__1_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v2
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v2, v1, s4
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__1_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s2, 0x7060302
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v2
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_perm_b32 v1, v2, v1, s2
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 1, i32 3>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @v_shuffle_v2bf16_v2bf16__2_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2bf16_v2bf16__2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v1
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2bf16_v2bf16__2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v1
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dword v0, v1, s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2bf16_v2bf16__2_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=v"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 2, i32 3>
  store <2 x bfloat> %shuf, ptr addrspace(1) %ptr, align 4
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__u_u() {
; GFX9-LABEL: s_shuffle_v2bf16_v2bf16__u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s8
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> poison
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__0_u() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__0_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 0, i32 poison>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__1_u() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s4
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s8, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s4
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s8, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__1_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s0
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_lshr_b32 s8, s0, 16
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 1, i32 poison>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__2_u() {
; GFX9-LABEL: s_shuffle_v2bf16_v2bf16__2_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s8
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 2, i32 poison>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__3_u() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s4
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s8, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s4
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s8, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__3_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s0
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_lshr_b32 s8, s0, 16
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 3, i32 poison>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__3_0() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s5
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s5, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s4
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s5
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s5, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s4
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__3_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_lshr_b32 s1, s1, 16
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s0
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 3, i32 0>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__3_1() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__3_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s4
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s5
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_lshr_b32 s5, s5, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__3_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s4
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s5
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_lshr_b32 s5, s5, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__3_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s0
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_lshr_b32 s0, s0, 16
; GFX940-NEXT:    s_lshr_b32 s1, s1, 16
; GFX940-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 3, i32 1>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__3_2() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s4
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s4
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__3_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s0
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_lshr_b32 s1, s0, 16
; GFX940-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 3, i32 2>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__3_3() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s4
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s4
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__3_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s0
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_lshr_b32 s0, s0, 16
; GFX940-NEXT:    s_pack_ll_b32_b16 s8, s0, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__u_0() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s4
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshl_b32 s8, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s4
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshl_b32 s8, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__u_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s0
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_lshl_b32 s8, s0, 16
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 poison, i32 0>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__0_0() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s4
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s4
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__0_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s0
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_pack_ll_b32_b16 s8, s0, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> zeroinitializer
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__1_0() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s4
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s4
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__1_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s0
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_lshr_b32 s1, s0, 16
; GFX940-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 1, i32 0>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__2_0() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__2_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s4
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshl_b32 s8, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__2_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s4
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshl_b32 s8, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__2_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s0
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_lshl_b32 s8, s0, 16
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 2, i32 0>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__u_1() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__u_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 poison, i32 1>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__0_1() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__0_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 0, i32 1>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__1_1() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s4
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s4
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__1_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s0
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_lshr_b32 s0, s0, 16
; GFX940-NEXT:    s_pack_ll_b32_b16 s8, s0, s0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__2_1() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__2_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__2_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__2_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 2, i32 1>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__u_2() {
; GFX9-LABEL: s_shuffle_v2bf16_v2bf16__u_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s8
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 poison, i32 2>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__0_2() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__0_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__0_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__0_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 0, i32 2>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__1_2() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s4
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s8, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s4
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s8, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__1_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s0
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_lshr_b32 s8, s0, 16
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 1, i32 2>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__2_2() {
; GFX9-LABEL: s_shuffle_v2bf16_v2bf16__2_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s8
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> poison, <2 x i32> <i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__u_3() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__u_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 poison, i32 3>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__0_3() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__0_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s5
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s5, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s4
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__0_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s5
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s5, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s4
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__0_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_lshr_b32 s1, s1, 16
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s0
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_pack_ll_b32_b16 s8, s0, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 0, i32 3>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__1_3() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__1_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s4
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s5
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s5, 16
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__1_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s4
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s5
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s5, 16
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__1_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s0
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s1
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_lshr_b32 s1, s1, 16
; GFX940-NEXT:    s_lshr_b32 s0, s0, 16
; GFX940-NEXT:    s_pack_ll_b32_b16 s8, s0, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 1, i32 3>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v2bf16_v2bf16__2_3() {
; GFX900-LABEL: s_shuffle_v2bf16_v2bf16__2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s8
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2bf16_v2bf16__2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s8
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2bf16_v2bf16__2_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s8
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <2 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <2 x bfloat> asm "; def $0", "=s"()
  %shuf = shufflevector <2 x bfloat> %vec0, <2 x bfloat> %vec1, <2 x i32> <i32 2, i32 3>
  call void asm sideeffect "; use $0", "{s8}"(<2 x bfloat> %shuf)
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX90APLUS: {{.*}}
