; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

target datalayout = "p:128:64"

; Test for 128 bit pointers. At the moment, constraints only support signed i64 offsets.
define i1 @gep_decomp_large_index_63_bits(ptr %a) {
; CHECK-LABEL: @gep_decomp_large_index_63_bits(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds i64, ptr [[A:%.*]], i64 9223372036854775804
; CHECK-NEXT:    [[GEP_2:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 9223372036854775805
; CHECK-NEXT:    [[NE:%.*]] = icmp ne ptr [[GEP_1]], [[GEP_2]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[NE]])
; CHECK-NEXT:    [[CMP_ULE:%.*]] = icmp ule ptr [[GEP_1]], [[GEP_2]]
; CHECK-NEXT:    [[CMP_UGE:%.*]] = icmp uge ptr [[GEP_1]], [[GEP_2]]
; CHECK-NEXT:    [[RES:%.*]] = xor i1 [[CMP_ULE]], [[CMP_ULE]]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  %gep.1 = getelementptr inbounds i64, ptr %a, i64 9223372036854775804
  %gep.2 = getelementptr inbounds i64, ptr %a, i64 9223372036854775805
  %ne = icmp ne ptr %gep.1, %gep.2
  call void @llvm.assume(i1 %ne)
  %cmp.ule = icmp ule ptr %gep.1, %gep.2
  %cmp.uge = icmp uge ptr %gep.1, %gep.2
  %res = xor i1 %cmp.ule, %cmp.ule
  ret i1 %res
}

define i1 @gep_decomp_large_index_67_bits(ptr %a) {
; CHECK-LABEL: @gep_decomp_large_index_67_bits(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds i64, ptr [[A:%.*]], i128 147573952589676412928
; CHECK-NEXT:    [[GEP_2:%.*]] = getelementptr inbounds i64, ptr [[A]], i128 147573952589676412929
; CHECK-NEXT:    [[NE:%.*]] = icmp ne ptr [[GEP_1]], [[GEP_2]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[NE]])
; CHECK-NEXT:    [[CMP_ULE:%.*]] = icmp ule ptr [[GEP_1]], [[GEP_2]]
; CHECK-NEXT:    [[CMP_UGE:%.*]] = icmp uge ptr [[GEP_1]], [[GEP_2]]
; CHECK-NEXT:    [[RES:%.*]] = xor i1 [[CMP_ULE]], [[CMP_UGE]]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  %gep.1 = getelementptr inbounds i64, ptr %a, i128 147573952589676412928
  %gep.2 = getelementptr inbounds i64, ptr %a, i128 147573952589676412929
  %ne = icmp ne ptr %gep.1, %gep.2
  call void @llvm.assume(i1 %ne)
  %cmp.ule = icmp ule ptr %gep.1, %gep.2
  %cmp.uge = icmp uge ptr %gep.1, %gep.2
  %res = xor i1 %cmp.ule, %cmp.uge
  ret i1 %res
}

declare void @llvm.assume(i1)
