; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v,+f,+d,+zvfhmin,+zvfbfmin -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+v,+f,+d,+zvfhmin,+zvfbfmin -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

define <1 x i64> @llrint_v1i64_v1f32(<1 x float> %x) {
; CHECK-LABEL: llrint_v1i64_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.x.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %a = call <1 x i64> @llvm.llrint.v1i64.v1f32(<1 x float> %x)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.llrint.v1i64.v1f32(<1 x float>)

define <2 x i64> @llrint_v2i64_v2f32(<2 x float> %x) {
; CHECK-LABEL: llrint_v2i64_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.x.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %a = call <2 x i64> @llvm.llrint.v2i64.v2f32(<2 x float> %x)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.llrint.v2i64.v2f32(<2 x float>)

define <3 x i64> @llrint_v3i64_v3f32(<3 x float> %x) {
; CHECK-LABEL: llrint_v3i64_v3f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vfwcvt.x.f.v v8, v10
; CHECK-NEXT:    ret
  %a = call <3 x i64> @llvm.llrint.v3i64.v3f32(<3 x float> %x)
  ret <3 x i64> %a
}
declare <3 x i64> @llvm.llrint.v3i64.v3f32(<3 x float>)

define <4 x i64> @llrint_v4i64_v4f32(<4 x float> %x) {
; CHECK-LABEL: llrint_v4i64_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vfwcvt.x.f.v v8, v10
; CHECK-NEXT:    ret
  %a = call <4 x i64> @llvm.llrint.v4i64.v4f32(<4 x float> %x)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.llrint.v4i64.v4f32(<4 x float>)

define <8 x i64> @llrint_v8i64_v8f32(<8 x float> %x) {
; CHECK-LABEL: llrint_v8i64_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vfwcvt.x.f.v v8, v12
; CHECK-NEXT:    ret
  %a = call <8 x i64> @llvm.llrint.v8i64.v8f32(<8 x float> %x)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.llrint.v8i64.v8f32(<8 x float>)

define <16 x i64> @llrint_v16i64_v16f32(<16 x float> %x) {
; CHECK-LABEL: llrint_v16i64_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vmv4r.v v16, v8
; CHECK-NEXT:    vfwcvt.x.f.v v8, v16
; CHECK-NEXT:    ret
  %a = call <16 x i64> @llvm.llrint.v16i64.v16f32(<16 x float> %x)
  ret <16 x i64> %a
}
declare <16 x i64> @llvm.llrint.v16i64.v16f32(<16 x float>)

define <1 x i64> @llrint_v1i64_v1f64(<1 x double> %x) {
; CHECK-LABEL: llrint_v1i64_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v8, v8
; CHECK-NEXT:    ret
  %a = call <1 x i64> @llvm.llrint.v1i64.v1f64(<1 x double> %x)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.llrint.v1i64.v1f64(<1 x double>)

define <2 x i64> @llrint_v2i64_v2f64(<2 x double> %x) {
; CHECK-LABEL: llrint_v2i64_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v8, v8
; CHECK-NEXT:    ret
  %a = call <2 x i64> @llvm.llrint.v2i64.v2f64(<2 x double> %x)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.llrint.v2i64.v2f64(<2 x double>)

define <4 x i64> @llrint_v4i64_v4f64(<4 x double> %x) {
; CHECK-LABEL: llrint_v4i64_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v8, v8
; CHECK-NEXT:    ret
  %a = call <4 x i64> @llvm.llrint.v4i64.v4f64(<4 x double> %x)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.llrint.v4i64.v4f64(<4 x double>)

define <8 x i64> @llrint_v8i64_v8f64(<8 x double> %x) {
; CHECK-LABEL: llrint_v8i64_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfcvt.x.f.v v8, v8
; CHECK-NEXT:    ret
  %a = call <8 x i64> @llvm.llrint.v8i64.v8f64(<8 x double> %x)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.llrint.v8i64.v8f64(<8 x double>)

define <1 x i64> @llrint_v1i64_v1f16(<1 x half> %x) {
; CHECK-LABEL: llrint_v1i64_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.x.f.v v8, v9
; CHECK-NEXT:    ret
  %a = call <1 x i64> @llvm.llrint.v1i64.v1f16(<1 x half> %x)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.llrint.v1i64.v1f16(<1 x half>)

define <2 x i64> @llrint_v2i64_v2f16(<2 x half> %x) {
; CHECK-LABEL: llrint_v2i64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.x.f.v v8, v9
; CHECK-NEXT:    ret
  %a = call <2 x i64> @llvm.llrint.v2i64.v2f16(<2 x half> %x)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.llrint.v2i64.v2f16(<2 x half>)

define <3 x i64> @llrint_v3i64_v3f16(<3 x half> %x) {
; CHECK-LABEL: llrint_v3i64_v3f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.x.f.v v8, v10
; CHECK-NEXT:    ret
  %a = call <3 x i64> @llvm.llrint.v3i64.v3f16(<3 x half> %x)
  ret <3 x i64> %a
}
declare <3 x i64> @llvm.llrint.v3i64.v3f16(<3 x half>)

define <4 x i64> @llrint_v4i64_v4f16(<4 x half> %x) {
; CHECK-LABEL: llrint_v4i64_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.x.f.v v8, v10
; CHECK-NEXT:    ret
  %a = call <4 x i64> @llvm.llrint.v4i64.v4f16(<4 x half> %x)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.llrint.v4i64.v4f16(<4 x half>)

define <8 x i64> @llrint_v8i64_v8f16(<8 x half> %x) {
; CHECK-LABEL: llrint_v8i64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.x.f.v v8, v12
; CHECK-NEXT:    ret
  %a = call <8 x i64> @llvm.llrint.v8i64.v8f16(<8 x half> %x)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.llrint.v8i64.v8f16(<8 x half>)

define <16 x i64> @llrint_v16i64_v16f16(<16 x half> %x) {
; CHECK-LABEL: llrint_v16i64_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.x.f.v v8, v16
; CHECK-NEXT:    ret
  %a = call <16 x i64> @llvm.llrint.v16i64.v16f16(<16 x half> %x)
  ret <16 x i64> %a
}
declare <16 x i64> @llvm.llrint.v16i64.v16f16(<16 x half>)

define <1 x i64> @llrint_v1i64_v1bf16(<1 x bfloat> %x) {
; CHECK-LABEL: llrint_v1i64_v1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.x.f.v v8, v9
; CHECK-NEXT:    ret
  %a = call <1 x i64> @llvm.llrint.v1i64.v1bf16(<1 x bfloat> %x)
  ret <1 x i64> %a
}
declare <1 x i64> @llvm.llrint.v1i64.v1bf16(<1 x bfloat>)

define <2 x i64> @llrint_v2i64_v2bf16(<2 x bfloat> %x) {
; CHECK-LABEL: llrint_v2i64_v2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.x.f.v v8, v9
; CHECK-NEXT:    ret
  %a = call <2 x i64> @llvm.llrint.v2i64.v2bf16(<2 x bfloat> %x)
  ret <2 x i64> %a
}
declare <2 x i64> @llvm.llrint.v2i64.v2bf16(<2 x bfloat>)

define <3 x i64> @llrint_v3i64_v3bf16(<3 x bfloat> %x) {
; CHECK-LABEL: llrint_v3i64_v3bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.x.f.v v8, v10
; CHECK-NEXT:    ret
  %a = call <3 x i64> @llvm.llrint.v3i64.v3bf16(<3 x bfloat> %x)
  ret <3 x i64> %a
}
declare <3 x i64> @llvm.llrint.v3i64.v3bf16(<3 x bfloat>)

define <4 x i64> @llrint_v4i64_v4bf16(<4 x bfloat> %x) {
; CHECK-LABEL: llrint_v4i64_v4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.x.f.v v8, v10
; CHECK-NEXT:    ret
  %a = call <4 x i64> @llvm.llrint.v4i64.v4bf16(<4 x bfloat> %x)
  ret <4 x i64> %a
}
declare <4 x i64> @llvm.llrint.v4i64.v4bf16(<4 x bfloat>)

define <8 x i64> @llrint_v8i64_v8bf16(<8 x bfloat> %x) {
; CHECK-LABEL: llrint_v8i64_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.x.f.v v8, v12
; CHECK-NEXT:    ret
  %a = call <8 x i64> @llvm.llrint.v8i64.v8bf16(<8 x bfloat> %x)
  ret <8 x i64> %a
}
declare <8 x i64> @llvm.llrint.v8i64.v8bf16(<8 x bfloat>)

define <16 x i64> @llrint_v16i64_v16bf16(<16 x bfloat> %x) {
; CHECK-LABEL: llrint_v16i64_v16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.x.f.v v8, v16
; CHECK-NEXT:    ret
  %a = call <16 x i64> @llvm.llrint.v16i64.v16bf16(<16 x bfloat> %x)
  ret <16 x i64> %a
}
declare <16 x i64> @llvm.llrint.v16i64.v16bf16(<16 x bfloat>)
