# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=broadwell -instruction-tables < %s | FileCheck %s

xgetbv

xrstor  (%rax)

xrstors (%rax)

xsave   (%rax)

xsetbv

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  2      2     0.50                  U     xgetbv
# CHECK-NEXT:  19     23    4.50    *      *      U     xrstor	(%rax)
# CHECK-NEXT:  19     23    4.50    *      *      U     xrstors	(%rax)
# CHECK-NEXT:  28     30    6.25    *      *      U     xsave	(%rax)
# CHECK-NEXT:  5      5     1.25    *      *      U     xsetbv

# CHECK:      Resources:
# CHECK-NEXT: [0]   - BWDivider
# CHECK-NEXT: [1]   - BWFPDivider
# CHECK-NEXT: [2]   - BWPort0
# CHECK-NEXT: [3]   - BWPort1
# CHECK-NEXT: [4]   - BWPort2
# CHECK-NEXT: [5]   - BWPort3
# CHECK-NEXT: [6]   - BWPort4
# CHECK-NEXT: [7]   - BWPort5
# CHECK-NEXT: [8]   - BWPort6
# CHECK-NEXT: [9]   - BWPort7

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]
# CHECK-NEXT:  -      -     14.25  13.75  1.83   1.83   1.00   13.75  26.25  0.33

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    Instructions:
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -     0.50   0.50    -     xgetbv
# CHECK-NEXT:  -      -     3.75   3.75   0.50   0.50    -     3.75   6.75    -     xrstor	(%rax)
# CHECK-NEXT:  -      -     3.75   3.75   0.50   0.50    -     3.75   6.75    -     xrstors	(%rax)
# CHECK-NEXT:  -      -     4.75   4.75   0.83   0.83   1.00   4.75   10.75  0.33   xsave	(%rax)
# CHECK-NEXT:  -      -     1.50   1.00    -      -      -     1.00   1.50    -     xsetbv
