; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=dse -S %s | FileCheck %s

declare void @use_pointer(ptr)

; Out-of-bounds stores can be considered killing any other stores to the same
; object in the same BB, because they are UB and guaranteed to execute. Note
; that cases in which the BB is exited through unwinding are handled separately
; by DSE and the unwinding call will be considered as clobber.
define i32 @test_out_of_bounds_store_local(i1 %c) {
; CHECK-LABEL: @test_out_of_bounds_store_local(
; CHECK-NEXT:    [[D:%.*]] = alloca [1 x i32], align 4
; CHECK-NEXT:    [[ARRAYIDX_1:%.*]] = getelementptr inbounds [1 x i32], ptr [[D]], i64 0, i64 1
; CHECK-NEXT:    store i32 20, ptr [[ARRAYIDX_1]], align 4
; CHECK-NEXT:    call void @use_pointer(ptr [[D]])
; CHECK-NEXT:    ret i32 0
;
  %d = alloca [1 x i32], align 4
  store i32 10, ptr %d, align 4
  %arrayidx.1 = getelementptr inbounds [1 x i32], ptr %d, i64 0, i64 1
  store i32 20, ptr %arrayidx.1, align 4
  call void @use_pointer(ptr %d)
  ret i32 0
}

; Similar to @test_out_of_bounds_store_local, but with multiple in-bounds
; stores to a larger object, followed by an out-of-bounds store.
; FIXME: the 2 inbounds stores could be removed by applying the same
; reasoning as for @test_out_of_bounds_store_local.
define i32 @test_out_of_bounds_store_local_larger_object(i1 %c) {
; CHECK-LABEL: @test_out_of_bounds_store_local_larger_object(
; CHECK-NEXT:    [[D:%.*]] = alloca [2 x i32], align 4
; CHECK-NEXT:    store i32 10, ptr [[D]], align 4
; CHECK-NEXT:    [[ARRAYIDX_1:%.*]] = getelementptr inbounds [2 x i32], ptr [[D]], i64 0, i64 1
; CHECK-NEXT:    store i32 20, ptr [[ARRAYIDX_1]], align 4
; CHECK-NEXT:    [[ARRAYIDX_2:%.*]] = getelementptr inbounds [2 x i32], ptr [[D]], i64 0, i64 2
; CHECK-NEXT:    store i32 30, ptr [[ARRAYIDX_2]], align 4
; CHECK-NEXT:    call void @use_pointer(ptr [[D]])
; CHECK-NEXT:    ret i32 0
;
  %d = alloca [2 x i32], align 4
  store i32 10, ptr %d, align 4
  %arrayidx.1 = getelementptr inbounds [2 x i32], ptr %d, i64 0, i64 1
  store i32 20, ptr %arrayidx.1, align 4
  %arrayidx.2 = getelementptr inbounds [2 x i32], ptr %d, i64 0, i64 2
  store i32 30, ptr %arrayidx.2, align 4
  call void @use_pointer(ptr %d)
  ret i32 0
}

; Make sure that out-of-bound stores are not considered killing other stores to
; the same underlying object, if they are in different basic blocks. The
; out-of-bounds store may not be executed.
;
; Test case from PR48279. FIXME.
define i32 @test_out_of_bounds_store_nonlocal(i1 %c) {
; CHECK-LABEL: @test_out_of_bounds_store_nonlocal(
; CHECK-NEXT:    [[D:%.*]] = alloca [1 x i32], align 4
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    store i32 10, ptr [[D]], align 4
; CHECK-NEXT:    br label [[FOR_INC:%.*]]
; CHECK:       for.inc:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[FOR_BODY_1:%.*]], label [[FOR_END:%.*]]
; CHECK:       for.body.1:
; CHECK-NEXT:    ret i32 1
; CHECK:       for.end:
; CHECK-NEXT:    call void @use_pointer(ptr [[D]])
; CHECK-NEXT:    ret i32 0
;
  %d = alloca [1 x i32], align 4
  br label %for.body

for.body:                                         ; preds = %for.cond
  store i32 10, ptr %d, align 4
  br label %for.inc

for.inc:                                          ; preds = %for.body
  br i1 %c, label %for.body.1, label %for.end

for.body.1:                                       ; preds = %for.inc
  %arrayidx.1 = getelementptr inbounds [1 x i32], ptr %d, i64 0, i64 1
  store i32 20, ptr %arrayidx.1, align 4
  ret i32 1

for.end:                                          ; preds = %for.inc
  call void @use_pointer(ptr %d)
  ret i32 0
}
