; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc --mtriple=loongarch64 --mattr=+lsx < %s | FileCheck %s

define void @register_vr1() nounwind {
; CHECK-LABEL: register_vr1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    #APP
; CHECK-NEXT:    vldi $vr1, 1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i64> asm sideeffect "vldi ${0:w}, 1", "={$vr1}"()
  ret void
}

define void @register_vr7() nounwind {
; CHECK-LABEL: register_vr7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    #APP
; CHECK-NEXT:    vldi $vr7, 1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i64> asm sideeffect "vldi ${0:w}, 1", "={$vr7}"()
  ret void
}

define void @register_vr23() nounwind {
; CHECK-LABEL: register_vr23:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    #APP
; CHECK-NEXT:    vldi $vr23, 1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i64> asm sideeffect "vldi ${0:w}, 1", "={$vr23}"()
  ret void
}

;; The lower half of the vector register '$vr31' is overlapped with
;; the floating-point register '$f31'. And '$f31' is a callee-saved
;; register which is preserved across calls. That's why the
;; fst.d and fld.d instructions are emitted.
define void @register_vr31() nounwind {
; CHECK-LABEL: register_vr31:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    fst.d $fs7, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    vldi $vr31, 1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    fld.d $fs7, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i64> asm sideeffect "vldi ${0:w}, 1", "={$vr31}"()
  ret void
}
