---
title: 'DDL: Help Center'
---

The purpose of this page is to help speakers of [Digitally Disadvantaged Languages (DDL)](/ddl) make use of the CLDR Survey Tool and processes.
Thank you for your contributions and work on your language!

## Contribute to a CLDR Locale

A CLDR locale is an important part of helping to get your language supported on laptops, phones, and so on.  

Here is an outline of those steps:

1. Ensure that the characters needed to write your language are encoded in Unicode. Luckily, this is already the case for the vast majority of modern languages. If not, see [Unicode Proposals]. Until this is done (which can take years), none of the further steps can be done.
2. If no existing keyboards handle your language, see if there are installable keyboards that can. [Keyman] is a good source.
3. Contribute to getting locale data into CLDR. The most effective way to contribute is via a [CLDR Organization].

Notes:
 - Having a CLDR locale at [Basic Coverage][Coverage] is a necessary step for being selectable on many platforms. Users still may need to install keyboards and/or fonts in order to use the language. That can enable using your language within applications. And Coverage at Moderate and Modern can improve the capabilities of those applications to handle your language.
- Applications and platforms decide which languages and locales they support; therefore, having a CLDR locale is no guarentee that it will be supported on any given application or platform.

### Individual Contributors

1. Verify the locale is visible in the [Survey Tool][Survey Tool Home]
    1. If not, fill out the form: [Core Data for New Locales].
2. Fill out the form to request an account: [Request a Survey Tool Account]
3. Review the [Information Hub for Linguists]

## Support

To get support, use the [DDL Support] form.

[DDL Support]: https://unicode.org/cldr/ddl-support
[Information Hub for Linguists]: /translation
[CLDR Organization]: /index/survey-tool/cldr-organization
[Core Data for New Locales]: /index/cldr-spec/core-data-for-new-locales
[Unicode Proposals]: https://www.unicode.org/pending/proposals.html
[Keyman]: https://keyman.com/
[Coverage]: /index/survey-tool/coverage
[Survey Tool Home]: https://st.unicode.org
[Request a Survey Tool Account]: /index/survey-tool/survey-tool-accounts
