/***************************************************************************
** Although considerable effort has been expended to make this software   **
** correct and reliable, no warranty is implied; the author disclaims any **
** obligation or liability for damages, including but not limited to      **
** special, indirect, or consequential damages arising out of or in       **
** connection with the use or performance of this software.               **
***************************************************************************/

/*
 *	The following memory allocation / free routines utilize the
 *	VMS memory routines. The first two longwords of each block
 *	allocated are used internally to supply the memory block's
 *	size, and to link all blocks allocated with these routines
 *	together to facilitate mass release, without having to worry
 *	about what does or doesn't exist.
 */

struct Memory {
	struct Memory *Link;
	unsigned long Mem_Size;
	char Mem[];
};

struct Memory *Mem_Head = 0;	/* Allocated memory listhead */
unsigned long Mem_Zone;		/* Assigned zone */

int Mem_Init ()
{
	return (1);
}

char *Mem_Alloc (Size)
unsigned int Size;
{
	auto   unsigned long Sys_Status;
	auto   struct Memory *M_Ptr;
	auto   unsigned long M_Size;
	extern unsigned long Lib$Get_VM(), Lib$Signal();
	extern int Check_System_Status();

	M_Size = (Size + sizeof (struct Memory) + 3) & ~0x03;
	Sys_Status = Lib$Get_VM (&M_Size, &M_Ptr);
	if ((Sys_Status & 0x01) == 0) {
		Lib$Signal (Sys_Status);
		return (0);
	}
	M_Ptr->Link = Mem_Head;
	Mem_Head = M_Ptr;
	M_Ptr->Mem_Size = M_Size;
	return (M_Ptr->Mem);
}

Mem_Free (Mem_Ptr)
char *Mem_Ptr;
{
	auto   unsigned long Sys_Status;
	auto   struct Memory *M_Ptr, *M_Ptr0;
	auto   unsigned long M_Size;
	extern unsigned long Lib$Free_VM();
	extern int Check_System_Status();

	for (M_Ptr0 = (struct Memory *) &Mem_Head; (M_Ptr = M_Ptr0->Link) != 0; M_Ptr0 = M_Ptr)
	if (Mem_Ptr == &M_Ptr->Mem[0]) {
		M_Ptr0->Link = M_Ptr->Link;
		M_Size = M_Ptr->Mem_Size;
		Sys_Status = Lib$Free_VM (&M_Size, &M_Ptr);
		Check_System_Status (Sys_Status);
		break;
	}
}

Liberate_Memory ()
{
	auto   struct Memory *M_Ptr;

	while ((M_Ptr = Mem_Head) != 0)
		Mem_Free (M_Ptr->Mem);
}
