/***************************************************************************
** Although considerable effort has been expended to make this software   **
** correct and reliable, no warranty is implied; the author disclaims any **
** obligation or liability for damages, including but not limited to      **
** special, indirect, or consequential damages arising out of or in       **
** connection with the use or performance of this software.               **
***************************************************************************/

/*
 *	Command line processing routines:
 */

#include descrip

#include "strng.p"

/*
 *	Get_Input_File_Name obtains the next input filename in
 *	the command line.
 */

int Get_Input_File_Name (File_Name, Name_Size)
char *File_Name;
unsigned int Name_Size;
{
	extern int Get_Run_Option_Value();

	return (Get_Run_Option_Value ("P1", File_Name, Name_Size));
}

/*
 *	Check_Run_Option checks the command line for the presence
 *	or absence of an on/off command line option. The function
 *	return 0 if it is not present at all, +1 if it is positively
 *	asserted, or -1 if it is negated.
 */

int Check_Run_Option (Primary, Secondary, Scope)
char *Primary, *Secondary;
int Scope;
{
	static char Switch_Name[80];
	extern int VMS_Cli_Present();

	stringcpy_m (Switch_Name, Primary, sizeof (Switch_Name));
	if (*Secondary != '\0') {
		stringcat_m (Switch_Name, ".", sizeof (Switch_Name));
		stringcat_m (Switch_Name, Secondary, sizeof (Switch_Name));
	}
	return (VMS_Cli_Present (Switch_Name, Scope));
}

/*
 *	Get_Run_Option_Value obtains the next value for a given
 *	switch value.
 */

int Get_Run_Option_Value (Name, Value_Ptr, Val_Size)
char *Name, *Value_Ptr;
unsigned int Val_Size;
{
	static struct dsc$descriptor In_Desc, Out_Desc;
	static unsigned short Length;
	extern unsigned long Cli$Get_Value();
	globalvalue CLI$_ABSENT;

	Make_VMS_Descriptor (Name, &In_Desc);
	Set_VMS_Descriptor (Value_Ptr, Val_Size-1, &Out_Desc);
	if (Cli$Get_Value (&In_Desc, &Out_Desc, &Length) == CLI$_ABSENT) {
		Value_Ptr[0] = '\0';
		return (0);
	}
	Value_Ptr[Length] = '\0';
	return (1);
}

int VMS_Cli_Present (Switch_Name, Scope)
char *Switch_Name;
int Scope;
{
	auto   unsigned long Sys_Status;
	auto   int Indicator;
	static struct dsc$descriptor Name_Desc;
	extern unsigned long Cli$Present();
	extern int Check_System_Status();
	globalvalue CLI$_ABSENT, CLI$_DEFAULTED, CLI$_LOCNEG, CLI$_LOCPRES;
	globalvalue CLI$_NEGATED, CLI$_PRESENT;

	Make_VMS_Descriptor (Switch_Name, &Name_Desc);
	Sys_Status = Cli$Present (&Name_Desc);
	if (Sys_Status == CLI$_DEFAULTED ||
	    (Sys_Status == CLI$_PRESENT && Scope <= 0) ||
	    (Sys_Status == CLI$_LOCPRES && Scope >= 0))
		Indicator = 1;
	else if ((Sys_Status == CLI$_NEGATED && Scope <= 0) ||
		 (Sys_Status == CLI$_LOCNEG && Scope >= 0))
		Indicator = -1;
	else if (Sys_Status == CLI$_ABSENT)
		Indicator = 0;
	else {
		Check_System_Status (Sys_Status);
		Indicator = 0;
	}
	return (Indicator);
}
