/***************************************************************************
** Although considerable effort has been expended to make this software   **
** correct and reliable, no warranty is implied; the author disclaims any **
** obligation or liability for damages, including but not limited to      **
** special, indirect, or consequential damages arising out of or in       **
** connection with the use or performance of this software.               **
***************************************************************************/

/*
 *	This file contains modules for manipulating VMS library
 *	files.
 */

#include lbrdef
#include descrip
#include "iostatus.h"
#include "vmsio.h"

struct LFAB *Open_Text_Library (Name, Default_Name, Mode, Status_Ptr)
char *Name, *Default_Name, *Mode;
unsigned long *Status_Ptr;
{
	extern struct LFAB *Open_Library();

	return (Open_Library (Name, Default_Name, Mode, LBR$C_TYP_TXT, Status_Ptr));
}

struct LFAB *Open_Library (Name, Default_Name, Mode, Lib_Type, Status_Ptr)
char *Name, *Default_Name, *Mode;
unsigned long Lib_Type, *Status_Ptr;
{
	auto   struct LFAB *LFab_Ptr;
	auto   unsigned long Sys_Status;
	static struct dsc$descriptor Name_Desc, Def_Name_Desc;
	static char *Lib_Ext[] = { "", ".OLB", ".MLB", ".HLB", ".TLB", ".OLB" };
	static char Def_Name[256];
	extern struct LFAB *LFab_Alloc();
	extern struct NAM *Nam_Alloc();
	extern unsigned long Lbr$Ini_Control(), Lbr$Open(), Lbr$Close();
	extern int Check_System_Status();
	globalvalue LBR$_OLDLIBRARY, LBR$_NORMAL;
/*
 *	Allocate and set up the control block:
 */
	LFab_Ptr = LFab_Alloc ((Lib_Type <= 5) ? Lib_Type : 0, Mode, Nam_Alloc ());
	Make_VMS_Descriptor (Name, &Name_Desc);
/*
 *	Set up the library default name. If the supplied default name
 *	does not have a file extension defined, add the default file
 *	extension to the default name (for some reason, LBR$OPEN does
 *	not supply a default file extension based upon the library
 *	type):
 */
	if (Default_Name == 0)
		Make_VMS_Descriptor (Lib_Ext[LFab_Ptr->lfab$l_type], &Def_Name_Desc);
	else {
		Add_File_Defaults (Default_Name, Lib_Ext[LFab_Ptr->lfab$l_type], Def_Name, 0);
		Make_VMS_Descriptor (Def_Name, &Def_Name_Desc);
	}
/*
 *	Initialize the control structure and open the library file:
 */
	Sys_Status = Lbr$Ini_Control (&LFab_Ptr->lfab$l_index, &LFab_Ptr->lfab$l_func,
				      &LFab_Ptr->lfab$l_type, LFab_Ptr->lfab$l_nam);
	*Status_Ptr = Sys_Status;
	if (Check_System_Status (Sys_Status) == 0) {
		Free_LFab (LFab_Ptr);
		return (0);
	}
	Sys_Status = Lbr$Open (&LFab_Ptr->lfab$l_index, &Name_Desc, 0, &Def_Name_Desc, 0, 0, 0);
	if (Sys_Status == LBR$_OLDLIBRARY)
		Sys_Status = LBR$_NORMAL;
	*Status_Ptr = Sys_Status;
	if (Check_System_Status (Sys_Status) == 0) {
		Lbr$Close (&LFab_Ptr->lfab$l_index);
		Free_LFab (LFab_Ptr);
		return (0);
	}
	return (LFab_Ptr);
}

Close_Library (LFab_Ptr)
struct LFAB *LFab_Ptr;
{
	auto   unsigned long Sys_Status;
	extern unsigned long Lbr$Close();
	extern int Check_System_Status();

	Sys_Status = Lbr$Close (&LFab_Ptr->lfab$l_index);
	Check_System_Status (Sys_Status);
	Free_LFab (LFab_Ptr);
}

Free_LFab (LFab_Ptr)
struct LFAB *LFab_Ptr;
{
	Mem_Free (LFab_Ptr->lfab$l_nam);
	Mem_Free (LFab_Ptr);
}

struct LRAB *Open_Library_File (Module_Name, EOLStr, LFab_Ptr, Status_Ptr)
char *Module_Name, *EOLStr;
struct LFAB *LFab_Ptr;
unsigned long *Status_Ptr;
{
	auto   struct LRAB *LRab_Ptr;
	auto   unsigned long Sys_Status;
	static struct dsc$descriptor Module_Desc;
	static unsigned long RFA[2];
	extern struct LRAB *LRab_Alloc();
	extern unsigned long Lbr$Lookup_Key(), Lbr$Set_Locate();
	extern int Check_System_Status();

	LRab_Ptr = 0;
	Make_VMS_Descriptor (Module_Name, &Module_Desc);
	Sys_Status = Lbr$Lookup_Key (&LFab_Ptr->lfab$l_index, &Module_Desc, &RFA[0]);
	*Status_Ptr = Sys_Status;
	if (Check_System_Status (Sys_Status) != 0) {
		LRab_Ptr = LRab_Alloc (LFab_Ptr, EOLStr);
		LRab_Ptr->lrab$l_rfa[0] = RFA[0];
		LRab_Ptr->lrab$l_rfa[1] = RFA[1];
		Set_VMS_Descriptor (0, 0, &LRab_Ptr->lrab$l_bufdesc);
		LRab_Ptr->lrab$l_curdesc = LRab_Ptr->lrab$l_bufdesc;
		LRab_Ptr->lrab$w_flags = 0;
		Lbr$Set_Locate (&LFab_Ptr->lfab$l_index);
	}
	return (LRab_Ptr);
}

Close_Library_File (LRab_Ptr)
struct LRAB *LRab_Ptr;
{
	Mem_Free (LRab_Ptr);
}

/*
 *	Routine Read_Library_Character reads the next character
 *	from the current module in the library file. It alternates
 *	between the file buffer and the end of line string.
 */

unsigned char Read_Library_Character (LRab_Ptr)
struct LRAB *LRab_Ptr;
{
	auto   struct LFAB *LFab_Ptr;
	auto   struct dsc$descriptor *Desc_Ptr;
	auto   unsigned long Sys_Status;
	extern unsigned long Lbr$Get_Record();
	extern int Check_System_Status();
	globalvalue RMS$_EOF;

	Desc_Ptr = &LRab_Ptr->lrab$l_curdesc;
	while (Desc_Ptr->dsc$w_length == 0) {
		if ((LRab_Ptr->lrab$w_flags & LRAB$M_EOLSTR) == 0) {
			LFab_Ptr = LRab_Ptr->lrab$l_lfab;
			if ((LRab_Ptr->lrab$w_flags & LRAB$M_EOF) != 0 ||
			    (Sys_Status = Lbr$Get_Record (&LFab_Ptr->lfab$l_index, 0,
							  &LRab_Ptr->lrab$l_bufdesc)) == RMS$_EOF ||
			    Check_System_Status (Sys_Status) == 0) {
				LRab_Ptr->lrab$w_flags |= LRAB$M_EOF;
				return ('\0');
			}
			LRab_Ptr->lrab$l_nreads++;
			*Desc_Ptr = LRab_Ptr->lrab$l_bufdesc;
		} else
			*Desc_Ptr = LRab_Ptr->lrab$l_eoldesc;
		LRab_Ptr->lrab$w_flags ^= LRAB$M_EOLSTR;
	}
	Desc_Ptr->dsc$w_length--;
	return (*Desc_Ptr->dsc$a_pointer++);
}

int Lib_At_EOF (LRab_Ptr)
struct LRAB *LRab_Ptr;
{
	return (((LRab_Ptr->lrab$w_flags & LRAB$M_EOF) != 0) ? 1 : 0);
}

Get_Library_Stats (LRab_Ptr, Stats)
struct LRAB *LRab_Ptr;
unsigned long Stats[2];
{
	Stats[0] = LRab_Ptr->lrab$l_nreads;
	Stats[1] = LRab_Ptr->lrab$l_nwrites;
}

struct LFAB *LFab_Alloc (Lib_Type, Mode, Nam_Ptr)
unsigned long Lib_Type;
char *Mode;
struct NAM *Nam_Ptr;
{
	auto   struct LFAB *LFab_Ptr;
	extern char *Mem_Alloc();

	LFab_Ptr = (struct LFAB *) Mem_Alloc (sizeof (struct LFAB));
	Table_Init (LFab_Ptr, LFAB$C_BID, LFAB$C_BLN);
	LFab_Ptr->lfab$l_type = Lib_Type;
	LFab_Ptr->lfab$l_func = (*Mode == 'r') ? LBR$C_READ : LBR$C_UPDATE;
	LFab_Ptr->lfab$l_nam = Nam_Ptr;
	return (LFab_Ptr);
}

struct LRAB *LRab_Alloc (LFab_Ptr, EOLStr)
struct LFAB *LFab_Ptr;
char *EOLStr;
{
	auto   struct LRAB *LRab_Ptr;
	extern char *Mem_Alloc();
	extern int strlen();

	LRab_Ptr = (struct LRAB *) Mem_Alloc (sizeof (struct LRAB));
	Table_Init (LRab_Ptr, LRAB$C_BID, LRAB$C_BLN);
	LRab_Ptr->lrab$l_lfab = LFab_Ptr;
	Set_VMS_Descriptor (EOLStr, (EOLStr == 0) ? 0 : strlen (EOLStr), &LRab_Ptr->lrab$l_eoldesc);
	return (LRab_Ptr);
}
