/*
 *	The Device Table contains technical data on each device
 *	configured in the program, and pointers to the procedures
 *	that perform device-level functions. These include:
 *
 *	o Set layout - do whatever the device driver thinks is
 *	      is necessary to set up the physical layout of the
 *	      device to fit the maximum page size. This also
 *	      functions as the device initializing function.
 *
 *	o Terminate - do whatever is necessary to disconnect the
 *	      output stream from the program.
 *
 *	o Initialize for new page - clear screen or whatever needs
 *	      to be done at the device to prepare for a new page.
 *
 *	o Eject current page - eject paper or do whatever is necessary
 *	      to dispose of the current page. The number of copies
 *	      specified in Set Layout are top be printed.
 *
 *	o Download characters from given font with a given magnification.
 *	      (Note that the font is being downloaded to the device
 *	      driver; this may or may not result in a physical
 *	      downloading at the device. If a device driver does not
 *	      support downloadable fonts, characters will always be
 *	      typeset using pixel arrays.) Once a font is downloaded,
 *	      it is 'resident'. Fonts downloaded between a beginning of page
 *	      and end of page are temporary, and the resources used by the
 *	      downloaded font should be released after the end of page is
 *	      seen, if possible.
 *
 *	o Typeset a string at (h,v) - given a set of character numbers
 *	      in a resident font, typeset it with the character origin
 *	      at the indicated device position.
 *
 *	o Typeset pixel array at (h,v) - given a pixel array (which
 *	      will usually contain a character in a non-resident
 *	      font), typeset it at the indicated device position.
 *
 *	o Typeset a rule given by width and height at (h,v) - draw
 *	      a solid rectangle at the indicated device position.
 *	      (h,v) specifies the lower left corner of the rule.
 *
 *	o Save the current implicit graphics parameter (linestyle,
 *	      linewidth, color) on a stack, to be restored later.
 *
 *	o Restore the implicit graphics parameters from a previously
 *	      saved state.
 *
 *	o Typeset a filled rectangle with a given width and height
 *	      at (h,v) according to a given pixel array. (h,v)
 *	      specifies the lower left corner of the Rectangle.
 *	      [Graphics extension]
 *
 *	o Typeset a line given by the two endpoints (h1,v1) and
 *	      (h2,v2). [Graphics extension]
 *
 *	o Typeset a single point at (h,v) with a specified diameter.
 *	      [Graphics extension]
 *
 *	o Typeset an arc given by two inclusive angles (in thousandths
 *	      of a degree) on the circle defined with center (h,v) and
 *	      given radius. [Graphics extension]
 *
 *	o Set the line width to be used for drawing subsequent lines.
 *	      [Graphics extension]
 *
 *	o Set the line style to use in subsequent lines. This is
 *	      specified using an on/off segment array and beginning
 *	      phase. [Graphics extension]
 *
 *	o Set the color to be used for all subsequent output. The
 *	      color is specified by perthousand values of red, green
 *	      and blue. [Graphics extension]
 */

struct Device_Table {
	unsigned char *Device_Name;	/* The device's first name */
	unsigned long Device_Memory;	/* Resident amount of memory, in K bytes */
	unsigned long Max_Fonts;	/* Maximum number of fonts */
	unsigned long Device_Flags;	/* Various flags */
	struct Ratio Device_Resolution; /* in pixels per inch */
	struct Ratio Aspect_Ratio;	/* Ratio of y/x (usually 1/1) */
	unsigned int Mask_Resolution[2];/* Required fill mask multiples */
	char *Default_Font_Directory;	/* Place where the pixel files can be found */
	char **Native_Font_Prefix;	/* Prefixes of native fonts, if any */
	int (*Set_Layout)();
	int (*Terminate)();
	int (*Setup_New_Page)();
	int (*Eject_Page)();
	int (*Download_Font)();
	int (*Typeset_String)();
	int (*Typeset_Pixel)();
	int (*Typeset_Rule)();
	int (*Typeset_Filled)();
	int (*Typeset_Line)();
	int (*Typeset_Point)();
	int (*Typeset_Arc)();
	int (*Set_Linewidth)();
	int (*Set_Linestyle)();
	int (*Set_Color)();
	int (*Save_Graphics)();
	int (*Restore_Graphics)();
};
