---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, inclure du code dans un document, mode verbatim, 
              \verb, en-têtes personnalisées
---

# Comment gérer des en-têtes avec des environnements `verbatim` multipages ?

En temps normal, les en-têtes et pieds de page ne posent pas trop de difficultés 
avec l'environnement `verbatim` (détaillé à la question 
"[](/4_domaines_specialises/sciences/informatique/verbatim/ecrire_en_mode_verbatim)").

Il existe toutefois un cas assez particulier demandant deux conditions :
- vous utilisez un environnement `verbatim` comprenant un changement de page ;
- vous utilisez dans votre en-tête ou votre pied de page une commande `\input`.

Dans ce cas, LaTeX, au lieu d'interpréter la commande `\input`, 
fait un copier-coller du contenu du fichier appelé par la commande `\input` 
(comme s'il était en mode verbatim au moment de traiter `\input`).

:::{important}
Le phénomène décrit n'est plus observé depuis la version ``v4.2
2024/04/19`` de <ctanpkg:fancyhdr>, voir
[fancyhdr#8](https://github.com/pietvo/fancyhdr/issues/8).
D'autres problèmes de la même famille existent par ailleurs,
par exemple avec <ctanpkg:xspace> voir
[latex2e#600](https://github.com/latex3/latex2e/issues/600).
:::

Voici un exemple de ce cas en peu tordu. 
Le fichier `entete.tex` que nous voulons placer dans l'en-tête avec `\input` contient 
l'unique ligne suivante :

```{noedit}
\textbf{Démonstration édifiante}
```

Pour les besoins de notre FAQ, ce fichier est créé par les premières lignes 
du code ci-dessous. Mais vous pouvez procéder sans ces lignes en plaçant 
le fichier `entete.tex` dans le même dossier que le fichier d'exemple ci-dessous 
(en supprimant les premières lignes alors inutiles).

Dès lors, notre fichier principal avec le code suivant va mal interprêter notre besoin : 
l'en-tête de la première page restitue le code du fichier `entete.tex` 
(par contre, la seconde page est correcte).


```
% Code particulier pour rendre l'exemple observable dans la FAQ
\begin{filecontents}[force,noheader]{entete}
\textbf{Démonstration édifiante}
\end{filecontents}
% Fin du code particulier

\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{fancyhdr}

  \pagestyle{fancy}
  \fancyhead[C]{\input{entete}}

\begin{document}
\section{Un peu de vide pour commencer}
\vspace{16cm}
\section{Un exemple}
Un premier document en \LaTeX{} :
\begin{verbatim}
\documentclass{article}
\begin{document}
Salut, le monde !
\end{document}
\end{verbatim}
\end{document}
```

Pour corriger cela, vous pouvez utiliser les commandes `\newsavebox` et `\savebox` 
pour conserver le contenu de ce fichier. Par la suite, vous pouvez utiliser 
la commande `\usebox` pour restituer le contenu de cette boîte.

```
% Code particulier pour rendre l'exemple observable dans la FAQ
\begin{filecontents}[force,noheader]{entete}
\textbf{Démonstration édifiante}
\end{filecontents}
% Fin du code particulier

\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{fancyhdr}

  \newsavebox{\logo}
  \savebox{\logo}[2cm][c]{\input{entete}}

  \pagestyle{fancy}
  \fancyhead[C]{\usebox{\logo}}

\begin{document}
\section{Un peu de vide pour commencer}
\vspace{16cm}
\section{Un exemple}
Un premier document en \LaTeX{} :
\begin{verbatim}
\documentclass{article}
\begin{document}
Salut, le monde !
\end{document}
\end{verbatim}
\end{document}
```
