;;; dgnushack-xemacs.el --- a version of dgnushack.el for XEmacs package
(defalias 'facep 'ignore)

(defalias 'device-sound-enabled-p 'ignore)
(defalias 'play-sound-file 'ignore)
(defalias 'nndb-request-article 'ignore)
(defalias 'efs-re-read-dir 'ignore)
(defalias 'ange-ftp-re-read-dir 'ignore)
(defalias 'define-mail-user-agent 'ignore)


(eval-and-compile
  (when (featurep 'xemacs)
    ;; XEmacs 21.1 needs some extra hand holding
    (when (eq emacs-minor-version 1)
      (autoload 'custom-declare-face "cus-face" nil t)
      (autoload 'cl-compile-time-init "cl-macs" nil t)
      (autoload 'defadvice "advice" nil nil 'macro))
    (unless (fboundp 'defadvice)
      (autoload 'defadvice "advice" nil nil 'macro))
    (autoload 'Info-directory "info" nil t)
    (autoload 'Info-menu "info" nil t)
    (autoload 'annotations-at "annotations")
    (autoload 'apropos "apropos" nil t)
    (autoload 'apropos-command "apropos" nil t)
    (autoload 'bbdb-complete-name "bbdb-com" nil t)
    (autoload 'browse-url "browse-url" nil t)
    (autoload 'customize-apropos "cus-edit" nil t)
    (autoload 'customize-save-variable "cus-edit" nil t)
    (autoload 'customize-variable "cus-edit" nil t)
    (autoload 'delete-annotation "annotations")
    (autoload 'dolist "cl-macs" nil nil 'macro)
    (autoload 'enriched-decode "enriched")
    (autoload 'info "info" nil t)
    (autoload 'make-annotation "annotations")
    (autoload 'make-display-table "disp-table")
    (autoload 'pp "pp")
    (autoload 'ps-despool "ps-print" nil t)
    (autoload 'ps-spool-buffer "ps-print" nil t)
    (autoload 'ps-spool-buffer-with-faces "ps-print" nil t)
    (autoload 'read-passwd "passwd")
    (autoload 'regexp-opt "regexp-opt")
    (autoload 'reporter-submit-bug-report "reporter")
    (if (emacs-version>= 21 5)
	(autoload 'setenv "process" nil t)
      (autoload 'setenv "env" nil t))
    (autoload 'smtpmail-send-it "smtpmail")
    (autoload 'sort-numeric-fields "sort" nil t)
    (autoload 'sort-subr "sort")
    (autoload 'trace-function-background "trace" nil t)
    (autoload 'w3-do-setup "w3")
    (autoload 'w3-prepare-buffer "w3-display")
    (autoload 'w3-region "w3-display" nil t)
    (defalias 'match-string-no-properties 'match-string)
    (defalias 'frame-char-height 'frame-height)
    (defalias 'frame-char-width 'frame-width)
    (defalias 'frame-parameter 'frame-property)
    (defalias 'make-overlay 'ignore)
    (defalias 'overlay-end 'ignore)
    (defalias 'overlay-get 'ignore)
    (defalias 'overlay-put 'ignore)
    (defalias 'overlay-start 'ignore)
    (defalias 'overlays-in 'ignore)
    (defalias 'replace-dehighlight 'ignore)
    (defalias 'replace-highlight 'ignore)
    (defalias 'run-with-idle-timer 'ignore)
    (defalias 'w3-coding-system-for-mime-charset 'ignore)
    (defalias 'timer-create 'make-itimer)
    (defalias 'cancel-timer 'delete-itimer)
    (defalias 'timer-activate 'activate-itimer)
    (defalias 'timer-set-time 'set-itimer-value)
    (defalias 'timer-set-function 'set-itimer-function)
    (unless (fboundp 'timer-relative-time)
      (defun timer-relative-time (time secs &optional usecs)
	"Advance TIME by SECS seconds and optionally USECS microseconds.
SECS may be a fraction."
	(let ((high (car time))
	      (low (if (consp (cdr time)) (nth 1 time) (cdr time)))
	      (micro (if (numberp (car-safe (cdr-safe (cdr time))))
			 (nth 2 time)
		       0)))
	  ;; Add
	  (if usecs (setq micro (+ micro usecs)))
	  (if (floatp secs)
	      (setq micro (+ micro (floor (* 1000000 (- secs (floor secs)))))))
	  (setq low (+ low (floor secs)))
	  ;; Normalize
	  (setq low (+ low (/ micro 1000000)))
	  (setq micro (mod micro 1000000))
	  (setq high (+ high (/ low 65536)))
	  (setq low (logand low 65535))
	  (list high low (and (/= micro 0) micro)))))))



;;; dgnushack-xemacs.el ends here
