.TH sane-mustek_pp 5 "February 20 2002"
.IX sane-mustek_pp
.SH NAME
sane-mustek_pp - SANE backend for Mustek parallel port flatbed scanners
.SH DESCRIPTION
The
.B sane-mustek_pp
library implements a SANE (Scanner Access Now Easy) backend that
provides access to Mustek parallel port flatbed scanners and OEM versions.

There are 2 classes of Mustek parallel port scanners: regular 
.B CCD
(cold cathode device) scanners and 
.B CIS 
(contact image sensor) scanners.

Previous versions of this backend only supported CCD type scanners. Patches 
for CIS type scanners were available, but simultaneous support for both 
types was not possible. The current version of the driver enables both types
to co-exist. The CIS drivers have been ported to it already, and work
is going on to port the CCD drivers too. Currently there is no CCD support however. For CCD
scanners, use the
.BR sane-mustek_pp_ccd(5)
backend.


The following scanners might work with this backend:

.TP
.BR "CCD scanners" " (currently not hooked up yet, use mustek_pp_ccd backend)"
.PP
.RS
Model:               ASIC ID:  CCD Type:  works:
.br
-------------------- --------- ---------- -------
.br
SE 6000 P            1013      00          yes
.br
SM 4800 P            1013/1015 04/01       yes
.br
SE 1200 ED Plus      1015      01          partly
.br
SM 1200 ED Plus      1015      01          partly
.br
SE 12000 P           1505      05          no
.br
600 III EP Plus      1013/1015 00/01       yes
.br
SE 600 SEP           1013      ??          yes
.br
600 II EP            ????      ??          no
.br
MD9848               1015      00          yes
.br
Gallery 4800         ????      ??          yes
.br
Viviscan Compact II  1013      00          yes
.br
.RE
.PP
.B CIS scanners
.PP
.RS
Model:                 ASIC ID:   works:
.br
---------------------  ---------  -------
.br
Mustek 600 CP & 96 CP  1015        yes (*)
.br
Mustek 1200 CP         1015        yes
.br
Mustek 1200 CP+        1015        yes

OEM versions           Original   works 
.br
---------------------  ---------  ----------
.br
Medion/LifeTec/Tevion
.br
   MD/LT 9350/9351     1200 CP     yes
.br 
   MD/LT 9850/9851     1200 CP     maybe (**)
.br 
   MD/LT 9858          1200 CP     probably
.br
   MD/LT 9890/9891     1200 CP     yes
.br
Targa 
.br
   Funline TS12EP      1200 CP     yes
.br
   Funline TS6EP        600 CP     yes
.br
Trust  
.br
   Easy Connect 9600+   600 CP     yes
.RE

.PP
.HP 
(*)   Calibration  problems existed with earlier version of
this driver. They seem to be solved now.
.HP 
(**)   Problems have been reported in the past for the
MD/LT9850 type (striped scans, head moving in wrong
direction at some resolutions). It is not known whether
the current version of the driver still has these problems.
.br
.B  IF YOU HEAR LOUD CLICKING NOISES, IMMEDIATELY UNPLUG THE SCANNER !
(This holds for any type of scanner).
.PP


Please note that this backend is still under construction. Certain models
are currently not supported and some may never be because the communication
protocol is still unknown (eg., SE 12000 P).
.PP
Some scanners work faster when 
.B EPP/ECP
is enabled in the BIOS.
.PP
Note that the backend needs to run as root. To allow user access to the scanner
run the backend through the network interface (See saned(1) and sane\-net(5)). Note also that the backend
.I does not
support
.I parport sharing ,
i.e. if you try printing while scanning, your computer may crash. This backend
also conflicts with the
.I sane\-musteka4s2
backend. You can only enable one of them in your dll.conf. However, you have
to enable the backend explicitly in your dll.conf, just remove the hash mark
in the line "mustek_pp".

.SH "DEVICE DEFINITION"
This backend allows multiple devices being defined and configured via the 
.B 
mustek_pp.conf
file (even simultaneously, provided that they are connected to different
parallel ports). Please make sure to edit this file
.B before
you use the backend.

A device can be defined as follows:
.PP
.RS
.I scanner <name> <port name> <driver>
.RE
.PP
where
.HP
.B <name>
is an arbitrary name for the device, optionally enclosed by double quotes,
for instance "LifeTec 9350".
.PP
.HP
.B <port name>
is the name of the parallel port to which the device is connected. In case
libieee1284 is used for communication with the port
.I (default 
.IR setup) , 
valid port names are 
.BR parport0 , 
.BR parport1 , 
and
.BR parport2 .

In case the backend is configured for raw IO
.I (old 
.IR setup) ,
port addresses have to be used instead of port names:
.BR 0x378 ,
.BR 0x278 , 
or
.BR 0x3BC .
The mapping of parallel ports (lp0, lp1, and lp2) to these addresses 
can be different for different Linux kernel versions. For instance,
if you are using a Kernel 2.2.x or better and you have only one
parallel port, this port is named lp0 regardless of the base address. However,
this backend requires the base address of your port. If you are not sure which
port your scanner is connected to, have a look at your /etc/conf.modules,
/etc/modules.conf and/or /proc/ioports.
.PP
.HP
.B <driver>
is the driver to use for this device. Currently available drivers are:
.IP
.BR cis600 "   : for 600 CP, 96 CP & OEM versions"
.br
.BR cis1200 "  : for 1200 CP & OEM versions"
.br  
.BR cis1200+ " : for 1200 CP+ & OEM versions"
.IP
.B Choosing  the  wrong  driver  can  damage  your scanner!
.br
Especially, using the 1200CP settings on a 600CP can be
harmful. If the scanner starts making a loud noice, turn
it off immediately !!!
.br
Using the cis600 driver on a 1200CP or a 1200CP+ is probably not
dangerous. The cis1200+ driver also works for the 1200CP, and using
the cis1200 driver on a 1200CP+ will typically result in scans that
cover only half of the width of the scan area (also not dangerous).
.br
If unsure about the exact model of your OEM version, check the optical
resolution in the manual or on the box: the 600CP has a maximum optical
resolution of 300x600 DPI, whereas the 1200CP and 1200CP+ have a maximum 
optical resolution of 600x1200 DPI. 

.PP
Examples:
.PP
.RS 
scanner "LifeTec 9350" 0x378 cis1200
.PP
scanner Mustek_600CP 0x378 cis600
.RE


.SH CONFIGURATION
.PP
The contents of the
.B mustek_pp.conf
file is a list of device definitions and device options that correspond to 
Mustek scanners.  Empty lines and lines starting with a hash mark (#) are
ignored. Options have the following format:
.PP
.RS
.I option <name> [<value>]
.RE
.PP
Depending on the nature of the option, a value may or may not be present.
Options always apply to the scanner definition that preceeds them. There
are no global options. Options are also driver-specific: not all drivers
support all possible options. 

.TP
.B Common options
.RS 4
.PP
.HP
.B bw <value>
Black/white discrimination value to be used during lineart scanning. Pixel
values below this value are assumed to be black, values above are
assumed to be white. 
.br
Default value: 127
.br 
Minimum:         0
.br 
Maximum:       255
.PP
Example:  option bw 150
.PP
.RE
.TP
.B CIS driver options
.RS 4
.PP
.HP
.B top_adjust <value>
Vertical adjustment of the origin, expressed in millimeter (floating point). 
This option can be used to calibrate the position of the origin, within
certain limits. Note that CIS scanners are probably temperature sensitive, and
that a certain inaccuracy may be hard to avoid. Differences in offset between
runs in the order of 1 to 2 mm are not unusual.
.br
Default value: 0.0
.br
Minimum:      -5.0
.br
Maximum:       5.0
.br
.PP
Example:  option top_skip -2.5
.HP
.B slow_skip
Turns fast skipping to the start of the scan region off. When the region to
scan does not start at the origin, the driver will try to move the scanhead
to the start of the scan area at the fastest possible speed. On some models,
this may not work, resulting in large inaccuracies (up to centimeters).
By setting this option, the driver is forced to use normal speed during
skipping, which can circumvent the accuracy problems. Currently, there are 
no models for which these inaccuracy problems are known to occur.
.br
By default, fast skipping is used.
.PP
Example:  option slow_skip
.PP
.RE
.TP
.B CCD driver options
.RS 4
.HP
To be defined. 
.PP
.RE

.PP
A sample configuration file is shown below:
.PP
.RS
#
.br
# LifeTec/Medion 9350 on port 0x378
.br
#
.br
scanner "LifeTec 9350" 0x378 cis1200

   # Some calibration options (examples!).
.br
   option bw 127
.br
   option top_skip -0.8

#
.br
# A Mustek 600CP on port 0x3BC
.br
#
.br
scanner "Mustek 600CP" 0x3BC cis600

   # Some calibration options (examples!).
.br
   option bw 120
.br
   option top_skip 1.2

#
.br
# A Mustek 1200CP+ on port 0x278
.br
#
.br
scanner "Mustek 1200CP plus" 0x278 cis1200+

   # Some calibration options (examples!).
.br
   option bw 130
.br
   option top_skip 0.2
.RE

.SH FILES
.TP
.I @CONFIGDIR@/mustek_pp.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane\-mustek_pp.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-mustek_pp.so
The shared library implementing this backend (present on systems that
support dynamic loading).

.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP
.B SANE_DEBUG_MUSTEK_PP
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.

.PP
.RS
level   debug output
.br
------- ------------------------------
.br
 0       nothing
.br
 1       errors
.br
 2       warnings & minor errors
.br
 3       additional information
.br
 4       debug information
.br
 5       code flow (not supported yet)
.br
 6       special debug information
.RE
.PP
.TP
.B SANE_DEBUG_SANEI_PA4S2
This variable sets the debug level for the SANE interface for the Mustek
chipset A4S2. Note that enabling this will spam your terminal with some
million lines of debug output.

.PP
.RS
level   debug output
.br
------- -------------------------------
.br
 0       nothing
.br
 1       errors
.br
 2       warnings
.br
 3       things nice to know
.br
 4       code flow
.br
 5       detailed code flow
.br
 6       everything
.RE
.PP
 
.PP
.SH "SEE ALSO"
sane(7), sane\-mustek_pp_ccd(5), sane\-mustek(5), sane\-net(5), saned(1)

.TP
For latest bug fixes and information see
.I http://www.penguin-breeder.org/?page=mustek_pp

.TP
For the latest CIS driver versions, see
.I http://home.tiscalinet.be/EddyDeGreef/

.SH AUTHORS
Jochen Eisinger <jochen.eisinger@gmx.net> 
.br
Eddy De Greef <eddy_de_greef at tiscali dot be>

.SH BUGS
Too many... please send bug reports to 
.I sane\-devel@lists.alioth.debian.org
(note that you have to subscribe first to the list before you can send
emails... see http://www.sane\-project.org/mailing\-lists.html)
.PP
.RS
* 1013 support isn't bullet proofed
.br
* 1505 support isn't even present
.br
* 1015 only works for CCD type 00 & 01 (01 only bw/grayscale)
.RE


.SH BUG REPORTS
If something doesn't work, please contact us (Jochen for the CCD scanners,
Eddy for the CIS scanners). But we need some information about
your scanner to be able to help you...

.TP
.I SANE version
run "scanimage -V" to determine this
.TP
.I the backend version and your scanner hardware
run "SANE_DEBUG_MUSTEK_PP=128 scanimage -L" as root. If you don't get any output
from the mustek_pp backend, make sure a line "mustek_pp" is included into
your @CONFIGDIR@/dll.conf.
If your scanner isn't detected, make sure you've defined the right port address
in your mustek_pp.conf.
.TP
.I the name of your scanner/vendor
also a worthy information. Please also include the optical resolution and lamp type of your scanner, both can be found in the manual of your scanner.
.TP
.I any further comments
if you have comments about the documentation (what could be done better), or you
think I should know something, please include it.
.TP
.I some nice greetings
.
