// -*- C++ -*-
/**
 * \file GTabularCreate.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Michael Koziarski
 *
 * Full author contact details are available in file CREDITS
 */

#ifndef GTABULARCREATE_H
#define GTABULARCREATE_H

#ifdef __GNUG__
#pragma interface
#endif

#include "ControlTabularCreate.h"
#include "GnomeBase.h"

namespace Gtk {
	class SpinButton;
	class Button;
}

/**
 * This class implements the dialog to insert/modify urls.
 */
class GTabularCreate : public GnomeCB<ControlTabularCreate> {
public:
	///
	GTabularCreate(ControlTabularCreate & c);
	///
	~GTabularCreate();

	void apply();

private:
	/// Build the dialog
	void build();

	/// Returns true if the dialog input is in a valid state.
	bool validate() const;
	void update();

	void OKClicked() { OKButton(); }
	void CancelClicked() { CancelButton(); }
	void ApplyClicked() { ApplyButton(); }

	/// generated by accessors.py
	Gtk::Button * ok_btn() const;
	/// generated by accessors.py
	Gtk::Button * apply_btn() const;
	/// generated by accessors.py
	Gtk::Button * cancel_btn() const;
	/// generated by accessors.py
	Gtk::SpinButton * rows() const;
	/// generated by accessors.py
	Gtk::SpinButton * cols() const;

};

#endif
