// -*- C++ -*-
/**
 * \file GERT.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Michael Koziarski
 *
 * Full author contact details are available in file CREDITS
 */

#ifndef GERT_H
#define GERT_H

#ifdef __GNUG__
#pragma interface
#endif

#include "ControlERT.h"
#include "GnomeBase.h"

namespace Gtk {
	class RadioButton;
	class Button;
}

/**
 * This class implements the dialog to insert/modify urls.
 */
class GERT : public GnomeCB<ControlERT> {
public:
	///
	GERT(ControlERT & c);
	///
	~GERT();

	void apply();
	void update();

private:
	/// Build the dialog
	void build();

	/// Returns true if the dialog input is in a valid state.
	bool validate() const;

	/// Do the connection of signals
	void connect_signals();
	/// Disconnect the signals.
	void disconnect_signals();

	/// generated by accessors.py
	Gtk::Button * close_btn() const;
	/// generated by accessors.py
	Gtk::RadioButton * open() const;
	/// generated by accessors.py
	Gtk::RadioButton * collapsed() const;
	/// generated by accessors.py
	Gtk::RadioButton * inlined() const;


	/// do input validation
	SigC::Connection slot_open;
	SigC::Connection slot_collapsed;
	SigC::Connection slot_inlined;

};

#endif
