/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with Directory administrator; if not, send e-mail to amador@alomega.com
*/


#include "appsupport.h"
#include "profile.h"
#include "users.h"
#include "groups.h"
#include "appglobals.h"
#include "appfunctions.h"
#include "profile.h"
#include "newdruids.h"
#include "usergrouplists.h"
#include "ldaptransaction.h"
#include "dir_entry.h"
#include "charset.h"

gboolean
newgroup_commit (GnomeDruidPage * gnomedruidpage)
{
  ldaptransaction*t;
  diradmin_group *newuser = NULL;
  int ldap_errors = LDAP_SUCCESS;
  GtkWidget *window = NULL;
  gchar *dn = NULL;
  gchar *basedn = NULL;
  gchar *gid = NULL;
  dir_entry *dentry = NULL;

  if (connection_profile_is_connected (current_connection_profile) == FALSE)
    return ERROR;

  window = lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_group");
  basedn = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "baseou")));
  //this is a stupid kludge to avoid constructing the DN, for the time being
  if (GTK_TOGGLE_BUTTON
      (lookup_widget (GTK_WIDGET (gnomedruidpage), "automaticgid"))->active)
    gid = get_lowest_gid (current_connection_profile);
  else
    gid =
      g_strdup (gtk_entry_get_text
		(GTK_ENTRY (lookup_widget (window, "gidnumber"))));

  if (gid) /* fixes extraneous bug when gid could be null!!! */
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (window, "gidnumber")), gid);

  dn =
    g_strconcat ("cn=",
		 gtk_entry_get_text (GTK_ENTRY
				     (lookup_widget (window, "cn"))), ",",
		 basedn, NULL);


  newuser = create_group_struct_from_dialogbox (current_connection_profile,
						window, dn);

  t = diradmin_group_create_ldapdiff (newuser);
      ldap_errors =
	connection_profile_create_record (current_connection_profile,
					  t->mods, dn);
  ldaptransaction_destroy(t);
  if (ldap_errors)
    {
      if (ldap_errors == LDAP_UNDEFINED_TYPE)
	gtk_widget_show (create_messagebox_with_message
			 (
"The group could not be created because your directory hasn't\nsupport for certain features.  Go to Settings->Preferences and\nset the appropriate compatibility options."));
      else if (ldap_errors == LDAP_ALREADY_EXISTS)
		gtk_widget_show (create_messagebox_with_message("Another group with the same distinguished name exists.\nPlease go back and change the user ID or the organizational unit."));
    	  else
	gtk_widget_show (create_messagebox_with_message
			 (ldap_err2string (ldap_errors)));
    }
  else
    {
      dentry = dir_entry_group_new(
          g_strdup(dn),
          g_strdup(diradmin_group_get_attribute (newuser, "cn")),
          atoi(diradmin_group_get_attribute (newuser, "gidnumber"))
         );

  diradmin_group_destroy (newuser);

//  g_print("\nThe following entry was just added to the directory cache");
//  dir_entry_dump(dentry);

  app_add_dir_entry(dentry);



    }

  g_free (dn);
  g_free (gid);
// TEMP DISABLED  diradmin_group_destroy (newuser);
  if (ldap_errors)
    return ERROR;
  connection_profile_set_last_group_ou
    (connection_profile_list_getbyname
     (connection_profile_list,
      connection_profile_get_name (current_connection_profile)), basedn);
  return OK;
}

gboolean
newuser_commit (GnomeDruidPage * gnomedruidpage)
{
  ldaptransaction * t;
  diradmin_user *newuser = NULL;
  int ldap_errors = LDAP_SUCCESS;
  GtkWidget *window = NULL;
  gchar *dn = NULL;
  gchar *basedn = NULL;
  gchar *uid = NULL;
  dir_entry*dentry=NULL;

//		char*groupdn = NULL;
//		dir_entry*groupentry = NULL;
		int gidnumber; char*gidnumberstring;
//diradmin_group * oldgroup;diradmin_group * newgroup;
gchar*asciichar;
gchar*homedir;
gchar*message;

//here I check syntax for common attributes




  if (connection_profile_is_connected (current_connection_profile) == FALSE)
    return ERROR;
  window = lookup_widget (GTK_WIDGET (gnomedruidpage), "druid_new_user");



homedir = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "homedirectory")));
asciichar = convert_to_ascii(homedir);
if (g_strcasecmp(homedir,asciichar) != 0) {
	message = g_strconcat("The user cannot be added because its home directory has non-ASCII\n",
	"characters (e.g. accented characters).  Please go back, change it, and try again.", NULL);
	gtk_widget_show(create_messagebox_with_message(message));
	g_free(message);
	g_free(asciichar);
	return ERROR;
} else {
	g_free(asciichar);
}



  basedn = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "baseou")));
  if (GTK_TOGGLE_BUTTON
      (lookup_widget (GTK_WIDGET (gnomedruidpage), "automaticuid"))->active)
    uid = get_lowest_uid (current_connection_profile);
  else
    uid =
      g_strdup (gtk_entry_get_text
		(GTK_ENTRY (lookup_widget (window, "uidnumber"))));
  if (uid) /* fixes extraneous bug when uid could be null!!! */
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (window, "uidnumber")), uid);
  dn =
    g_strconcat ("uid=",
		 gtk_entry_get_text (GTK_ENTRY
				     (lookup_widget
				      (window, "uid"))), ",", basedn, NULL);
  g_print ("Base DN for user creation: %s\n", basedn);
  newuser =
    create_user_struct_from_dialogbox
    (current_connection_profile, window, dn);

if (diradmin_user_get_attribute(newuser,"gidnumber") == NULL) {

	message = g_strconcat("The primary group you selected no longer exists. Please\n",
	"go back to the User account page and change it.", NULL);
	gtk_widget_show(create_messagebox_with_message(message));
	g_free(message);
	diradmin_user_destroy(newuser);
	g_free(dn);
   return ERROR;
}

  /* En esta parte, activamos que el usuario creado con el druida
     sea logon to all servers */
/*  diradmin_user_allowallservers(newuser);*/
  t = diradmin_user_create_ldapdiff (newuser);
      ldap_errors =
	connection_profile_create_record
	(current_connection_profile, t->mods, dn);
  ldaptransaction_destroy(t);

  if (ldap_errors)
    {
      if (ldap_errors == LDAP_UNDEFINED_TYPE)
	gtk_widget_show (create_messagebox_with_message
			 (
"The user could not be created because your directory does not\nsupport certain features.  Go to Settings->Preferences... and\ntry changing the compatibility options."));
      else if (ldap_errors == LDAP_ALREADY_EXISTS)
		gtk_widget_show (create_messagebox_with_message("Another user with the same distinguished name exists.\nPlease go back and change the group name or the organizational unit."));
      else if (ldap_errors == LDAP_INVALID_SYNTAX)
		gtk_widget_show (create_messagebox_with_message("One or more fields contain invalid characters (e.g. letters in number-only fields, or accented characters).  Please go back and change them."));
	  else
	gtk_widget_show
	  (create_messagebox_with_message (ldap_err2string (ldap_errors)));
    }
  else
    {



		//ahora ponemos el DN de este usuario de su nuevo grupo primario

		gidnumberstring = diradmin_user_get_attribute(newuser,"gidnumber");
		g_assert(gidnumberstring);
		gidnumber = atoi (gidnumberstring);

		_add_this_dn_to_this_group(dn,gidnumber);


//ahora lo agregamos al panela en la huevada de lista de usuarios

    dentry=dir_entry_user_new(g_strdup(dn),
g_strdup(diradmin_user_get_attribute (newuser, "uid")),
g_strdup(diradmin_user_get_attribute(newuser, "cn")),
atoi(diradmin_user_get_attribute(newuser, "uidnumber")),
atoi(diradmin_user_get_attribute(newuser, "gidnumber"))
);
//  g_print("\nThe following entry was just added to the directory cache");
//  dir_entry_dump(dentry);

  app_add_dir_entry(dentry);
    }

  g_free (dn);
  g_free (uid);
  diradmin_user_destroy (newuser);
  if (ldap_errors)
    return ERROR;

preferences.userbox.lastgroup = g_strdup(gtk_entry_get_text ( GTK_ENTRY(lookup_widget(GTK_WIDGET(gnomedruidpage),"gidnumber"))));
preferences.userbox.sambaused = ((GtkToggleButton*)lookup_widget(GTK_WIDGET(gnomedruidpage),"enablesambaobjectclass"))->active;

  connection_profile_set_last_user_ou
    (connection_profile_list_getbyname
     (connection_profile_list,
      connection_profile_get_name (current_connection_profile)), basedn);
  return OK;
}









void newgroup_exec_accel(GtkWidget* window,GdkEventKey     *event) {

GnomeDruid* druid; // GnomeDruidPage*page; GnomeDruidPage*nextpage;

druid = (GnomeDruid*)lookup_widget(window,"druid_new_group_druid");

// this entire function is dedicated to the fuckup GNOME/GTK+ causes with accelerators
/*g_print("Disabled actions\n");
return;*/
	//ALT accelerators
/*	if (event->state & 8) {

		if (strcasecmp(event->string,"g") == 0) {
			gtk_notebook_set_page ( lookup_widget(window,"propertypages"),1);
			event->string = g_strdup("n");
		}
		if (strcasecmp(event->string,"m") == 0) {
			gtk_notebook_set_page ( lookup_widget(window,"propertypages"),0);
			event->string = g_strdup("m");
		}


	if (gtk_notebook_get_current_page(lookup_widget(window,"propertypages")) == 1) {
		g_print("Selecting widgets from Group information tab\n");
		if (strcasecmp(event->string,"n") == 0)
			gtk_widget_grab_focus ((GtkWidget*)lookup_widget(window,"cn"));
		if (strcasecmp(event->string,"i") == 0)
			gtk_widget_grab_focus ((GtkWidget*)lookup_widget(window,"gidnumber"));

	}
	if (gtk_notebook_get_current_page(lookup_widget(window,"propertypages")) == 0) {
		g_print("Selecting widgets from Memberships tab\n");
		if (strcasecmp(event->string,"m") == 0)
			gtk_widget_grab_focus ((GtkWidget*)GTK_WIDGET(lookup_widget(window,"members")));
	}


	}


	//CTRL accelerators
	if (event->state & 4) {
		if (event->keyval == 65366)
			gtk_notebook_next_page (lookup_widget(window,"propertypages"));

		if (event->keyval == 65365)
			gtk_notebook_prev_page (lookup_widget(window,"propertypages"));



	}
*/
//other accelerators
		if (event->keyval == 65293 || event->keyval == 65421) {
			if (
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"cn")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"gidnumber"))

			 ) {
			gtk_button_clicked ( (GtkButton*)druid->next );
			g_print("Advancing to next druid page");

			}
        }
				if (event->keyval == 65307) {
			gtk_widget_destroy(window);
		}

}

void newgroup_keypress(GtkWidget* window,GdkEventKey     *event)
{


  /*guint32 delta;
  gchar*tmp;

  GtkWidget * delbutton;*/
  unsigned char letter;
  int key;

  letter=event->string[0];
  key = event->keyval;

  g_print("Keypress on new group druid %d (%s) state %d\n",event->keyval,event->string,event->state);


  if (event->state & 8)
		g_print("(Alt was pressed)\n");
  if (event->state & 4)
		g_print("(Control was pressed)\n");

	newgroup_exec_accel(window,event);


return;




}



void newuser_exec_accel(GtkWidget* window,GdkEventKey     *event) {

GnomeDruid* druid;//  GnomeDruidPage*page; GnomeDruidPage*nextpage;

druid = (GnomeDruid*) lookup_widget(window,"druid_new_user_druid");

// this entire function is dedicated to the fuckup GNOME/GTK+ causes with accelerators
/*g_print("Disabled actions\n");
return;*/
	//ALT accelerators
	if (event->state & 8) {


	if (druid->current == (GnomeDruidPage*)lookup_widget(window,"druidpageessential")) {
		g_print("Selecting widgets from Essential tab\n");
		if (strcasecmp(event->string,"o") == 0)
			gtk_widget_grab_focus (lookup_widget(window,"baseou"));
		if (strcasecmp(event->string,"f") == 0)
			gtk_widget_grab_focus (lookup_widget(window,"givenname"));
		if (strcasecmp(event->string,"m") == 0)
			gtk_widget_grab_focus (lookup_widget(window,"initials"));
		if (strcasecmp(event->string,"l") == 0)
			gtk_widget_grab_focus (lookup_widget(window,"sn"));;
		if (strcasecmp(event->string,"h") == 0)
			gtk_widget_grab_focus (lookup_widget(window,"cn"));
		if (strcasecmp(event->string,"w") == 0)
			gtk_widget_grab_focus (lookup_widget(window,"userpassword"));
		if (strcasecmp(event->string,"r") == 0)
			gtk_widget_grab_focus (lookup_widget(window,"userpasswordconfirm"));
		if (strcasecmp(event->string,"u") == 0)
			gtk_widget_grab_focus (lookup_widget(window,"uid"));

	}
	if (druid->current == (GnomeDruidPage*)lookup_widget(window,"druidpageorginfo")) {
		g_print("Selecting widgets from Organization tab\n");
		if (strcasecmp(event->string,"c") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"o")));
		if (strcasecmp(event->string,"j") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"title")));
		if (strcasecmp(event->string,"n") == 0)
			gtk_widget_grab_focus(GTK_WIDGET(lookup_widget(window,"physicaldeliveryofficename")));
		if (strcasecmp(event->string,"d") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"ou")));
		if (strcasecmp(event->string,"y") == 0)
			gtk_widget_grab_focus(GTK_WIDGET(lookup_widget(window,"l")));
		if (strcasecmp(event->string,"m") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"employeenumber")));
		if (strcasecmp(event->string,"k") == 0)
			gtk_widget_grab_focus(GTK_WIDGET(lookup_widget(window,"telephonenumber")));
		if (strcasecmp(event->string,"f") == 0)
			gtk_widget_grab_focus(GTK_WIDGET(lookup_widget(window,"facsimiletelephonenumber")));
		if (strcasecmp(event->string,"h") == 0)
			gtk_widget_grab_focus(GTK_WIDGET(lookup_widget(window,"homephone")));
		if (strcasecmp(event->string,"b") == 0)
			gtk_widget_grab_focus(GTK_WIDGET(lookup_widget(window,"mobile")));
	}

	if (druid->current == (GnomeDruidPage*)lookup_widget(window,"druidpageunixaccount")) {
		g_print("Selecting widgets from User account tab\n");
		if (strcasecmp(event->string,"a") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"automaticuid")));
		if (strcasecmp(event->string,"m") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"gidnumber")));
		if (strcasecmp(event->string,"n") == 0)
			gtk_widget_grab_focus(GTK_WIDGET(lookup_widget(window,"uidnumber")));
		if (strcasecmp(event->string,"h") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"homedirectory")));
		if (strcasecmp(event->string,"l") == 0)
			gtk_widget_grab_focus(GTK_WIDGET(lookup_widget(window,"loginshell")));
	}

	if (druid->current == (GnomeDruidPage*)lookup_widget(window,"druidpagesamba")) {
		g_print("Selecting widgets from Windows domain tab\n");
		if (strcasecmp(event->string,"w") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"enablesambaobjectclass")));
//			gtk_toggle_button_set_active((GtkToggleButton*)lookup_widget(window,"enablesambaobjectclass"),TRUE);
		if (strcasecmp(event->string,"h") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"smbHome")));
		if (strcasecmp(event->string,"d") == 0)
			gtk_widget_grab_focus(GTK_WIDGET(lookup_widget(window,"homeDrive")));
		if (strcasecmp(event->string,"t") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"profilePath")));
		if (strcasecmp(event->string,"l") == 0)
			gtk_widget_grab_focus(GTK_WIDGET(lookup_widget(window,"scriptPath")));
	}
	if (druid->current == (GnomeDruidPage*)lookup_widget(window,"druidpagesecuritypolicies")) {
		g_print("Selecting widgets from Security tab\n");
		if (strcasecmp(event->string,"f") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"shadowmin")));
		if (strcasecmp(event->string,"c") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"shadowmax")));
		if (strcasecmp(event->string,"n") == 0)
			gtk_widget_grab_focus(GTK_WIDGET(lookup_widget(window,"shadowwarning")));
		if (strcasecmp(event->string,"d") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"shadowinactive")));
		if (strcasecmp(event->string,"x") == 0)
			gtk_widget_grab_focus(GTK_WIDGET(lookup_widget(window,"shadowexpirecheck")));
	}

	if (druid->current == (GnomeDruidPage*)lookup_widget(window,"druidpagemail")) {
		g_print("Selecting widgets from Mail tab\n");
		if (strcasecmp(event->string,"e") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"mail")));
		if (strcasecmp(event->string,"d") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"enablemailpolicycontrol")));
		if (strcasecmp(event->string,"v") == 0)
			gtk_widget_grab_focus(GTK_WIDGET(lookup_widget(window,"mailroutingaddressset")));
		if (strcasecmp(event->string,"r") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"mailhostset")));
	}
	if (druid->current == (GnomeDruidPage*)lookup_widget(window,"druidpageaccesscontrol")) {
		g_print("Selecting widgets from Access control tab\n");
		if (strcasecmp(event->string,"a") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"logontoallservers")));
		if (strcasecmp(event->string,"h") == 0)
			gtk_widget_grab_focus (GTK_WIDGET(lookup_widget(window,"selectedserver")));
		if (strcasecmp(event->string,"n") == 0)
			gtk_widget_grab_focus(GTK_WIDGET(lookup_widget(window,"allowedservers")));
		if (strcasecmp(event->string,"d") == 0)
			gtk_button_clicked (GTK_BUTTON(lookup_widget(window,"addserver")));
		if (strcasecmp(event->string,"r") == 0)
			gtk_button_clicked (GTK_BUTTON(lookup_widget(window,"delserver")));
	}




	}


/*	//CTRL accelerators
	if (event->state & 4) {
		if (event->keyval == 65366)
			gtk_notebook_next_page (lookup_widget(window,"propertypages"));

		if (event->keyval == 65365)
			gtk_notebook_prev_page (lookup_widget(window,"propertypages"));



	}
*/

//other accelerators
		if (event->keyval == 65293 || event->keyval == 65421) {
			if (
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"givenname")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"initials")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"sn")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"cn")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"uid")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"userpassword")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"userpasswordconfirm")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"o")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"title")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"physicaldeliveryofficename")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"ou")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"l")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"employeenumber")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"telephonenumber")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"facsimiletelephonenumber")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"homephone")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"mobile")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"mail")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"mailroutingaddress")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"mailhost")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"homedirectory")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"smbHome")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"homeDrive")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"profilePath")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"scriptPath")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"shadowmin")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"shadowmax")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"shadowwarning")) ||
			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"shadowinactive"))
//			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"gidnumber")) //||
//			GTK_WIDGET_HAS_FOCUS(lookup_widget((GtkWidget*)druid,"gidnumber"))

			 ) {
			gtk_button_clicked ( (GtkButton*)druid->next );
			g_print("Advancing to next druid page\n");

			}
        }
		if (event->keyval == 65307) {
			gtk_widget_destroy(window);
		}
}

void newuser_keypress(GtkWidget* window,GdkEventKey     *event)
{


//  guint32 delta;
//  gchar*tmp;

//  GtkWidget * delbutton;
  unsigned char letter;
  int key;

  letter=event->string[0];
  key = event->keyval;

  //g_print("\nKeypress on new user druid %d (%s) state %d\n",event->keyval,event->string,event->state);


  if (event->state & 8)
		g_print("(Alt was pressed)\n");
  if (event->state & 4)
		g_print("(Control was pressed)\n");

	newuser_exec_accel(window,event);


return;




}



