/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with Directory administrator; if not, send e-mail to amador@alomega.com
*/


#include "appsupport.h"
#include "dir_entry.h"

void
dir_entry_destroy (dir_entry * entry)
{
  g_assert (entry);
  g_free (entry->dn);
  g_free (entry->name);
  g_free (entry->cn);
  g_free (entry->uid);
  g_free (entry->ou);
  g_free (entry);
}

dir_entry *
dir_entry_new (dir_entry * entry)
{
  dir_entry *new = g_new (dir_entry, 1);
  new->dn = NULL;
  new->name = NULL;
  new->cn = NULL;
  new->uid = NULL;
  new->ou = NULL;
  new->type = DENTRY_UNDEFINED;
  new->uidnumber = 0;
  new->gidnumber = 0;

  if (entry != NULL)
    {
      new->dn = g_strdup (entry->dn);
      new->name = g_strdup (entry->name);
      new->cn = g_strdup (entry->cn);
      new->uid = g_strdup (entry->uid);
      new->uidnumber = entry->uidnumber;
      new->gidnumber = entry->gidnumber;
      new->type = entry->type;
    }
  return new;
}


dir_entry *dir_entry_user_new (gchar * dn, gchar * uid, gchar *cn,
 gint uidnumber, gint gidnumber){
dir_entry *new = dir_entry_new(NULL);
new->dn = g_strdup(dn);
new->uid = g_strdup(uid);
new->cn = g_strdup(cn);
new->uidnumber = uidnumber;
new->gidnumber = gidnumber;

new->type = DENTRY_USER;
if (cn) new->name = g_strdup(cn);
else new->name =g_strdup(uid);
return new;
}


dir_entry *dir_entry_group_new (gchar * dn, gchar * cn, gint gidnumber){
dir_entry *new = dir_entry_new(NULL);
new->dn = g_strdup(dn);
new->cn = g_strdup(cn);
new->gidnumber = gidnumber;

new->type = DENTRY_GROUP;
new->name = g_strdup(cn);

return new;
}

dir_entry *dir_entry_orgunit_new (gchar * dn, gchar * ou){
dir_entry *new = dir_entry_new(NULL);
new->dn = g_strdup(dn);
new->ou = g_strdup(ou);

new->type = DENTRY_ORGUNIT;
new->name = g_strdup(ou);

return new;
}

dir_entry *dir_entry_undef_new (gchar * dn){
dir_entry *new = dir_entry_new(NULL);
new->dn = g_strdup(dn);

new->type = DENTRY_UNDEFINED;
new->name = g_strdup(dn);

return new;
}

char* dir_entry_get_name(dir_entry* d) { return d->name ;}
char* dir_entry_get_dn(dir_entry* d) {return d->dn;}
char* dir_entry_get_cn(dir_entry* d) {return d->cn;}
char* dir_entry_get_uid(dir_entry* d) {return d->uid;}
gint dir_entry_get_uidnumber(dir_entry* d) {return d->uidnumber;}
gint dir_entry_get_gidnumber(dir_entry* d) {return d->gidnumber;}
int dir_entry_is_user(dir_entry* d) {
if (d->type == DENTRY_USER)return TRUE;
return FALSE;
}
int dir_entry_is_group(dir_entry* d) {
if (d->type == DENTRY_GROUP){ return TRUE; }
return FALSE;
}
int dir_entry_is_orgunit(dir_entry* d) {
if (d->type == DENTRY_ORGUNIT) {return TRUE;}
return FALSE;
}



dir_entry *
dir_entry_list_getbydn (GList * connec, gchar *nombre)
{
 GList
*loopix = g_list_first (connec);
  dir_entry *now = NULL;


  while (loopix != NULL)
    {
      g_assert (dir_entry_get_dn (loopix->data));
      if (g_strcasecmp (nombre, dir_entry_get_dn (loopix->data)) ==
          0)
        {
          now = loopix->data;
        }
      loopix = g_list_next (loopix);
    }
  return (now);
}

dir_entry *
dir_entry_list_getbyuid (GList * connec, gchar *uid)
{
  dir_entry *now = NULL;
  GList *loopix;

  for (loopix = g_list_first(connec); loopix != NULL; loopix=loopix->next)
    {
//      dir_entry_dump (loopix->data);
      if (dir_entry_is_user (loopix->data))
        if (strcmp (uid, dir_entry_get_uid (loopix->data)) == 0)
          {
            now = loopix->data;
          }
    }

  return (now);
}

dir_entry *
dir_entry_list_getbygidnumber (GList * connec, gint gidnumber)
{
  dir_entry *now = NULL;
  GList *loopix;

  for (loopix = g_list_first(connec); loopix != NULL; loopix=loopix->next)
    {
//      dir_entry_dump (loopix->data);
      if (dir_entry_is_user (loopix->data))
        if (gidnumber == dir_entry_get_gidnumber (loopix->data) )
          {
            now = loopix->data;
          }
    }

  return (now);
}

dir_entry *
dir_entry_list_getgroupbygidnumber (GList * connec, gint gidnumber)
{
  dir_entry *now = NULL;
  GList *loopix;

  for (loopix = g_list_first(connec); loopix != NULL; loopix=loopix->next)
    {
//      dir_entry_dump (loopix->data);
      if (dir_entry_is_group (loopix->data))
        if (gidnumber == dir_entry_get_gidnumber (loopix->data) )
          {
            now = loopix->data;
          }
    }

  return (now);
}
dir_entry* 
dir_entry_list_getgroupbycn (GList * connec, gchar* cn)
{
  dir_entry *now = NULL;
  GList *loopix;

  for (loopix = g_list_first(connec); loopix != NULL; loopix=loopix->next)
    {
//      dir_entry_dump (loopix->data);
      if (dir_entry_is_group (loopix->data))
        if (g_strcasecmp (cn,dir_entry_get_cn (loopix->data)) == 0 )
          {
            now = loopix->data;
          }
    }

  return (now);
}



dir_entry *
dir_entry_list_getfirstgroup (GList* connec)
{
  GList *loopix;

  for (loopix = g_list_first(connec); loopix != NULL; loopix=loopix->next)
    {
//      dir_entry_dump (loopix->data);
      if (dir_entry_is_group (loopix->data))
		return loopix->data;
    }

  return NULL;
}

dir_entry *
dir_entry_list_getfirstou (GList* connec)
{
  GList *loopix;

  for (loopix = g_list_first(connec); loopix != NULL; loopix=loopix->next)
    {
//      dir_entry_dump (loopix->data);
      if (dir_entry_is_orgunit (loopix->data))
		return loopix->data;
    }

  return NULL;
}



void
dir_entry_list_dump (GList * connec)
{

}

void dir_entry_dump (dir_entry *s)
 {
//   g_assert (dir_entry_get_uid (loopix->data));
   g_print( "\nEntry DN: %s\nName: %s\nUID: %s\nuidnumber: %d\n\n",s->dn,s->name,s->uid,s->uidnumber);

}

int dir_entry_compare (dir_entry *one, dir_entry* two) {
  return (g_strcasecmp(one->name,two->name));
}

