#ifndef PLAY_H
#define PLAY_H

#define RECORD		0		/* mode: record */
#define PLAY		1		/* mode: play   */

#ifndef AUDIODEV
#define AUDIODEV	"/dev/dsp"
#endif

#ifndef AUDIOLCK
#define AUDIOLCK	0x33333333
#endif

typedef unsigned long ulongT;
typedef unsigned short ushortT;

typedef struct {		/* header for WAV-Files */
	char	main_chunk[4];	/* 'RIFF' */
	ulongT	length;		/* length of file */
	char	chunk_type[4];	/* 'WAVE' */
	char	sub_chunk[4];	/* 'fmt' */
	ulongT	length_chunk;	/* length sub_chunk, always 16 bytes */
	ushortT	format;		/* always 1 = PCM-Code */
	ushortT	modus;		/* 1 = Mono, 2 = Stereo */
	ulongT	sample_fq;	/* Sample Freq */
	ulongT	byte_p_sec;	/* Data per sec */
	ushortT	byte_p_spl;	/* bytes per sample, 1=8 bit, 2=16 bit (mono)
						     2=8 bit, 4=16 bit (stereo) */
	ushortT	bit_p_spl;	/* bits per sample, 8, 12, 16 */
	char	data_chunk[4];	/* 'data' */
	ulongT	data_length;	/* length of data */
} wave_header;

typedef struct {		/* options set */
	int	quiet_mode;		/* -q */
	ulongT	speed;		/* -s xxxxx */
	int	force_speed;
	int	stereo;		/* -S */
	int	force_stereo;
	ulongT	sample_size;	/* -b xx */
	int	force_sample_size;
	float	time_limit;	/* -t xxx */
	ulongT	lower_border;
	ulongT	upper_border;	/* for xplay */
} header_data;

void err(int syserrflg,char *text);
extern int recplay(char *name,int mode,header_data data,int ipc, void (*loop_func)(void));
// 1 on err

extern void recplay_stop(void);

#endif /* PLAY_H */






