#ifndef BASIC_H
#define BASIC_H

#include <wx/wx.h>
#include <wx/filedlg.h>

static const wxChar *TITLE  = _T("wxWindows Basic steps - step 4: ");
static const wxChar *AUTHOR = _T("\nDB 2001");
static const wxChar *ABOUT  = _T(" Using file dialogs and a status bar");

static const
 wxChar
  *FILETYPES = _T( "Text files|*.txt|"
                   "C/C++ source files|*.cpp;*.cc;*.c|"
                   "C/C++ header files|*.hpp;*.h|"
                   "Make files|Mak*;mak*|"
                   "Java files|*java|"
                   "Hypertext markup files|*html;*htm;*HTML;*HTM|"
                   "All files|*.*"
                  );

class BasicApplication : public wxApp
{
  public:
	virtual bool OnInit();
};

class BasicFrame : public wxFrame
{
  public:
	BasicFrame( const wxChar *title, int xpos, int ypos, int width, int height);
	~BasicFrame();

        wxTextCtrl *theText;
	wxMenuBar  *menuBar;
	wxMenu     *fileMenu;

	void OnOpenFile(wxCommandEvent &);
	void OnAbout(wxCommandEvent &);
    void OnSave(wxCommandEvent &);
    void OnSaveAs(wxCommandEvent &);
	void OnExit(wxCommandEvent &);
    wxString GetCurrentFilename();
	void SetCurrentFilename(wxString);
	bool SaveCurrentFile();

  private:
	wxString currentFilename;
 
  DECLARE_EVENT_TABLE()
};

enum
{ BASIC_EXIT = wxID_HIGHEST + 1,
  BASIC_OPEN,
  BASIC_SAVE,
  BASIC_SAVE_AS,
  BASIC_ABOUT
};

#endif

