#ifndef MAINFRAME_H
#define MAINFRAME_H

#include <wx/wx.h>
#include <fstream>
#include <string>
#include <wx/filedlg.h>
#include <wx/fontdlg.h>
#include <wx/colour.h>
#include <wx/sizer.h>
#include <wx/statline.h>
#include <wx/utils.h>
#include <wx/list.h>

class MainFrame : public wxFrame
{
  public:
	MainFrame(	wxWindow * parent,
				const wxChar *title,
				int xpos,
				int ypos,
				int width,
				int height);
	~MainFrame();

    wxTextCtrl *theText;
	wxMenuBar  *menuBar;
	wxMenu     *fileMenu, *editMenu, *helpMenu;
	//static wxList *windowList;
	
	void OnExit     		(wxCommandEvent & event);
	void OnAbout    		(wxCommandEvent & event);
	void OnChooseFont		(wxCommandEvent & event);
	void OnNewFrame			(wxCommandEvent & event);
	void OnCloseWindow		(wxCloseEvent& event);
	void ChildMessage		(wxString);
	
  private:
 	wxColour colour;
	wxFont   font;
	size_t   fontSize;

  DECLARE_EVENT_TABLE()
};

enum
{ MAIN_EXIT = 400,
  MAIN_FONT,
  MAIN_NEWFRAME,       
  MAIN_ABOUT,
  MAIN_TEXT
};

#endif

