#include "basic.h"
#include "basicdlg.h"
#include "basicframe.h"
#include "mainframe.h"

MainFrame::MainFrame
             (	wxWindow * parent,
             	const wxChar *title, int xpos, int ypos, int width, int height)
             : wxFrame( parent, -1, title,
                        wxPoint(xpos, ypos),
                        wxSize(width, height))
{
  theText  = (wxTextCtrl *) NULL;
  menuBar  = (wxMenuBar *) NULL;
  CreateStatusBar(3);

  theText = new wxTextCtrl
  		( this,
  		  MAIN_TEXT,
  		  wxEmptyString,
  		  wxDefaultPosition,
  		  wxDefaultSize,
  		  wxTE_MULTILINE
  		);

  editMenu = new wxMenu;
  editMenu->Append(MAIN_FONT, "Choose font");
  editMenu->Append(MAIN_NEWFRAME, "Create new frame");
  
  helpMenu = new wxMenu;
  helpMenu->Append(MAIN_ABOUT,		"About");
  
  menuBar = new wxMenuBar;
  menuBar->Append(editMenu, "&Edit");
  menuBar->Append(helpMenu, "&Help");
  SetMenuBar(menuBar);
  wxString x;
  x.Printf(_T("Id is %d"), this->GetId());
  theText->AppendText(x);
}

MainFrame::~MainFrame()
{
}

void MainFrame::ChildMessage(wxString s)
{	theText->AppendText(s); }

void MainFrame::OnExit   (wxCommandEvent & event)
{
	Close();
}

void MainFrame::OnCloseWindow	(wxCloseEvent& event)
{ wxString msg = "Close Warning: the text has changed"
                 "\nSelect OK to ignore changes for\n";

  if ( theText->IsModified() )
   { wxMessageDialog
      warnDialog ( this,
                   msg,    
                   "File changed",
                   wxICON_HAND | wxOK | wxCANCEL);
     if (warnDialog.ShowModal() == wxID_OK)
      this->Destroy();
   }
  else
   { this->Destroy(); }
}


void MainFrame::OnChooseFont(wxCommandEvent & event)
{ wxFontData fontData;
  wxFont     theFont = theText->GetFont();

  colour = theText->GetForegroundColour();
  fontData.SetColour(colour);
  fontData.SetInitialFont(theFont);
  fontData.SetShowHelp(true);
  wxFontDialog *dialog = new wxFontDialog(this, &fontData);
  if (dialog->ShowModal() == wxID_OK)
   { fontData = dialog->GetFontData();
     theFont = 	fontData.GetChosenFont();
     theText->SetFont(theFont);
     theText->SetForegroundColour(fontData.GetColour());
   }
  dialog->Destroy();
   
}

void MainFrame::OnNewFrame (wxCommandEvent & event)
{
    wxString theTitle;
    theTitle =
     wxGetTextFromUser("Enter a title", "Input text", "NO NAME", this, -1,-1,TRUE);

  BasicFrame * win = new BasicFrame(this, theTitle, 150, 150, 450, 300);
  win->Show(TRUE);
}

void MainFrame::OnAbout(wxCommandEvent & event)
{  
  BasicDialog
   aboutDialog ( this, -1,
                 this->GetTitle(),
                 wxPoint(100,100),
                 wxSize(250, 300),
                 wxRESIZE_BORDER |  wxDEFAULT_DIALOG_STYLE 
               );
  aboutDialog.ShowModal();
}


BEGIN_EVENT_TABLE (MainFrame, wxFrame)
  EVT_MENU ( MAIN_EXIT,  		MainFrame::OnExit)
  EVT_MENU ( MAIN_FONT, 		MainFrame::OnChooseFont)
  EVT_MENU ( MAIN_NEWFRAME, 	MainFrame::OnNewFrame)
  EVT_MENU ( MAIN_ABOUT, 		MainFrame::OnAbout)
  EVT_CLOSE(                    MainFrame::OnCloseWindow)
END_EVENT_TABLE()
