#ifndef BASICFRAME_H
#define BASICFRAME_H

#include <wx/wx.h>
#include <fstream>
#include <string>
#include <wx/filedlg.h>
#include <wx/fontdlg.h>
#include <wx/colour.h>
#include <wx/sizer.h>
#include <wx/statline.h>
#include <wx/utils.h>
#include <wx/list.h>

class BasicFrame : public wxFrame
{
  public:
	BasicFrame(	wxWindow * parent,
				const wxChar *title,
				int xpos,
				int ypos,
				int width,
				int height);
	~BasicFrame();

    wxTextCtrl *theText;
	wxMenuBar  *menuBar;
	wxMenu     *fileMenu, *editMenu, *helpMenu;
	wxWindow   *p;
  	
	void OnOpenFileNative 	(wxCommandEvent & event);
    void OnSave				(wxCommandEvent & event);
    void OnSaveAs			(wxCommandEvent & event);
	void OnExit     		(wxCommandEvent & event);
	void OnHelp	    		(wxCommandEvent & event);
	void OnChooseFont		(wxCommandEvent & event);
	void OnCloseWindow		(wxCloseEvent& event);
    wxString GetCurrentFilename();
	void SetCurrentFilename(wxString);
	bool SaveCurrentFile();
	
  private:
	wxString currentFilename;
 	wxColour colour;
	wxFont   font;
	size_t   fontSize;

  DECLARE_EVENT_TABLE()
};

enum
{ BASIC_EXIT    	=   1,
  BASIC_OPEN_NATIVE	= 100,
  BASIC_SAVE,
  BASIC_SAVE_AS,
  BASIC_FONT		= 150,
  BASIC_HELP
};

#endif

